/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal) {
  Drupal.behaviors.flagAttach = {
    attach: function attach(context) {
      var links = context.querySelectorAll('.flag a');
      links.forEach(function (link) {
        return link.addEventListener('click', function (event) {
          return event.target.parentNode.classList.add('flag-waiting');
        });
      });
    }
  };

  Drupal.AjaxCommands.prototype.actionLinkFlash = function (ajax, response, status) {
    if (status === 'success') {
      var para = document.createElement('P');
      para.innerText = response.message;

      para.setAttribute('class', 'js-flag-message');

      para.addEventListener('animationend', function (event) {
        return event.target.remove();
      }, false);

      document.querySelector(response.selector).appendChild(para);
    } else {
      var links = document.querySelectAll('.flag-waiting');
      links.forEach(function (link) {
        return link.classList.remove('flag-waiting');
      });
    }
  };
})(Drupal);