Drupal Examples For Developers: Contributor's Guide
===================================================

Examples for Developers is a community project.

If you'd like to participate in Examples development, thank you!

If you are new to Drupal or open source in general, have no fear. Examples is
an easy-going project where you can learn some things about how to work on a
collaborative project in a friendly environment.


Policies
--------

Examples follows the Drupal core process as much as possible.

Contributions thus need to be similar in quality to Drupal core patches.
Contributions will need to meet the following minimum standards:

### Normal Drupal issue process

Drupal projects use patches related to issues. You should know how to make a
patch and an interdiff using git. It's fine to develop on github or
what-have-you, but eventually it has to be a patch that can be reviewed in the
normal Drupal issue process. See the list of resources for some information on
how to do this.

Your patch will also need to be reviewed by someone other than yourself. Learn
about the review process in the resources section.

### DrupalCI

Examples uses the Drupal automated testing system to verify the applicability of
patches. See `TESTING.md` for details.

### Drupal coding standards

All code in Examples should adhere to the Drupal core coding standards. Examples
uses the Drupal Coder project and PHP_CodeSniffer to enforce coding standards.
Think of this as another test your code must pass. See `STANDARDS.md` for
details.


Resources
---------

### Novice

Drupal novice contribution guide: https://www.drupal.org/novice

Drupal contribution guide: https://www.drupal.org/contribute

What's a patch? https://www.drupal.org/patch

How to make a patch with git: https://www.drupal.org/node/707484

### Everyone

How to review a patch: https://www.drupal.org/patch/review

See `STANDARDS.md` and `TESTING.md` for information on how to run a coding
standards test, and also how to run the tests themselves.
