<?php
// phpcs:ignoreFile
// cSpell:disable
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 10.2.12 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'indexes' => array(
    'token' => array(
      'token',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_config', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_container', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_default', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_discovery', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_dynamic_page_cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_entity', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_render', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cachetags', array(
  'fields' => array(
    'tag' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tag',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('config', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('config')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.stark_admin',
  'data' => 'a:13:{s:4:"uuid";s:36:"fcf27115-9ff9-4ee2-96a5-bdb9c05c2ede";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:17:"system.menu.admin";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"stark";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5MfnyzXbzrDa_OJuFfZfpiBYkMiuRp4mk4GM7HYc8eM";}s:2:"id";s:11:"stark_admin";s:5:"theme";s:5:"stark";s:6:"region";s:13:"sidebar_first";s:6:"weight";i:1;s:8:"provider";N;s:6:"plugin";s:23:"system_menu_block:admin";s:8:"settings";a:7:{s:2:"id";s:23:"system_menu_block:admin";s:5:"label";s:14:"Administration";s:13:"label_display";s:7:"visible";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:0;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.stark_branding',
  'data' => 'a:13:{s:4:"uuid";s:36:"c97760f9-fa87-4c3e-9be8-5791c0ba0e53";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"stark";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sG8t_FghbUscJ-GrnQ8zs_vx5YM4bJCfntrK-J5HcAY";}s:2:"id";s:14:"stark_branding";s:5:"theme";s:5:"stark";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.stark_local_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"52b4e949-b9ae-4bd5-952c-912d9ca06548";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"stark";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ABoKnlk20KHqZRw_2Qr4EvaFvH4lnQ2nuhunHeE1JIU";}s:2:"id";s:19:"stark_local_actions";s:5:"theme";s:5:"stark";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.stark_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"5ad7b49d-3015-45dd-96ef-a56007e86172";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"stark";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"T0wbI6qVdThbbIqXDZFg_1VZ3_ittXBdEoUH7d7ux_E";}s:2:"id";s:17:"stark_local_tasks";s:5:"theme";s:5:"stark";s:6:"region";s:7:"content";s:6:"weight";i:-20;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:4:"Tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.stark_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"fb9d5bdb-c7d5-4364-b6ca-d28da63123b0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"stark";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aeqlWs7HwctZeZC7ADcbxfqehJzBRfZKmuZz3DsH3_4";}s:2:"id";s:14:"stark_messages";s:5:"theme";s:5:"stark";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.stark_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"401917a4-c2e5-400c-b000-f8772b11ebdc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"stark";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Oh72CHUkp6cj6dbrXMK2hzCsM05w9cHVoD22rMLQUfk";}s:2:"id";s:16:"stark_page_title";s:5:"theme";s:5:"stark";s:6:"region";s:7:"content";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.stark_tools',
  'data' => 'a:13:{s:4:"uuid";s:36:"d5adac31-7b75-4a3b-b912-35343332e967";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:17:"system.menu.tools";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"stark";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UL5ZZvI0Lnp3fmVmhIDxvNI9RlMD0sfBIOi9ozr-k5o";}s:2:"id";s:11:"stark_tools";s:5:"theme";s:5:"stark";s:6:"region";s:13:"sidebar_first";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_menu_block:tools";s:8:"settings";a:7:{s:2:"id";s:23:"system_menu_block:tools";s:5:"label";s:5:"Tools";s:13:"label_display";s:7:"visible";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:0;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.fallback',
  'data' => 'a:9:{s:4:"uuid";s:36:"4220aa60-0f12-440b-9cbd-b81472ccd135";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"b6666537-c921-45a1-8e91-8196b4d282b2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_datetime',
  'data' => 'a:9:{s:4:"uuid";s:36:"744ef199-4c24-4c2d-af24-c4f8c4022f54";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\TH:i:sO";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_month',
  'data' => 'a:9:{s:4:"uuid";s:36:"6bdad038-d30c-46d9-bbbf-a02d0d092df2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_time',
  'data' => 'a:9:{s:4:"uuid";s:36:"77151777-a2f7-4216-9282-c26356557fc8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_week',
  'data' => 'a:9:{s:4:"uuid";s:36:"3544730f-5ca7-48b9-b624-91981e9d485b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\WW";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_year',
  'data' => 'a:9:{s:4:"uuid";s:36:"da7e77f9-1267-4e34-a878-a3ef0318fc21";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_yearless_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"9798a0a3-98f6-4100-8627-e9063c4e0f95";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.long',
  'data' => 'a:9:{s:4:"uuid";s:36:"b2677589-0046-4372-8520-8e59c3bce6ed";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:15:"l, F j, Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"05863111-6df5-4737-ac7b-c29ec6f87697";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.short',
  'data' => 'a:9:{s:4:"uuid";s:36:"775aed12-f1ac-43e0-bc3a-3986db1e2be5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.page.default',
  'data' => 'a:10:{s:4:"uuid";s:36:"8432dc25-0cf4-41c5-ba55-7cd1e9742ec0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:7:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:121;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_mode.user.register',
  'data' => 'a:10:{s:4:"uuid";s:36:"f41a115b-5f35-4f7f-84c9-3aea7608f06d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5pE_4hurqtIlZN3XDi7eTo5RG13BMG0Rh9HYlRI3h8U";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.default',
  'data' => 'a:10:{s:4:"uuid";s:36:"c5fd3018-858e-4848-b14a-2051d2ff4f3b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:101;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.teaser',
  'data' => 'a:10:{s:4:"uuid";s:36:"f01aef4f-f724-4d6b-93c3-d0a21ab9920d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:101;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.full',
  'data' => 'a:10:{s:4:"uuid";s:36:"e9548fd8-4785-4763-ac08-33b091817552";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QJ2aZ1xfVf59aq6Pz5X7fyUOa2HxuCoTwQ_RQjoulAU";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.rss',
  'data' => 'a:10:{s:4:"uuid";s:36:"17461be9-d62a-45a1-afc7-19b19ade3301";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"l8fiAFE3Kng_6bhLlUDnVTkTDzXWxzYFrCWTrngVXEA";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_index',
  'data' => 'a:10:{s:4:"uuid";s:36:"13ad69c2-052f-4a60-ad9a-e27010b0c6d2";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"r_A0T3aTqGDwLyvoH7wLps-0PM--RHlS8UsiJe_Ac64";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_result',
  'data' => 'a:10:{s:4:"uuid";s:36:"9c294639-1b34-4a1a-afa8-4627740db481";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"d8wBEm7XvJ6H3S0IneDD9PfTBklPIH7GMpxElVemPf8";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.teaser',
  'data' => 'a:10:{s:4:"uuid";s:36:"255e0239-bb23-4beb-97c0-d4242371bc3f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgGJDZFpMaz_8bTv6fN1bXS3Qi5LWmRJI9R53kEGsNQ";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.compact',
  'data' => 'a:10:{s:4:"uuid";s:36:"a5e1f8b2-34cd-46a5-aa64-c12b82d86597";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TtD7OuGskOsQfoGyxXkrdtllBpR37J19d5BMQDZWJgA";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.full',
  'data' => 'a:10:{s:4:"uuid";s:36:"05a6655c-2d5e-4f18-8846-e92ca7a76c1a";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZbXunWS_xAvMZXFfinyvClDAb_RCVLt7gAzE3v16E-Q";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.extension',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc";}s:6:"module";a:18:{s:5:"block";i:0;s:5:"dblog";i:0;s:18:"dynamic_page_cache";i:0;s:23:"elasticsearch_connector";i:0;s:5:"field";i:0;s:6:"filter";i:0;s:5:"mysql";i:0;s:4:"node";i:0;s:10:"page_cache";i:0;s:10:"path_alias";i:0;s:10:"search_api";i:0;s:6:"system";i:0;s:4:"text";i:0;s:6:"update";i:0;s:4:"user";i:0;s:5:"views";i:0;s:8:"views_ui";i:0;s:7:"minimal";i:1000;}s:5:"theme";a:1:{s:5:"stark";i:0;}s:7:"profile";s:7:"minimal";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.menu.static_menu_link_overrides',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jdY7AU0tU-QsjmiOw3W8vwpYMb-By--_MSFgbqKUTYM";}s:11:"definitions";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'dblog.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"e883aGsrt1wFrsydlYU584PZONCSfRy0DtkZ9KzHb58";}s:9:"row_limit";i:1000;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.page.body',
  'data' => 'a:16:{s:4:"uuid";s:36:"c6dfa52f-5b49-4fae-9d7d-4805eff4f814";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:3:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}s:16:"purge_batch_size";i:50;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"73d16e8c-f281-4338-a40a-60957448edfc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.plain_text',
  'data' => 'a:9:{s:4:"uuid";s:36:"322bbc57-e399-472a-bcba-1fbd9051bed9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JLMwODO0epnA_H-jFlH9ezVfa5YBJniRv3MmLqYNl_Q";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.settings',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2OMXCScXUOLSYID9-phjO4q36nnnaMWNUlDxEqZzG1U";}s:15:"use_admin_theme";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.page',
  'data' => "a:11:{s:4:\"uuid\";s:36:\"075eac33-0c00-4036-ad55-d0a775e9a59b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:4:\"name\";s:10:\"Basic page\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:1;}",
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.colorful_organization',
  'data' => 'a:14:{s:4:"uuid";s:36:"f66681aa-c8a8-4a22-8248-1c1b603c4995";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:34:"search_api.server.circular_opinion";}s:6:"module";a:2:{i:0;s:4:"user";i:1;s:10:"search_api";}}s:2:"id";s:21:"colorful_organization";s:4:"name";s:21:"Colorful organization";s:11:"description";s:90:"colorful_organization index, user datasource, circular_opinion server, read-only, enabled.";s:9:"read_only";b:1;s:14:"field_settings";a:2:{s:4:"name";a:5:{s:5:"label";s:4:"Name";s:13:"datasource_id";s:11:"entity:user";s:13:"property_path";s:4:"name";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}}s:3:"uid";a:5:{s:5:"label";s:7:"User ID";s:13:"datasource_id";s:11:"entity:user";s:13:"property_path";s:3:"uid";s:4:"type";s:7:"integer";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:user";a:1:{s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:6:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:13:"entity_status";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:16:"circular_opinion";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.drab_feather',
  'data' => 'a:14:{s:4:"uuid";s:36:"59543ae1-8068-40f8-87e0-bcf197523b14";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:34:"search_api.server.circular_opinion";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:10:"search_api";}}s:2:"id";s:12:"drab_feather";s:4:"name";s:12:"Drab feather";s:11:"description";s:71:"drab_feather index, node datasource, circular_opinion server, disabled.";s:9:"read_only";b:0;s:14:"field_settings";a:6:{s:4:"body";a:5:{s:5:"label";s:4:"Body";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:4:"body";s:4:"type";s:4:"text";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:23:"field.storage.node.body";}}}s:7:"created";a:5:{s:5:"label";s:11:"Authored on";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:7:"created";s:4:"type";s:4:"date";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:11:"node_grants";a:6:{s:5:"label";s:23:"Node access information";s:13:"property_path";s:22:"search_api_node_grants";s:4:"type";s:6:"string";s:14:"indexed_locked";b:1;s:11:"type_locked";b:1;s:6:"hidden";b:1;}s:6:"status";a:7:{s:5:"label";N;s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:6:"status";s:4:"type";s:7:"boolean";s:14:"indexed_locked";b:1;s:11:"type_locked";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:5:"title";a:5:{s:5:"label";s:5:"Title";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:5:"title";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:3:"uid";a:7:{s:5:"label";N;s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:3:"uid";s:4:"type";s:7:"integer";s:14:"indexed_locked";b:1;s:11:"type_locked";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:6:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:14:"content_access";a:1:{s:7:"weights";a:1:{s:16:"preprocess_query";i:-30;}}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:16:"circular_opinion";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.parched_arithmetic',
  'data' => 'a:14:{s:4:"uuid";s:36:"53eab7f3-8b14-449f-8da9-9f91364a833c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:34:"search_api.server.circular_opinion";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:10:"search_api";i:2;s:23:"elasticsearch_connector";}}s:2:"id";s:18:"parched_arithmetic";s:4:"name";s:18:"Parched arithmetic";s:11:"description";s:76:"parched_arithmetic index, node datasource, circular_opinion server, enabled.";s:9:"read_only";b:0;s:14:"field_settings";a:3:{s:4:"body";a:5:{s:5:"label";s:4:"Body";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:4:"body";s:4:"type";s:4:"text";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:23:"field.storage.node.body";}}}s:7:"created";a:5:{s:5:"label";s:11:"Authored on";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:7:"created";s:4:"type";s:4:"date";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:3:"nid";a:5:{s:5:"label";s:2:"ID";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:3:"nid";s:4:"type";s:7:"integer";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:6:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:23:"elasticsearch_highlight";a:14:{s:7:"weights";a:2:{s:17:"postprocess_query";i:0;s:16:"preprocess_query";i:0;}s:16:"boundary_scanner";s:8:"sentence";s:23:"boundary_scanner_locale";s:6:"system";s:7:"encoder";s:7:"default";s:6:"fields";a:1:{i:0;s:4:"body";}s:13:"fragment_size";i:60;s:10:"fragmenter";s:4:"span";s:13:"no_match_size";i:0;s:19:"number_of_fragments";i:5;s:5:"order";s:4:"none";s:7:"pre_tag";s:24:"<em class="placeholder">";s:19:"require_field_match";b:1;s:14:"snippet_joiner";s:5:" … ";s:4:"type";s:7:"unified";}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:16:"circular_opinion";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.robust_discussion',
  'data' => "a:14:{s:4:\"uuid\";s:36:\"44923017-13a1-4eb1-ad6e-87159de6526a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:34:\"search_api.server.octagonal_rhythm\";}s:6:\"module\";a:2:{i:0;s:4:\"user\";i:1;s:10:\"search_api\";}}s:2:\"id\";s:17:\"robust_discussion\";s:4:\"name\";s:17:\"Robust discussion\";s:11:\"description\";s:76:\"robust_discussion index, user datasource, octagonal_rhythm server, disabled.\";s:9:\"read_only\";b:0;s:14:\"field_settings\";a:3:{s:6:\"access\";a:5:{s:5:\"label\";s:11:\"Last access\";s:13:\"datasource_id\";s:11:\"entity:user\";s:13:\"property_path\";s:6:\"access\";s:4:\"type\";s:4:\"date\";s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}}s:4:\"name\";a:5:{s:5:\"label\";s:4:\"Name\";s:13:\"datasource_id\";s:11:\"entity:user\";s:13:\"property_path\";s:4:\"name\";s:4:\"type\";s:6:\"string\";s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}}s:3:\"uid\";a:5:{s:5:\"label\";s:7:\"User ID\";s:13:\"datasource_id\";s:11:\"entity:user\";s:13:\"property_path\";s:3:\"uid\";s:4:\"type\";s:7:\"integer\";s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}}}s:19:\"datasource_settings\";a:1:{s:11:\"entity:user\";a:1:{s:9:\"languages\";a:2:{s:7:\"default\";b:1;s:8:\"selected\";a:0:{}}}}s:18:\"processor_settings\";a:6:{s:7:\"add_url\";a:0:{}s:16:\"aggregated_field\";a:0:{}s:11:\"entity_type\";a:0:{}s:16:\"ignore_character\";a:5:{s:7:\"weights\";a:2:{s:16:\"preprocess_index\";i:-10;s:16:\"preprocess_query\";i:-10;}s:10:\"all_fields\";b:0;s:6:\"fields\";a:1:{i:0;s:4:\"name\";}s:9:\"ignorable\";s:13:\"['¿¡!?,.:;]\";s:17:\"ignorable_classes\";a:7:{i:0;s:2:\"Pc\";i:1;s:2:\"Pd\";i:2;s:2:\"Pe\";i:3;s:2:\"Pf\";i:4;s:2:\"Pi\";i:5;s:2:\"Po\";i:6;s:2:\"Ps\";}}s:22:\"language_with_fallback\";a:0:{}s:13:\"rendered_item\";a:0:{}}s:16:\"tracker_settings\";a:1:{s:7:\"default\";a:1:{s:14:\"indexing_order\";s:4:\"fifo\";}}s:7:\"options\";a:3:{s:10:\"cron_limit\";i:50;s:14:\"index_directly\";b:1;s:27:\"track_changes_in_references\";b:1;}s:6:\"server\";s:16:\"octagonal_rhythm\";}",
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.yummy_lettuce',
  'data' => 'a:14:{s:4:"uuid";s:36:"245096ec-9535-4727-82a9-12ed241547c1";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:31:"search_api.server.oval_decision";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:10:"search_api";}}s:2:"id";s:13:"yummy_lettuce";s:4:"name";s:13:"Yummy lettuce";s:11:"description";s:69:"yummy_lettuce index, node datasource, oval_decision server, disabled.";s:9:"read_only";b:0;s:14:"field_settings";a:3:{s:4:"body";a:5:{s:5:"label";s:4:"Body";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:4:"body";s:4:"type";s:4:"text";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:23:"field.storage.node.body";}}}s:7:"created";a:5:{s:5:"label";s:11:"Authored on";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:7:"created";s:4:"type";s:4:"date";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:5:"title";a:5:{s:5:"label";s:5:"Title";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:5:"title";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:6:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:11:"entity_type";a:0:{}s:10:"ignorecase";a:3:{s:7:"weights";a:2:{s:16:"preprocess_index";i:-20;s:16:"preprocess_query";i:-20;}s:10:"all_fields";b:0;s:6:"fields";a:2:{i:0;s:4:"body";i:1;s:5:"title";}}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";s:13:"oval_decision";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.circular_opinion',
  'data' => 'a:9:{s:4:"uuid";s:36:"1494994e-7309-45a3-98ed-4588137565c0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:16:"circular_opinion";s:4:"name";s:16:"Circular opinion";s:11:"description";s:64:"circular_opinion server, standard connector, enabled, connected.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:3:{s:9:"connector";s:8:"standard";s:16:"connector_config";a:2:{s:3:"url";s:25:"http://elasticsearch:9200";s:20:"enable_debug_logging";b:0;}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:6:"lorem_";s:6:"suffix";s:6:"_ipsum";s:8:"synonyms";a:1:{i:0;s:20:"computer, pc, laptop";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.octagonal_rhythm',
  'data' => 'a:9:{s:4:"uuid";s:36:"f19831dd-09e9-4551-a946-81ba191b8254";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:16:"octagonal_rhythm";s:4:"name";s:16:"Octagonal rhythm";s:11:"description";s:54:"octagonal_rhythm server, standard connector, disabled.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:3:{s:9:"connector";s:8:"standard";s:16:"connector_config";a:2:{s:3:"url";s:25:"http://elasticsearch:9200";s:20:"enable_debug_logging";b:0;}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:5:"amet_";s:6:"suffix";s:5:"_elit";s:8:"synonyms";a:1:{i:0;s:23:"come, advance, approach";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.oval_decision',
  'data' => 'a:9:{s:4:"uuid";s:36:"d4d3cf1a-e2d9-4020-869d-f85be72d25a6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:23:"elasticsearch_connector";}}s:2:"id";s:13:"oval_decision";s:4:"name";s:13:"Oval decision";s:11:"description";s:57:"oval_decision, basicauth connector, enabled, unavailable.";s:7:"backend";s:13:"elasticsearch";s:14:"backend_config";a:3:{s:9:"connector";s:9:"basicauth";s:16:"connector_config";a:4:{s:3:"url";s:25:"http://elasticsaerch:9200";s:20:"enable_debug_logging";b:0;s:8:"username";s:8:"username";s:8:"password";s:0:"";}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:6:"dolor_";s:6:"suffix";s:4:"_sit";s:8:"synonyms";a:1:{i:0;s:37:"sea biscuit, sea biscit => seabiscuit";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.settings',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2zIRm9Jv3SB60NYdZkZHxH8-KdEa-Xa48-4NsIi4lg";}s:18:"default_cron_limit";i:50;s:19:"cron_worker_runtime";i:15;s:15:"default_tracker";s:7:"default";s:18:"tracking_page_size";i:100;s:13:"boost_factors";a:21:{i:0;d:0;i:1;d:0.1;i:2;d:0.2;i:3;d:0.3;i:4;d:0.5;i:5;d:0.6;i:6;d:0.7;i:7;d:0.8;i:8;d:0.9;i:9;d:1;i:10;d:1.1;i:11;d:1.2;i:12;d:1.3;i:13;d:1.4;i:14;d:1.5;i:15;d:2;i:16;d:3;i:17;d:5;i:18;d:8;i:19;d:13;i:20;d:21;}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"f56a7000-25eb-4277-b4c0-8ddfc3ad77e6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_sticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"01264f90-f3ea-4fb3-b878-da6b7bd0fffa";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_unsticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"976e2d47-7be9-4ca9-90a3-adec3509f1a3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_promote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"318f7a06-4dbe-46d8-b0a8-8be5e7194da2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"e87f13f2-ca46-4915-9c5b-5eea38306b1e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"8a1e86b5-f41e-4286-ae75-8b9eb919ee3f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpromote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"9daf1a1d-ef25-466a-a35f-e76882793bbd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"882e6831-a888-4427-9f8a-6de0dbf861e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_block_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"c1d028a2-bf5d-4b96-9562-2eb3e4832d7a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_cancel_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"d02d50af-330c-48cf-b28d-68eb7e7c88bf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_unblock_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"835c43b3-dbb9-49dd-847f-d40bfd25b36e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.advisories',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.cron',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5Pw921y1EPfFN98wykliBBLArm51pC-SmrXeYCe7d0Y";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";i:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.date',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t7clj3mzmOGrXX0HuCH5usf0vEqRtnMTBFVBIEmZ5pc";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";s:0:"";}s:8:"timezone";a:2:{s:7:"default";s:15:"America/Toronto";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.diff',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.feature_flags',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZYyVj1FtPGV40Cf65YDVTUIc7YgLH6trXlotuevfs2I";}s:16:"linkset_endpoint";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image.gd',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.logging',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.mail',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5PvD9swkqWUeHkabdvbJ2SQqdhrzjkCT21wtD4BLfk4";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}s:10:"mailer_dsn";a:6:{s:6:"scheme";s:8:"sendmail";s:4:"host";s:7:"default";s:4:"user";N;s:8:"password";N;s:4:"port";N;s:7:"options";a:0:{}}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.maintenance',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.account',
  'data' => 'a:9:{s:4:"uuid";s:36:"04b4b7b7-fe43-426d-a0d7-51c2766e23df";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.admin',
  'data' => 'a:9:{s:4:"uuid";s:36:"6285ecd7-f640-4d53-87f9-72b0fb91c0f0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.footer',
  'data' => 'a:9:{s:4:"uuid";s:36:"41d51db4-83bd-4b18-9bfe-13c0deb31436";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.main',
  'data' => 'a:9:{s:4:"uuid";s:36:"66cfbefa-d9a4-4992-9b10-1dde97e8c145";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.tools',
  'data' => 'a:9:{s:4:"uuid";s:36:"e62953d0-d064-43ea-ae72-cd2c5660a180";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.performance',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jtno5biznHZbrIgKwzq-ze-7XaQxLCGe6PeUOR7bRiQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\/(?:styles|imagecache)\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.rss',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0";}s:5:"items";a:1:{s:9:"view_mode";s:3:"rss";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.site',
  'data' => 'a:10:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"l58O_yEXSo-SeJi19LXdzTU1tNJG3lmnIhCitRkM1tk";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"043747b0-2f80-4fae-806e-73397dc5786f";s:4:"name";s:18:"Drush Site-Install";s:4:"mail";s:17:"admin@example.com";s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:11:"/user/login";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6lQ55NXM9ysybMQ6NzJj4dtiQ1dAkOYxdDompa-r_kk";}s:5:"admin";s:0:"";s:7:"default";s:5:"stark";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme.global',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3qY7PfXvJcCtBPQpb9FxxBgXtUGFzx8JVakfWiNNYzw";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";N;s:11:"use_default";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'text.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}s:22:"default_summary_length";i:600;}',
))
->values(array(
  'collection' => '',
  'name' => 'update.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"xbYr66-g0FjNgVBkGypCuN46vBI2XHntXN1URawq1s4";}s:5:"check";a:2:{s:19:"disabled_extensions";b:0;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";N;s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;s:17:"admin@example.com";}s:9:"threshold";s:3:"all";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.flood',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'user.mail',
  'data' => "a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM\";}s:8:\"langcode\";s:2:\"en\";s:14:\"cancel_confirm\";a:2:{s:7:\"subject\";s:67:\"Account cancellation request for [user:display-name] at [site:name]\";s:4:\"body\";s:376:\"[user:display-name]\n\nA request to cancel your account has been made at [site:name].\n\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\n\n[user:cancel-url]\n\nNOTE: The cancellation of your account is not reversible.\n\nThis link expires in one day and nothing will happen if it is not used.\n\n--  [site:name] team\";}s:14:\"password_reset\";a:2:{s:7:\"subject\";s:68:\"Replacement login information for [user:display-name] at [site:name]\";s:4:\"body\";s:407:\"[user:display-name],\n\nA request to reset the password for your account has been made at [site:name].\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it's not used.\n\n--  [site:name] team\";}s:22:\"register_admin_created\";a:2:{s:7:\"subject\";s:58:\"An administrator created an account for you at [site:name]\";s:4:\"body\";s:473:\"[user:display-name],\n\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team\";}s:29:\"register_no_approval_required\";a:2:{s:7:\"subject\";s:54:\"Account details for [user:display-name] at [site:name]\";s:4:\"body\";s:447:\"[user:display-name],\n\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team\";}s:25:\"register_pending_approval\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:288:\"[user:display-name],\n\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n--  [site:name] team\";}s:31:\"register_pending_approval_admin\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:64:\"[user:display-name] has applied for an account.\n\n[user:edit-url]\";}s:16:\"status_activated\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (approved)\";s:4:\"body\";s:462:\"[user:display-name],\n\nYour account at [site:name] has been activated.\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:account-name]\npassword: Your password\n\n--  [site:name] team\";}s:14:\"status_blocked\";a:2:{s:7:\"subject\";s:64:\"Account details for [user:display-name] at [site:name] (blocked)\";s:4:\"body\";s:89:\"[user:display-name],\n\nYour account on [site:name] has been blocked.\n\n--  [site:name] team\";}s:15:\"status_canceled\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (canceled)\";s:4:\"body\";s:90:\"[user:display-name],\n\nYour account on [site:name] has been canceled.\n\n--  [site:name] team\";}}",
))
->values(array(
  'collection' => '',
  'name' => 'user.role.anonymous',
  'data' => 'a:10:{s:4:"uuid";s:36:"f834bbb1-fb07-4c5e-b128-ab92cc8f07c8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j5zLMOdJBqC0bMvSdth5UebkprJB8g_2FXHqhfpJzow";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:1:{i:0;s:14:"access content";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.authenticated',
  'data' => 'a:10:{s:4:"uuid";s:36:"c60ebf7d-075a-4731-85f6-59f661e037eb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dJ0L2DNSj5q6XVZAGsuVDpJTh5UeYkIPwKrUOOpr8YI";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:1:{i:0;s:14:"access content";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.settings',
  'data' => 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:23:"visitors_admin_approval";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'views.settings',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8oDr9oPVb_ostrNnVV6V7VdphwoH_u-NqTS0u7SE7qc";}s:17:"display_extenders";a:0:{}s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.view_search_colorful_organization',
  'data' => 'a:12:{s:4:"uuid";s:36:"3329cb8a-8c37-44eb-a5c2-77f5c3645ecf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:38:"search_api.index.colorful_organization";i:1;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:10:"search_api";}}s:2:"id";s:33:"view_search_colorful_organization";s:5:"label";s:35:"View: Search: Colorful organization";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:38:"search_api_index_colorful_organization";s:10:"base_field";s:13:"search_api_id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:35:"View: Search: Colorful organization";s:6:"fields";a:1:{s:4:"name";a:40:{s:2:"id";s:4:"name";s:5:"table";s:38:"search_api_index_colorful_organization";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";N;s:9:"plugin_id";s:16:"search_api_field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:15:"field_rendering";b:1;s:16:"fallback_handler";s:10:"search_api";s:16:"fallback_options";a:4:{s:12:"link_to_item";b:0;s:16:"use_highlighting";b:0;s:10:"multi_type";s:9:"separator";s:15:"multi_separator";s:2:", ";}}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:20:"search_api_relevance";a:10:{s:2:"id";s:20:"search_api_relevance";s:5:"table";s:38:"search_api_index_colorful_organization";s:5:"field";s:20:"search_api_relevance";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"search_api";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:1:{s:19:"search_api_fulltext";a:17:{s:2:"id";s:19:"search_api_fulltext";s:5:"table";s:38:"search_api_index_colorful_organization";s:5:"field";s:19:"search_api_fulltext";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:19:"search_api_fulltext";s:8:"operator";s:3:"and";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:22:"search_api_fulltext_op";s:5:"label";s:15:"Fulltext search";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:22:"search_api_fulltext_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:19:"search_api_fulltext";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:13:"expose_fields";b:0;s:11:"placeholder";s:0:"";s:18:"searched_fields_id";s:35:"search_api_fulltext_searched_fields";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:10:"parse_mode";s:5:"terms";s:10:"min_length";N;s:6:"fields";a:0:{}}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:2:{s:4:"type";s:10:"search_api";s:7:"options";a:1:{s:10:"view_modes";a:1:{s:11:"entity:user";a:1:{s:4:"user";s:7:"default";}}}}s:5:"query";a:2:{s:4:"type";s:16:"search_api_query";s:7:"options";a:4:{s:13:"bypass_access";b:0;s:11:"skip_access";b:0;s:25:"preserve_facet_query_args";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:1:{i:0;s:45:"config:search_api.index.colorful_organization";}}}s:11:"page_search";a:6:{s:2:"id";s:11:"page_search";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:33:"view-search-colorful-organization";s:4:"menu";a:4:{s:4:"type";s:6:"normal";s:5:"title";s:35:"View: Search: Colorful organization";s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:1:{i:0;s:45:"config:search_api.index.colorful_organization";}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.view_search_drab_feather',
  'data' => 'a:12:{s:4:"uuid";s:36:"07d6603d-8cff-46f5-bca9-179bb740abd3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:23:"field.storage.node.body";i:1;s:29:"search_api.index.drab_feather";i:2;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:10:"search_api";i:1;s:4:"text";}}s:2:"id";s:24:"view_search_drab_feather";s:5:"label";s:26:"View: Search: Drab feather";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:29:"search_api_index_drab_feather";s:10:"base_field";s:13:"search_api_id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:26:"View: Search: Drab feather";s:6:"fields";a:2:{s:4:"body";a:40:{s:2:"id";s:4:"body";s:5:"table";s:29:"search_api_index_drab_feather";s:5:"field";s:4:"body";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";N;s:9:"plugin_id";s:16:"search_api_field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:15:"field_rendering";b:1;s:16:"fallback_handler";s:10:"search_api";s:16:"fallback_options";a:4:{s:12:"link_to_item";b:0;s:16:"use_highlighting";b:0;s:10:"multi_type";s:9:"separator";s:15:"multi_separator";s:2:", ";}}s:5:"title";a:38:{s:2:"id";s:5:"title";s:5:"table";s:29:"search_api_index_drab_feather";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"search_api_field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:15:"field_rendering";b:1;s:16:"fallback_handler";s:10:"search_api";s:16:"fallback_options";a:4:{s:12:"link_to_item";b:0;s:16:"use_highlighting";b:0;s:10:"multi_type";s:9:"separator";s:15:"multi_separator";s:2:", ";}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:20:"search_api_relevance";a:10:{s:2:"id";s:20:"search_api_relevance";s:5:"table";s:29:"search_api_index_drab_feather";s:5:"field";s:20:"search_api_relevance";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"search_api";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:1:{s:19:"search_api_fulltext";a:17:{s:2:"id";s:19:"search_api_fulltext";s:5:"table";s:29:"search_api_index_drab_feather";s:5:"field";s:19:"search_api_fulltext";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:19:"search_api_fulltext";s:8:"operator";s:3:"and";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:22:"search_api_fulltext_op";s:5:"label";s:15:"Fulltext search";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:22:"search_api_fulltext_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:19:"search_api_fulltext";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:13:"expose_fields";b:0;s:11:"placeholder";s:0:"";s:18:"searched_fields_id";s:35:"search_api_fulltext_searched_fields";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:10:"parse_mode";s:5:"terms";s:10:"min_length";N;s:6:"fields";a:0:{}}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:2:{s:4:"type";s:10:"search_api";s:7:"options";a:1:{s:10:"view_modes";a:1:{s:11:"entity:node";a:1:{s:4:"page";s:7:"default";}}}}s:5:"query";a:2:{s:4:"type";s:16:"search_api_query";s:7:"options";a:4:{s:13:"bypass_access";b:0;s:11:"skip_access";b:0;s:25:"preserve_facet_query_args";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:1:{i:0;s:30:"config:field.storage.node.body";}}}s:10:"page_query";a:6:{s:2:"id";s:10:"page_query";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:24:"view-search-drab-feather";s:4:"menu";a:4:{s:4:"type";s:6:"normal";s:5:"title";s:26:"View: Search: Drab feather";s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:1:{i:0;s:30:"config:field.storage.node.body";}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.view_search_parched_arithmetic',
  'data' => 'a:12:{s:4:"uuid";s:36:"6bee6afd-f221-49d6-b869-e3450d68e53e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:23:"field.storage.node.body";i:1;s:35:"search_api.index.parched_arithmetic";i:2;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:10:"search_api";i:1;s:4:"text";}}s:2:"id";s:30:"view_search_parched_arithmetic";s:5:"label";s:32:"View: Search: Parched arithmetic";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:35:"search_api_index_parched_arithmetic";s:10:"base_field";s:13:"search_api_id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:32:"View: Search: Parched arithmetic";s:6:"fields";a:1:{s:4:"body";a:40:{s:2:"id";s:4:"body";s:5:"table";s:35:"search_api_index_parched_arithmetic";s:5:"field";s:4:"body";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";N;s:9:"plugin_id";s:16:"search_api_field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:15:"field_rendering";b:1;s:16:"fallback_handler";s:10:"search_api";s:16:"fallback_options";a:4:{s:12:"link_to_item";b:0;s:16:"use_highlighting";b:0;s:10:"multi_type";s:9:"separator";s:15:"multi_separator";s:2:", ";}}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:20:"search_api_relevance";a:10:{s:2:"id";s:20:"search_api_relevance";s:5:"table";s:35:"search_api_index_parched_arithmetic";s:5:"field";s:20:"search_api_relevance";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"search_api";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:1:{s:19:"search_api_fulltext";a:17:{s:2:"id";s:19:"search_api_fulltext";s:5:"table";s:35:"search_api_index_parched_arithmetic";s:5:"field";s:19:"search_api_fulltext";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:19:"search_api_fulltext";s:8:"operator";s:3:"and";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:22:"search_api_fulltext_op";s:5:"label";s:15:"Fulltext search";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:22:"search_api_fulltext_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:19:"search_api_fulltext";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:13:"expose_fields";b:0;s:11:"placeholder";s:0:"";s:18:"searched_fields_id";s:35:"search_api_fulltext_searched_fields";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:10:"parse_mode";s:5:"terms";s:10:"min_length";N;s:6:"fields";a:0:{}}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:16:"search_api_query";s:7:"options";a:4:{s:13:"bypass_access";b:0;s:11:"skip_access";b:0;s:25:"preserve_facet_query_args";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";}s:4:"tags";a:2:{i:0;s:30:"config:field.storage.node.body";i:1;s:42:"config:search_api.index.parched_arithmetic";}}}s:12:"page_rummage";a:6:{s:2:"id";s:12:"page_rummage";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:30:"view-search-parched-arithmetic";s:4:"menu";a:4:{s:4:"type";s:6:"normal";s:5:"title";s:32:"View: Search: Parched arithmetic";s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";}s:4:"tags";a:2:{i:0;s:30:"config:field.storage.node.body";i:1;s:42:"config:search_api.index.parched_arithmetic";}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.view_search_robust_discussion',
  'data' => 'a:12:{s:4:"uuid";s:36:"c997133d-2c2e-4218-8423-8a2a2b477048";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"search_api.index.robust_discussion";i:1;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:10:"search_api";}}s:2:"id";s:29:"view_search_robust_discussion";s:5:"label";s:31:"View: Search: Robust discussion";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:34:"search_api_index_robust_discussion";s:10:"base_field";s:13:"search_api_id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:31:"View: Search: Robust discussion";s:6:"fields";a:1:{s:6:"access";a:40:{s:2:"id";s:6:"access";s:5:"table";s:34:"search_api_index_robust_discussion";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";N;s:9:"plugin_id";s:16:"search_api_field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:0:"";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:15:"field_rendering";b:1;s:16:"fallback_handler";s:10:"search_api";s:16:"fallback_options";a:4:{s:12:"link_to_item";b:0;s:16:"use_highlighting";b:0;s:10:"multi_type";s:9:"separator";s:15:"multi_separator";s:2:", ";}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:20:"search_api_relevance";a:10:{s:2:"id";s:20:"search_api_relevance";s:5:"table";s:34:"search_api_index_robust_discussion";s:5:"field";s:20:"search_api_relevance";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"search_api";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:1:{s:19:"search_api_fulltext";a:17:{s:2:"id";s:19:"search_api_fulltext";s:5:"table";s:34:"search_api_index_robust_discussion";s:5:"field";s:19:"search_api_fulltext";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:19:"search_api_fulltext";s:8:"operator";s:3:"and";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:22:"search_api_fulltext_op";s:5:"label";s:15:"Fulltext search";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:22:"search_api_fulltext_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:19:"search_api_fulltext";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:13:"expose_fields";b:0;s:11:"placeholder";s:0:"";s:18:"searched_fields_id";s:35:"search_api_fulltext_searched_fields";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:10:"parse_mode";s:5:"terms";s:10:"min_length";N;s:6:"fields";a:0:{}}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:16:"search_api_query";s:7:"options";a:4:{s:13:"bypass_access";b:0;s:11:"skip_access";b:0;s:25:"preserve_facet_query_args";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:0:{}}}s:12:"page_explore";a:6:{s:2:"id";s:12:"page_explore";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:29:"view-search-robust-discussion";s:4:"menu";a:4:{s:4:"type";s:6:"normal";s:5:"title";s:31:"View: Search: Robust discussion";s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.view_search_yummy_lettuce',
  'data' => 'a:12:{s:4:"uuid";s:36:"2bb13dbf-9b2b-48ab-9846-5636f0c2a376";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:23:"field.storage.node.body";i:1;s:30:"search_api.index.yummy_lettuce";i:2;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:10:"search_api";i:1;s:4:"text";}}s:2:"id";s:25:"view_search_yummy_lettuce";s:5:"label";s:27:"View: Search: Yummy lettuce";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:30:"search_api_index_yummy_lettuce";s:10:"base_field";s:13:"search_api_id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:27:"View: Search: Yummy lettuce";s:6:"fields";a:1:{s:4:"body";a:40:{s:2:"id";s:4:"body";s:5:"table";s:30:"search_api_index_yummy_lettuce";s:5:"field";s:4:"body";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";N;s:9:"plugin_id";s:16:"search_api_field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:15:"field_rendering";b:1;s:16:"fallback_handler";s:10:"search_api";s:16:"fallback_options";a:4:{s:12:"link_to_item";b:0;s:16:"use_highlighting";b:0;s:10:"multi_type";s:9:"separator";s:15:"multi_separator";s:2:", ";}}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:20:"search_api_relevance";a:10:{s:2:"id";s:20:"search_api_relevance";s:5:"table";s:30:"search_api_index_yummy_lettuce";s:5:"field";s:20:"search_api_relevance";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"search_api";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:1:{s:19:"search_api_fulltext";a:17:{s:2:"id";s:19:"search_api_fulltext";s:5:"table";s:30:"search_api_index_yummy_lettuce";s:5:"field";s:19:"search_api_fulltext";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:19:"search_api_fulltext";s:8:"operator";s:3:"and";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:22:"search_api_fulltext_op";s:5:"label";s:15:"Fulltext search";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:22:"search_api_fulltext_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:19:"search_api_fulltext";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:13:"expose_fields";b:0;s:11:"placeholder";s:0:"";s:18:"searched_fields_id";s:35:"search_api_fulltext_searched_fields";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:10:"parse_mode";s:5:"terms";s:10:"min_length";N;s:6:"fields";a:0:{}}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:16:"search_api_query";s:7:"options";a:4:{s:13:"bypass_access";b:0;s:11:"skip_access";b:0;s:25:"preserve_facet_query_args";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:1:{i:0;s:30:"config:field.storage.node.body";}}}s:9:"page_seek";a:6:{s:2:"id";s:9:"page_seek";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:25:"view-search-yummy-lettuce";s:4:"menu";a:4:{s:4:"type";s:6:"normal";s:5:"title";s:27:"View: Search: Yummy lettuce";s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:1:{i:0;s:30:"config:field.storage.node.body";}}}}}',
))
->execute();
$connection->schema()->createTable('key_value', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('key_value')
->fields(array(
  'collection',
  'name',
  'value',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:01264f90-f3ea-4fb3-b878-da6b7bd0fffa',
  'value' => 'a:1:{i:0;s:37:"system.action.node_make_sticky_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:318f7a06-4dbe-46d8-b0a8-8be5e7194da2',
  'value' => 'a:1:{i:0;s:33:"system.action.node_promote_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:835c43b3-dbb9-49dd-847f-d40bfd25b36e',
  'value' => 'a:1:{i:0;s:38:"system.action.user_unblock_user_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:882e6831-a888-4427-9f8a-6de0dbf861e3',
  'value' => 'a:1:{i:0;s:35:"system.action.node_unpublish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:8a1e86b5-f41e-4286-ae75-8b9eb919ee3f',
  'value' => 'a:1:{i:0;s:30:"system.action.node_save_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:976e2d47-7be9-4ca9-90a3-adec3509f1a3',
  'value' => 'a:1:{i:0;s:39:"system.action.node_make_unsticky_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:9daf1a1d-ef25-466a-a35f-e76882793bbd',
  'value' => 'a:1:{i:0;s:35:"system.action.node_unpromote_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:c1d028a2-bf5d-4b96-9562-2eb3e4832d7a',
  'value' => 'a:1:{i:0;s:36:"system.action.user_block_user_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:d02d50af-330c-48cf-b28d-68eb7e7c88bf',
  'value' => 'a:1:{i:0;s:37:"system.action.user_cancel_user_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:e87f13f2-ca46-4915-9c5b-5eea38306b1e',
  'value' => 'a:1:{i:0;s:33:"system.action.node_publish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:f56a7000-25eb-4277-b4c0-8ddfc3ad77e6',
  'value' => 'a:1:{i:0;s:32:"system.action.node_delete_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'theme:stark',
  'value' => 'a:7:{i:0;s:28:"block.block.stark_page_title";i:1;s:29:"block.block.stark_local_tasks";i:2;s:31:"block.block.stark_local_actions";i:3;s:26:"block.block.stark_messages";i:4;s:26:"block.block.stark_branding";i:5;s:23:"block.block.stark_admin";i:6;s:23:"block.block.stark_tools";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:401917a4-c2e5-400c-b000-f8772b11ebdc',
  'value' => 'a:1:{i:0;s:28:"block.block.stark_page_title";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:52b4e949-b9ae-4bd5-952c-912d9ca06548',
  'value' => 'a:1:{i:0;s:31:"block.block.stark_local_actions";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:5ad7b49d-3015-45dd-96ef-a56007e86172',
  'value' => 'a:1:{i:0;s:29:"block.block.stark_local_tasks";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:c97760f9-fa87-4c3e-9be8-5791c0ba0e53',
  'value' => 'a:1:{i:0;s:26:"block.block.stark_branding";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:d5adac31-7b75-4a3b-b912-35343332e967',
  'value' => 'a:1:{i:0;s:23:"block.block.stark_tools";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:fb9d5bdb-c7d5-4364-b6ca-d28da63123b0',
  'value' => 'a:1:{i:0;s:26:"block.block.stark_messages";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:fcf27115-9ff9-4ee2-96a5-bdb9c05c2ede',
  'value' => 'a:1:{i:0;s:23:"block.block.stark_admin";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:05863111-6df5-4737-ac7b-c29ec6f87697',
  'value' => 'a:1:{i:0;s:23:"core.date_format.medium";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:3544730f-5ca7-48b9-b624-91981e9d485b',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_week";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:4220aa60-0f12-440b-9cbd-b81472ccd135',
  'value' => 'a:1:{i:0;s:25:"core.date_format.fallback";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:6bdad038-d30c-46d9-bbbf-a02d0d092df2',
  'value' => 'a:1:{i:0;s:27:"core.date_format.html_month";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:744ef199-4c24-4c2d-af24-c4f8c4022f54',
  'value' => 'a:1:{i:0;s:30:"core.date_format.html_datetime";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:77151777-a2f7-4216-9282-c26356557fc8',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_time";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:775aed12-f1ac-43e0-bc3a-3986db1e2be5',
  'value' => 'a:1:{i:0;s:22:"core.date_format.short";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:9798a0a3-98f6-4100-8627-e9063c4e0f95',
  'value' => 'a:1:{i:0;s:35:"core.date_format.html_yearless_date";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:b2677589-0046-4372-8520-8e59c3bce6ed',
  'value' => 'a:1:{i:0;s:21:"core.date_format.long";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:b6666537-c921-45a1-8e91-8196b4d282b2',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_date";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:da7e77f9-1267-4e34-a878-a3ef0318fc21',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_year";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:8432dc25-0cf4-41c5-ba55-7cd1e9742ec0',
  'value' => 'a:1:{i:0;s:42:"core.entity_form_display.node.page.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_mode',
  'name' => 'uuid:f41a115b-5f35-4f7f-84c9-3aea7608f06d',
  'value' => 'a:1:{i:0;s:35:"core.entity_form_mode.user.register";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:c5fd3018-858e-4848-b14a-2051d2ff4f3b',
  'value' => 'a:1:{i:0;s:42:"core.entity_view_display.node.page.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:f01aef4f-f724-4d6b-93c3-d0a21ab9920d',
  'value' => 'a:1:{i:0;s:41:"core.entity_view_display.node.page.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:05a6655c-2d5e-4f18-8846-e92ca7a76c1a',
  'value' => 'a:1:{i:0;s:31:"core.entity_view_mode.user.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:13ad69c2-052f-4a60-ad9a-e27010b0c6d2',
  'value' => 'a:1:{i:0;s:39:"core.entity_view_mode.node.search_index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:17461be9-d62a-45a1-afc7-19b19ade3301',
  'value' => 'a:1:{i:0;s:30:"core.entity_view_mode.node.rss";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:255e0239-bb23-4beb-97c0-d4242371bc3f',
  'value' => 'a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:9c294639-1b34-4a1a-afa8-4627740db481',
  'value' => 'a:1:{i:0;s:40:"core.entity_view_mode.node.search_result";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:a5e1f8b2-34cd-46a5-aa64-c12b82d86597',
  'value' => 'a:1:{i:0;s:34:"core.entity_view_mode.user.compact";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:e9548fd8-4785-4763-ac08-33b091817552',
  'value' => 'a:1:{i:0;s:31:"core.entity_view_mode.node.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:c6dfa52f-5b49-4fae-9d7d-4805eff4f814',
  'value' => 'a:1:{i:0;s:26:"field.field.node.page.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:73d16e8c-f281-4338-a40a-60957448edfc',
  'value' => 'a:1:{i:0;s:23:"field.storage.node.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.filter_format',
  'name' => 'uuid:322bbc57-e399-472a-bcba-1fbd9051bed9',
  'value' => 'a:1:{i:0;s:24:"filter.format.plain_text";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:04b4b7b7-fe43-426d-a0d7-51c2766e23df',
  'value' => 'a:1:{i:0;s:19:"system.menu.account";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:41d51db4-83bd-4b18-9bfe-13c0deb31436',
  'value' => 'a:1:{i:0;s:18:"system.menu.footer";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:6285ecd7-f640-4d53-87f9-72b0fb91c0f0',
  'value' => 'a:1:{i:0;s:17:"system.menu.admin";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:66cfbefa-d9a4-4992-9b10-1dde97e8c145',
  'value' => 'a:1:{i:0;s:16:"system.menu.main";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:e62953d0-d064-43ea-ae72-cd2c5660a180',
  'value' => 'a:1:{i:0;s:17:"system.menu.tools";}',
))
->values(array(
  'collection' => 'config.entity.key_store.node_type',
  'name' => 'uuid:075eac33-0c00-4036-ad55-d0a775e9a59b',
  'value' => 'a:1:{i:0;s:14:"node.type.page";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:245096ec-9535-4727-82a9-12ed241547c1',
  'value' => 'a:1:{i:0;s:30:"search_api.index.yummy_lettuce";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:44923017-13a1-4eb1-ad6e-87159de6526a',
  'value' => 'a:1:{i:0;s:34:"search_api.index.robust_discussion";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:53eab7f3-8b14-449f-8da9-9f91364a833c',
  'value' => 'a:1:{i:0;s:35:"search_api.index.parched_arithmetic";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:59543ae1-8068-40f8-87e0-bcf197523b14',
  'value' => 'a:1:{i:0;s:29:"search_api.index.drab_feather";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:f66681aa-c8a8-4a22-8248-1c1b603c4995',
  'value' => 'a:1:{i:0;s:38:"search_api.index.colorful_organization";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:1494994e-7309-45a3-98ed-4588137565c0',
  'value' => 'a:1:{i:0;s:34:"search_api.server.circular_opinion";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:d4d3cf1a-e2d9-4020-869d-f85be72d25a6',
  'value' => 'a:1:{i:0;s:31:"search_api.server.oval_decision";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:f19831dd-09e9-4551-a946-81ba191b8254',
  'value' => 'a:1:{i:0;s:34:"search_api.server.octagonal_rhythm";}',
))
->values(array(
  'collection' => 'config.entity.key_store.user_role',
  'name' => 'uuid:c60ebf7d-075a-4731-85f6-59f661e037eb',
  'value' => 'a:1:{i:0;s:23:"user.role.authenticated";}',
))
->values(array(
  'collection' => 'config.entity.key_store.user_role',
  'name' => 'uuid:f834bbb1-fb07-4c5e-b128-ab92cc8f07c8',
  'value' => 'a:1:{i:0;s:19:"user.role.anonymous";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:07d6603d-8cff-46f5-bca9-179bb740abd3',
  'value' => 'a:1:{i:0;s:35:"views.view.view_search_drab_feather";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:2bb13dbf-9b2b-48ab-9846-5636f0c2a376',
  'value' => 'a:1:{i:0;s:36:"views.view.view_search_yummy_lettuce";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:3329cb8a-8c37-44eb-a5c2-77f5c3645ecf',
  'value' => 'a:1:{i:0;s:44:"views.view.view_search_colorful_organization";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:6bee6afd-f221-49d6-b869-e3450d68e53e',
  'value' => 'a:1:{i:0;s:41:"views.view.view_search_parched_arithmetic";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:c997133d-2c2e-4218-8423-8a2a2b477048',
  'value' => 'a:1:{i:0;s:40:"views.view.view_search_robust_discussion";}',
))
->values(array(
  'collection' => 'entity.definitions.bundle_field_map',
  'name' => 'node',
  'value' => 'a:1:{s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:1:{s:4:"page";s:4:"page";}}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'action.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:6:"action";s:8:" * class";s:27:"Drupal\system\Entity\Action";s:11:" * provider";s:6:"system";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:27:"Drupal\system\Entity\Action";s:11:" * handlers";a:2:{s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:18:"administer actions";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Action";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Actions";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"action";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"actions";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:13:"@count action";s:6:"plural";s:14:"@count actions";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:18:"config:action_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"type";i:3;s:6:"plugin";i:4;s:13:"configuration";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'base_field_override.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:19:"base_field_override";s:8:" * class";s:42:"Drupal\Core\Field\Entity\BaseFieldOverride";s:11:" * provider";s:4:"core";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:42:"Drupal\Core\Field\Entity\BaseFieldOverride";s:11:" * handlers";a:2:{s:7:"storage";s:42:"Drupal\Core\Field\BaseFieldOverrideStorage";s:6:"access";s:55:"Drupal\Core\Field\BaseFieldOverrideAccessControlHandler";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Base field override";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:31:"config:base_field_override_list";}s:14:" * constraints";a:1:{s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:6:"bundle";i:3;s:10:"field_name";i:4;s:10:"field_type";}}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:19:"base_field_override";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'block.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:5:"block";s:8:" * class";s:25:"Drupal\block\Entity\Block";s:11:" * provider";s:5:"block";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:25:"Drupal\block\Entity\Block";s:11:" * handlers";a:5:{s:6:"access";s:38:"Drupal\block\BlockAccessControlHandler";s:12:"view_builder";s:29:"Drupal\block\BlockViewBuilder";s:12:"list_builder";s:29:"Drupal\block\BlockListBuilder";s:4:"form";a:2:{s:7:"default";s:22:"Drupal\block\BlockForm";s:6:"delete";s:33:"Drupal\block\Form\BlockDeleteForm";}s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:17:"administer blocks";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:4:{s:11:"delete-form";s:44:"/admin/structure/block/manage/{block}/delete";s:9:"edit-form";s:37:"/admin/structure/block/manage/{block}";s:6:"enable";s:44:"/admin/structure/block/manage/{block}/enable";s:7:"disable";s:45:"/admin/structure/block/manage/{block}/disable";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Block";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Blocks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"block";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"blocks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:12:"@count block";s:6:"plural";s:13:"@count blocks";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:17:"config:block_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:2:{i:0;s:5:"theme";i:1;s:4:"uuid";}s:16:" * config_export";a:8:{i:0;s:2:"id";i:1;s:5:"theme";i:2;s:6:"region";i:3;s:6:"weight";i:4;s:8:"provider";i:5;s:6:"plugin";i:6;s:8:"settings";i:7;s:10:"visibility";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'date_format.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:11:"date_format";s:8:" * class";s:38:"Drupal\Core\Datetime\Entity\DateFormat";s:11:" * provider";s:4:"core";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:38:"Drupal\Core\Datetime\Entity\DateFormat";s:11:" * handlers";a:4:{s:6:"access";s:44:"Drupal\system\DateFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\system\Form\DateFormatAddForm";s:4:"edit";s:37:"Drupal\system\Form\DateFormatEditForm";s:6:"delete";s:39:"Drupal\system\Form\DateFormatDeleteForm";}s:12:"list_builder";s:35:"Drupal\system\DateFormatListBuilder";}s:19:" * admin_permission";s:29:"administer site configuration";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:3:{s:9:"edit-form";s:61:"/admin/config/regional/date-time/formats/manage/{date_format}";s:11:"delete-form";s:68:"/admin/config/regional/date-time/formats/manage/{date_format}/delete";s:10:"collection";s:40:"/admin/config/regional/date-time/formats";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Date format";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:8:"rendered";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"locked";i:3;s:7:"pattern";}s:21:" * mergedConfigExport";a:10:{s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:6:"status";s:6:"status";s:12:"dependencies";s:12:"dependencies";s:20:"third_party_settings";s:20:"third_party_settings";s:5:"_core";s:5:"_core";s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"locked";s:6:"locked";s:7:"pattern";s:7:"pattern";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'entity_form_display.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:19:"entity_form_display";s:8:" * class";s:43:"Drupal\Core\Entity\Entity\EntityFormDisplay";s:11:" * provider";s:4:"core";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:43:"Drupal\Core\Entity\Entity\EntityFormDisplay";s:11:" * handlers";a:2:{s:6:"access";s:71:"\Drupal\Core\Entity\Entity\Access\EntityFormDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Entity form display";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:31:"config:entity_form_display_list";}s:14:" * constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'entity_form_mode.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:16:"entity_form_mode";s:8:" * class";s:40:"Drupal\Core\Entity\Entity\EntityFormMode";s:11:" * provider";s:4:"core";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:40:"Drupal\Core\Entity\Entity\EntityFormMode";s:11:" * handlers";a:2:{s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Form mode";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:28:"config:entity_form_mode_list";}s:14:" * constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'entity_view_display.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:19:"entity_view_display";s:8:" * class";s:43:"Drupal\Core\Entity\Entity\EntityViewDisplay";s:11:" * provider";s:4:"core";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:43:"Drupal\Core\Entity\Entity\EntityViewDisplay";s:11:" * handlers";a:2:{s:6:"access";s:71:"\Drupal\Core\Entity\Entity\Access\EntityViewDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Entity view display";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:31:"config:entity_view_display_list";}s:14:" * constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'entity_view_mode.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:16:"entity_view_mode";s:8:" * class";s:40:"Drupal\Core\Entity\Entity\EntityViewMode";s:11:" * provider";s:4:"core";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:40:"Drupal\Core\Entity\Entity\EntityViewMode";s:11:" * handlers";a:2:{s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"View mode";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:28:"config:entity_view_mode_list";}s:14:" * constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'field_config.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:12:"field_config";s:8:" * class";s:31:"Drupal\field\Entity\FieldConfig";s:11:" * provider";s:5:"field";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:31:"Drupal\field\Entity\FieldConfig";s:11:" * handlers";a:2:{s:6:"access";s:44:"Drupal\field\FieldConfigAccessControlHandler";s:7:"storage";s:31:"Drupal\field\FieldConfigStorage";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Field";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Fields";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"field";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"fields";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:12:"@count field";s:6:"plural";s:13:"@count fields";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:24:"config:field_config_list";}s:14:" * constraints";a:2:{s:26:"RequiredConfigDependencies";a:1:{i:0;s:20:"field_storage_config";}s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:6:"bundle";i:4;s:10:"field_type";}}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:5:"field";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'field_storage_config.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:20:"field_storage_config";s:8:" * class";s:38:"Drupal\field\Entity\FieldStorageConfig";s:11:" * provider";s:5:"field";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:38:"Drupal\field\Entity\FieldStorageConfig";s:11:" * handlers";a:2:{s:6:"access";s:51:"Drupal\field\FieldStorageConfigAccessControlHandler";s:7:"storage";s:38:"Drupal\field\FieldStorageConfigStorage";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Field storage";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Field storages";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"field storage";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"field storages";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:20:"@count field storage";s:6:"plural";s:21:"@count field storages";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:32:"config:field_storage_config_list";}s:14:" * constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:4:"type";}}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:7:"storage";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:4:"type";i:4;s:8:"settings";i:5;s:6:"module";i:6;s:6:"locked";i:7;s:11:"cardinality";i:8;s:12:"translatable";i:9;s:7:"indexes";i:10;s:22:"persist_with_no_fields";i:11;s:14:"custom_storage";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'filter_format.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:13:"filter_format";s:8:" * class";s:33:"Drupal\filter\Entity\FilterFormat";s:11:" * provider";s:6:"filter";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:10:{s:2:"id";s:6:"format";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:33:"Drupal\filter\Entity\FilterFormat";s:11:" * handlers";a:4:{s:4:"form";a:3:{s:3:"add";s:33:"Drupal\filter\FilterFormatAddForm";s:4:"edit";s:34:"Drupal\filter\FilterFormatEditForm";s:7:"disable";s:36:"Drupal\filter\Form\FilterDisableForm";}s:12:"list_builder";s:37:"Drupal\filter\FilterFormatListBuilder";s:6:"access";s:46:"Drupal\filter\FilterFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:18:"administer filters";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:2:{s:9:"edit-form";s:52:"/admin/config/content/formats/manage/{filter_format}";s:7:"disable";s:60:"/admin/config/content/formats/manage/{filter_format}/disable";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Text format";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Text formats";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"text format";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"text formats";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:18:"@count text format";s:6:"plural";s:19:"@count text formats";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:25:"config:filter_format_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:6:"format";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:4:"name";i:1;s:6:"format";i:2;s:6:"weight";i:3;s:5:"roles";i:4;s:7:"filters";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'menu.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:4:"menu";s:8:" * class";s:25:"Drupal\system\Entity\Menu";s:11:" * provider";s:6:"system";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:25:"Drupal\system\Entity\Menu";s:11:" * handlers";a:2:{s:6:"access";s:38:"Drupal\system\MenuAccessControlHandler";s:7:"storage";s:25:"Drupal\system\MenuStorage";}s:19:" * admin_permission";s:15:"administer menu";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Menu";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Menus";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"menu";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"menus";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:11:"@count menu";s:6:"plural";s:12:"@count menus";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:16:"config:menu_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:6:"locked";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'node.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":41:{s:5:" * id";s:4:"node";s:8:" * class";s:23:"Drupal\node\Entity\Node";s:11:" * provider";s:4:"node";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:12:{s:2:"id";s:3:"nid";s:8:"revision";s:3:"vid";s:6:"bundle";s:4:"type";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:9:"published";s:6:"status";s:3:"uid";s:3:"uid";s:5:"owner";s:3:"uid";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:23:"Drupal\node\Entity\Node";s:11:" * handlers";a:9:{s:7:"storage";s:23:"Drupal\node\NodeStorage";s:14:"storage_schema";s:29:"Drupal\node\NodeStorageSchema";s:12:"view_builder";s:27:"Drupal\node\NodeViewBuilder";s:6:"access";s:36:"Drupal\node\NodeAccessControlHandler";s:10:"views_data";s:25:"Drupal\node\NodeViewsData";s:4:"form";a:4:{s:7:"default";s:20:"Drupal\node\NodeForm";s:6:"delete";s:31:"Drupal\node\Form\NodeDeleteForm";s:4:"edit";s:20:"Drupal\node\NodeForm";s:23:"delete-multiple-confirm";s:31:"Drupal\node\Form\DeleteMultiple";}s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\node\Entity\NodeRouteProvider";}s:12:"list_builder";s:27:"Drupal\node\NodeListBuilder";s:11:"translation";s:34:"Drupal\node\NodeTranslationHandler";}s:19:" * admin_permission";N;s:24:" * collection_permission";s:23:"access content overview";s:25:" * permission_granularity";s:6:"bundle";s:8:" * links";a:7:{s:9:"canonical";s:12:"/node/{node}";s:11:"delete-form";s:19:"/node/{node}/delete";s:20:"delete-multiple-form";s:26:"/admin/content/node/delete";s:9:"edit-form";s:17:"/node/{node}/edit";s:15:"version-history";s:22:"/node/{node}/revisions";s:8:"revision";s:43:"/node/{node}/revisions/{node_revision}/view";s:6:"create";s:5:"/node";}s:21:" * bundle_entity_type";s:9:"node_type";s:12:" * bundle_of";N;s:15:" * bundle_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Content type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:13:" * base_table";s:4:"node";s:22:" * revision_data_table";s:19:"node_field_revision";s:17:" * revision_table";s:13:"node_revision";s:13:" * data_table";s:15:"node_field_data";s:11:" * internal";b:0;s:15:" * translatable";b:1;s:19:" * show_revision_ui";b:1;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"content item";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"content items";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:19:"@count content item";s:6:"plural";s:20:"@count content items";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";s:26:"entity.node_type.edit_form";s:26:" * common_reference_target";b:1;s:22:" * list_cache_contexts";a:1:{i:0;s:21:"user.node_grants:view";}s:18:" * list_cache_tags";a:1:{i:0;s:9:"node_list";}s:14:" * constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:4:{s:13:"revision_user";s:12:"revision_uid";s:16:"revision_created";s:18:"revision_timestamp";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'node.field_storage_definitions',
  'value' => 'a:19:{s:3:"nid";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"nid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:2;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"UUID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:36;}s:7:" * type";s:4:"uuid";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:3:"vid";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Revision ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:69;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"Language";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:103;}s:7:" * type";s:8:"language";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"type";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";s:12:"Content type";s:8:"required";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"type";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"node_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:" * fieldDefinition";r:139;}s:7:" * type";s:16:"entity_reference";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:18:"revision_timestamp";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"Revision create time";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:47:"The time that the current revision was created.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:18:"revision_timestamp";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:170;}s:7:" * type";s:7:"created";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:12:"revision_uid";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Revision user";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:50:"The user ID of the author of the current revision.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:" * fieldDefinition";r:200;}s:7:" * type";s:16:"entity_reference";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:12:"revision_log";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"Revision log message";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:43:"Briefly describe the changes you have made.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:237;}s:7:" * type";s:11:"string_long";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:6:"status";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Published";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:120;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:279;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:3:"uid";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:11:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Authored by";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:46:"Drupal\node\Entity\Node::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:35:"The username of the content author.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:3:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:" * fieldDefinition";r:326;}s:7:" * type";s:16:"entity_reference";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:5:"title";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Title";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:5:"title";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:380;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:7:"created";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Authored on";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:47:"The date and time that the content was created.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:9:"timestamp";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:424;}s:7:" * type";s:7:"created";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:7:"changed";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Changed";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:39:"The time that the node was last edited.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:466;}s:7:" * type";s:7:"changed";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:7:"promote";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:22:"Promoted to front page";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:15;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:497;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:6:"sticky";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:22:"Sticky at top of lists";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:16;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"sticky";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:544;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Default translation";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"A flag indicating whether this is the default translation.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:591;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:11:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Default revision";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:634;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:29:"Revision translation affected";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:676;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"body";O:38:"Drupal\field\Entity\FieldStorageConfig":30:{s:15:" * entityTypeId";s:20:"field_storage_config";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";s:9:"node.body";s:9:" * status";b:1;s:7:" * uuid";s:36:"73d16e8c-f281-4338-a40a-60957448edfc";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:14:" * trustedData";b:1;s:15:" * dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:12:" * isSyncing";b:0;s:5:" * id";s:9:"node.body";s:13:" * field_name";s:4:"body";s:14:" * entity_type";s:4:"node";s:7:" * type";s:17:"text_with_summary";s:9:" * module";s:4:"text";s:11:" * settings";a:0:{}s:14:" * cardinality";i:1;s:15:" * translatable";b:1;s:9:" * locked";b:0;s:25:" * persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:" * indexes";a:0:{}s:10:" * deleted";b:0;}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'node_type.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:9:"node_type";s:8:" * class";s:27:"Drupal\node\Entity\NodeType";s:11:" * provider";s:4:"node";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:4:"type";s:5:"label";s:4:"name";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:27:"Drupal\node\Entity\NodeType";s:11:" * handlers";a:5:{s:6:"access";s:40:"Drupal\node\NodeTypeAccessControlHandler";s:4:"form";a:3:{s:3:"add";s:24:"Drupal\node\NodeTypeForm";s:4:"edit";s:24:"Drupal\node\NodeTypeForm";s:6:"delete";s:38:"Drupal\node\Form\NodeTypeDeleteConfirm";}s:14:"route_provider";a:1:{s:11:"permissions";s:49:"Drupal\user\Entity\EntityPermissionsRouteProvider";}s:12:"list_builder";s:31:"Drupal\node\NodeTypeListBuilder";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:24:"administer content types";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:4:{s:9:"edit-form";s:41:"/admin/structure/types/manage/{node_type}";s:11:"delete-form";s:48:"/admin/structure/types/manage/{node_type}/delete";s:23:"entity-permissions-form";s:53:"/admin/structure/types/manage/{node_type}/permissions";s:10:"collection";s:22:"/admin/structure/types";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";s:4:"node";s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Content type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Content types";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"content type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"content types";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:19:"@count content type";s:6:"plural";s:20:"@count content types";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:21:"config:node_type_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:4:"type";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:7:{i:0;s:4:"name";i:1;s:4:"type";i:2;s:11:"description";i:3;s:4:"help";i:4;s:12:"new_revision";i:5;s:12:"preview_mode";i:6;s:17:"display_submitted";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'path_alias.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":41:{s:5:" * id";s:10:"path_alias";s:8:" * class";s:34:"Drupal\path_alias\Entity\PathAlias";s:11:" * provider";s:10:"path_alias";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:34:"Drupal\path_alias\Entity\PathAlias";s:11:" * handlers";a:4:{s:7:"storage";s:34:"Drupal\path_alias\PathAliasStorage";s:14:"storage_schema";s:40:"Drupal\path_alias\PathAliasStorageSchema";s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:12:"view_builder";s:36:"Drupal\Core\Entity\EntityViewBuilder";}s:19:" * admin_permission";s:22:"administer url aliases";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";s:10:"path_alias";s:22:" * revision_data_table";N;s:17:" * revision_table";s:19:"path_alias_revision";s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"URL alias";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"URL aliases";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"URL alias";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"URL aliases";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:16:"@count URL alias";s:6:"plural";s:18:"@count URL aliases";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:11:"route_match";}s:14:" * constraints";a:2:{s:15:"UniquePathAlias";a:0:{}s:26:"EntityUntranslatableFields";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'path_alias.field_storage_definitions',
  'value' => 'a:8:{s:2:"id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:2:"id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:2;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"UUID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:36;}s:7:" * type";s:4:"uuid";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Revision ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:69;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"Language";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:3:"und";}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:103;}s:7:" * type";s:8:"language";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"path";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"System path";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:36:"The path that this alias belongs to.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"path";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:9:"ValidPath";a:0:{}s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\//i";s:7:"message";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:42:"The source path has to start with a slash.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}}}}s:18:" * fieldDefinition";r:141;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:5:"alias";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"URL alias";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:29:"An alias used with this path.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:5:"alias";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:1:{s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\//i";s:7:"message";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:41:"The alias path has to start with a slash.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}}}}s:18:" * fieldDefinition";r:187;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:6:"status";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Published";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:6:"status";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:232;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:11:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Default revision";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:271;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_index.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:16:"search_api_index";s:8:" * class";s:30:"Drupal\search_api\Entity\Index";s:11:" * provider";s:10:"search_api";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:4:"name";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:30:"Drupal\search_api\Entity\Index";s:11:" * handlers";a:4:{s:7:"storage";s:53:"Drupal\search_api\Entity\SearchApiConfigEntityStorage";s:12:"list_builder";s:34:"Drupal\search_api\IndexListBuilder";s:4:"form";a:12:{s:7:"default";s:32:"Drupal\search_api\Form\IndexForm";s:4:"edit";s:32:"Drupal\search_api\Form\IndexForm";s:6:"fields";s:38:"Drupal\search_api\Form\IndexFieldsForm";s:10:"add_fields";s:41:"Drupal\search_api\Form\IndexAddFieldsForm";s:12:"field_config";s:45:"Drupal\search_api\Form\FieldConfigurationForm";s:10:"break_lock";s:41:"Drupal\search_api\Form\IndexBreakLockForm";s:10:"processors";s:42:"Drupal\search_api\Form\IndexProcessorsForm";s:6:"delete";s:45:"Drupal\search_api\Form\IndexDeleteConfirmForm";s:7:"disable";s:46:"Drupal\search_api\Form\IndexDisableConfirmForm";s:7:"reindex";s:46:"Drupal\search_api\Form\IndexReindexConfirmForm";s:5:"clear";s:44:"Drupal\search_api\Form\IndexClearConfirmForm";s:15:"rebuild_tracker";s:53:"Drupal\search_api\Form\IndexRebuildTrackerConfirmForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";}s:19:" * admin_permission";s:21:"administer search_api";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:11:{s:9:"canonical";s:56:"/admin/config/search/search-api/index/{search_api_index}";s:8:"add-form";s:41:"/admin/config/search/search-api/add-index";s:9:"edit-form";s:61:"/admin/config/search/search-api/index/{search_api_index}/edit";s:6:"fields";s:63:"/admin/config/search/search-api/index/{search_api_index}/fields";s:10:"add-fields";s:72:"/admin/config/search/search-api/index/{search_api_index}/fields/add/nojs";s:15:"add-fields-ajax";s:72:"/admin/config/search/search-api/index/{search_api_index}/fields/add/ajax";s:15:"break-lock-form";s:74:"/admin/config/search/search-api/index/{search_api_index}/fields/break-lock";s:10:"processors";s:67:"/admin/config/search/search-api/index/{search_api_index}/processors";s:11:"delete-form";s:63:"/admin/config/search/search-api/index/{search_api_index}/delete";s:7:"disable";s:64:"/admin/config/search/search-api/index/{search_api_index}/disable";s:6:"enable";s:63:"/admin/config/search/search-api/index/{search_api_index}/enable";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Search index";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Search indexes";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"search index";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"search indexes";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:19:"@count search index";s:6:"plural";s:21:"@count search indexes";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:28:"config:search_api_index_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:5:"index";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:10:{i:0;s:2:"id";i:1;s:4:"name";i:2;s:11:"description";i:3;s:9:"read_only";i:4;s:14:"field_settings";i:5;s:19:"datasource_settings";i:6;s:18:"processor_settings";i:7;s:16:"tracker_settings";i:8;s:7:"options";i:9;s:6:"server";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_server.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:17:"search_api_server";s:8:" * class";s:31:"Drupal\search_api\Entity\Server";s:11:" * provider";s:10:"search_api";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:4:"name";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:31:"Drupal\search_api\Entity\Server";s:11:" * handlers";a:3:{s:7:"storage";s:53:"Drupal\search_api\Entity\SearchApiConfigEntityStorage";s:4:"form";a:5:{s:7:"default";s:33:"Drupal\search_api\Form\ServerForm";s:4:"edit";s:33:"Drupal\search_api\Form\ServerForm";s:6:"delete";s:46:"Drupal\search_api\Form\ServerDeleteConfirmForm";s:7:"disable";s:47:"Drupal\search_api\Form\ServerDisableConfirmForm";s:5:"clear";s:45:"Drupal\search_api\Form\ServerClearConfirmForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";}s:19:" * admin_permission";s:21:"administer search_api";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:6:{s:9:"canonical";s:58:"/admin/config/search/search-api/server/{search_api_server}";s:8:"add-form";s:42:"/admin/config/search/search-api/add-server";s:9:"edit-form";s:63:"/admin/config/search/search-api/server/{search_api_server}/edit";s:11:"delete-form";s:65:"/admin/config/search/search-api/server/{search_api_server}/delete";s:7:"disable";s:66:"/admin/config/search/search-api/server/{search_api_server}/disable";s:6:"enable";s:65:"/admin/config/search/search-api/server/{search_api_server}/enable";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Search server";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Search servers";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"search server";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"search servers";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:20:"@count search server";s:6:"plural";s:21:"@count search servers";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:29:"config:search_api_server_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:6:"server";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:4:"name";i:2;s:11:"description";i:3;s:7:"backend";i:4;s:14:"backend_config";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_task.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":41:{s:5:" * id";s:15:"search_api_task";s:8:" * class";s:29:"Drupal\search_api\Entity\Task";s:11:" * provider";s:10:"search_api";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:6:{s:2:"id";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:29:"Drupal\search_api\Entity\Task";s:11:" * handlers";a:3:{s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:46:"Drupal\Core\Entity\Sql\SqlContentEntityStorage";s:12:"view_builder";s:36:"Drupal\Core\Entity\EntityViewBuilder";}s:19:" * admin_permission";N;s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";s:15:"search_api_task";s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Search task";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Search tasks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"search task";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"search tasks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:18:"@count search task";s:6:"plural";s:19:"@count search tasks";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:20:"search_api_task_list";}s:14:" * constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'search_api_task.field_storage_definitions',
  'value' => 'a:5:{s:2:"id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:2:"id";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:2;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"type";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Task type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:4:"type";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:50;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:36;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:9:"server_id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Server ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:9:"server_id";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:50;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:68;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:8:"index_id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"Index ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:8:"index_id";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:50;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:99;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"data";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:7:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Task data";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"search_api";s:10:"field_name";s:4:"data";s:11:"entity_type";s:15:"search_api_task";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:130;}s:7:" * type";s:11:"string_long";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'user.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":41:{s:5:" * id";s:4:"user";s:8:" * class";s:23:"Drupal\user\Entity\User";s:11:" * provider";s:4:"user";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:7:{s:2:"id";s:3:"uid";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:23:"Drupal\user\Entity\User";s:11:" * handlers";a:9:{s:7:"storage";s:23:"Drupal\user\UserStorage";s:14:"storage_schema";s:29:"Drupal\user\UserStorageSchema";s:6:"access";s:36:"Drupal\user\UserAccessControlHandler";s:12:"list_builder";s:27:"Drupal\user\UserListBuilder";s:10:"views_data";s:25:"Drupal\user\UserViewsData";s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\user\Entity\UserRouteProvider";}s:4:"form";a:3:{s:7:"default";s:23:"Drupal\user\ProfileForm";s:6:"cancel";s:31:"Drupal\user\Form\UserCancelForm";s:8:"register";s:24:"Drupal\user\RegisterForm";}s:11:"translation";s:37:"Drupal\user\ProfileTranslationHandler";s:12:"view_builder";s:36:"Drupal\Core\Entity\EntityViewBuilder";}s:19:" * admin_permission";s:16:"administer users";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:4:{s:9:"canonical";s:12:"/user/{user}";s:9:"edit-form";s:17:"/user/{user}/edit";s:11:"cancel-form";s:19:"/user/{user}/cancel";s:10:"collection";s:13:"/admin/people";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";s:5:"users";s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";s:16:"users_field_data";s:11:" * internal";b:0;s:15:" * translatable";b:1;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"User";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Users";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"user";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"users";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:11:"@count user";s:6:"plural";s:12:"@count users";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";s:22:"entity.user.admin_form";s:26:" * common_reference_target";b:1;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:9:"user_list";}s:14:" * constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'user.field_storage_definitions',
  'value' => "a:17:{s:3:\"uid\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"User ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"read-only\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"The user ID.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:3:\"uid\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:integer\";s:8:\"settings\";a:6:{s:8:\"unsigned\";b:1;s:4:\"size\";s:6:\"normal\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}}s:18:\" * fieldDefinition\";r:2;}s:7:\" * type\";s:7:\"integer\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:4:\"size\";s:6:\"normal\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"uuid\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"UUID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"read-only\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:14:\"The user UUID.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:4:\"uuid\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:15:\"field_item:uuid\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:128;s:8:\"is_ascii\";b:1;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:40;}s:7:\" * type\";s:4:\"uuid\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:128;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:1:{s:5:\"value\";a:1:{i:0;s:5:\"value\";}}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:8:\"langcode\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:13:\"Language code\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:7:\"display\";a:2:{s:4:\"view\";a:1:{s:7:\"options\";a:1:{s:6:\"region\";s:6:\"hidden\";}}s:4:\"form\";a:1:{s:7:\"options\";a:1:{s:6:\"region\";s:6:\"hidden\";}}}s:12:\"translatable\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:23:\"The user language code.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:8:\"langcode\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:19:\"field_item:language\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:77;}s:7:\" * type\";s:8:\"language\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:12;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:18:\"preferred_langcode\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:23:\"Preferred language code\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:77:\"The user's preferred language code for receiving emails and viewing the site.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:18:\"preferred_langcode\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:3:{s:4:\"type\";s:19:\"field_item:language\";s:8:\"settings\";a:0:{}s:11:\"constraints\";a:1:{s:11:\"ComplexData\";a:1:{s:5:\"value\";a:2:{s:13:\"AllowedValues\";a:1:{s:8:\"callback\";s:60:\"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes\";}s:6:\"Length\";a:1:{s:3:\"max\";i:12;}}}}}s:18:\" * fieldDefinition\";r:115;}s:7:\" * type\";s:8:\"language\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:12;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:24:\"preferred_admin_langcode\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:29:\"Preferred admin language code\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:68:\"The user's preferred language code for viewing administration pages.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";N;}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:24:\"preferred_admin_langcode\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:3:{s:4:\"type\";s:19:\"field_item:language\";s:8:\"settings\";a:0:{}s:11:\"constraints\";a:1:{s:11:\"ComplexData\";a:1:{s:5:\"value\";a:2:{s:13:\"AllowedValues\";a:1:{s:8:\"callback\";s:60:\"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes\";}s:6:\"Length\";a:1:{s:3:\"max\";i:12;}}}}}s:18:\" * fieldDefinition\";r:152;}s:7:\" * type\";s:8:\"language\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:12;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"name\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Name\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:22:\"The name of this user.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:11:\"constraints\";a:2:{s:8:\"UserName\";a:0:{}s:14:\"UserNameUnique\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:4:\"name\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:3:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}s:5:\"class\";s:25:\"\\Drupal\\user\\UserNameItem\";}s:18:\" * fieldDefinition\";r:192;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"pass\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Password\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:35:\"The password of this user (hashed).\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"constraints\";a:1:{s:18:\"ProtectedUserField\";N;}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:4:\"pass\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:19:\"field_item:password\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:231;}s:7:\" * type\";s:8:\"password\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"mail\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:5:\"Email\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:23:\"The email of this user.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";s:0:\"\";}}s:11:\"constraints\";a:3:{s:14:\"UserMailUnique\";N;s:16:\"UserMailRequired\";N;s:18:\"ProtectedUserField\";N;}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:4:\"mail\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:16:\"field_item:email\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:267;}s:7:\" * type\";s:5:\"email\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:254;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:8:\"timezone\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Timezone\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:26:\"The timezone of this user.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:8:\"timezone\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:4:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:32;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}s:11:\"constraints\";a:1:{s:11:\"ComplexData\";a:1:{s:5:\"value\";a:1:{s:13:\"AllowedValues\";a:1:{s:8:\"callback\";s:44:\"Drupal\\user\\Entity\\User::getAllowedTimezones\";}}}}s:5:\"class\";s:24:\"Drupal\\user\\TimeZoneItem\";}s:18:\" * fieldDefinition\";r:304;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:6:\"status\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"User status\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:38:\"Whether the user is active or blocked.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";b:0;}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:3:{s:4:\"type\";s:18:\"field_item:boolean\";s:8:\"settings\";a:2:{s:8:\"on_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:2:\"On\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"off_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:3:\"Off\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:5:\"class\";s:22:\"Drupal\\user\\StatusItem\";}s:18:\" * fieldDefinition\";r:344;}s:7:\" * type\";s:7:\"boolean\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:7:\"created\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Created\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:35:\"The time that the user was created.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:7:\"created\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:created\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:386;}s:7:\" * type\";s:7:\"created\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:1:{s:4:\"type\";s:3:\"int\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:7:\"changed\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Changed\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:39:\"The time that the user was last edited.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:7:\"changed\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:changed\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:415;}s:7:\" * type\";s:7:\"changed\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:1:{s:4:\"type\";s:3:\"int\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:6:\"access\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Last access\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:46:\"The time that the user last accessed the site.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:6:\"access\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:20:\"field_item:timestamp\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:445;}s:7:\" * type\";s:9:\"timestamp\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:1:{s:4:\"type\";s:3:\"int\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:5:\"login\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:10:\"Last login\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:38:\"The time that the user last logged in.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:5:\"login\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:20:\"field_item:timestamp\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:477;}s:7:\" * type\";s:9:\"timestamp\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:1:{s:4:\"type\";s:3:\"int\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"init\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:13:\"Initial email\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:52:\"The email address used for initial account creation.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";s:0:\"\";}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:4:\"init\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:16:\"field_item:email\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:509;}s:7:\" * type\";s:5:\"email\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:254;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:5:\"roles\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:5:\"Roles\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"cardinality\";i:-1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:23:\"The roles the user has.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:5:\"roles\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:27:\"field_item:entity_reference\";s:8:\"settings\";a:3:{s:11:\"target_type\";s:9:\"user_role\";s:7:\"handler\";s:7:\"default\";s:16:\"handler_settings\";a:0:{}}}s:18:\" * fieldDefinition\";r:542;}s:7:\" * type\";s:16:\"entity_reference\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:9:\"target_id\";a:3:{s:11:\"description\";s:28:\"The ID of the target entity.\";s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:255;}}s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:11:\"unique keys\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:16:\"default_langcode\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:10:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:19:\"Default translation\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:58:\"A flag indicating whether this is the default translation.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:12:\"revisionable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";b:1;}}s:8:\"provider\";s:4:\"user\";s:10:\"field_name\";s:16:\"default_langcode\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:boolean\";s:8:\"settings\";a:2:{s:8:\"on_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:2:\"On\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"off_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:3:\"Off\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}}s:18:\" * fieldDefinition\";r:578;}s:7:\" * type\";s:7:\"boolean\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}}",
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'user_role.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:9:"user_role";s:8:" * class";s:23:"Drupal\user\Entity\Role";s:11:" * provider";s:4:"user";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:6:"weight";s:6:"weight";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:23:"Drupal\user\Entity\Role";s:11:" * handlers";a:4:{s:7:"storage";s:23:"Drupal\user\RoleStorage";s:6:"access";s:36:"Drupal\user\RoleAccessControlHandler";s:12:"list_builder";s:27:"Drupal\user\RoleListBuilder";s:4:"form";a:2:{s:7:"default";s:20:"Drupal\user\RoleForm";s:6:"delete";s:35:"Drupal\Core\Entity\EntityDeleteForm";}}s:19:" * admin_permission";s:22:"administer permissions";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:4:{s:11:"delete-form";s:45:"/admin/people/roles/manage/{user_role}/delete";s:9:"edit-form";s:38:"/admin/people/roles/manage/{user_role}";s:21:"edit-permissions-form";s:37:"/admin/people/permissions/{user_role}";s:10:"collection";s:19:"/admin/people/roles";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Role";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Roles";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"role";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"roles";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:11:"@count role";s:6:"plural";s:12:"@count roles";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:21:"config:user_role_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:4:"role";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"weight";i:3;s:8:"is_admin";i:4;s:11:"permissions";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'view.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:4:"view";s:8:" * class";s:24:"Drupal\views\Entity\View";s:11:" * provider";s:5:"views";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:24:"Drupal\views\Entity\View";s:11:" * handlers";a:2:{s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:16:"administer views";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"View";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:16:"View entity type";}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Views";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:16:"View entity type";}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"view";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:16:"View entity type";}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"views";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:16:"View entity type";}}s:14:" * label_count";a:3:{s:8:"singular";s:11:"@count view";s:6:"plural";s:12:"@count views";s:7:"context";s:16:"View entity type";}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:16:"config:view_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:8:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"module";i:3;s:11:"description";i:4;s:3:"tag";i:5;s:10:"base_table";i:6;s:10:"base_field";i:7;s:7:"display";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.entity_schema_data',
  'value' => 'a:4:{s:4:"node";a:2:{s:11:"primary key";a:1:{i:0;s:3:"nid";}s:11:"unique keys";a:1:{s:9:"node__vid";a:1:{i:0;s:3:"vid";}}}s:13:"node_revision";a:2:{s:11:"primary key";a:1:{i:0;s:3:"vid";}s:7:"indexes";a:1:{s:9:"node__nid";a:1:{i:0;s:3:"nid";}}}s:15:"node_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"nid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:9:"node__vid";a:1:{i:0;s:3:"vid";}s:17:"node__status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:3:"nid";}s:15:"node__frontpage";a:4:{i:0;s:7:"promote";i:1;s:6:"status";i:2;s:6:"sticky";i:3;s:7:"created";}s:16:"node__title_type";a:2:{i:0;s:5:"title";i:1;a:2:{i:0;s:4:"type";i:1;i:4;}}}}s:19:"node_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:3:"vid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.body',
  'value' => 'a:2:{s:10:"node__body";a:4:{s:11:"description";s:33:"Data storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}s:19:"node_revision__body";a:4:{s:11:"description";s:45:"Revision archive storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.changed',
  'value' => 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__changed";a:1:{i:0;s:7:"changed";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.created',
  'value' => 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__created";a:1:{i:0;s:7:"created";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.default_langcode',
  'value' => 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.langcode',
  'value' => 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:13:"node_revision";a:2:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:20:"node_field__langcode";a:1:{i:0;s:8:"langcode";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.nid',
  'value' => 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.promote',
  'value' => 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.revision_default',
  'value' => 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.revision_log',
  'value' => 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:12:"revision_log";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.revision_timestamp',
  'value' => 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:18:"revision_timestamp";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.revision_translation_affected',
  'value' => 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.revision_uid',
  'value' => 'a:1:{s:13:"node_revision";a:3:{s:6:"fields";a:1:{s:12:"revision_uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:35:"node_field__revision_uid__target_id";a:1:{i:0;s:12:"revision_uid";}}s:12:"foreign keys";a:1:{s:24:"node_field__revision_uid";a:2:{s:5:"table";s:5:"users";s:7:"columns";a:1:{s:12:"revision_uid";s:3:"uid";}}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.status',
  'value' => 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.sticky',
  'value' => 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.title',
  'value' => 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.type',
  'value' => 'a:2:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.uid',
  'value' => 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}s:19:"node_field_revision";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.uuid',
  'value' => 'a:1:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"node_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'node.field_schema_data.vid',
  'value' => 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.entity_schema_data',
  'value' => 'a:2:{s:10:"path_alias";a:3:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:7:"indexes";a:2:{s:36:"path_alias__alias_langcode_id_status";a:4:{i:0;s:5:"alias";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}s:35:"path_alias__path_langcode_id_status";a:4:{i:0;s:4:"path";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}}s:11:"unique keys";a:1:{s:23:"path_alias__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:19:"path_alias_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:14:"path_alias__id";a:1:{i:0;s:2:"id";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.alias',
  'value' => 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.id',
  'value' => 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.langcode',
  'value' => 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.path',
  'value' => 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.revision_default',
  'value' => 'a:1:{s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.revision_id',
  'value' => 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.status',
  'value' => 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'path_alias.field_schema_data.uuid',
  'value' => 'a:1:{s:10:"path_alias";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:29:"path_alias_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.entity_schema_data',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:11:"primary key";a:1:{i:0;s:2:"id";}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.data',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:4:"data";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.id',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.index_id',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:8:"index_id";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.server_id',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:9:"server_id";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'search_api_task.field_schema_data.type',
  'value' => 'a:1:{s:15:"search_api_task";a:1:{s:6:"fields";a:1:{s:4:"type";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.entity_schema_data',
  'value' => 'a:2:{s:5:"users";a:1:{s:11:"primary key";a:1:{i:0;s:3:"uid";}}s:16:"users_field_data";a:3:{s:11:"primary key";a:2:{i:0;s:3:"uid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"user__id__default_langcode__langcode";a:3:{i:0;s:3:"uid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}s:11:"unique keys";a:1:{s:10:"user__name";a:2:{i:0;s:4:"name";i:1;s:8:"langcode";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.access',
  'value' => 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:6:"access";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:18:"user_field__access";a:1:{i:0;s:6:"access";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.changed',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.created',
  'value' => 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"user_field__created";a:1:{i:0;s:7:"created";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.default_langcode',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.init',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"init";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.langcode',
  'value' => 'a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.login',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:5:"login";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.mail',
  'value' => 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:4:"mail";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:16:"user_field__mail";a:1:{i:0;s:4:"mail";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.name',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.pass',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"pass";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.preferred_admin_langcode',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:24:"preferred_admin_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.preferred_langcode',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:18:"preferred_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.roles',
  'value' => 'a:1:{s:11:"user__roles";a:4:{s:11:"description";s:34:"Data storage for user field roles.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:15:"roles_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:15:"roles_target_id";a:1:{i:0;s:15:"roles_target_id";}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.status',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.timezone',
  'value' => 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"timezone";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:0;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.uid',
  'value' => 'a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}',
))
->values(array(
  'collection' => 'entity.storage_schema.sql',
  'name' => 'user.field_schema_data.uuid',
  'value' => 'a:1:{s:5:"users";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"user_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}',
))
->values(array(
  'collection' => 'entity_autocomplete',
  'name' => '0jsgI39kMGtSc5S4kB_xuItgc2UQ2SEtR93gnDuIXos',
  'value' => 'a:2:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;}',
))
->values(array(
  'collection' => 'post_update',
  'name' => 'existing_updates',
  'value' => 'a:101:{i:0;s:54:"system_post_update_add_description_to_entity_form_mode";i:1;s:54:"system_post_update_add_description_to_entity_view_mode";i:2;s:48:"system_post_update_enable_password_compatibility";i:3;s:35:"system_post_update_linkset_settings";i:4;s:38:"system_post_update_mailer_dsn_settings";i:5;s:49:"system_post_update_mailer_structured_dsn_settings";i:6;s:39:"system_post_update_remove_asset_entries";i:7;s:44:"system_post_update_remove_asset_query_string";i:8;s:44:"system_post_update_set_blank_log_url_to_null";i:9;s:38:"system_post_update_timestamp_formatter";i:10;s:64:"system_post_update_recalculate_configuration_entity_dependencies";i:11;s:48:"system_post_update_add_region_to_entity_displays";i:12;s:37:"system_post_update_hashes_clear_cache";i:13;s:36:"system_post_update_timestamp_plugins";i:14;s:41:"system_post_update_classy_message_library";i:15;s:37:"system_post_update_field_type_plugins";i:16;s:48:"system_post_update_field_formatter_entity_schema";i:17;s:36:"system_post_update_fix_jquery_extend";i:18;s:40:"system_post_update_change_action_plugins";i:19;s:47:"system_post_update_change_delete_action_plugins";i:20;s:41:"system_post_update_language_item_callback";i:21;s:31:"system_post_update_extra_fields";i:22;s:37:"system_post_update_states_clear_cache";i:23;s:64:"system_post_update_add_expand_all_items_key_in_system_menu_block";i:24;s:35:"system_post_update_clear_menu_cache";i:25;s:46:"system_post_update_layout_plugin_schema_change";i:26;s:60:"system_post_update_entity_reference_autocomplete_match_limit";i:27;s:44:"system_post_update_extra_fields_form_display";i:28;s:39:"system_post_update_uninstall_simpletest";i:29;s:52:"system_post_update_uninstall_entity_reference_module";i:30;s:54:"system_post_update_entity_revision_metadata_bc_cleanup";i:31;s:35:"system_post_update_uninstall_classy";i:32;s:35:"system_post_update_uninstall_stable";i:33;s:44:"system_post_update_claro_dropbutton_variants";i:34;s:37:"system_post_update_schema_version_int";i:35;s:38:"system_post_update_delete_rss_settings";i:36;s:52:"system_post_update_remove_key_value_expire_all_index";i:37;s:44:"system_post_update_service_advisory_settings";i:38;s:44:"system_post_update_delete_authorize_settings";i:39;s:34:"system_post_update_sort_all_config";i:40;s:50:"system_post_update_enable_provider_database_driver";i:41;s:33:"user_post_update_sort_permissions";i:42;s:39:"user_post_update_sort_permissions_again";i:43;s:45:"user_post_update_enforce_order_of_permissions";i:44;s:29:"user_post_update_update_roles";i:45;s:51:"path_alias_post_update_drop_path_alias_status_index";i:46;s:54:"block_post_update_disable_blocks_with_missing_contexts";i:47;s:40:"block_post_update_disabled_region_update";i:48;s:42:"block_post_update_fix_negate_in_conditions";i:49;s:45:"block_post_update_replace_node_type_condition";i:50;s:31:"filter_post_update_sort_filters";i:51;s:46:"field_post_update_save_custom_storage_property";i:52;s:50:"field_post_update_entity_reference_handler_setting";i:53;s:43:"field_post_update_email_widget_size_setting";i:54;s:47:"field_post_update_remove_handler_submit_setting";i:55;s:32:"text_post_update_allowed_formats";i:56;s:42:"text_post_update_add_required_summary_flag";i:57;s:55:"text_post_update_add_required_summary_flag_form_display";i:58;s:46:"node_post_update_configure_status_field_widget";i:59;s:41:"node_post_update_node_revision_views_data";i:60;s:40:"node_post_update_glossary_view_published";i:61;s:45:"node_post_update_rebuild_node_revision_routes";i:62;s:50:"node_post_update_modify_base_field_author_override";i:63;s:49:"dblog_post_update_convert_recent_messages_to_view";i:64;s:46:"update_post_update_set_blank_fetch_url_to_null";i:65;s:45:"search_api_post_update_fix_index_dependencies";i:66;s:39:"search_api_post_update_views_query_type";i:67;s:36:"views_post_update_add_missing_labels";i:68;s:39:"views_post_update_boolean_custom_titles";i:69;s:38:"views_post_update_fix_revision_id_part";i:70;s:35:"views_post_update_oembed_eager_load";i:71;s:50:"views_post_update_remove_default_argument_skip_url";i:72;s:43:"views_post_update_remove_skip_cache_setting";i:73;s:44:"views_post_update_responsive_image_lazy_load";i:74;s:46:"views_post_update_taxonomy_filter_user_context";i:75;s:37:"views_post_update_timestamp_formatter";i:76;s:46:"views_post_update_update_cacheability_metadata";i:77;s:46:"views_post_update_cleanup_duplicate_views_data";i:78;s:46:"views_post_update_field_formatter_dependencies";i:79;s:36:"views_post_update_taxonomy_index_tid";i:80;s:41:"views_post_update_serializer_dependencies";i:81;s:39:"views_post_update_boolean_filter_values";i:82;s:33:"views_post_update_grouped_filters";i:83;s:42:"views_post_update_revision_metadata_fields";i:84;s:33:"views_post_update_entity_link_url";i:85;s:34:"views_post_update_bulk_field_moved";i:86;s:41:"views_post_update_filter_placeholder_text";i:87;s:47:"views_post_update_views_data_table_dependencies";i:88;s:45:"views_post_update_table_display_cache_max_age";i:89;s:53:"views_post_update_exposed_filter_blocks_label_display";i:90;s:48:"views_post_update_make_placeholders_translatable";i:91;s:41:"views_post_update_limit_operator_defaults";i:92;s:33:"views_post_update_remove_core_key";i:93;s:51:"views_post_update_field_names_for_multivalue_fields";i:94;s:52:"views_post_update_configuration_entity_relationships";i:95;s:48:"views_post_update_rename_default_display_setting";i:96;s:50:"views_post_update_remove_sorting_global_text_field";i:97;s:36:"views_post_update_title_translations";i:98;s:33:"views_post_update_sort_identifier";i:99;s:53:"views_post_update_provide_revision_table_relationship";i:100;s:33:"views_post_update_image_lazy_load";}',
))
->values(array(
  'collection' => 'state',
  'name' => 'asset.css_js_query_string',
  'value' => 's:6:"t8g755";',
))
->values(array(
  'collection' => 'state',
  'name' => 'install_task',
  'value' => 's:4:"done";',
))
->values(array(
  'collection' => 'state',
  'name' => 'install_time',
  'value' => 'i:1767711785;',
))
->values(array(
  'collection' => 'state',
  'name' => 'router.path_roots',
  'value' => 'a:22:{i:0;s:5:"admin";i:1;s:14:"block-category";i:2;s:6:"filter";i:3;s:4:"node";i:4;s:5:"sites";i:5;s:6:"system";i:6;s:4:"cron";i:7;s:12:"machine_name";i:8;s:0:"";i:9;s:9:"<current>";i:10;s:5:"batch";i:11;s:10:"update.php";i:12;s:29:"entity_reference_autocomplete";i:13;s:7:"session";i:14;s:4:"user";i:15;s:11:".well-known";i:16;s:25:"view-search-yummy-lettuce";i:17;s:33:"view-search-colorful-organization";i:18;s:24:"view-search-drab-feather";i:19;s:30:"view-search-parched-arithmetic";i:20;s:29:"view-search-robust-discussion";i:21;s:5:"views";}',
))
->values(array(
  'collection' => 'state',
  'name' => 'routing.menu_masks.router',
  'value' => 'a:29:{i:0;i:503;i:1;i:502;i:2;i:464;i:3;i:253;i:4;i:251;i:5;i:232;i:6;i:126;i:7;i:125;i:8;i:116;i:9;i:63;i:10;i:62;i:11;i:61;i:12;i:49;i:13;i:42;i:14;i:31;i:15;i:30;i:16;i:24;i:17;i:21;i:18;i:15;i:19;i:14;i:20;i:12;i:21;i:11;i:22;i:8;i:23;i:7;i:24;i:6;i:25;i:5;i:26;i:3;i:27;i:2;i:28;i:1;}',
))
->values(array(
  'collection' => 'state',
  'name' => 'routing.non_admin_routes',
  'value' => 'a:55:{i:0;s:27:"block.category_autocomplete";i:1;s:15:"filter.tips_all";i:2;s:11:"filter.tips";i:3;s:13:"node.add_page";i:4;s:8:"node.add";i:5;s:19:"entity.node.preview";i:6;s:27:"entity.node.version_history";i:7;s:20:"entity.node.revision";i:8;s:28:"node.revision_revert_confirm";i:9;s:40:"node.revision_revert_translation_confirm";i:10;s:28:"node.revision_delete_confirm";i:11;s:16:"system.css_asset";i:12;s:15:"system.js_asset";i:13;s:10:"system.401";i:14;s:10:"system.403";i:15;s:10:"system.404";i:16;s:10:"system.4xx";i:17;s:11:"system.cron";i:18;s:33:"system.machine_name_transliterate";i:19;s:12:"system.files";i:20;s:28:"system.private_file_download";i:21;s:16:"system.temporary";i:22;s:7:"<front>";i:23;s:6:"<none>";i:24;s:8:"<nolink>";i:25;s:8:"<button>";i:26;s:9:"<current>";i:27;s:15:"system.timezone";i:28;s:22:"system.batch_page.html";i:29;s:16:"system.db_update";i:30;s:26:"system.entity_autocomplete";i:31;s:16:"system.csrftoken";i:32;s:13:"user.register";i:33;s:11:"user.logout";i:34;s:9:"user.pass";i:35;s:9:"user.page";i:36;s:9:"user.edit";i:37;s:10:"user.login";i:38;s:19:"user.cancel_confirm";i:39;s:16:"user.reset.login";i:40;s:10:"user.reset";i:41;s:15:"user.reset.form";i:42;s:31:"user.well-known.change_password";i:43;s:40:"view.view_search_yummy_lettuce.page_seek";i:44;s:50:"view.view_search_colorful_organization.page_search";i:45;s:40:"view.view_search_drab_feather.page_query";i:46;s:48:"view.view_search_parched_arithmetic.page_rummage";i:47;s:47:"view.view_search_robust_discussion.page_explore";i:48;s:10:"views.ajax";i:49;s:21:"entity.node.canonical";i:50;s:23:"entity.node.delete_form";i:51;s:21:"entity.node.edit_form";i:52;s:21:"entity.user.canonical";i:53;s:21:"entity.user.edit_form";i:54;s:23:"entity.user.cancel_form";}',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.datasource.entity.last_ids',
  'value' => 'a:0:{}',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.colorful_organization.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.drab_feather.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.parched_arithmetic.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.robust_discussion.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'search_api.index.yummy_lettuce.has_reindexed',
  'value' => 'b:1;',
))
->values(array(
  'collection' => 'state',
  'name' => 'system.cron_key',
  'value' => 's:74:"htVm4kjhEs15kObBMA7ahMimMKYjS2Xyc1-aTQJBfX6tx3fO6pa22fyBmd6K8ZxoSsPeAyImtg";',
))
->values(array(
  'collection' => 'state',
  'name' => 'system.cron_last',
  'value' => 'i:1767711785;',
))
->values(array(
  'collection' => 'state',
  'name' => 'system.private_key',
  'value' => 's:74:"6bqU5gI4bp9L8WCNioHmuO6DqtV6_K68QyILE5w74F1G3Ke2OISX_62Q9QRP6gt7kOZq_yHf6g";',
))
->values(array(
  'collection' => 'state',
  'name' => 'system.profile.files',
  'value' => 'a:17:{s:10:"demo_umami";s:44:"core/profiles/demo_umami/demo_umami.info.yml";s:7:"minimal";s:38:"core/profiles/minimal/minimal.info.yml";s:23:"nightwatch_a11y_testing";s:70:"core/profiles/nightwatch_a11y_testing/nightwatch_a11y_testing.info.yml";s:18:"nightwatch_testing";s:60:"core/profiles/nightwatch_testing/nightwatch_testing.info.yml";s:8:"standard";s:40:"core/profiles/standard/standard.info.yml";s:25:"test_language_negotiation";s:74:"core/profiles/test_language_negotiation/test_language_negotiation.info.yml";s:7:"testing";s:38:"core/profiles/testing/testing.info.yml";s:21:"testing_config_import";s:66:"core/profiles/testing_config_import/testing_config_import.info.yml";s:24:"testing_config_overrides";s:72:"core/profiles/testing_config_overrides/testing_config_overrides.info.yml";s:40:"testing_install_profile_all_dependencies";s:104:"core/profiles/testing_install_profile_all_dependencies/testing_install_profile_all_dependencies.info.yml";s:36:"testing_install_profile_dependencies";s:96:"core/profiles/testing_install_profile_dependencies/testing_install_profile_dependencies.info.yml";s:28:"testing_missing_dependencies";s:80:"core/profiles/testing_missing_dependencies/testing_missing_dependencies.info.yml";s:20:"testing_multilingual";s:64:"core/profiles/testing_multilingual/testing_multilingual.info.yml";s:33:"testing_multilingual_with_english";s:90:"core/profiles/testing_multilingual_with_english/testing_multilingual_with_english.info.yml";s:20:"testing_requirements";s:64:"core/profiles/testing_requirements/testing_requirements.info.yml";s:19:"testing_site_config";s:62:"core/profiles/testing_site_config/testing_site_config.info.yml";s:21:"testing_themes_blocks";s:66:"core/profiles/testing_themes_blocks/testing_themes_blocks.info.yml";}',
))
->values(array(
  'collection' => 'state',
  'name' => 'twig_extension_hash_prefix',
  'value' => 'a:2:{s:19:"twig_extension_hash";s:43:"162ZthUI8x2QzRcqJuF1tvyexLQi1RugkwVwD0LPO4A";s:17:"twig_cache_prefix";s:13:"695d24390ae73";}',
))
->values(array(
  'collection' => 'state',
  'name' => 'update.last_check',
  'value' => 'i:1767714984;',
))
->values(array(
  'collection' => 'state',
  'name' => 'update.last_email_notification',
  'value' => 'i:1767711785;',
))
->values(array(
  'collection' => 'state',
  'name' => 'views.view_route_names',
  'value' => 'a:5:{s:35:"view_search_yummy_lettuce.page_seek";s:40:"view.view_search_yummy_lettuce.page_seek";s:45:"view_search_colorful_organization.page_search";s:50:"view.view_search_colorful_organization.page_search";s:35:"view_search_drab_feather.page_query";s:40:"view.view_search_drab_feather.page_query";s:43:"view_search_parched_arithmetic.page_rummage";s:48:"view.view_search_parched_arithmetic.page_rummage";s:42:"view_search_robust_discussion.page_explore";s:47:"view.view_search_robust_discussion.page_explore";}',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'block',
  'value' => 'i:8003;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'dblog',
  'value' => 'i:10101;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'dynamic_page_cache',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'elasticsearch_connector',
  'value' => 'i:9803;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'field',
  'value' => 'i:8500;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'filter',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'minimal',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'mysql',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'node',
  'value' => 'i:8700;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'page_cache',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'path_alias',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'search_api',
  'value' => 'i:8110;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'system',
  'value' => 'i:10201;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'text',
  'value' => 'i:8000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'update',
  'value' => 'i:8001;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'user',
  'value' => 'i:10000;',
))
->values(array(
  'collection' => 'system.schema',
  'name' => 'views_ui',
  'value' => 'i:8000;',
))
->execute();
$connection->schema()->createTable('key_value_expire', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '2147483647',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('key_value_expire')
->fields(array(
  'collection',
  'name',
  'value',
  'expire',
))
->values(array(
  'collection' => 'form',
  'name' => 'form-aw4ivtFuRv9IhAUDUfsUkXqKswsdCQBKydJCDO5_9VI',
  'value' => "a:31:{s:11:\"#attributes\";a:2:{s:5:\"class\";a:1:{i:0;s:22:\"search-api-server-form\";}s:20:\"data-drupal-selector\";s:22:\"search-api-server-form\";}s:8:\"#process\";a:1:{i:0;s:13:\"::processForm\";}s:12:\"#after_build\";a:1:{i:0;s:12:\"::afterBuild\";}s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"Add search server\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"#attached\";a:2:{s:7:\"library\";a:1:{i:0;s:38:\"search_api/drupal.search_api.admin_css\";}s:12:\"placeholders\";a:1:{s:55:\"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM\";a:1:{s:13:\"#lazy_builder\";a:2:{i:0;s:40:\"form_builder:renderPlaceholderFormAction\";i:1;a:0:{}}}}}s:4:\"name\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Server name\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:40:\"Enter the displayed name for the server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:13:\"Oval decision\";s:9:\"#required\";b:1;}s:2:\"id\";a:6:{s:5:\"#type\";s:12:\"machine_name\";s:14:\"#default_value\";N;s:10:\"#maxlength\";i:50;s:9:\"#required\";b:1;s:13:\"#machine_name\";a:2:{s:6:\"exists\";s:38:\"\\Drupal\\search_api\\Entity\\Server::load\";s:6:\"source\";a:1:{i:0;s:4:\"name\";}}s:9:\"#disabled\";b:0;}s:6:\"status\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Enabled\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:57:\"Only enabled servers can index items or execute searches.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";b:1;}s:11:\"description\";a:4:{s:5:\"#type\";s:8:\"textarea\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Description\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:35:\"Enter a description for the server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:51:\"oval_decision, HTTP Basic Authentication connector.\";}s:7:\"backend\";a:9:{s:5:\"#type\";s:6:\"radios\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Backend\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:40:\"Choose a backend to use for this server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"#options\";a:1:{s:13:\"elasticsearch\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:13:\"ElasticSearch\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:14:\"#default_value\";s:13:\"elasticsearch\";s:9:\"#required\";b:1;s:9:\"#disabled\";b:0;s:5:\"#ajax\";a:4:{s:8:\"callback\";a:2:{i:0;s:33:\"Drupal\\search_api\\Form\\ServerForm\";i:1;s:26:\"buildAjaxBackendConfigForm\";}s:7:\"wrapper\";s:30:\"search-api-backend-config-form\";s:6:\"method\";s:7:\"replace\";s:6:\"effect\";s:4:\"fade\";}s:13:\"elasticsearch\";a:1:{s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:34:\"Provides an ElasticSearch backend.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}}s:14:\"backend_config\";a:8:{s:9:\"connector\";a:7:{s:5:\"#type\";s:6:\"radios\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:23:\"ElasticSearch Connector\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:56:\"Choose a connector to use for this ElasticSearch server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"#options\";a:4:{s:8:\"standard\";s:8:\"Standard\";s:16:\"elastic_cloud_id\";s:16:\"Elastic Cloud ID\";s:22:\"elastic_cloud_endpoint\";s:22:\"Elastic Cloud Endpoint\";s:9:\"basicauth\";s:25:\"HTTP Basic Authentication\";}s:14:\"#default_value\";s:16:\"elastic_cloud_id\";s:9:\"#required\";b:1;s:5:\"#ajax\";a:4:{s:8:\"callback\";a:2:{i:0;O:77:\"Drupal\\elasticsearch_connector\\Plugin\\search_api\\backend\\ElasticSearchBackend\":12:{s:11:\" * pluginId\";s:13:\"elasticsearch\";s:19:\" * pluginDefinition\";a:5:{s:2:\"id\";s:13:\"elasticsearch\";s:5:\"label\";r:77;s:11:\"description\";r:92;s:5:\"class\";s:77:\"Drupal\\elasticsearch_connector\\Plugin\\search_api\\backend\\ElasticSearchBackend\";s:8:\"provider\";s:23:\"elasticsearch_connector\";}s:16:\" * configuration\";a:3:{s:9:\"connector\";s:16:\"elastic_cloud_id\";s:16:\"connector_config\";a:4:{s:3:\"url\";s:0:\"\";s:20:\"enable_debug_logging\";i:0;s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";}s:8:\"advanced\";a:4:{s:9:\"fuzziness\";s:4:\"auto\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:8:\"synonyms\";s:0:\"\";}}s:14:\" * _serviceIds\";a:4:{s:17:\"stringTranslation\";s:18:\"string_translation\";s:22:\"connectorPluginManager\";s:48:\"plugin.manager.elasticsearch_connector.connector\";s:20:\"backendClientFactory\";s:46:\"elasticsearch_connector.backend_client_factory\";s:15:\"eventDispatcher\";s:16:\"event_dispatcher\";}s:18:\" * _entityStorages\";a:0:{}s:12:\" * messenger\";N;s:15:\" * dependencies\";a:0:{}s:9:\" * server\";O:31:\"Drupal\\search_api\\Entity\\Server\":29:{s:15:\" * entityTypeId\";s:17:\"search_api_server\";s:15:\" * enforceIsNew\";b:1;s:12:\" * typedData\";N;s:16:\" * cacheContexts\";a:0:{}s:12:\" * cacheTags\";a:0:{}s:14:\" * cacheMaxAge\";i:-1;s:14:\" * _serviceIds\";a:0:{}s:18:\" * _entityStorages\";a:0:{}s:13:\" * originalId\";N;s:9:\" * status\";i:1;s:7:\" * uuid\";s:36:\"d4d3cf1a-e2d9-4020-869d-f85be72d25a6\";s:11:\" * langcode\";s:2:\"en\";s:23:\" * third_party_settings\";a:0:{}s:8:\" * _core\";a:0:{}s:14:\" * trustedData\";b:0;s:15:\" * dependencies\";a:0:{}s:12:\" * isSyncing\";b:0;s:5:\" * id\";s:13:\"oval_decision\";s:7:\" * name\";s:13:\"Oval decision\";s:14:\" * description\";s:51:\"oval_decision, HTTP Basic Authentication connector.\";s:10:\" * backend\";s:13:\"elasticsearch\";s:17:\" * backend_config\";a:3:{s:9:\"connector\";s:16:\"elastic_cloud_id\";s:16:\"connector_config\";a:4:{s:3:\"url\";s:0:\"\";s:20:\"enable_debug_logging\";i:0;s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";}s:8:\"advanced\";a:4:{s:9:\"fuzziness\";s:4:\"auto\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:8:\"synonyms\";s:0:\"\";}}s:16:\" * backendPlugin\";r:116;s:11:\" * features\";N;s:9:\" * logger\";N;s:6:\"submit\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Save\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"form_build_id\";s:48:\"form-Kb_hR2ixFMXb_guPjHv4grSlQl6n5SFnfNq6iRmI9sk\";s:10:\"form_token\";s:43:\"mAws8SsEXEbyRoRs1cpWVgxqqCi4jeLmrEe2WRuBfWI\";s:7:\"form_id\";s:22:\"search_api_server_form\";}s:11:\" * serverId\";N;s:15:\" * fieldsHelper\";N;s:9:\" * logger\";N;s:16:\" * backendClient\";N;}i:1;s:28:\"buildAjaxConnectorConfigForm\";}s:7:\"wrapper\";s:35:\"elasticsearch-connector-config-form\";s:6:\"method\";s:7:\"replace\";s:6:\"effect\";s:4:\"fade\";}}s:16:\"connector_config\";a:9:{s:16:\"elastic_cloud_id\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:16:\"Elastic Cloud ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:571:\"Your Hosted deployment's <em>Cloud ID</em>, in the format <code>&lt;label&gt;:&lt;cloud-id&gt;</code>, where <code>&lt;label&gt;:</code> is an optional human-readable name, and <code>&lt;cloud-id&gt;</code> is a base64-encoded text value of about 120 characters, made up of upper and lower case letters and numbers. Your Cloud ID is displayed at the top of the Hosted deployment's Kibana instance's Overview page. You can also find it by clicking on the deployment name from the <a href='@elastic_cloud_deployments'>Elastic Cloud <em>Hosted deployments</em> list page</a>\";s:12:\" * arguments\";a:1:{s:26:\"@elastic_cloud_deployments\";s:37:\"https://cloud.elastic.co/deployments/\";}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";s:9:\"#required\";b:1;s:10:\"#maxlength\";i:500;}s:21:\"no_key_module_message\";a:3:{s:6:\"#theme\";s:15:\"status_messages\";s:16:\"#status_headings\";a:1:{s:5:\"error\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:18:\"Key module missing\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:13:\"#message_list\";a:1:{s:5:\"error\";a:1:{i:0;O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:160:\"You must install <a href='@key_module_url'>Drupal's Key module</a> to use this authentication type! Please ensure that the Key module is downloaded and enabled.\";s:12:\" * arguments\";a:1:{s:15:\"@key_module_url\";s:34:\"https://www.drupal.org/project/key\";}s:10:\" * options\";a:0:{}}}}}s:20:\"enable_debug_logging\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:56:\"Enable debugging mode: log ElasticSearch network traffic\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:506:\"This will write requests, responses, and response-time information to Drupal's log, which may help you diagnose problems with Drupal's connection to ElasticSearch.<p><strong>Warning</strong>: This setting will result in poor performance and may log a user’s personally identifiable information. This setting is only intended for temporary use and should be disabled when you finish debugging. Logs written while this mode is active will remain in the log until you clear them or the logs are rotated.</p>\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";i:0;}s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:41:\"Configure %plugin ElasticSearch connector\";s:12:\" * arguments\";a:1:{s:7:\"%plugin\";s:16:\"Elastic Cloud ID\";}s:10:\" * options\";a:0:{}}s:12:\"#description\";s:85:\"Connect to Elasticsearch B.V.’s official Elastic Cloud with a Cloud ID and API key.\";s:5:\"#open\";b:1;s:11:\"#attributes\";a:1:{s:2:\"id\";s:35:\"elasticsearch-connector-config-form\";}s:5:\"#tree\";b:1;}s:8:\"advanced\";a:6:{s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Advanced\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"fuzziness\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:9:\"Fuzziness\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"#required\";b:1;s:8:\"#options\";a:7:{i:0;O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"- Disabled -\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:4:\"auto\";s:4:\"auto\";i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;}s:14:\"#default_value\";s:4:\"auto\";s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:248:\"Some queries and APIs support parameters to allow inexact fuzzy matching, using the fuzziness parameter. See <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/common-options.html#fuzziness\">Fuzziness</a> for more information.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:6:\"prefix\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Index prefix\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:101:\"Using an index prefix can be useful for using the same server for different projects or environments.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}s:6:\"suffix\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Index suffix\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:101:\"Using an index suffix can be useful for using the same server for different projects or environments.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}s:8:\"synonyms\";a:4:{s:5:\"#type\";s:8:\"textarea\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Synonyms\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:61:\"Enter synonyms in <a href=\":url\">Solr synonyms.txt format</a>\";s:12:\" * arguments\";a:1:{s:4:\":url\";s:112:\"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis-synonym-tokenfilter.html#_solr_synonyms\";}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}}s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:25:\"Configure %plugin backend\";s:12:\" * arguments\";a:1:{s:7:\"%plugin\";r:77;}s:10:\" * options\";a:0:{}}s:5:\"#open\";b:1;s:11:\"#attributes\";a:1:{s:2:\"id\";s:30:\"search-api-backend-config-form\";}s:5:\"#tree\";b:1;}s:7:\"actions\";a:2:{s:6:\"submit\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Save\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:7:\"#submit\";a:2:{i:0;s:12:\"::submitForm\";i:1;s:6:\"::save\";}s:12:\"#button_type\";s:7:\"primary\";s:7:\"#weight\";i:5;}s:5:\"#type\";s:7:\"actions\";}s:8:\"#form_id\";s:22:\"search_api_server_form\";s:9:\"#build_id\";s:48:\"form-aw4ivtFuRv9IhAUDUfsUkXqKswsdCQBKydJCDO5_9VI\";s:5:\"#type\";s:4:\"form\";s:7:\"#action\";s:55:\"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM\";s:13:\"form_build_id\";a:6:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-aw4ivtFuRv9IhAUDUfsUkXqKswsdCQBKydJCDO5_9VI\";s:3:\"#id\";s:48:\"form-aw4ivtFuRv9IhAUDUfsUkXqKswsdCQBKydJCDO5_9VI\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}s:11:\"#attributes\";a:1:{s:12:\"autocomplete\";s:3:\"off\";}}s:6:\"#cache\";a:1:{s:8:\"contexts\";a:1:{i:0;s:24:\"user.roles:authenticated\";}}s:6:\"#token\";s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";s:10:\"form_token\";a:6:{s:3:\"#id\";s:51:\"edit-search-api-server-form-form-token--PHRG8AkAi1U\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}s:9:\"#attached\";a:1:{s:12:\"placeholders\";a:1:{s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";a:1:{s:13:\"#lazy_builder\";a:2:{i:0;s:39:\"form_builder:renderFormTokenPlaceholder\";i:1;a:1:{i:0;s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";}}}}}s:6:\"#cache\";a:1:{s:7:\"max-age\";i:0;}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:22:\"search_api_server_form\";s:3:\"#id\";s:40:\"edit-search-api-server-form--zZzT4FPeGBw\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:35:\"search-api-server-form--QQUr6uHo9Ac\";s:7:\"#method\";s:4:\"post\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:16:\"#defaults_loaded\";b:1;s:5:\"#tree\";b:0;s:8:\"#parents\";a:0:{}s:9:\"#validate\";a:1:{i:0;s:14:\"::validateForm\";}s:7:\"#submit\";a:1:{i:0;s:12:\"::submitForm\";}s:6:\"#theme\";a:1:{i:0;s:22:\"search_api_server_form\";}s:12:\"#cache_token\";s:43:\"w-8loJAIj0zwn86cENAl2YZ_OfSLRYqcrb9HEdMfJAw\";}",
  'expire' => '1767734282',
))
->values(array(
  'collection' => 'form',
  'name' => 'form-bh0AsljSHn16_ZT2T4D9SZxHxEiiCK1gBaAzJIF33Ik',
  'value' => "a:31:{s:11:\"#attributes\";a:2:{s:5:\"class\";a:1:{i:0;s:22:\"search-api-server-form\";}s:20:\"data-drupal-selector\";s:22:\"search-api-server-form\";}s:8:\"#process\";a:1:{i:0;s:13:\"::processForm\";}s:12:\"#after_build\";a:1:{i:0;s:12:\"::afterBuild\";}s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"Add search server\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"#attached\";a:2:{s:7:\"library\";a:1:{i:0;s:38:\"search_api/drupal.search_api.admin_css\";}s:12:\"placeholders\";a:1:{s:55:\"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM\";a:1:{s:13:\"#lazy_builder\";a:2:{i:0;s:40:\"form_builder:renderPlaceholderFormAction\";i:1;a:0:{}}}}}s:4:\"name\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Server name\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:40:\"Enter the displayed name for the server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:16:\"Octagonal rhythm\";s:9:\"#required\";b:1;}s:2:\"id\";a:6:{s:5:\"#type\";s:12:\"machine_name\";s:14:\"#default_value\";N;s:10:\"#maxlength\";i:50;s:9:\"#required\";b:1;s:13:\"#machine_name\";a:2:{s:6:\"exists\";s:38:\"\\Drupal\\search_api\\Entity\\Server::load\";s:6:\"source\";a:1:{i:0;s:4:\"name\";}}s:9:\"#disabled\";b:0;}s:6:\"status\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Enabled\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:57:\"Only enabled servers can index items or execute searches.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";b:1;}s:11:\"description\";a:4:{s:5:\"#type\";s:8:\"textarea\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Description\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:35:\"Enter a description for the server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}s:7:\"backend\";a:9:{s:5:\"#type\";s:6:\"radios\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Backend\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:40:\"Choose a backend to use for this server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"#options\";a:1:{s:13:\"elasticsearch\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:13:\"ElasticSearch\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:14:\"#default_value\";s:13:\"elasticsearch\";s:9:\"#required\";b:1;s:9:\"#disabled\";b:0;s:5:\"#ajax\";a:4:{s:8:\"callback\";a:2:{i:0;s:33:\"Drupal\\search_api\\Form\\ServerForm\";i:1;s:26:\"buildAjaxBackendConfigForm\";}s:7:\"wrapper\";s:30:\"search-api-backend-config-form\";s:6:\"method\";s:7:\"replace\";s:6:\"effect\";s:4:\"fade\";}s:13:\"elasticsearch\";a:1:{s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:34:\"Provides an ElasticSearch backend.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}}s:14:\"backend_config\";a:8:{s:9:\"connector\";a:7:{s:5:\"#type\";s:6:\"radios\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:23:\"ElasticSearch Connector\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:56:\"Choose a connector to use for this ElasticSearch server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"#options\";a:4:{s:8:\"standard\";s:8:\"Standard\";s:16:\"elastic_cloud_id\";s:16:\"Elastic Cloud ID\";s:22:\"elastic_cloud_endpoint\";s:22:\"Elastic Cloud Endpoint\";s:9:\"basicauth\";s:25:\"HTTP Basic Authentication\";}s:14:\"#default_value\";s:16:\"elastic_cloud_id\";s:9:\"#required\";b:1;s:5:\"#ajax\";a:4:{s:8:\"callback\";a:2:{i:0;O:77:\"Drupal\\elasticsearch_connector\\Plugin\\search_api\\backend\\ElasticSearchBackend\":12:{s:11:\" * pluginId\";s:13:\"elasticsearch\";s:19:\" * pluginDefinition\";a:5:{s:2:\"id\";s:13:\"elasticsearch\";s:5:\"label\";r:77;s:11:\"description\";r:92;s:5:\"class\";s:77:\"Drupal\\elasticsearch_connector\\Plugin\\search_api\\backend\\ElasticSearchBackend\";s:8:\"provider\";s:23:\"elasticsearch_connector\";}s:16:\" * configuration\";a:3:{s:9:\"connector\";s:16:\"elastic_cloud_id\";s:16:\"connector_config\";a:2:{s:3:\"url\";s:0:\"\";s:20:\"enable_debug_logging\";i:0;}s:8:\"advanced\";a:4:{s:9:\"fuzziness\";s:4:\"auto\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:8:\"synonyms\";s:0:\"\";}}s:14:\" * _serviceIds\";a:4:{s:17:\"stringTranslation\";s:18:\"string_translation\";s:22:\"connectorPluginManager\";s:48:\"plugin.manager.elasticsearch_connector.connector\";s:20:\"backendClientFactory\";s:46:\"elasticsearch_connector.backend_client_factory\";s:15:\"eventDispatcher\";s:16:\"event_dispatcher\";}s:18:\" * _entityStorages\";a:0:{}s:12:\" * messenger\";N;s:15:\" * dependencies\";a:0:{}s:9:\" * server\";O:31:\"Drupal\\search_api\\Entity\\Server\":29:{s:15:\" * entityTypeId\";s:17:\"search_api_server\";s:15:\" * enforceIsNew\";b:1;s:12:\" * typedData\";N;s:16:\" * cacheContexts\";a:0:{}s:12:\" * cacheTags\";a:0:{}s:14:\" * cacheMaxAge\";i:-1;s:14:\" * _serviceIds\";a:0:{}s:18:\" * _entityStorages\";a:0:{}s:13:\" * originalId\";N;s:9:\" * status\";i:1;s:7:\" * uuid\";s:36:\"cb97c534-ca4e-4e4e-9773-e7871c6a2ccf\";s:11:\" * langcode\";s:2:\"en\";s:23:\" * third_party_settings\";a:0:{}s:8:\" * _core\";a:0:{}s:14:\" * trustedData\";b:0;s:15:\" * dependencies\";a:0:{}s:12:\" * isSyncing\";b:0;s:5:\" * id\";s:16:\"octagonal_rhythm\";s:7:\" * name\";s:16:\"Octagonal rhythm\";s:14:\" * description\";s:0:\"\";s:10:\" * backend\";s:13:\"elasticsearch\";s:17:\" * backend_config\";a:3:{s:9:\"connector\";s:16:\"elastic_cloud_id\";s:16:\"connector_config\";a:2:{s:3:\"url\";s:0:\"\";s:20:\"enable_debug_logging\";i:0;}s:8:\"advanced\";a:4:{s:9:\"fuzziness\";s:4:\"auto\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:8:\"synonyms\";s:0:\"\";}}s:16:\" * backendPlugin\";r:116;s:11:\" * features\";N;s:9:\" * logger\";N;s:6:\"submit\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Save\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"form_build_id\";s:48:\"form-SRtYPNhb2PeW5pZ__9KU_H2HkAlTk6uwsCEutYBKM6U\";s:10:\"form_token\";s:43:\"mAws8SsEXEbyRoRs1cpWVgxqqCi4jeLmrEe2WRuBfWI\";s:7:\"form_id\";s:22:\"search_api_server_form\";}s:11:\" * serverId\";N;s:15:\" * fieldsHelper\";N;s:9:\" * logger\";N;s:16:\" * backendClient\";N;}i:1;s:28:\"buildAjaxConnectorConfigForm\";}s:7:\"wrapper\";s:35:\"elasticsearch-connector-config-form\";s:6:\"method\";s:7:\"replace\";s:6:\"effect\";s:4:\"fade\";}}s:16:\"connector_config\";a:9:{s:16:\"elastic_cloud_id\";a:6:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:16:\"Elastic Cloud ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:571:\"Your Hosted deployment's <em>Cloud ID</em>, in the format <code>&lt;label&gt;:&lt;cloud-id&gt;</code>, where <code>&lt;label&gt;:</code> is an optional human-readable name, and <code>&lt;cloud-id&gt;</code> is a base64-encoded text value of about 120 characters, made up of upper and lower case letters and numbers. Your Cloud ID is displayed at the top of the Hosted deployment's Kibana instance's Overview page. You can also find it by clicking on the deployment name from the <a href='@elastic_cloud_deployments'>Elastic Cloud <em>Hosted deployments</em> list page</a>\";s:12:\" * arguments\";a:1:{s:26:\"@elastic_cloud_deployments\";s:37:\"https://cloud.elastic.co/deployments/\";}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";s:9:\"#required\";b:1;s:10:\"#maxlength\";i:500;}s:21:\"no_key_module_message\";a:3:{s:6:\"#theme\";s:15:\"status_messages\";s:16:\"#status_headings\";a:1:{s:5:\"error\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:18:\"Key module missing\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:13:\"#message_list\";a:1:{s:5:\"error\";a:1:{i:0;O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:160:\"You must install <a href='@key_module_url'>Drupal's Key module</a> to use this authentication type! Please ensure that the Key module is downloaded and enabled.\";s:12:\" * arguments\";a:1:{s:15:\"@key_module_url\";s:34:\"https://www.drupal.org/project/key\";}s:10:\" * options\";a:0:{}}}}}s:20:\"enable_debug_logging\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:56:\"Enable debugging mode: log ElasticSearch network traffic\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:506:\"This will write requests, responses, and response-time information to Drupal's log, which may help you diagnose problems with Drupal's connection to ElasticSearch.<p><strong>Warning</strong>: This setting will result in poor performance and may log a user’s personally identifiable information. This setting is only intended for temporary use and should be disabled when you finish debugging. Logs written while this mode is active will remain in the log until you clear them or the logs are rotated.</p>\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";i:0;}s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:41:\"Configure %plugin ElasticSearch connector\";s:12:\" * arguments\";a:1:{s:7:\"%plugin\";s:16:\"Elastic Cloud ID\";}s:10:\" * options\";a:0:{}}s:12:\"#description\";s:85:\"Connect to Elasticsearch B.V.’s official Elastic Cloud with a Cloud ID and API key.\";s:5:\"#open\";b:1;s:11:\"#attributes\";a:1:{s:2:\"id\";s:35:\"elasticsearch-connector-config-form\";}s:5:\"#tree\";b:1;}s:8:\"advanced\";a:6:{s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Advanced\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"fuzziness\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:9:\"Fuzziness\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"#required\";b:1;s:8:\"#options\";a:7:{i:0;O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"- Disabled -\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:4:\"auto\";s:4:\"auto\";i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;}s:14:\"#default_value\";s:4:\"auto\";s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:248:\"Some queries and APIs support parameters to allow inexact fuzzy matching, using the fuzziness parameter. See <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/common-options.html#fuzziness\">Fuzziness</a> for more information.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:6:\"prefix\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Index prefix\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:101:\"Using an index prefix can be useful for using the same server for different projects or environments.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}s:6:\"suffix\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Index suffix\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:101:\"Using an index suffix can be useful for using the same server for different projects or environments.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}s:8:\"synonyms\";a:4:{s:5:\"#type\";s:8:\"textarea\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Synonyms\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:61:\"Enter synonyms in <a href=\":url\">Solr synonyms.txt format</a>\";s:12:\" * arguments\";a:1:{s:4:\":url\";s:112:\"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis-synonym-tokenfilter.html#_solr_synonyms\";}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}}s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:25:\"Configure %plugin backend\";s:12:\" * arguments\";a:1:{s:7:\"%plugin\";r:77;}s:10:\" * options\";a:0:{}}s:5:\"#open\";b:1;s:11:\"#attributes\";a:1:{s:2:\"id\";s:30:\"search-api-backend-config-form\";}s:5:\"#tree\";b:1;}s:7:\"actions\";a:2:{s:6:\"submit\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Save\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:7:\"#submit\";a:2:{i:0;s:12:\"::submitForm\";i:1;s:6:\"::save\";}s:12:\"#button_type\";s:7:\"primary\";s:7:\"#weight\";i:5;}s:5:\"#type\";s:7:\"actions\";}s:8:\"#form_id\";s:22:\"search_api_server_form\";s:9:\"#build_id\";s:48:\"form-bh0AsljSHn16_ZT2T4D9SZxHxEiiCK1gBaAzJIF33Ik\";s:5:\"#type\";s:4:\"form\";s:7:\"#action\";s:55:\"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM\";s:13:\"form_build_id\";a:6:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-bh0AsljSHn16_ZT2T4D9SZxHxEiiCK1gBaAzJIF33Ik\";s:3:\"#id\";s:48:\"form-bh0AsljSHn16_ZT2T4D9SZxHxEiiCK1gBaAzJIF33Ik\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}s:11:\"#attributes\";a:1:{s:12:\"autocomplete\";s:3:\"off\";}}s:6:\"#cache\";a:1:{s:8:\"contexts\";a:1:{i:0;s:24:\"user.roles:authenticated\";}}s:6:\"#token\";s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";s:10:\"form_token\";a:6:{s:3:\"#id\";s:51:\"edit-search-api-server-form-form-token--oAn4RiD3_Ik\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}s:9:\"#attached\";a:1:{s:12:\"placeholders\";a:1:{s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";a:1:{s:13:\"#lazy_builder\";a:2:{i:0;s:39:\"form_builder:renderFormTokenPlaceholder\";i:1;a:1:{i:0;s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";}}}}}s:6:\"#cache\";a:1:{s:7:\"max-age\";i:0;}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:22:\"search_api_server_form\";s:3:\"#id\";s:40:\"edit-search-api-server-form--jcd-yXvAFZA\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:35:\"search-api-server-form--Bvwblf4NKGc\";s:7:\"#method\";s:4:\"post\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:16:\"#defaults_loaded\";b:1;s:5:\"#tree\";b:0;s:8:\"#parents\";a:0:{}s:9:\"#validate\";a:1:{i:0;s:14:\"::validateForm\";}s:7:\"#submit\";a:1:{i:0;s:12:\"::submitForm\";}s:6:\"#theme\";a:1:{i:0;s:22:\"search_api_server_form\";}s:12:\"#cache_token\";s:43:\"w-8loJAIj0zwn86cENAl2YZ_OfSLRYqcrb9HEdMfJAw\";}",
  'expire' => '1767734394',
))
->values(array(
  'collection' => 'form',
  'name' => 'form-BPT1l2BMSY3pFQsQChoqVI7Ye4bSiRBxuF79wbJyCDE',
  'value' => 'a:37:{s:11:"#attributes";a:2:{s:5:"class";a:1:{i:0;s:21:"search-api-index-form";}s:20:"data-drupal-selector";s:21:"search-api-index-form";}s:8:"#process";a:1:{i:0;s:13:"::processForm";}s:12:"#after_build";a:1:{i:0;s:12:"::afterBuild";}s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Add search index";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:5:"#tree";b:1;s:4:"name";a:5:{s:5:"#type";s:9:"textfield";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:10:"Index name";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:39:"Enter the displayed name for the index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:21:"colorful_organization";s:9:"#required";b:1;}s:2:"id";a:6:{s:5:"#type";s:12:"machine_name";s:14:"#default_value";N;s:10:"#maxlength";i:50;s:9:"#required";b:1;s:13:"#machine_name";a:2:{s:6:"exists";s:37:"\Drupal\search_api\Entity\Index::load";s:6:"source";a:1:{i:0;s:4:"name";}}s:9:"#disabled";b:0;}s:9:"#attached";a:2:{s:7:"library";a:1:{i:0;s:38:"search_api/drupal.search_api.admin_css";}s:12:"placeholders";a:1:{s:55:"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM";a:1:{s:13:"#lazy_builder";a:2:{i:0;s:40:"form_builder:renderPlaceholderFormAction";i:1;a:0:{}}}}}s:11:"datasources";a:13:{s:5:"#type";s:10:"checkboxes";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Datasources";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:74:"Select one or more datasources of items that will be stored in this index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";a:0:{}s:9:"#multiple";b:1;s:9:"#required";b:1;s:11:"#attributes";a:1:{s:5:"class";a:1:{i:0;s:26:"search-api-checkboxes-list";}}s:5:"#ajax";a:5:{s:10:"trigger_as";a:1:{s:4:"name";s:21:"datasources_configure";}s:8:"callback";s:31:"::buildAjaxDatasourceConfigForm";s:7:"wrapper";s:34:"search-api-datasources-config-form";s:6:"method";s:7:"replace";s:6:"effect";s:4:"fade";}s:11:"entity:node";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:17:"entity:path_alias";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"URL alias";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:22:"entity:search_api_task";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Search task";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:11:"entity:user";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"User";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:8:"#options";a:4:{s:11:"entity:node";r:72;s:22:"entity:search_api_task";r:90;s:17:"entity:path_alias";r:81;s:11:"entity:user";r:99;}}s:18:"datasource_configs";a:4:{s:5:"#type";s:9:"container";s:11:"#attributes";a:1:{s:2:"id";s:34:"search-api-datasources-config-form";}s:5:"#tree";b:1;s:22:"entity:search_api_task";a:3:{s:5:"#type";s:7:"details";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:36:"Configure the %datasource datasource";s:12:" * arguments";a:1:{s:11:"%datasource";r:90;}s:10:" * options";a:0:{}}s:5:"#open";b:1;}}s:27:"datasource_configure_button";a:7:{s:5:"#type";s:6:"submit";s:5:"#name";s:21:"datasources_configure";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:24:"#limit_validation_errors";a:1:{i:0;a:1:{i:0;s:11:"datasources";}}s:7:"#submit";a:1:{i:0;s:32:"::submitAjaxDatasourceConfigForm";}s:5:"#ajax";a:2:{s:8:"callback";s:31:"::buildAjaxDatasourceConfigForm";s:7:"wrapper";s:34:"search-api-datasources-config-form";}s:11:"#attributes";a:1:{s:5:"class";a:1:{i:0;s:7:"js-hide";}}}s:7:"tracker";a:9:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Tracker";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:82:"Select the type of tracker which should be used for keeping track of item changes.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:7:"default";s:9:"#required";b:1;s:5:"#ajax";a:5:{s:10:"trigger_as";a:1:{s:4:"name";s:17:"tracker_configure";}s:8:"callback";s:28:"::buildAjaxTrackerConfigForm";s:7:"wrapper";s:30:"search-api-tracker-config-form";s:6:"method";s:7:"replace";s:6:"effect";s:4:"fade";}s:7:"default";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:76:"Default index tracker which uses a simple database table for tracking items.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:8:"#options";a:1:{s:7:"default";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Default";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:7:"#access";b:0;}s:14:"tracker_config";a:7:{s:5:"#type";s:7:"details";s:11:"#attributes";a:1:{s:2:"id";s:30:"search-api-tracker-config-form";}s:5:"#tree";b:1;s:14:"indexing_order";a:5:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Indexing order";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:41:"The order in which items will be indexed.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:2:{s:4:"fifo";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:54:"Index items in the same order in which they were saved";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:4:"lifo";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:33:"Index the most recent items first";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:14:"#default_value";s:4:"fifo";}s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:29:"Configure the %plugin tracker";s:12:" * arguments";a:1:{s:7:"%plugin";r:165;}s:10:" * options";a:0:{}}s:12:"#description";r:160;s:5:"#open";b:1;}s:24:"tracker_configure_button";a:8:{s:5:"#type";s:6:"submit";s:5:"#name";s:17:"tracker_configure";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:24:"#limit_validation_errors";a:1:{i:0;a:1:{i:0;s:7:"tracker";}}s:7:"#submit";a:1:{i:0;s:29:"::submitAjaxTrackerConfigForm";}s:5:"#ajax";a:2:{s:8:"callback";s:28:"::buildAjaxTrackerConfigForm";s:7:"wrapper";s:30:"search-api-tracker-config-form";}s:11:"#attributes";a:1:{s:5:"class";a:1:{i:0;s:7:"js-hide";}}s:7:"#access";b:0;}s:6:"server";a:5:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Server";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:115:"Select the server this index should use. Indexes cannot be enabled without a connection to a valid, enabled server.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:3:{s:0:"";s:22:"<em>- No server -</em>";s:16:"circular_opinion";O:25:"Drupal\Core\Render\Markup":1:{s:9:" * string";s:16:"Circular opinion";}s:13:"oval_decision";O:25:"Drupal\Core\Render\Markup":1:{s:9:" * string";s:13:"Oval decision";}}s:14:"#default_value";s:0:"";}s:6:"status";a:6:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Enabled";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:135:"Only enabled indexes can be used for indexing and searching. This setting will only take effect if the selected server is also enabled.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";b:1;s:9:"#disabled";b:0;s:7:"#states";a:1:{s:9:"invisible";a:1:{s:21:":input[name="server"]";a:1:{s:5:"value";s:0:"";}}}}s:11:"description";a:4:{s:5:"#type";s:8:"textarea";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Description";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"Enter a description for the index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:29:"colorful_organization index, ";}s:7:"options";a:8:{s:5:"#tree";b:1;s:5:"#type";s:7:"details";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Index options";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:10:"#collapsed";b:1;s:9:"read_only";a:5:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Read only";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:70:"Do not write to this index or track the status of items in this index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";i:0;s:8:"#parents";a:1:{i:0;s:9:"read_only";}}s:14:"index_directly";a:4:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:23:"Index items immediately";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:173:"Immediately index new or updated items instead of waiting for the next cron run. This might have serious performance drawbacks and is generally not advised for larger sites.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";i:1;}s:27:"track_changes_in_references";a:4:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:36:"Track changes in referenced entities";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:562:"Automatically queue items for re-indexing if one of the field values indexed from entities they reference is changed. (For instance, when indexing the name of a taxonomy term in a Content index, this would lead to re-indexing when the term’s name changes.) Enabling this setting can lead to performance problems on large sites when saving some types of entities (an often-used taxonomy term in our example). However, when the setting is disabled, fields from referenced entities can go stale in the search index and other steps should be taken to prevent this.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";i:1;}s:10:"cron_limit";a:5:{s:5:"#type";s:9:"textfield";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:15:"Cron batch size";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:198:"Set how many items will be indexed at once when indexing items during a cron run. "0" means that no items will be indexed by cron for this index, "-1" means that cron should index all items at once.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:2:"50";s:5:"#size";i:4;}}s:7:"actions";a:3:{s:6:"submit";a:5:{s:5:"#type";s:6:"submit";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Save";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"#submit";a:2:{i:0;s:12:"::submitForm";i:1;s:6:"::save";}s:12:"#button_type";s:7:"primary";s:7:"#weight";i:5;}s:9:"save_edit";a:6:{s:5:"#type";s:6:"submit";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Save and add fields";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"#submit";a:2:{i:0;s:12:"::submitForm";i:1;s:6:"::save";}s:12:"#button_type";s:7:"primary";s:16:"#redirect_to_url";s:10:"add-fields";s:7:"#weight";i:10;}s:5:"#type";s:7:"actions";}s:8:"#form_id";s:21:"search_api_index_form";s:9:"#build_id";s:48:"form-BPT1l2BMSY3pFQsQChoqVI7Ye4bSiRBxuF79wbJyCDE";s:5:"#type";s:4:"form";s:7:"#action";s:55:"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM";s:13:"form_build_id";a:6:{s:5:"#type";s:6:"hidden";s:6:"#value";s:48:"form-BPT1l2BMSY3pFQsQChoqVI7Ye4bSiRBxuF79wbJyCDE";s:3:"#id";s:48:"form-BPT1l2BMSY3pFQsQChoqVI7Ye4bSiRBxuF79wbJyCDE";s:5:"#name";s:13:"form_build_id";s:8:"#parents";a:1:{i:0;s:13:"form_build_id";}s:11:"#attributes";a:1:{s:12:"autocomplete";s:3:"off";}}s:6:"#cache";a:1:{s:8:"contexts";a:1:{i:0;s:24:"user.roles:authenticated";}}s:6:"#token";s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";s:10:"form_token";a:6:{s:3:"#id";s:50:"edit-search-api-index-form-form-token--7Gd58-lFUBc";s:5:"#type";s:5:"token";s:14:"#default_value";s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";s:8:"#parents";a:1:{i:0;s:10:"form_token";}s:9:"#attached";a:1:{s:12:"placeholders";a:1:{s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";a:1:{s:13:"#lazy_builder";a:2:{i:0;s:39:"form_builder:renderFormTokenPlaceholder";i:1;a:1:{i:0;s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";}}}}}s:6:"#cache";a:1:{s:7:"max-age";i:0;}}s:7:"form_id";a:4:{s:5:"#type";s:6:"hidden";s:6:"#value";s:21:"search_api_index_form";s:3:"#id";s:39:"edit-search-api-index-form--gQMzo6JSzms";s:8:"#parents";a:1:{i:0;s:7:"form_id";}}s:3:"#id";s:34:"search-api-index-form--d8-CvnWvaRQ";s:7:"#method";s:4:"post";s:15:"#theme_wrappers";a:1:{i:0;s:4:"form";}s:16:"#defaults_loaded";b:1;s:8:"#parents";a:0:{}s:9:"#validate";a:1:{i:0;s:14:"::validateForm";}s:7:"#submit";a:1:{i:0;s:12:"::submitForm";}s:6:"#theme";a:1:{i:0;s:21:"search_api_index_form";}s:12:"#cache_token";s:43:"w-8loJAIj0zwn86cENAl2YZ_OfSLRYqcrb9HEdMfJAw";}',
  'expire' => '1767734555',
))
->values(array(
  'collection' => 'form',
  'name' => 'form-GA0NYOvXA3Ve-szIncitnXcPp1aujQafPbwsKCv8_tI',
  'value' => 'a:37:{s:11:"#attributes";a:2:{s:5:"class";a:1:{i:0;s:21:"search-api-index-form";}s:20:"data-drupal-selector";s:21:"search-api-index-form";}s:8:"#process";a:1:{i:0;s:13:"::processForm";}s:12:"#after_build";a:1:{i:0;s:12:"::afterBuild";}s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Add search index";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:5:"#tree";b:1;s:4:"name";a:5:{s:5:"#type";s:9:"textfield";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:10:"Index name";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:39:"Enter the displayed name for the index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:17:"Robust discussion";s:9:"#required";b:1;}s:2:"id";a:6:{s:5:"#type";s:12:"machine_name";s:14:"#default_value";N;s:10:"#maxlength";i:50;s:9:"#required";b:1;s:13:"#machine_name";a:2:{s:6:"exists";s:37:"\Drupal\search_api\Entity\Index::load";s:6:"source";a:1:{i:0;s:4:"name";}}s:9:"#disabled";b:0;}s:9:"#attached";a:2:{s:7:"library";a:1:{i:0;s:38:"search_api/drupal.search_api.admin_css";}s:12:"placeholders";a:1:{s:55:"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM";a:1:{s:13:"#lazy_builder";a:2:{i:0;s:40:"form_builder:renderPlaceholderFormAction";i:1;a:0:{}}}}}s:11:"datasources";a:13:{s:5:"#type";s:10:"checkboxes";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Datasources";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:74:"Select one or more datasources of items that will be stored in this index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";a:0:{}s:9:"#multiple";b:1;s:9:"#required";b:1;s:11:"#attributes";a:1:{s:5:"class";a:1:{i:0;s:26:"search-api-checkboxes-list";}}s:5:"#ajax";a:5:{s:10:"trigger_as";a:1:{s:4:"name";s:21:"datasources_configure";}s:8:"callback";s:31:"::buildAjaxDatasourceConfigForm";s:7:"wrapper";s:34:"search-api-datasources-config-form";s:6:"method";s:7:"replace";s:6:"effect";s:4:"fade";}s:11:"entity:node";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:17:"entity:path_alias";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"URL alias";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:22:"entity:search_api_task";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Search task";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:11:"entity:user";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"Provides %entity_type entities for indexing and searching.";s:12:" * arguments";a:1:{s:12:"%entity_type";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"User";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:10:" * options";a:0:{}}}s:8:"#options";a:4:{s:11:"entity:node";r:72;s:22:"entity:search_api_task";r:90;s:17:"entity:path_alias";r:81;s:11:"entity:user";r:99;}}s:18:"datasource_configs";a:4:{s:5:"#type";s:9:"container";s:11:"#attributes";a:1:{s:2:"id";s:34:"search-api-datasources-config-form";}s:5:"#tree";b:1;s:11:"entity:node";a:5:{s:7:"bundles";a:5:{s:5:"#type";s:7:"details";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Bundles";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:5:"#open";b:1;s:7:"default";a:4:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:32:"Which bundles should be indexed?";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:2:{i:0;O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Only those selected";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}i:1;O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:25:"All except those selected";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:14:"#default_value";i:1;}s:8:"selected";a:6:{s:5:"#type";s:10:"checkboxes";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Bundles";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:1:{s:4:"page";O:25:"Drupal\Core\Render\Markup":1:{s:9:" * string";s:10:"Basic page";}}s:14:"#default_value";a:0:{}s:5:"#size";i:1;s:9:"#multiple";b:1;}}s:9:"languages";a:5:{s:5:"#type";s:7:"details";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Languages";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:5:"#open";b:1;s:7:"default";a:4:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"Which languages should be indexed?";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:2:{i:0;O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Only those selected";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}i:1;O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:25:"All except those selected";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:14:"#default_value";i:1;}s:8:"selected";a:5:{s:5:"#type";s:10:"checkboxes";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Languages";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:1:{s:2:"en";s:7:"English";}s:14:"#default_value";a:0:{}s:9:"#multiple";b:1;}}s:5:"#type";s:7:"details";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:36:"Configure the %datasource datasource";s:12:" * arguments";a:1:{s:11:"%datasource";r:72;}s:10:" * options";a:0:{}}s:5:"#open";b:1;}}s:27:"datasource_configure_button";a:7:{s:5:"#type";s:6:"submit";s:5:"#name";s:21:"datasources_configure";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:24:"#limit_validation_errors";a:1:{i:0;a:1:{i:0;s:11:"datasources";}}s:7:"#submit";a:1:{i:0;s:32:"::submitAjaxDatasourceConfigForm";}s:5:"#ajax";a:2:{s:8:"callback";s:31:"::buildAjaxDatasourceConfigForm";s:7:"wrapper";s:34:"search-api-datasources-config-form";}s:11:"#attributes";a:1:{s:5:"class";a:1:{i:0;s:7:"js-hide";}}}s:7:"tracker";a:9:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Tracker";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:82:"Select the type of tracker which should be used for keeping track of item changes.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:7:"default";s:9:"#required";b:1;s:5:"#ajax";a:5:{s:10:"trigger_as";a:1:{s:4:"name";s:17:"tracker_configure";}s:8:"callback";s:28:"::buildAjaxTrackerConfigForm";s:7:"wrapper";s:30:"search-api-tracker-config-form";s:6:"method";s:7:"replace";s:6:"effect";s:4:"fade";}s:7:"default";a:1:{s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:76:"Default index tracker which uses a simple database table for tracking items.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:8:"#options";a:1:{s:7:"default";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Default";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:7:"#access";b:0;}s:14:"tracker_config";a:7:{s:5:"#type";s:7:"details";s:11:"#attributes";a:1:{s:2:"id";s:30:"search-api-tracker-config-form";}s:5:"#tree";b:1;s:14:"indexing_order";a:5:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Indexing order";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:41:"The order in which items will be indexed.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:2:{s:4:"fifo";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:54:"Index items in the same order in which they were saved";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:4:"lifo";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:33:"Index the most recent items first";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:14:"#default_value";s:4:"fifo";}s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:29:"Configure the %plugin tracker";s:12:" * arguments";a:1:{s:7:"%plugin";r:233;}s:10:" * options";a:0:{}}s:12:"#description";r:228;s:5:"#open";b:1;}s:24:"tracker_configure_button";a:8:{s:5:"#type";s:6:"submit";s:5:"#name";s:17:"tracker_configure";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:24:"#limit_validation_errors";a:1:{i:0;a:1:{i:0;s:7:"tracker";}}s:7:"#submit";a:1:{i:0;s:29:"::submitAjaxTrackerConfigForm";}s:5:"#ajax";a:2:{s:8:"callback";s:28:"::buildAjaxTrackerConfigForm";s:7:"wrapper";s:30:"search-api-tracker-config-form";}s:11:"#attributes";a:1:{s:5:"class";a:1:{i:0;s:7:"js-hide";}}s:7:"#access";b:0;}s:6:"server";a:5:{s:5:"#type";s:6:"radios";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Server";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:115:"Select the server this index should use. Indexes cannot be enabled without a connection to a valid, enabled server.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"#options";a:4:{s:0:"";s:22:"<em>- No server -</em>";s:16:"circular_opinion";O:25:"Drupal\Core\Render\Markup":1:{s:9:" * string";s:16:"Circular opinion";}s:16:"octagonal_rhythm";O:25:"Drupal\Core\Render\Markup":1:{s:9:" * string";s:16:"Octagonal rhythm";}s:13:"oval_decision";O:25:"Drupal\Core\Render\Markup":1:{s:9:" * string";s:13:"Oval decision";}}s:14:"#default_value";s:16:"octagonal_rhythm";}s:6:"status";a:6:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Enabled";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:135:"Only enabled indexes can be used for indexing and searching. This setting will only take effect if the selected server is also enabled.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";b:1;s:9:"#disabled";b:0;s:7:"#states";a:1:{s:9:"invisible";a:1:{s:21:":input[name="server"]";a:1:{s:5:"value";s:0:"";}}}}s:11:"description";a:4:{s:5:"#type";s:8:"textarea";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Description";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"Enter a description for the index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:18:"robust_discussion ";}s:7:"options";a:8:{s:5:"#tree";b:1;s:5:"#type";s:7:"details";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Index options";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:10:"#collapsed";b:1;s:9:"read_only";a:5:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Read only";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:70:"Do not write to this index or track the status of items in this index.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";i:0;s:8:"#parents";a:1:{i:0;s:9:"read_only";}}s:14:"index_directly";a:4:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:23:"Index items immediately";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:173:"Immediately index new or updated items instead of waiting for the next cron run. This might have serious performance drawbacks and is generally not advised for larger sites.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";i:1;}s:27:"track_changes_in_references";a:4:{s:5:"#type";s:8:"checkbox";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:36:"Track changes in referenced entities";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:562:"Automatically queue items for re-indexing if one of the field values indexed from entities they reference is changed. (For instance, when indexing the name of a taxonomy term in a Content index, this would lead to re-indexing when the term’s name changes.) Enabling this setting can lead to performance problems on large sites when saving some types of entities (an often-used taxonomy term in our example). However, when the setting is disabled, fields from referenced entities can go stale in the search index and other steps should be taken to prevent this.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";i:1;}s:10:"cron_limit";a:5:{s:5:"#type";s:9:"textfield";s:6:"#title";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:15:"Cron batch size";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"#description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:198:"Set how many items will be indexed at once when indexing items during a cron run. "0" means that no items will be indexed by cron for this index, "-1" means that cron should index all items at once.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:"#default_value";s:2:"50";s:5:"#size";i:4;}}s:7:"actions";a:3:{s:6:"submit";a:5:{s:5:"#type";s:6:"submit";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Save";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"#submit";a:2:{i:0;s:12:"::submitForm";i:1;s:6:"::save";}s:12:"#button_type";s:7:"primary";s:7:"#weight";i:5;}s:9:"save_edit";a:6:{s:5:"#type";s:6:"submit";s:6:"#value";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Save and add fields";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"#submit";a:2:{i:0;s:12:"::submitForm";i:1;s:6:"::save";}s:12:"#button_type";s:7:"primary";s:16:"#redirect_to_url";s:10:"add-fields";s:7:"#weight";i:10;}s:5:"#type";s:7:"actions";}s:8:"#form_id";s:21:"search_api_index_form";s:9:"#build_id";s:48:"form-GA0NYOvXA3Ve-szIncitnXcPp1aujQafPbwsKCv8_tI";s:5:"#type";s:4:"form";s:7:"#action";s:55:"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM";s:13:"form_build_id";a:6:{s:5:"#type";s:6:"hidden";s:6:"#value";s:48:"form-GA0NYOvXA3Ve-szIncitnXcPp1aujQafPbwsKCv8_tI";s:3:"#id";s:48:"form-GA0NYOvXA3Ve-szIncitnXcPp1aujQafPbwsKCv8_tI";s:5:"#name";s:13:"form_build_id";s:8:"#parents";a:1:{i:0;s:13:"form_build_id";}s:11:"#attributes";a:1:{s:12:"autocomplete";s:3:"off";}}s:6:"#cache";a:1:{s:8:"contexts";a:1:{i:0;s:24:"user.roles:authenticated";}}s:6:"#token";s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";s:10:"form_token";a:6:{s:3:"#id";s:50:"edit-search-api-index-form-form-token--AbURbb47eRU";s:5:"#type";s:5:"token";s:14:"#default_value";s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";s:8:"#parents";a:1:{i:0;s:10:"form_token";}s:9:"#attached";a:1:{s:12:"placeholders";a:1:{s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";a:1:{s:13:"#lazy_builder";a:2:{i:0;s:39:"form_builder:renderFormTokenPlaceholder";i:1;a:1:{i:0;s:66:"form_token_placeholder_W6_kiUHRm1o8DHPl2HgxycUOwV_OYgX7YL4sFdYQDCY";}}}}}s:6:"#cache";a:1:{s:7:"max-age";i:0;}}s:7:"form_id";a:4:{s:5:"#type";s:6:"hidden";s:6:"#value";s:21:"search_api_index_form";s:3:"#id";s:39:"edit-search-api-index-form--GiGUqM2KSEY";s:8:"#parents";a:1:{i:0;s:7:"form_id";}}s:3:"#id";s:34:"search-api-index-form--Qaqx2B_uGzA";s:7:"#method";s:4:"post";s:15:"#theme_wrappers";a:1:{i:0;s:4:"form";}s:16:"#defaults_loaded";b:1;s:8:"#parents";a:0:{}s:9:"#validate";a:1:{i:0;s:14:"::validateForm";}s:7:"#submit";a:1:{i:0;s:12:"::submitForm";}s:6:"#theme";a:1:{i:0;s:21:"search_api_index_form";}s:12:"#cache_token";s:43:"w-8loJAIj0zwn86cENAl2YZ_OfSLRYqcrb9HEdMfJAw";}',
  'expire' => '1767735518',
))
->values(array(
  'collection' => 'form',
  'name' => 'form-Kb_hR2ixFMXb_guPjHv4grSlQl6n5SFnfNq6iRmI9sk',
  'value' => "a:31:{s:11:\"#attributes\";a:2:{s:5:\"class\";a:1:{i:0;s:22:\"search-api-server-form\";}s:20:\"data-drupal-selector\";s:22:\"search-api-server-form\";}s:8:\"#process\";a:1:{i:0;s:13:\"::processForm\";}s:12:\"#after_build\";a:1:{i:0;s:12:\"::afterBuild\";}s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"Add search server\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"#attached\";a:2:{s:7:\"library\";a:1:{i:0;s:38:\"search_api/drupal.search_api.admin_css\";}s:12:\"placeholders\";a:1:{s:55:\"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM\";a:1:{s:13:\"#lazy_builder\";a:2:{i:0;s:40:\"form_builder:renderPlaceholderFormAction\";i:1;a:0:{}}}}}s:4:\"name\";a:5:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Server name\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:40:\"Enter the displayed name for the server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:13:\"Oval decision\";s:9:\"#required\";b:1;}s:2:\"id\";a:6:{s:5:\"#type\";s:12:\"machine_name\";s:14:\"#default_value\";N;s:10:\"#maxlength\";i:50;s:9:\"#required\";b:1;s:13:\"#machine_name\";a:2:{s:6:\"exists\";s:38:\"\\Drupal\\search_api\\Entity\\Server::load\";s:6:\"source\";a:1:{i:0;s:4:\"name\";}}s:9:\"#disabled\";b:0;}s:6:\"status\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Enabled\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:57:\"Only enabled servers can index items or execute searches.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";b:1;}s:11:\"description\";a:4:{s:5:\"#type\";s:8:\"textarea\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Description\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:35:\"Enter a description for the server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:51:\"oval_decision, HTTP Basic Authentication connector.\";}s:7:\"backend\";a:9:{s:5:\"#type\";s:6:\"radios\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Backend\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:40:\"Choose a backend to use for this server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"#options\";a:1:{s:13:\"elasticsearch\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:13:\"ElasticSearch\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:14:\"#default_value\";s:13:\"elasticsearch\";s:9:\"#required\";b:1;s:9:\"#disabled\";b:0;s:5:\"#ajax\";a:4:{s:8:\"callback\";a:2:{i:0;s:33:\"Drupal\\search_api\\Form\\ServerForm\";i:1;s:26:\"buildAjaxBackendConfigForm\";}s:7:\"wrapper\";s:30:\"search-api-backend-config-form\";s:6:\"method\";s:7:\"replace\";s:6:\"effect\";s:4:\"fade\";}s:13:\"elasticsearch\";a:1:{s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:34:\"Provides an ElasticSearch backend.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}}s:14:\"backend_config\";a:8:{s:9:\"connector\";a:7:{s:5:\"#type\";s:6:\"radios\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:23:\"ElasticSearch Connector\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:56:\"Choose a connector to use for this ElasticSearch server.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"#options\";a:4:{s:8:\"standard\";s:8:\"Standard\";s:16:\"elastic_cloud_id\";s:16:\"Elastic Cloud ID\";s:22:\"elastic_cloud_endpoint\";s:22:\"Elastic Cloud Endpoint\";s:9:\"basicauth\";s:25:\"HTTP Basic Authentication\";}s:14:\"#default_value\";s:9:\"basicauth\";s:9:\"#required\";b:1;s:5:\"#ajax\";a:4:{s:8:\"callback\";a:2:{i:0;O:77:\"Drupal\\elasticsearch_connector\\Plugin\\search_api\\backend\\ElasticSearchBackend\":12:{s:11:\" * pluginId\";s:13:\"elasticsearch\";s:19:\" * pluginDefinition\";a:5:{s:2:\"id\";s:13:\"elasticsearch\";s:5:\"label\";r:77;s:11:\"description\";r:92;s:5:\"class\";s:77:\"Drupal\\elasticsearch_connector\\Plugin\\search_api\\backend\\ElasticSearchBackend\";s:8:\"provider\";s:23:\"elasticsearch_connector\";}s:16:\" * configuration\";a:3:{s:9:\"connector\";s:9:\"basicauth\";s:16:\"connector_config\";a:2:{s:3:\"url\";s:0:\"\";s:20:\"enable_debug_logging\";i:0;}s:8:\"advanced\";a:4:{s:9:\"fuzziness\";s:4:\"auto\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:8:\"synonyms\";s:0:\"\";}}s:14:\" * _serviceIds\";a:4:{s:17:\"stringTranslation\";s:18:\"string_translation\";s:22:\"connectorPluginManager\";s:48:\"plugin.manager.elasticsearch_connector.connector\";s:20:\"backendClientFactory\";s:46:\"elasticsearch_connector.backend_client_factory\";s:15:\"eventDispatcher\";s:16:\"event_dispatcher\";}s:18:\" * _entityStorages\";a:0:{}s:12:\" * messenger\";N;s:15:\" * dependencies\";a:0:{}s:9:\" * server\";O:31:\"Drupal\\search_api\\Entity\\Server\":29:{s:15:\" * entityTypeId\";s:17:\"search_api_server\";s:15:\" * enforceIsNew\";b:1;s:12:\" * typedData\";N;s:16:\" * cacheContexts\";a:0:{}s:12:\" * cacheTags\";a:0:{}s:14:\" * cacheMaxAge\";i:-1;s:14:\" * _serviceIds\";a:0:{}s:18:\" * _entityStorages\";a:0:{}s:13:\" * originalId\";N;s:9:\" * status\";i:1;s:7:\" * uuid\";s:36:\"d4d3cf1a-e2d9-4020-869d-f85be72d25a6\";s:11:\" * langcode\";s:2:\"en\";s:23:\" * third_party_settings\";a:0:{}s:8:\" * _core\";a:0:{}s:14:\" * trustedData\";b:0;s:15:\" * dependencies\";a:0:{}s:12:\" * isSyncing\";b:0;s:5:\" * id\";s:13:\"oval_decision\";s:7:\" * name\";s:13:\"Oval decision\";s:14:\" * description\";s:51:\"oval_decision, HTTP Basic Authentication connector.\";s:10:\" * backend\";s:13:\"elasticsearch\";s:17:\" * backend_config\";a:3:{s:9:\"connector\";s:9:\"basicauth\";s:16:\"connector_config\";a:2:{s:3:\"url\";s:0:\"\";s:20:\"enable_debug_logging\";i:0;}s:8:\"advanced\";a:4:{s:9:\"fuzziness\";s:4:\"auto\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:8:\"synonyms\";s:0:\"\";}}s:16:\" * backendPlugin\";r:116;s:11:\" * features\";N;s:9:\" * logger\";N;s:6:\"submit\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Save\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:13:\"form_build_id\";s:48:\"form-XbIKvokPZF1ghnRc6N0--ypOnvtlobtXSqSmJ2Gq8rc\";s:10:\"form_token\";s:43:\"mAws8SsEXEbyRoRs1cpWVgxqqCi4jeLmrEe2WRuBfWI\";s:7:\"form_id\";s:22:\"search_api_server_form\";}s:11:\" * serverId\";N;s:15:\" * fieldsHelper\";N;s:9:\" * logger\";N;s:16:\" * backendClient\";N;}i:1;s:28:\"buildAjaxConnectorConfigForm\";}s:7:\"wrapper\";s:35:\"elasticsearch-connector-config-form\";s:6:\"method\";s:7:\"replace\";s:6:\"effect\";s:4:\"fade\";}}s:16:\"connector_config\";a:10:{s:3:\"url\";a:5:{s:5:\"#type\";s:3:\"url\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"ElasticSearch URL\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:117:\"The URL of your ElasticSearch server, e.g. <code>http://127.0.0.1</code> or <code>https://www.example.com:443</code>.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";s:9:\"#required\";b:1;}s:20:\"enable_debug_logging\";a:4:{s:5:\"#type\";s:8:\"checkbox\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:56:\"Enable debugging mode: log ElasticSearch network traffic\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:506:\"This will write requests, responses, and response-time information to Drupal's log, which may help you diagnose problems with Drupal's connection to ElasticSearch.<p><strong>Warning</strong>: This setting will result in poor performance and may log a user’s personally identifiable information. This setting is only intended for temporary use and should be disabled when you finish debugging. Logs written while this mode is active will remain in the log until you clear them or the logs are rotated.</p>\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";i:0;}s:8:\"username\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Username\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";s:9:\"#required\";b:1;}s:8:\"password\";a:3:{s:5:\"#type\";s:8:\"password\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Password\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:106:\"If this field is left blank and the HTTP username is filled out, the current password will not be changed.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:41:\"Configure %plugin ElasticSearch connector\";s:12:\" * arguments\";a:1:{s:7:\"%plugin\";s:25:\"HTTP Basic Authentication\";}s:10:\" * options\";a:0:{}}s:12:\"#description\";s:45:\"ElasticSearch connector with HTTP Basic Auth.\";s:5:\"#open\";b:1;s:11:\"#attributes\";a:1:{s:2:\"id\";s:35:\"elasticsearch-connector-config-form\";}s:5:\"#tree\";b:1;}s:8:\"advanced\";a:6:{s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Advanced\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"fuzziness\";a:6:{s:5:\"#type\";s:6:\"select\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:9:\"Fuzziness\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"#required\";b:1;s:8:\"#options\";a:7:{i:0;O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"- Disabled -\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:4:\"auto\";s:4:\"auto\";i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;}s:14:\"#default_value\";s:4:\"auto\";s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:248:\"Some queries and APIs support parameters to allow inexact fuzzy matching, using the fuzziness parameter. See <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/common-options.html#fuzziness\">Fuzziness</a> for more information.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}s:6:\"prefix\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Index prefix\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:101:\"Using an index prefix can be useful for using the same server for different projects or environments.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}s:6:\"suffix\";a:4:{s:5:\"#type\";s:9:\"textfield\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Index suffix\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:101:\"Using an index suffix can be useful for using the same server for different projects or environments.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}s:8:\"synonyms\";a:4:{s:5:\"#type\";s:8:\"textarea\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Synonyms\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"#description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:61:\"Enter synonyms in <a href=\":url\">Solr synonyms.txt format</a>\";s:12:\" * arguments\";a:1:{s:4:\":url\";s:112:\"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis-synonym-tokenfilter.html#_solr_synonyms\";}s:10:\" * options\";a:0:{}}s:14:\"#default_value\";s:0:\"\";}}s:5:\"#type\";s:7:\"details\";s:6:\"#title\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:25:\"Configure %plugin backend\";s:12:\" * arguments\";a:1:{s:7:\"%plugin\";r:77;}s:10:\" * options\";a:0:{}}s:5:\"#open\";b:1;s:11:\"#attributes\";a:1:{s:2:\"id\";s:30:\"search-api-backend-config-form\";}s:5:\"#tree\";b:1;}s:7:\"actions\";a:2:{s:6:\"submit\";a:5:{s:5:\"#type\";s:6:\"submit\";s:6:\"#value\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Save\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:7:\"#submit\";a:2:{i:0;s:12:\"::submitForm\";i:1;s:6:\"::save\";}s:12:\"#button_type\";s:7:\"primary\";s:7:\"#weight\";i:5;}s:5:\"#type\";s:7:\"actions\";}s:8:\"#form_id\";s:22:\"search_api_server_form\";s:9:\"#build_id\";s:48:\"form-Kb_hR2ixFMXb_guPjHv4grSlQl6n5SFnfNq6iRmI9sk\";s:5:\"#type\";s:4:\"form\";s:7:\"#action\";s:55:\"form_action_p_pvdeGsVG5zNF_XLGPTvYSKCf43t8qZYSwcfZl2uzM\";s:13:\"form_build_id\";a:6:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:48:\"form-Kb_hR2ixFMXb_guPjHv4grSlQl6n5SFnfNq6iRmI9sk\";s:3:\"#id\";s:48:\"form-Kb_hR2ixFMXb_guPjHv4grSlQl6n5SFnfNq6iRmI9sk\";s:5:\"#name\";s:13:\"form_build_id\";s:8:\"#parents\";a:1:{i:0;s:13:\"form_build_id\";}s:11:\"#attributes\";a:1:{s:12:\"autocomplete\";s:3:\"off\";}}s:6:\"#cache\";a:1:{s:8:\"contexts\";a:1:{i:0;s:24:\"user.roles:authenticated\";}}s:6:\"#token\";s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";s:10:\"form_token\";a:6:{s:3:\"#id\";s:51:\"edit-search-api-server-form-form-token--Qv8lmL5O1TU\";s:5:\"#type\";s:5:\"token\";s:14:\"#default_value\";s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";s:8:\"#parents\";a:1:{i:0;s:10:\"form_token\";}s:9:\"#attached\";a:1:{s:12:\"placeholders\";a:1:{s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";a:1:{s:13:\"#lazy_builder\";a:2:{i:0;s:39:\"form_builder:renderFormTokenPlaceholder\";i:1;a:1:{i:0;s:66:\"form_token_placeholder_jGb57w1J7MUMf_jpoaA5zVGGEcLAEaHuozuEyrcpCHM\";}}}}}s:6:\"#cache\";a:1:{s:7:\"max-age\";i:0;}}s:7:\"form_id\";a:4:{s:5:\"#type\";s:6:\"hidden\";s:6:\"#value\";s:22:\"search_api_server_form\";s:3:\"#id\";s:40:\"edit-search-api-server-form--2ypQexLXl0M\";s:8:\"#parents\";a:1:{i:0;s:7:\"form_id\";}}s:3:\"#id\";s:35:\"search-api-server-form--m-Iai6NU1jo\";s:7:\"#method\";s:4:\"post\";s:15:\"#theme_wrappers\";a:1:{i:0;s:4:\"form\";}s:16:\"#defaults_loaded\";b:1;s:5:\"#tree\";b:0;s:8:\"#parents\";a:0:{}s:9:\"#validate\";a:1:{i:0;s:14:\"::validateForm\";}s:7:\"#submit\";a:1:{i:0;s:12:\"::submitForm\";}s:6:\"#theme\";a:1:{i:0;s:22:\"search_api_server_form\";}s:12:\"#cache_token\";s:43:\"w-8loJAIj0zwn86cENAl2YZ_OfSLRYqcrb9HEdMfJAw\";}",
  'expire' => '1767734276',
))
->values(array(
  'collection' => 'form_state',
  'name' => 'form-aw4ivtFuRv9IhAUDUfsUkXqKswsdCQBKydJCDO5_9VI',
  'value' => 'a:9:{s:10:"build_info";a:5:{s:4:"args";a:0:{}s:5:"files";a:0:{}s:15:"callback_object";O:33:"Drupal\search_api\Form\ServerForm":9:{s:15:" * requestStack";N;s:16:" * configFactory";N;s:13:" * routeMatch";N;s:14:" * _serviceIds";a:5:{s:9:"messenger";s:9:"messenger";s:17:"stringTranslation";s:18:"string_translation";s:13:"moduleHandler";s:14:"module_handler";s:17:"entityTypeManager";s:19:"entity_type.manager";s:20:"backendPluginManager";s:33:"plugin.manager.search_api.backend";}s:18:" * _entityStorages";a:0:{}s:16:" * loggerFactory";N;s:22:" * redirectDestination";N;s:12:" * operation";s:7:"default";s:9:" * entity";O:31:"Drupal\search_api\Entity\Server":29:{s:15:" * entityTypeId";s:17:"search_api_server";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";N;s:9:" * status";i:1;s:7:" * uuid";s:36:"d4d3cf1a-e2d9-4020-869d-f85be72d25a6";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:0:{}s:14:" * trustedData";b:0;s:15:" * dependencies";a:0:{}s:12:" * isSyncing";b:0;s:5:" * id";s:13:"oval_decision";s:7:" * name";s:13:"Oval decision";s:14:" * description";s:51:"oval_decision, HTTP Basic Authentication connector.";s:10:" * backend";s:13:"elasticsearch";s:17:" * backend_config";a:3:{s:9:"connector";s:16:"elastic_cloud_id";s:16:"connector_config";a:4:{s:3:"url";s:0:"";s:20:"enable_debug_logging";i:0;s:8:"username";s:0:"";s:8:"password";s:0:"";}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:8:"synonyms";s:0:"";}}s:16:" * backendPlugin";O:77:"Drupal\elasticsearch_connector\Plugin\search_api\backend\ElasticSearchBackend":12:{s:11:" * pluginId";s:13:"elasticsearch";s:19:" * pluginDefinition";a:5:{s:2:"id";s:13:"elasticsearch";s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"ElasticSearch";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"Provides an ElasticSearch backend.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:5:"class";s:77:"Drupal\elasticsearch_connector\Plugin\search_api\backend\ElasticSearchBackend";s:8:"provider";s:23:"elasticsearch_connector";}s:16:" * configuration";a:3:{s:9:"connector";s:16:"elastic_cloud_id";s:16:"connector_config";a:4:{s:3:"url";s:0:"";s:20:"enable_debug_logging";i:0;s:8:"username";s:0:"";s:8:"password";s:0:"";}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:8:"synonyms";s:0:"";}}s:14:" * _serviceIds";a:4:{s:17:"stringTranslation";s:18:"string_translation";s:22:"connectorPluginManager";s:48:"plugin.manager.elasticsearch_connector.connector";s:20:"backendClientFactory";s:46:"elasticsearch_connector.backend_client_factory";s:15:"eventDispatcher";s:16:"event_dispatcher";}s:18:" * _entityStorages";a:0:{}s:12:" * messenger";N;s:15:" * dependencies";a:0:{}s:9:" * server";r:19;s:11:" * serverId";N;s:15:" * fieldsHelper";N;s:9:" * logger";N;s:16:" * backendClient";N;}s:11:" * features";N;s:9:" * logger";N;s:6:"submit";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Save";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:13:"form_build_id";s:48:"form-Kb_hR2ixFMXb_guPjHv4grSlQl6n5SFnfNq6iRmI9sk";s:10:"form_token";s:43:"mAws8SsEXEbyRoRs1cpWVgxqqCi4jeLmrEe2WRuBfWI";s:7:"form_id";s:22:"search_api_server_form";}}s:12:"base_form_id";N;s:7:"form_id";s:22:"search_api_server_form";}s:8:"response";N;s:10:"programmed";b:0;s:30:"programmed_bypass_access_check";b:1;s:13:"process_input";b:1;s:16:"has_file_element";N;s:7:"storage";a:5:{s:23:"entity_form_initialized";b:1;s:7:"backend";s:13:"elasticsearch";s:9:"connector";s:16:"elastic_cloud_id";s:27:"machine_name.initial_values";a:1:{s:2:"id";N;}s:17:"previous_password";N;}s:5:"cache";b:1;s:8:"no_cache";N;}',
  'expire' => '1767734282',
))
->values(array(
  'collection' => 'form_state',
  'name' => 'form-bh0AsljSHn16_ZT2T4D9SZxHxEiiCK1gBaAzJIF33Ik',
  'value' => 'a:9:{s:10:"build_info";a:5:{s:4:"args";a:0:{}s:5:"files";a:0:{}s:15:"callback_object";O:33:"Drupal\search_api\Form\ServerForm":9:{s:15:" * requestStack";N;s:16:" * configFactory";N;s:13:" * routeMatch";N;s:14:" * _serviceIds";a:5:{s:9:"messenger";s:9:"messenger";s:17:"stringTranslation";s:18:"string_translation";s:13:"moduleHandler";s:14:"module_handler";s:17:"entityTypeManager";s:19:"entity_type.manager";s:20:"backendPluginManager";s:33:"plugin.manager.search_api.backend";}s:18:" * _entityStorages";a:0:{}s:16:" * loggerFactory";N;s:22:" * redirectDestination";N;s:12:" * operation";s:7:"default";s:9:" * entity";O:31:"Drupal\search_api\Entity\Server":29:{s:15:" * entityTypeId";s:17:"search_api_server";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";N;s:9:" * status";i:1;s:7:" * uuid";s:36:"cb97c534-ca4e-4e4e-9773-e7871c6a2ccf";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:0:{}s:14:" * trustedData";b:0;s:15:" * dependencies";a:0:{}s:12:" * isSyncing";b:0;s:5:" * id";s:16:"octagonal_rhythm";s:7:" * name";s:16:"Octagonal rhythm";s:14:" * description";s:0:"";s:10:" * backend";s:13:"elasticsearch";s:17:" * backend_config";a:3:{s:9:"connector";s:16:"elastic_cloud_id";s:16:"connector_config";a:2:{s:3:"url";s:0:"";s:20:"enable_debug_logging";i:0;}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:8:"synonyms";s:0:"";}}s:16:" * backendPlugin";O:77:"Drupal\elasticsearch_connector\Plugin\search_api\backend\ElasticSearchBackend":12:{s:11:" * pluginId";s:13:"elasticsearch";s:19:" * pluginDefinition";a:5:{s:2:"id";s:13:"elasticsearch";s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"ElasticSearch";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"Provides an ElasticSearch backend.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:5:"class";s:77:"Drupal\elasticsearch_connector\Plugin\search_api\backend\ElasticSearchBackend";s:8:"provider";s:23:"elasticsearch_connector";}s:16:" * configuration";a:3:{s:9:"connector";s:16:"elastic_cloud_id";s:16:"connector_config";a:2:{s:3:"url";s:0:"";s:20:"enable_debug_logging";i:0;}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:8:"synonyms";s:0:"";}}s:14:" * _serviceIds";a:4:{s:17:"stringTranslation";s:18:"string_translation";s:22:"connectorPluginManager";s:48:"plugin.manager.elasticsearch_connector.connector";s:20:"backendClientFactory";s:46:"elasticsearch_connector.backend_client_factory";s:15:"eventDispatcher";s:16:"event_dispatcher";}s:18:" * _entityStorages";a:0:{}s:12:" * messenger";N;s:15:" * dependencies";a:0:{}s:9:" * server";r:19;s:11:" * serverId";N;s:15:" * fieldsHelper";N;s:9:" * logger";N;s:16:" * backendClient";N;}s:11:" * features";N;s:9:" * logger";N;s:6:"submit";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Save";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:13:"form_build_id";s:48:"form-SRtYPNhb2PeW5pZ__9KU_H2HkAlTk6uwsCEutYBKM6U";s:10:"form_token";s:43:"mAws8SsEXEbyRoRs1cpWVgxqqCi4jeLmrEe2WRuBfWI";s:7:"form_id";s:22:"search_api_server_form";}}s:12:"base_form_id";N;s:7:"form_id";s:22:"search_api_server_form";}s:8:"response";N;s:10:"programmed";b:0;s:30:"programmed_bypass_access_check";b:1;s:13:"process_input";b:1;s:16:"has_file_element";N;s:7:"storage";a:4:{s:23:"entity_form_initialized";b:1;s:7:"backend";s:13:"elasticsearch";s:9:"connector";s:16:"elastic_cloud_id";s:27:"machine_name.initial_values";a:1:{s:2:"id";N;}}s:5:"cache";b:1;s:8:"no_cache";N;}',
  'expire' => '1767734394',
))
->values(array(
  'collection' => 'form_state',
  'name' => 'form-BPT1l2BMSY3pFQsQChoqVI7Ye4bSiRBxuF79wbJyCDE',
  'value' => 'a:9:{s:10:"build_info";a:5:{s:4:"args";a:0:{}s:5:"files";a:0:{}s:15:"callback_object";O:32:"Drupal\search_api\Form\IndexForm":10:{s:15:" * requestStack";N;s:16:" * configFactory";N;s:13:" * routeMatch";N;s:14:" * _serviceIds";a:5:{s:9:"messenger";s:9:"messenger";s:17:"stringTranslation";s:18:"string_translation";s:13:"moduleHandler";s:14:"module_handler";s:17:"entityTypeManager";s:19:"entity_type.manager";s:12:"pluginHelper";s:24:"search_api.plugin_helper";}s:18:" * _entityStorages";a:0:{}s:16:" * loggerFactory";N;s:22:" * redirectDestination";N;s:12:" * operation";s:7:"default";s:9:" * entity";O:30:"Drupal\search_api\Entity\Index":38:{s:15:" * entityTypeId";s:16:"search_api_index";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";N;s:9:" * status";i:1;s:7:" * uuid";s:36:"f66681aa-c8a8-4a22-8248-1c1b603c4995";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:0:{}s:14:" * trustedData";b:0;s:15:" * dependencies";a:0:{}s:12:" * isSyncing";b:0;s:5:" * id";s:21:"colorful_organization";s:7:" * name";s:21:"colorful_organization";s:14:" * description";s:29:"colorful_organization index, ";s:12:" * read_only";i:0;s:17:" * field_settings";a:0:{}s:10:" * options";a:3:{s:14:"index_directly";i:1;s:27:"track_changes_in_references";i:1;s:10:"cron_limit";s:2:"50";}s:22:" * datasource_settings";a:0:{}s:19:" * tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:9:" * server";s:0:"";s:21:" * processor_settings";a:5:{s:16:"aggregated_field";a:0:{}s:13:"rendered_item";a:0:{}s:7:"add_url";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}}s:9:" * logger";N;s:11:"datasources";a:4:{s:11:"entity:node";i:0;s:17:"entity:path_alias";i:0;s:22:"entity:search_api_task";i:0;s:11:"entity:user";i:0;}s:27:"datasource_configure_button";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"tracker";s:7:"default";s:14:"tracker_config";a:1:{s:14:"indexing_order";s:4:"fifo";}s:24:"tracker_configure_button";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"actions";a:2:{s:6:"submit";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Save";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"save_edit";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Save and add fields";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:13:"form_build_id";s:48:"form-BPT1l2BMSY3pFQsQChoqVI7Ye4bSiRBxuF79wbJyCDE";s:10:"form_token";s:43:"JDoJsirovwGgpmdWrQg-IcNd_Ga_IhhNj7IxRdp61xA";s:7:"form_id";s:21:"search_api_index_form";s:21:"datasources_configure";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:17:" * originalEntity";O:30:"Drupal\search_api\Entity\Index":28:{s:15:" * entityTypeId";s:16:"search_api_index";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";N;s:9:" * status";b:0;s:7:" * uuid";s:36:"4297f400-12bf-45ef-94c8-b82ecd7aff2a";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:0:{}s:14:" * trustedData";b:0;s:15:" * dependencies";a:0:{}s:12:" * isSyncing";b:0;s:5:" * id";N;s:7:" * name";N;s:14:" * description";N;s:12:" * read_only";b:0;s:17:" * field_settings";a:0:{}s:10:" * options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:22:" * datasource_settings";a:0:{}s:19:" * tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:9:" * server";N;s:21:" * processor_settings";a:5:{s:16:"aggregated_field";a:0:{}s:13:"rendered_item";a:0:{}s:7:"add_url";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}}s:9:" * logger";N;}}s:12:"base_form_id";N;s:7:"form_id";s:21:"search_api_index_form";}s:8:"response";N;s:10:"programmed";b:0;s:30:"programmed_bypass_access_check";b:1;s:13:"process_input";b:1;s:16:"has_file_element";N;s:7:"storage";a:4:{s:23:"entity_form_initialized";b:1;s:11:"datasources";a:1:{i:0;s:22:"entity:search_api_task";}s:7:"tracker";s:7:"default";s:27:"machine_name.initial_values";a:1:{s:2:"id";N;}}s:5:"cache";b:1;s:8:"no_cache";N;}',
  'expire' => '1767734555',
))
->values(array(
  'collection' => 'form_state',
  'name' => 'form-GA0NYOvXA3Ve-szIncitnXcPp1aujQafPbwsKCv8_tI',
  'value' => 'a:9:{s:10:"build_info";a:5:{s:4:"args";a:0:{}s:5:"files";a:0:{}s:15:"callback_object";O:32:"Drupal\search_api\Form\IndexForm":10:{s:15:" * requestStack";N;s:16:" * configFactory";N;s:13:" * routeMatch";N;s:14:" * _serviceIds";a:5:{s:9:"messenger";s:9:"messenger";s:17:"stringTranslation";s:18:"string_translation";s:13:"moduleHandler";s:14:"module_handler";s:17:"entityTypeManager";s:19:"entity_type.manager";s:12:"pluginHelper";s:24:"search_api.plugin_helper";}s:18:" * _entityStorages";a:0:{}s:16:" * loggerFactory";N;s:22:" * redirectDestination";N;s:12:" * operation";s:7:"default";s:9:" * entity";O:30:"Drupal\search_api\Entity\Index":39:{s:15:" * entityTypeId";s:16:"search_api_index";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";N;s:9:" * status";i:1;s:7:" * uuid";s:36:"44923017-13a1-4eb1-ad6e-87159de6526a";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:0:{}s:14:" * trustedData";b:0;s:15:" * dependencies";a:0:{}s:12:" * isSyncing";b:0;s:5:" * id";s:17:"robust_discussion";s:7:" * name";s:17:"Robust discussion";s:14:" * description";s:42:"robust_discussion index, node datasource, ";s:12:" * read_only";i:0;s:17:" * field_settings";a:0:{}s:10:" * options";a:3:{s:14:"index_directly";i:1;s:27:"track_changes_in_references";i:1;s:10:"cron_limit";s:2:"50";}s:22:" * datasource_settings";a:0:{}s:19:" * tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:9:" * server";s:16:"octagonal_rhythm";s:21:" * processor_settings";a:5:{s:16:"aggregated_field";a:0:{}s:13:"rendered_item";a:0:{}s:7:"add_url";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}}s:9:" * logger";N;s:11:"datasources";a:4:{s:11:"entity:node";i:0;s:17:"entity:path_alias";i:0;s:22:"entity:search_api_task";i:0;s:11:"entity:user";i:0;}s:27:"datasource_configure_button";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"tracker";s:7:"default";s:14:"tracker_config";a:1:{s:14:"indexing_order";s:4:"fifo";}s:24:"tracker_configure_button";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"actions";a:2:{s:6:"submit";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Save";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"save_edit";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Save and add fields";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}s:13:"form_build_id";s:48:"form-GA0NYOvXA3Ve-szIncitnXcPp1aujQafPbwsKCv8_tI";s:10:"form_token";s:43:"JDoJsirovwGgpmdWrQg-IcNd_Ga_IhhNj7IxRdp61xA";s:7:"form_id";s:21:"search_api_index_form";s:21:"datasources_configure";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Configure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:18:"datasource_configs";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";s:1:"1";s:8:"selected";a:1:{s:4:"page";i:0;}}s:9:"languages";a:2:{s:7:"default";s:1:"1";s:8:"selected";a:1:{s:2:"en";i:0;}}}}}s:17:" * originalEntity";O:30:"Drupal\search_api\Entity\Index":28:{s:15:" * entityTypeId";s:16:"search_api_index";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";N;s:9:" * status";b:0;s:7:" * uuid";s:36:"c7238edb-004d-4e6f-9d83-4a487c764f7f";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:0:{}s:14:" * trustedData";b:0;s:15:" * dependencies";a:0:{}s:12:" * isSyncing";b:0;s:5:" * id";N;s:7:" * name";N;s:14:" * description";N;s:12:" * read_only";b:0;s:17:" * field_settings";a:0:{}s:10:" * options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:22:" * datasource_settings";a:0:{}s:19:" * tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:9:" * server";N;s:21:" * processor_settings";a:5:{s:16:"aggregated_field";a:0:{}s:13:"rendered_item";a:0:{}s:7:"add_url";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}}s:9:" * logger";N;}}s:12:"base_form_id";N;s:7:"form_id";s:21:"search_api_index_form";}s:8:"response";N;s:10:"programmed";b:0;s:30:"programmed_bypass_access_check";b:1;s:13:"process_input";b:1;s:16:"has_file_element";N;s:7:"storage";a:4:{s:23:"entity_form_initialized";b:1;s:11:"datasources";a:1:{i:0;s:11:"entity:node";}s:7:"tracker";s:7:"default";s:27:"machine_name.initial_values";a:1:{s:2:"id";N;}}s:5:"cache";b:1;s:8:"no_cache";N;}',
  'expire' => '1767735518',
))
->values(array(
  'collection' => 'form_state',
  'name' => 'form-Kb_hR2ixFMXb_guPjHv4grSlQl6n5SFnfNq6iRmI9sk',
  'value' => 'a:9:{s:10:"build_info";a:5:{s:4:"args";a:0:{}s:5:"files";a:0:{}s:15:"callback_object";O:33:"Drupal\search_api\Form\ServerForm":9:{s:15:" * requestStack";N;s:16:" * configFactory";N;s:13:" * routeMatch";N;s:14:" * _serviceIds";a:5:{s:9:"messenger";s:9:"messenger";s:17:"stringTranslation";s:18:"string_translation";s:13:"moduleHandler";s:14:"module_handler";s:17:"entityTypeManager";s:19:"entity_type.manager";s:20:"backendPluginManager";s:33:"plugin.manager.search_api.backend";}s:18:" * _entityStorages";a:0:{}s:16:" * loggerFactory";N;s:22:" * redirectDestination";N;s:12:" * operation";s:7:"default";s:9:" * entity";O:31:"Drupal\search_api\Entity\Server":29:{s:15:" * entityTypeId";s:17:"search_api_server";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";N;s:9:" * status";i:1;s:7:" * uuid";s:36:"d4d3cf1a-e2d9-4020-869d-f85be72d25a6";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:0:{}s:14:" * trustedData";b:0;s:15:" * dependencies";a:0:{}s:12:" * isSyncing";b:0;s:5:" * id";s:13:"oval_decision";s:7:" * name";s:13:"Oval decision";s:14:" * description";s:51:"oval_decision, HTTP Basic Authentication connector.";s:10:" * backend";s:13:"elasticsearch";s:17:" * backend_config";a:3:{s:9:"connector";s:9:"basicauth";s:16:"connector_config";a:2:{s:3:"url";s:0:"";s:20:"enable_debug_logging";i:0;}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:8:"synonyms";s:0:"";}}s:16:" * backendPlugin";O:77:"Drupal\elasticsearch_connector\Plugin\search_api\backend\ElasticSearchBackend":12:{s:11:" * pluginId";s:13:"elasticsearch";s:19:" * pluginDefinition";a:5:{s:2:"id";s:13:"elasticsearch";s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"ElasticSearch";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"Provides an ElasticSearch backend.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:5:"class";s:77:"Drupal\elasticsearch_connector\Plugin\search_api\backend\ElasticSearchBackend";s:8:"provider";s:23:"elasticsearch_connector";}s:16:" * configuration";a:3:{s:9:"connector";s:9:"basicauth";s:16:"connector_config";a:2:{s:3:"url";s:0:"";s:20:"enable_debug_logging";i:0;}s:8:"advanced";a:4:{s:9:"fuzziness";s:4:"auto";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:8:"synonyms";s:0:"";}}s:14:" * _serviceIds";a:4:{s:17:"stringTranslation";s:18:"string_translation";s:22:"connectorPluginManager";s:48:"plugin.manager.elasticsearch_connector.connector";s:20:"backendClientFactory";s:46:"elasticsearch_connector.backend_client_factory";s:15:"eventDispatcher";s:16:"event_dispatcher";}s:18:" * _entityStorages";a:0:{}s:12:" * messenger";N;s:15:" * dependencies";a:0:{}s:9:" * server";r:19;s:11:" * serverId";N;s:15:" * fieldsHelper";N;s:9:" * logger";N;s:16:" * backendClient";N;}s:11:" * features";N;s:9:" * logger";N;s:6:"submit";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Save";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:13:"form_build_id";s:48:"form-XbIKvokPZF1ghnRc6N0--ypOnvtlobtXSqSmJ2Gq8rc";s:10:"form_token";s:43:"mAws8SsEXEbyRoRs1cpWVgxqqCi4jeLmrEe2WRuBfWI";s:7:"form_id";s:22:"search_api_server_form";}}s:12:"base_form_id";N;s:7:"form_id";s:22:"search_api_server_form";}s:8:"response";N;s:10:"programmed";b:0;s:30:"programmed_bypass_access_check";b:1;s:13:"process_input";b:1;s:16:"has_file_element";N;s:7:"storage";a:5:{s:23:"entity_form_initialized";b:1;s:7:"backend";s:13:"elasticsearch";s:9:"connector";s:9:"basicauth";s:27:"machine_name.initial_values";a:1:{s:2:"id";N;}s:17:"previous_password";N;}s:5:"cache";b:1;s:8:"no_cache";N;}',
  'expire' => '1767734276',
))
->values(array(
  'collection' => 'system',
  'name' => 'advisories_response',
  'value' => 'a:0:{}',
  'expire' => '1767733385',
))
->values(array(
  'collection' => 'update',
  'name' => 'fetch_failures',
  'value' => 'N;',
  'expire' => '1767715284',
))
->values(array(
  'collection' => 'update',
  'name' => 'update_project_data',
  'value' => "a:2:{s:6:\"drupal\";a:16:{s:4:\"name\";s:6:\"drupal\";s:4:\"info\";a:6:{s:4:\"name\";s:5:\"Block\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:7:\"10.2.12\";s:7:\"project\";s:6:\"drupal\";s:16:\"_info_file_ctime\";i:1767711525;s:9:\"datestamp\";i:0;}s:9:\"datestamp\";i:0;s:8:\"includes\";a:15:{s:5:\"block\";s:5:\"Block\";s:5:\"dblog\";s:16:\"Database Logging\";s:18:\"dynamic_page_cache\";s:27:\"Internal Dynamic Page Cache\";s:5:\"field\";s:5:\"Field\";s:6:\"filter\";s:6:\"Filter\";s:5:\"mysql\";s:5:\"MySQL\";s:4:\"node\";s:4:\"Node\";s:10:\"page_cache\";s:19:\"Internal Page Cache\";s:10:\"path_alias\";s:10:\"Path alias\";s:6:\"system\";s:6:\"System\";s:4:\"text\";s:4:\"Text\";s:6:\"update\";s:14:\"Update Manager\";s:4:\"user\";s:4:\"User\";s:5:\"views\";s:5:\"Views\";s:8:\"views_ui\";s:8:\"Views UI\";}s:12:\"project_type\";s:4:\"core\";s:14:\"project_status\";b:1;s:16:\"existing_version\";s:7:\"10.2.12\";s:14:\"existing_major\";s:2:\"10\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:11:\"Drupal core\";s:4:\"link\";s:37:\"https://www.drupal.org/project/drupal\";s:6:\"status\";i:1;s:14:\"latest_version\";s:6:\"11.3.1\";s:8:\"releases\";a:1:{s:6:\"11.3.1\";a:10:{s:4:\"name\";s:13:\"drupal 11.3.1\";s:7:\"version\";s:6:\"11.3.1\";s:3:\"tag\";s:6:\"11.3.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.3.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.3.1.tar.gz\";s:4:\"date\";s:10:\"1766069226\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}}s:11:\"recommended\";s:6:\"11.3.1\";s:16:\"security updates\";a:2:{i:0;a:10:{s:4:\"name\";s:13:\"drupal 11.2.8\";s:7:\"version\";s:6:\"11.2.8\";s:3:\"tag\";s:6:\"11.2.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.8.tar.gz\";s:4:\"date\";s:10:\"1762990140\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}i:1;a:10:{s:4:\"name\";s:13:\"drupal 10.5.6\";s:7:\"version\";s:6:\"10.5.6\";s:3:\"tag\";s:6:\"10.5.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.6.tar.gz\";s:4:\"date\";s:10:\"1762990833\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}}}s:10:\"search_api\";a:16:{s:4:\"name\";s:10:\"search_api\";s:4:\"info\";a:6:{s:4:\"name\";s:10:\"Search API\";s:7:\"package\";s:6:\"Search\";s:7:\"version\";s:8:\"8.x-1.24\";s:7:\"project\";s:10:\"search_api\";s:9:\"datestamp\";i:1657180588;s:16:\"_info_file_ctime\";i:1767711524;}s:9:\"datestamp\";i:1657180588;s:8:\"includes\";a:1:{s:10:\"search_api\";s:10:\"Search API\";}s:12:\"project_type\";s:6:\"module\";s:14:\"project_status\";b:1;s:16:\"existing_version\";s:8:\"8.x-1.24\";s:14:\"existing_major\";s:1:\"1\";s:12:\"install_type\";s:8:\"official\";s:5:\"title\";s:10:\"Search API\";s:4:\"link\";s:41:\"https://www.drupal.org/project/search_api\";s:14:\"latest_version\";s:8:\"8.x-1.40\";s:8:\"releases\";a:1:{s:8:\"8.x-1.40\";a:13:{s:4:\"name\";s:19:\"search_api 8.x-1.40\";s:7:\"version\";s:8:\"8.x-1.40\";s:3:\"tag\";s:8:\"8.x-1.40\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.40\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.40.tar.gz\";s:4:\"date\";s:10:\"1762030914\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.3 || ^11\";s:15:\"core_compatible\";b:0;s:26:\"core_compatibility_message\";s:38:\"Requires Drupal core: 10.3.0 to 11.3.1\";}}s:11:\"recommended\";s:8:\"8.x-1.40\";s:16:\"security updates\";a:1:{i:0;a:13:{s:4:\"name\";s:19:\"search_api 8.x-1.27\";s:7:\"version\";s:8:\"8.x-1.27\";s:3:\"tag\";s:8:\"8.x-1.27\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.27\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.27.tar.gz\";s:4:\"date\";s:10:\"1666181440\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.3 || ^10.0\";s:15:\"core_compatible\";b:1;s:26:\"core_compatibility_message\";s:39:\"Requires Drupal core: 10.2.12 to 10.6.1\";}}s:6:\"status\";i:1;}}",
  'expire' => '1767718584',
))
->values(array(
  'collection' => 'update',
  'name' => 'update_project_projects',
  'value' => 'a:2:{s:6:"drupal";a:6:{s:4:"name";s:6:"drupal";s:4:"info";a:6:{s:4:"name";s:5:"Block";s:7:"package";s:4:"Core";s:7:"version";s:7:"10.2.12";s:7:"project";s:6:"drupal";s:16:"_info_file_ctime";i:1767711525;s:9:"datestamp";i:0;}s:9:"datestamp";i:0;s:8:"includes";a:15:{s:5:"block";s:5:"Block";s:5:"dblog";s:16:"Database Logging";s:18:"dynamic_page_cache";s:27:"Internal Dynamic Page Cache";s:5:"field";s:5:"Field";s:6:"filter";s:6:"Filter";s:5:"mysql";s:5:"MySQL";s:4:"node";s:4:"Node";s:10:"page_cache";s:19:"Internal Page Cache";s:10:"path_alias";s:10:"Path alias";s:6:"system";s:6:"System";s:4:"text";s:4:"Text";s:6:"update";s:14:"Update Manager";s:4:"user";s:4:"User";s:5:"views";s:5:"Views";s:8:"views_ui";s:8:"Views UI";}s:12:"project_type";s:4:"core";s:14:"project_status";b:1;}s:10:"search_api";a:6:{s:4:"name";s:10:"search_api";s:4:"info";a:6:{s:4:"name";s:10:"Search API";s:7:"package";s:6:"Search";s:7:"version";s:8:"8.x-1.24";s:7:"project";s:10:"search_api";s:9:"datestamp";i:1657180588;s:16:"_info_file_ctime";i:1767711524;}s:9:"datestamp";i:1657180588;s:8:"includes";a:1:{s:10:"search_api";s:10:"Search API";}s:12:"project_type";s:6:"module";s:14:"project_status";b:1;}}',
  'expire' => '1767718584',
))
->values(array(
  'collection' => 'update_available_releases',
  'name' => 'drupal',
  'value' => "a:10:{s:5:\"title\";s:11:\"Drupal core\";s:10:\"short_name\";s:6:\"drupal\";s:4:\"type\";s:12:\"project_core\";s:18:\"supported_branches\";s:23:\"10.5.,10.6.,11.2.,11.3.\";s:18:\"composer_namespace\";s:11:\"drupal/core\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:37:\"https://www.drupal.org/project/drupal\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:504:{s:6:\"11.3.1\";a:10:{s:4:\"name\";s:13:\"drupal 11.3.1\";s:7:\"version\";s:6:\"11.3.1\";s:3:\"tag\";s:6:\"11.3.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.3.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.3.1.tar.gz\";s:4:\"date\";s:10:\"1766069226\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.3.0\";a:10:{s:4:\"name\";s:13:\"drupal 11.3.0\";s:7:\"version\";s:6:\"11.3.0\";s:3:\"tag\";s:6:\"11.3.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.3.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.3.0.tar.gz\";s:4:\"date\";s:10:\"1765971890\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"11.3.0-rc2\";a:10:{s:4:\"name\";s:17:\"drupal 11.3.0-rc2\";s:7:\"version\";s:10:\"11.3.0-rc2\";s:3:\"tag\";s:10:\"11.3.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.3.0-rc2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.3.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1765804707\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:10:\"11.3.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 11.3.0-rc1\";s:7:\"version\";s:10:\"11.3.0-rc1\";s:3:\"tag\";s:10:\"11.3.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.3.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1764843586\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"11.3.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 11.3.0-beta1\";s:7:\"version\";s:12:\"11.3.0-beta1\";s:3:\"tag\";s:12:\"11.3.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/11.3.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-11.3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1764071187\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"11.3.0-alpha1\";a:10:{s:4:\"name\";s:20:\"drupal 11.3.0-alpha1\";s:7:\"version\";s:13:\"11.3.0-alpha1\";s:3:\"tag\";s:13:\"11.3.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/11.3.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-11.3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1762423955\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"11.2.10\";a:10:{s:4:\"name\";s:14:\"drupal 11.2.10\";s:7:\"version\";s:7:\"11.2.10\";s:3:\"tag\";s:7:\"11.2.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/11.2.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-11.2.10.tar.gz\";s:4:\"date\";s:10:\"1765361834\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.9\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.9\";s:7:\"version\";s:6:\"11.2.9\";s:3:\"tag\";s:6:\"11.2.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.9.tar.gz\";s:4:\"date\";s:10:\"1764840100\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.8\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.8\";s:7:\"version\";s:6:\"11.2.8\";s:3:\"tag\";s:6:\"11.2.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.8.tar.gz\";s:4:\"date\";s:10:\"1762990140\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.7\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.7\";s:7:\"version\";s:6:\"11.2.7\";s:3:\"tag\";s:6:\"11.2.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.7.tar.gz\";s:4:\"date\";s:10:\"1762453153\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.6\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.6\";s:7:\"version\";s:6:\"11.2.6\";s:3:\"tag\";s:6:\"11.2.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.6.tar.gz\";s:4:\"date\";s:10:\"1762402744\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.5\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.5\";s:7:\"version\";s:6:\"11.2.5\";s:3:\"tag\";s:6:\"11.2.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.5.tar.gz\";s:4:\"date\";s:10:\"1759390965\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.4\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.4\";s:7:\"version\";s:6:\"11.2.4\";s:3:\"tag\";s:6:\"11.2.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.4.tar.gz\";s:4:\"date\";s:10:\"1756977008\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.3\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.3\";s:7:\"version\";s:6:\"11.2.3\";s:3:\"tag\";s:6:\"11.2.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.3.tar.gz\";s:4:\"date\";s:10:\"1754563343\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.2\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.2\";s:7:\"version\";s:6:\"11.2.2\";s:3:\"tag\";s:6:\"11.2.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.2.tar.gz\";s:4:\"date\";s:10:\"1750948270\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.1\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.1\";s:7:\"version\";s:6:\"11.2.1\";s:3:\"tag\";s:6:\"11.2.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.1.tar.gz\";s:4:\"date\";s:10:\"1750849338\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.2.0\";a:10:{s:4:\"name\";s:13:\"drupal 11.2.0\";s:7:\"version\";s:6:\"11.2.0\";s:3:\"tag\";s:6:\"11.2.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.2.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.2.0.tar.gz\";s:4:\"date\";s:10:\"1750707923\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"11.2.0-rc2\";a:10:{s:4:\"name\";s:17:\"drupal 11.2.0-rc2\";s:7:\"version\";s:10:\"11.2.0-rc2\";s:3:\"tag\";s:10:\"11.2.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.2.0-rc2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1750706924\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:10:\"11.2.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 11.2.0-rc1\";s:7:\"version\";s:10:\"11.2.0-rc1\";s:3:\"tag\";s:10:\"11.2.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.2.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1750707307\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"11.2.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 11.2.0-beta1\";s:7:\"version\";s:12:\"11.2.0-beta1\";s:3:\"tag\";s:12:\"11.2.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/11.2.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-11.2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1750706273\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"11.2.0-alpha1\";a:10:{s:4:\"name\";s:20:\"drupal 11.2.0-alpha1\";s:7:\"version\";s:13:\"11.2.0-alpha1\";s:3:\"tag\";s:13:\"11.2.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/11.2.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-11.2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1750705843\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"11.1.9\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.9\";s:7:\"version\";s:6:\"11.1.9\";s:3:\"tag\";s:6:\"11.1.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.9.tar.gz\";s:4:\"date\";s:10:\"1762992079\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.8\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.8\";s:7:\"version\";s:6:\"11.1.8\";s:3:\"tag\";s:6:\"11.1.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.8.tar.gz\";s:4:\"date\";s:10:\"1749167497\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.7\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.7\";s:7:\"version\";s:6:\"11.1.7\";s:3:\"tag\";s:6:\"11.1.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.7.tar.gz\";s:4:\"date\";s:10:\"1746678183\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.6\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.6\";s:7:\"version\";s:6:\"11.1.6\";s:3:\"tag\";s:6:\"11.1.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.6.tar.gz\";s:4:\"date\";s:10:\"1743628262\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.5\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.5\";s:7:\"version\";s:6:\"11.1.5\";s:3:\"tag\";s:6:\"11.1.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.5.tar.gz\";s:4:\"date\";s:10:\"1742407823\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.4\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.4\";s:7:\"version\";s:6:\"11.1.4\";s:3:\"tag\";s:6:\"11.1.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.4.tar.gz\";s:4:\"date\";s:10:\"1741210524\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.3\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.3\";s:7:\"version\";s:6:\"11.1.3\";s:3:\"tag\";s:6:\"11.1.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.3.tar.gz\";s:4:\"date\";s:10:\"1739986133\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.2\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.2\";s:7:\"version\";s:6:\"11.1.2\";s:3:\"tag\";s:6:\"11.1.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.2.tar.gz\";s:4:\"date\";s:10:\"1738796542\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.1\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.1\";s:7:\"version\";s:6:\"11.1.1\";s:3:\"tag\";s:6:\"11.1.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.1.tar.gz\";s:4:\"date\";s:10:\"1736204811\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.1.0\";a:10:{s:4:\"name\";s:13:\"drupal 11.1.0\";s:7:\"version\";s:6:\"11.1.0\";s:3:\"tag\";s:6:\"11.1.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.1.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.1.0.tar.gz\";s:4:\"date\";s:10:\"1734369672\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"11.1.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 11.1.0-rc1\";s:7:\"version\";s:10:\"11.1.0-rc1\";s:3:\"tag\";s:10:\"11.1.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.1.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1733153182\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"11.1.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 11.1.0-beta1\";s:7:\"version\";s:12:\"11.1.0-beta1\";s:3:\"tag\";s:12:\"11.1.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/11.1.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-11.1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1731695942\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"11.0.13\";a:10:{s:4:\"name\";s:14:\"drupal 11.0.13\";s:7:\"version\";s:7:\"11.0.13\";s:3:\"tag\";s:7:\"11.0.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/11.0.13\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-11.0.13.tar.gz\";s:4:\"date\";s:10:\"1742408477\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"11.0.12\";a:10:{s:4:\"name\";s:14:\"drupal 11.0.12\";s:7:\"version\";s:7:\"11.0.12\";s:3:\"tag\";s:7:\"11.0.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/11.0.12\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-11.0.12.tar.gz\";s:4:\"date\";s:10:\"1739988102\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"11.0.11\";a:10:{s:4:\"name\";s:14:\"drupal 11.0.11\";s:7:\"version\";s:7:\"11.0.11\";s:3:\"tag\";s:7:\"11.0.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/11.0.11\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-11.0.11.tar.gz\";s:4:\"date\";s:10:\"1738797159\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"11.0.10\";a:10:{s:4:\"name\";s:14:\"drupal 11.0.10\";s:7:\"version\";s:7:\"11.0.10\";s:3:\"tag\";s:7:\"11.0.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/11.0.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-11.0.10.tar.gz\";s:4:\"date\";s:10:\"1736206526\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.9\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.9\";s:7:\"version\";s:6:\"11.0.9\";s:3:\"tag\";s:6:\"11.0.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.9.tar.gz\";s:4:\"date\";s:10:\"1732283629\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.8\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.8\";s:7:\"version\";s:6:\"11.0.8\";s:3:\"tag\";s:6:\"11.0.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.8.tar.gz\";s:4:\"date\";s:10:\"1732132096\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.7\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.7\";s:7:\"version\";s:6:\"11.0.7\";s:3:\"tag\";s:6:\"11.0.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.7.tar.gz\";s:4:\"date\";s:10:\"1731407794\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.6\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.6\";s:7:\"version\";s:6:\"11.0.6\";s:3:\"tag\";s:6:\"11.0.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.6.tar.gz\";s:4:\"date\";s:10:\"1730969764\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.5\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.5\";s:7:\"version\";s:6:\"11.0.5\";s:3:\"tag\";s:6:\"11.0.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.5.tar.gz\";s:4:\"date\";s:10:\"1727946737\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.4\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.4\";s:7:\"version\";s:6:\"11.0.4\";s:3:\"tag\";s:6:\"11.0.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.4.tar.gz\";s:4:\"date\";s:10:\"1726136390\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.3\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.3\";s:7:\"version\";s:6:\"11.0.3\";s:3:\"tag\";s:6:\"11.0.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.3.tar.gz\";s:4:\"date\";s:10:\"1726074557\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.2\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.2\";s:7:\"version\";s:6:\"11.0.2\";s:3:\"tag\";s:6:\"11.0.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.2.tar.gz\";s:4:\"date\";s:10:\"1725526703\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.1\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.1\";s:7:\"version\";s:6:\"11.0.1\";s:3:\"tag\";s:6:\"11.0.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.1.tar.gz\";s:4:\"date\";s:10:\"1723108396\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"11.0.0\";a:10:{s:4:\"name\";s:13:\"drupal 11.0.0\";s:7:\"version\";s:6:\"11.0.0\";s:3:\"tag\";s:6:\"11.0.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/11.0.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-11.0.0.tar.gz\";s:4:\"date\";s:10:\"1722578454\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"11.0.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 11.0.0-rc1\";s:7:\"version\";s:10:\"11.0.0-rc1\";s:3:\"tag\";s:10:\"11.0.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.0.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.0.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1720736512\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"11.0.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 11.0.0-beta1\";s:7:\"version\";s:12:\"11.0.0-beta1\";s:3:\"tag\";s:12:\"11.0.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/11.0.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-11.0.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1715953266\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"11.0.0-alpha1\";a:10:{s:4:\"name\";s:20:\"drupal 11.0.0-alpha1\";s:7:\"version\";s:13:\"11.0.0-alpha1\";s:3:\"tag\";s:13:\"11.0.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/11.0.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-11.0.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1714797816\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"10.6.1\";a:10:{s:4:\"name\";s:13:\"drupal 10.6.1\";s:7:\"version\";s:6:\"10.6.1\";s:3:\"tag\";s:6:\"10.6.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.6.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.6.1.tar.gz\";s:4:\"date\";s:10:\"1766067020\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.6.0\";a:10:{s:4:\"name\";s:13:\"drupal 10.6.0\";s:7:\"version\";s:6:\"10.6.0\";s:3:\"tag\";s:6:\"10.6.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.6.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.6.0.tar.gz\";s:4:\"date\";s:10:\"1765965714\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"10.6.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 10.6.0-rc1\";s:7:\"version\";s:10:\"10.6.0-rc1\";s:3:\"tag\";s:10:\"10.6.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.6.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.6.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1764842812\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"10.6.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 10.6.0-beta1\";s:7:\"version\";s:12:\"10.6.0-beta1\";s:3:\"tag\";s:12:\"10.6.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.6.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.6.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1764083058\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:6:\"10.5.8\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.8\";s:7:\"version\";s:6:\"10.5.8\";s:3:\"tag\";s:6:\"10.5.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.8.tar.gz\";s:4:\"date\";s:10:\"1765309285\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.7\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.7\";s:7:\"version\";s:6:\"10.5.7\";s:3:\"tag\";s:6:\"10.5.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.7.tar.gz\";s:4:\"date\";s:10:\"1764837891\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.6\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.6\";s:7:\"version\";s:6:\"10.5.6\";s:3:\"tag\";s:6:\"10.5.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.6.tar.gz\";s:4:\"date\";s:10:\"1762990833\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.5\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.5\";s:7:\"version\";s:6:\"10.5.5\";s:3:\"tag\";s:6:\"10.5.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.5.tar.gz\";s:4:\"date\";s:10:\"1762403351\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.4\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.4\";s:7:\"version\";s:6:\"10.5.4\";s:3:\"tag\";s:6:\"10.5.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.4.tar.gz\";s:4:\"date\";s:10:\"1759391576\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.3\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.3\";s:7:\"version\";s:6:\"10.5.3\";s:3:\"tag\";s:6:\"10.5.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.3.tar.gz\";s:4:\"date\";s:10:\"1756978175\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.2\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.2\";s:7:\"version\";s:6:\"10.5.2\";s:3:\"tag\";s:6:\"10.5.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.2.tar.gz\";s:4:\"date\";s:10:\"1754564029\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.1\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.1\";s:7:\"version\";s:6:\"10.5.1\";s:3:\"tag\";s:6:\"10.5.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.1.tar.gz\";s:4:\"date\";s:10:\"1750947651\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.5.0\";a:10:{s:4:\"name\";s:13:\"drupal 10.5.0\";s:7:\"version\";s:6:\"10.5.0\";s:3:\"tag\";s:6:\"10.5.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.5.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.5.0.tar.gz\";s:4:\"date\";s:10:\"1750294139\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"10.5.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 10.5.0-rc1\";s:7:\"version\";s:10:\"10.5.0-rc1\";s:3:\"tag\";s:10:\"10.5.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.5.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.5.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1749746527\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"10.5.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 10.5.0-beta1\";s:7:\"version\";s:12:\"10.5.0-beta1\";s:3:\"tag\";s:12:\"10.5.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.5.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.5.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1748162570\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:6:\"10.4.9\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.9\";s:7:\"version\";s:6:\"10.4.9\";s:3:\"tag\";s:6:\"10.4.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.9.tar.gz\";s:4:\"date\";s:10:\"1762991487\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.8\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.8\";s:7:\"version\";s:6:\"10.4.8\";s:3:\"tag\";s:6:\"10.4.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.8.tar.gz\";s:4:\"date\";s:10:\"1749168268\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.7\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.7\";s:7:\"version\";s:6:\"10.4.7\";s:3:\"tag\";s:6:\"10.4.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.7.tar.gz\";s:4:\"date\";s:10:\"1746678757\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.6\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.6\";s:7:\"version\";s:6:\"10.4.6\";s:3:\"tag\";s:6:\"10.4.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.6.tar.gz\";s:4:\"date\";s:10:\"1743628915\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.5\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.5\";s:7:\"version\";s:6:\"10.4.5\";s:3:\"tag\";s:6:\"10.4.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.5.tar.gz\";s:4:\"date\";s:10:\"1742409107\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.4\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.4\";s:7:\"version\";s:6:\"10.4.4\";s:3:\"tag\";s:6:\"10.4.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.4.tar.gz\";s:4:\"date\";s:10:\"1741211791\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.3\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.3\";s:7:\"version\";s:6:\"10.4.3\";s:3:\"tag\";s:6:\"10.4.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.3.tar.gz\";s:4:\"date\";s:10:\"1739987505\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.2\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.2\";s:7:\"version\";s:6:\"10.4.2\";s:3:\"tag\";s:6:\"10.4.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.2.tar.gz\";s:4:\"date\";s:10:\"1738798328\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.1\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.1\";s:7:\"version\";s:6:\"10.4.1\";s:3:\"tag\";s:6:\"10.4.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.1.tar.gz\";s:4:\"date\";s:10:\"1736207882\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.4.0\";a:10:{s:4:\"name\";s:13:\"drupal 10.4.0\";s:7:\"version\";s:6:\"10.4.0\";s:3:\"tag\";s:6:\"10.4.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.4.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.4.0.tar.gz\";s:4:\"date\";s:10:\"1734475162\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"10.4.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 10.4.0-rc1\";s:7:\"version\";s:10:\"10.4.0-rc1\";s:3:\"tag\";s:10:\"10.4.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.4.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.4.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1733155673\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"10.4.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 10.4.0-beta1\";s:7:\"version\";s:12:\"10.4.0-beta1\";s:3:\"tag\";s:12:\"10.4.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.4.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.4.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1731947109\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"10.3.14\";a:10:{s:4:\"name\";s:14:\"drupal 10.3.14\";s:7:\"version\";s:7:\"10.3.14\";s:3:\"tag\";s:7:\"10.3.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.3.14\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.3.14.tar.gz\";s:4:\"date\";s:10:\"1742410042\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"10.3.13\";a:10:{s:4:\"name\";s:14:\"drupal 10.3.13\";s:7:\"version\";s:7:\"10.3.13\";s:3:\"tag\";s:7:\"10.3.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.3.13\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.3.13.tar.gz\";s:4:\"date\";s:10:\"1739986815\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"10.3.12\";a:10:{s:4:\"name\";s:14:\"drupal 10.3.12\";s:7:\"version\";s:7:\"10.3.12\";s:3:\"tag\";s:7:\"10.3.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.3.12\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.3.12.tar.gz\";s:4:\"date\";s:10:\"1738798951\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"10.3.11\";a:10:{s:4:\"name\";s:14:\"drupal 10.3.11\";s:7:\"version\";s:7:\"10.3.11\";s:3:\"tag\";s:7:\"10.3.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.3.11\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.3.11.tar.gz\";s:4:\"date\";s:10:\"1736208549\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"10.3.10\";a:10:{s:4:\"name\";s:14:\"drupal 10.3.10\";s:7:\"version\";s:7:\"10.3.10\";s:3:\"tag\";s:7:\"10.3.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.3.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.3.10.tar.gz\";s:4:\"date\";s:10:\"1732284381\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.9\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.9\";s:7:\"version\";s:6:\"10.3.9\";s:3:\"tag\";s:6:\"10.3.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.9.tar.gz\";s:4:\"date\";s:10:\"1732132747\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.8\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.8\";s:7:\"version\";s:6:\"10.3.8\";s:3:\"tag\";s:6:\"10.3.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.8.tar.gz\";s:4:\"date\";s:10:\"1731407050\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.7\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.7\";s:7:\"version\";s:6:\"10.3.7\";s:3:\"tag\";s:6:\"10.3.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.7.tar.gz\";s:4:\"date\";s:10:\"1730969060\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.6\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.6\";s:7:\"version\";s:6:\"10.3.6\";s:3:\"tag\";s:6:\"10.3.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.6.tar.gz\";s:4:\"date\";s:10:\"1727948888\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.5\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.5\";s:7:\"version\";s:6:\"10.3.5\";s:3:\"tag\";s:6:\"10.3.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.5.tar.gz\";s:4:\"date\";s:10:\"1726134993\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.4\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.4\";s:7:\"version\";s:6:\"10.3.4\";s:3:\"tag\";s:6:\"10.3.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.4.tar.gz\";s:4:\"date\";s:10:\"1726072510\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.3\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.3\";s:7:\"version\";s:6:\"10.3.3\";s:3:\"tag\";s:6:\"10.3.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.3.tar.gz\";s:4:\"date\";s:10:\"1725528161\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.2\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.2\";s:7:\"version\";s:6:\"10.3.2\";s:3:\"tag\";s:6:\"10.3.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.2.tar.gz\";s:4:\"date\";s:10:\"1723109810\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.1\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.1\";s:7:\"version\";s:6:\"10.3.1\";s:3:\"tag\";s:6:\"10.3.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.1.tar.gz\";s:4:\"date\";s:10:\"1720094095\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.3.0\";a:10:{s:4:\"name\";s:13:\"drupal 10.3.0\";s:7:\"version\";s:6:\"10.3.0\";s:3:\"tag\";s:6:\"10.3.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.3.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.3.0.tar.gz\";s:4:\"date\";s:10:\"1718911125\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"10.3.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 10.3.0-rc1\";s:7:\"version\";s:10:\"10.3.0-rc1\";s:3:\"tag\";s:10:\"10.3.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.3.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1717621189\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"10.3.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 10.3.0-beta1\";s:7:\"version\";s:12:\"10.3.0-beta1\";s:3:\"tag\";s:12:\"10.3.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.3.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1715953149\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:7:\"10.2.12\";a:10:{s:4:\"name\";s:14:\"drupal 10.2.12\";s:7:\"version\";s:7:\"10.2.12\";s:3:\"tag\";s:7:\"10.2.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.2.12\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.2.12.tar.gz\";s:4:\"date\";s:10:\"1732281201\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"10.2.11\";a:10:{s:4:\"name\";s:14:\"drupal 10.2.11\";s:7:\"version\";s:7:\"10.2.11\";s:3:\"tag\";s:7:\"10.2.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.2.11\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.2.11.tar.gz\";s:4:\"date\";s:10:\"1732133662\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"10.2.10\";a:10:{s:4:\"name\";s:14:\"drupal 10.2.10\";s:7:\"version\";s:7:\"10.2.10\";s:3:\"tag\";s:7:\"10.2.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.2.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.2.10.tar.gz\";s:4:\"date\";s:10:\"1729096989\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.9\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.9\";s:7:\"version\";s:6:\"10.2.9\";s:3:\"tag\";s:6:\"10.2.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.9.tar.gz\";s:4:\"date\";s:10:\"1728387439\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.8\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.8\";s:7:\"version\";s:6:\"10.2.8\";s:3:\"tag\";s:6:\"10.2.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.8.tar.gz\";s:4:\"date\";s:10:\"1726073816\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.7\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.7\";s:7:\"version\";s:6:\"10.2.7\";s:3:\"tag\";s:6:\"10.2.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.7.tar.gz\";s:4:\"date\";s:10:\"1717660024\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.6\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.6\";s:7:\"version\";s:6:\"10.2.6\";s:3:\"tag\";s:6:\"10.2.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.6.tar.gz\";s:4:\"date\";s:10:\"1714597701\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.5\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.5\";s:7:\"version\";s:6:\"10.2.5\";s:3:\"tag\";s:6:\"10.2.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.5.tar.gz\";s:4:\"date\";s:10:\"1712130945\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.4\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.4\";s:7:\"version\";s:6:\"10.2.4\";s:3:\"tag\";s:6:\"10.2.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.4.tar.gz\";s:4:\"date\";s:10:\"1709715366\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.3\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.3\";s:7:\"version\";s:6:\"10.2.3\";s:3:\"tag\";s:6:\"10.2.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.3.tar.gz\";s:4:\"date\";s:10:\"1707347611\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.2\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.2\";s:7:\"version\";s:6:\"10.2.2\";s:3:\"tag\";s:6:\"10.2.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.2.tar.gz\";s:4:\"date\";s:10:\"1705511786\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.1\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.1\";s:7:\"version\";s:6:\"10.2.1\";s:3:\"tag\";s:6:\"10.2.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.1.tar.gz\";s:4:\"date\";s:10:\"1704448164\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.2.0\";a:10:{s:4:\"name\";s:13:\"drupal 10.2.0\";s:7:\"version\";s:6:\"10.2.0\";s:3:\"tag\";s:6:\"10.2.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.2.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.2.0.tar.gz\";s:4:\"date\";s:10:\"1702681674\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"10.2.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 10.2.0-rc1\";s:7:\"version\";s:10:\"10.2.0-rc1\";s:3:\"tag\";s:10:\"10.2.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.2.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1701450971\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"10.2.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 10.2.0-beta1\";s:7:\"version\";s:12:\"10.2.0-beta1\";s:3:\"tag\";s:12:\"10.2.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.2.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1700578716\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"10.2.0-alpha1\";a:10:{s:4:\"name\";s:20:\"drupal 10.2.0-alpha1\";s:7:\"version\";s:13:\"10.2.0-alpha1\";s:3:\"tag\";s:13:\"10.2.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.2.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1699048959\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"10.1.8\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.8\";s:7:\"version\";s:6:\"10.1.8\";s:3:\"tag\";s:6:\"10.1.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.8.tar.gz\";s:4:\"date\";s:10:\"1705512711\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.7\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.7\";s:7:\"version\";s:6:\"10.1.7\";s:3:\"tag\";s:6:\"10.1.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.7.tar.gz\";s:4:\"date\";s:10:\"1701857745\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.6\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.6\";s:7:\"version\";s:6:\"10.1.6\";s:3:\"tag\";s:6:\"10.1.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.6.tar.gz\";s:4:\"date\";s:10:\"1698841286\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.5\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.5\";s:7:\"version\";s:6:\"10.1.5\";s:3:\"tag\";s:6:\"10.1.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.5.tar.gz\";s:4:\"date\";s:10:\"1696456362\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.4\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.4\";s:7:\"version\";s:6:\"10.1.4\";s:3:\"tag\";s:6:\"10.1.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.4.tar.gz\";s:4:\"date\";s:10:\"1695227262\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.3\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.3\";s:7:\"version\";s:6:\"10.1.3\";s:3:\"tag\";s:6:\"10.1.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.3.tar.gz\";s:4:\"date\";s:10:\"1694101052\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.2\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.2\";s:7:\"version\";s:6:\"10.1.2\";s:3:\"tag\";s:6:\"10.1.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.2.tar.gz\";s:4:\"date\";s:10:\"1690972078\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.1\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.1\";s:7:\"version\";s:6:\"10.1.1\";s:3:\"tag\";s:6:\"10.1.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.1.tar.gz\";s:4:\"date\";s:10:\"1688632960\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.1.0\";a:10:{s:4:\"name\";s:13:\"drupal 10.1.0\";s:7:\"version\";s:6:\"10.1.0\";s:3:\"tag\";s:6:\"10.1.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.1.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.1.0.tar.gz\";s:4:\"date\";s:10:\"1687424272\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"10.1.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 10.1.0-rc1\";s:7:\"version\";s:10:\"10.1.0-rc1\";s:3:\"tag\";s:10:\"10.1.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.1.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1686244833\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"10.1.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 10.1.0-beta1\";s:7:\"version\";s:12:\"10.1.0-beta1\";s:3:\"tag\";s:12:\"10.1.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.1.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1684130534\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"10.1.0-alpha1\";a:10:{s:4:\"name\";s:20:\"drupal 10.1.0-alpha1\";s:7:\"version\";s:13:\"10.1.0-alpha1\";s:3:\"tag\";s:13:\"10.1.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.1.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1682694475\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:7:\"10.0.11\";a:10:{s:4:\"name\";s:14:\"drupal 10.0.11\";s:7:\"version\";s:7:\"10.0.11\";s:3:\"tag\";s:7:\"10.0.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.0.11\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.0.11.tar.gz\";s:4:\"date\";s:10:\"1695228927\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:7:\"10.0.10\";a:10:{s:4:\"name\";s:14:\"drupal 10.0.10\";s:7:\"version\";s:7:\"10.0.10\";s:3:\"tag\";s:7:\"10.0.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:54:\"https://www.drupal.org/project/drupal/releases/10.0.10\";s:13:\"download_link\";s:59:\"https://ftp.drupal.org/files/projects/drupal-10.0.10.tar.gz\";s:4:\"date\";s:10:\"1688549719\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.9\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.9\";s:7:\"version\";s:6:\"10.0.9\";s:3:\"tag\";s:6:\"10.0.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.9\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.9.tar.gz\";s:4:\"date\";s:10:\"1683108606\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.8\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.8\";s:7:\"version\";s:6:\"10.0.8\";s:3:\"tag\";s:6:\"10.0.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.8\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.8.tar.gz\";s:4:\"date\";s:10:\"1681921539\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.7\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.7\";s:7:\"version\";s:6:\"10.0.7\";s:3:\"tag\";s:6:\"10.0.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.7\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.7.tar.gz\";s:4:\"date\";s:10:\"1679678060\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.6\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.6\";s:7:\"version\";s:6:\"10.0.6\";s:3:\"tag\";s:6:\"10.0.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.6\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.6.tar.gz\";s:4:\"date\";s:10:\"1679664982\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.5\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.5\";s:7:\"version\";s:6:\"10.0.5\";s:3:\"tag\";s:6:\"10.0.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.5\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.5.tar.gz\";s:4:\"date\";s:10:\"1678901067\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.4\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.4\";s:7:\"version\";s:6:\"10.0.4\";s:3:\"tag\";s:6:\"10.0.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.4\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.4.tar.gz\";s:4:\"date\";s:10:\"1677681486\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.3\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.3\";s:7:\"version\";s:6:\"10.0.3\";s:3:\"tag\";s:6:\"10.0.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.3\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.3.tar.gz\";s:4:\"date\";s:10:\"1675276709\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.2\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.2\";s:7:\"version\";s:6:\"10.0.2\";s:3:\"tag\";s:6:\"10.0.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.2\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.2.tar.gz\";s:4:\"date\";s:10:\"1674065542\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.1\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.1\";s:7:\"version\";s:6:\"10.0.1\";s:3:\"tag\";s:6:\"10.0.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.1\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.1.tar.gz\";s:4:\"date\";s:10:\"1672847780\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"10.0.0\";a:10:{s:4:\"name\";s:13:\"drupal 10.0.0\";s:7:\"version\";s:6:\"10.0.0\";s:3:\"tag\";s:6:\"10.0.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/10.0.0\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-10.0.0.tar.gz\";s:4:\"date\";s:10:\"1671125939\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:10:\"10.0.0-rc3\";a:10:{s:4:\"name\";s:17:\"drupal 10.0.0-rc3\";s:7:\"version\";s:10:\"10.0.0-rc3\";s:3:\"tag\";s:10:\"10.0.0-rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.0.0-rc3\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1670591784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:10:\"10.0.0-rc2\";a:10:{s:4:\"name\";s:17:\"drupal 10.0.0-rc2\";s:7:\"version\";s:10:\"10.0.0-rc2\";s:3:\"tag\";s:10:\"10.0.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.0.0-rc2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1670320927\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:10:\"10.0.0-rc1\";a:10:{s:4:\"name\";s:17:\"drupal 10.0.0-rc1\";s:7:\"version\";s:10:\"10.0.0-rc1\";s:3:\"tag\";s:10:\"10.0.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.0.0-rc1\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1668612993\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"10.0.0-beta2\";a:10:{s:4:\"name\";s:19:\"drupal 10.0.0-beta2\";s:7:\"version\";s:12:\"10.0.0-beta2\";s:3:\"tag\";s:12:\"10.0.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.0.0-beta2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1664462663\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"10.0.0-beta1\";a:10:{s:4:\"name\";s:19:\"drupal 10.0.0-beta1\";s:7:\"version\";s:12:\"10.0.0-beta1\";s:3:\"tag\";s:12:\"10.0.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/10.0.0-beta1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1663358020\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"10.0.0-alpha7\";a:10:{s:4:\"name\";s:20:\"drupal 10.0.0-alpha7\";s:7:\"version\";s:13:\"10.0.0-alpha7\";s:3:\"tag\";s:13:\"10.0.0-alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.0.0-alpha7\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1659633851\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:13:\"10.0.0-alpha6\";a:10:{s:4:\"name\";s:20:\"drupal 10.0.0-alpha6\";s:7:\"version\";s:13:\"10.0.0-alpha6\";s:3:\"tag\";s:13:\"10.0.0-alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.0.0-alpha6\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1657218740\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:13:\"10.0.0-alpha5\";a:10:{s:4:\"name\";s:20:\"drupal 10.0.0-alpha5\";s:7:\"version\";s:13:\"10.0.0-alpha5\";s:3:\"tag\";s:13:\"10.0.0-alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.0.0-alpha5\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1654722993\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:13:\"10.0.0-alpha4\";a:10:{s:4:\"name\";s:20:\"drupal 10.0.0-alpha4\";s:7:\"version\";s:13:\"10.0.0-alpha4\";s:3:\"tag\";s:13:\"10.0.0-alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.0.0-alpha4\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1651875601\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:13:\"10.0.0-alpha3\";a:10:{s:4:\"name\";s:20:\"drupal 10.0.0-alpha3\";s:7:\"version\";s:13:\"10.0.0-alpha3\";s:3:\"tag\";s:13:\"10.0.0-alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.0.0-alpha3\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1649887793\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:13:\"10.0.0-alpha2\";a:10:{s:4:\"name\";s:20:\"drupal 10.0.0-alpha2\";s:7:\"version\";s:13:\"10.0.0-alpha2\";s:3:\"tag\";s:13:\"10.0.0-alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.0.0-alpha2\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1645204305\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:13:\"10.0.0-alpha1\";a:10:{s:4:\"name\";s:20:\"drupal 10.0.0-alpha1\";s:7:\"version\";s:13:\"10.0.0-alpha1\";s:3:\"tag\";s:13:\"10.0.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/10.0.0-alpha1\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-10.0.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1643404041\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"9.5.11\";a:10:{s:4:\"name\";s:13:\"drupal 9.5.11\";s:7:\"version\";s:6:\"9.5.11\";s:3:\"tag\";s:6:\"9.5.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.5.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.5.11.tar.gz\";s:4:\"date\";s:10:\"1695228016\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.5.10\";a:10:{s:4:\"name\";s:13:\"drupal 9.5.10\";s:7:\"version\";s:6:\"9.5.10\";s:3:\"tag\";s:6:\"9.5.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.5.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.5.10.tar.gz\";s:4:\"date\";s:10:\"1688550984\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.9\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.9\";s:7:\"version\";s:5:\"9.5.9\";s:3:\"tag\";s:5:\"9.5.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.9.tar.gz\";s:4:\"date\";s:10:\"1683121532\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.8\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.8\";s:7:\"version\";s:5:\"9.5.8\";s:3:\"tag\";s:5:\"9.5.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.8.tar.gz\";s:4:\"date\";s:10:\"1681922649\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.7\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.7\";s:7:\"version\";s:5:\"9.5.7\";s:3:\"tag\";s:5:\"9.5.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.7.tar.gz\";s:4:\"date\";s:10:\"1679677448\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.6\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.6\";s:7:\"version\";s:5:\"9.5.6\";s:3:\"tag\";s:5:\"9.5.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.6.tar.gz\";s:4:\"date\";s:10:\"1679664389\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.5\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.5\";s:7:\"version\";s:5:\"9.5.5\";s:3:\"tag\";s:5:\"9.5.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.5.tar.gz\";s:4:\"date\";s:10:\"1678902101\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.4\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.4\";s:7:\"version\";s:5:\"9.5.4\";s:3:\"tag\";s:5:\"9.5.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.4.tar.gz\";s:4:\"date\";s:10:\"1677680813\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.3\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.3\";s:7:\"version\";s:5:\"9.5.3\";s:3:\"tag\";s:5:\"9.5.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.3.tar.gz\";s:4:\"date\";s:10:\"1675281829\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.2\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.2\";s:7:\"version\";s:5:\"9.5.2\";s:3:\"tag\";s:5:\"9.5.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.2.tar.gz\";s:4:\"date\";s:10:\"1674066112\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.1\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.1\";s:7:\"version\";s:5:\"9.5.1\";s:3:\"tag\";s:5:\"9.5.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.1.tar.gz\";s:4:\"date\";s:10:\"1672849046\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.5.0\";a:10:{s:4:\"name\";s:12:\"drupal 9.5.0\";s:7:\"version\";s:5:\"9.5.0\";s:3:\"tag\";s:5:\"9.5.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.5.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.5.0.tar.gz\";s:4:\"date\";s:10:\"1671115839\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"9.5.0-rc2\";a:10:{s:4:\"name\";s:16:\"drupal 9.5.0-rc2\";s:7:\"version\";s:9:\"9.5.0-rc2\";s:3:\"tag\";s:9:\"9.5.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.5.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.5.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1670593040\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"9.5.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 9.5.0-rc1\";s:7:\"version\";s:9:\"9.5.0-rc1\";s:3:\"tag\";s:9:\"9.5.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.5.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.5.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1668611189\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"9.5.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 9.5.0-beta2\";s:7:\"version\";s:11:\"9.5.0-beta2\";s:3:\"tag\";s:11:\"9.5.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.5.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.5.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1664463958\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"9.5.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 9.5.0-beta1\";s:7:\"version\";s:11:\"9.5.0-beta1\";s:3:\"tag\";s:11:\"9.5.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.5.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.5.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1663358587\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:6:\"9.4.15\";a:10:{s:4:\"name\";s:13:\"drupal 9.4.15\";s:7:\"version\";s:6:\"9.4.15\";s:3:\"tag\";s:6:\"9.4.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.4.15\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.4.15.tar.gz\";s:4:\"date\";s:10:\"1683122076\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.4.14\";a:10:{s:4:\"name\";s:13:\"drupal 9.4.14\";s:7:\"version\";s:6:\"9.4.14\";s:3:\"tag\";s:6:\"9.4.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.4.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.4.14.tar.gz\";s:4:\"date\";s:10:\"1681922120\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.4.13\";a:10:{s:4:\"name\";s:13:\"drupal 9.4.13\";s:7:\"version\";s:6:\"9.4.13\";s:3:\"tag\";s:6:\"9.4.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.4.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.4.13.tar.gz\";s:4:\"date\";s:10:\"1679665413\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.4.12\";a:10:{s:4:\"name\";s:13:\"drupal 9.4.12\";s:7:\"version\";s:6:\"9.4.12\";s:3:\"tag\";s:6:\"9.4.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.4.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.4.12.tar.gz\";s:4:\"date\";s:10:\"1678901516\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.4.11\";a:10:{s:4:\"name\";s:13:\"drupal 9.4.11\";s:7:\"version\";s:6:\"9.4.11\";s:3:\"tag\";s:6:\"9.4.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.4.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.4.11.tar.gz\";s:4:\"date\";s:10:\"1675282255\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.4.10\";a:10:{s:4:\"name\";s:13:\"drupal 9.4.10\";s:7:\"version\";s:6:\"9.4.10\";s:3:\"tag\";s:6:\"9.4.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.4.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.4.10.tar.gz\";s:4:\"date\";s:10:\"1674066615\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.9\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.9\";s:7:\"version\";s:5:\"9.4.9\";s:3:\"tag\";s:5:\"9.4.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.9.tar.gz\";s:4:\"date\";s:10:\"1670421053\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.8\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.8\";s:7:\"version\";s:5:\"9.4.8\";s:3:\"tag\";s:5:\"9.4.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.8.tar.gz\";s:4:\"date\";s:10:\"1665072393\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.7\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.7\";s:7:\"version\";s:5:\"9.4.7\";s:3:\"tag\";s:5:\"9.4.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.7.tar.gz\";s:4:\"date\";s:10:\"1664383239\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.6\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.6\";s:7:\"version\";s:5:\"9.4.6\";s:3:\"tag\";s:5:\"9.4.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.6.tar.gz\";s:4:\"date\";s:10:\"1663681319\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.5\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.5\";s:7:\"version\";s:5:\"9.4.5\";s:3:\"tag\";s:5:\"9.4.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.5.tar.gz\";s:4:\"date\";s:10:\"1659545453\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.4\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.4\";s:7:\"version\";s:5:\"9.4.4\";s:3:\"tag\";s:5:\"9.4.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.4.tar.gz\";s:4:\"date\";s:10:\"1659037490\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.3\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.3\";s:7:\"version\";s:5:\"9.4.3\";s:3:\"tag\";s:5:\"9.4.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.3.tar.gz\";s:4:\"date\";s:10:\"1658333415\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.2\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.2\";s:7:\"version\";s:5:\"9.4.2\";s:3:\"tag\";s:5:\"9.4.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.2.tar.gz\";s:4:\"date\";s:10:\"1657157309\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.1\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.1\";s:7:\"version\";s:5:\"9.4.1\";s:3:\"tag\";s:5:\"9.4.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.1.tar.gz\";s:4:\"date\";s:10:\"1655845511\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.4.0\";a:10:{s:4:\"name\";s:12:\"drupal 9.4.0\";s:7:\"version\";s:5:\"9.4.0\";s:3:\"tag\";s:5:\"9.4.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.4.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.4.0.tar.gz\";s:4:\"date\";s:10:\"1655311138\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"9.4.0-rc2\";a:10:{s:4:\"name\";s:16:\"drupal 9.4.0-rc2\";s:7:\"version\";s:9:\"9.4.0-rc2\";s:3:\"tag\";s:9:\"9.4.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.4.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.4.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1654890055\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"9.4.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 9.4.0-rc1\";s:7:\"version\";s:9:\"9.4.0-rc1\";s:3:\"tag\";s:9:\"9.4.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.4.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.4.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1654740019\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"9.4.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 9.4.0-beta1\";s:7:\"version\";s:11:\"9.4.0-beta1\";s:3:\"tag\";s:11:\"9.4.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.4.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.4.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1653938214\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"9.4.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 9.4.0-alpha1\";s:7:\"version\";s:12:\"9.4.0-alpha1\";s:3:\"tag\";s:12:\"9.4.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/9.4.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-9.4.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1651875606\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"9.3.22\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.22\";s:7:\"version\";s:6:\"9.3.22\";s:3:\"tag\";s:6:\"9.3.22\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.22\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.22.tar.gz\";s:4:\"date\";s:10:\"1664382666\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.21\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.21\";s:7:\"version\";s:6:\"9.3.21\";s:3:\"tag\";s:6:\"9.3.21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.21\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.21.tar.gz\";s:4:\"date\";s:10:\"1659544886\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.20\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.20\";s:7:\"version\";s:6:\"9.3.20\";s:3:\"tag\";s:6:\"9.3.20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.20\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.20.tar.gz\";s:4:\"date\";s:10:\"1659037977\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.19\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.19\";s:7:\"version\";s:6:\"9.3.19\";s:3:\"tag\";s:6:\"9.3.19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.19\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.19.tar.gz\";s:4:\"date\";s:10:\"1658333887\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.18\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.18\";s:7:\"version\";s:6:\"9.3.18\";s:3:\"tag\";s:6:\"9.3.18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.18\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.18.tar.gz\";s:4:\"date\";s:10:\"1657238772\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.17\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.17\";s:7:\"version\";s:6:\"9.3.17\";s:3:\"tag\";s:6:\"9.3.17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.17\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.17.tar.gz\";s:4:\"date\";s:10:\"1655846622\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.16\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.16\";s:7:\"version\";s:6:\"9.3.16\";s:3:\"tag\";s:6:\"9.3.16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.16\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.16.tar.gz\";s:4:\"date\";s:10:\"1654888736\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.15\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.15\";s:7:\"version\";s:6:\"9.3.15\";s:3:\"tag\";s:6:\"9.3.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.15\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.15.tar.gz\";s:4:\"date\";s:10:\"1654098765\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.14\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.14\";s:7:\"version\";s:6:\"9.3.14\";s:3:\"tag\";s:6:\"9.3.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.14.tar.gz\";s:4:\"date\";s:10:\"1653506291\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.13\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.13\";s:7:\"version\";s:6:\"9.3.13\";s:3:\"tag\";s:6:\"9.3.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.13.tar.gz\";s:4:\"date\";s:10:\"1652261874\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.12\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.12\";s:7:\"version\";s:6:\"9.3.12\";s:3:\"tag\";s:6:\"9.3.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.12.tar.gz\";s:4:\"date\";s:10:\"1650467536\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.11\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.11\";s:7:\"version\";s:6:\"9.3.11\";s:3:\"tag\";s:6:\"9.3.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.11.tar.gz\";s:4:\"date\";s:10:\"1649897391\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.3.10\";a:10:{s:4:\"name\";s:13:\"drupal 9.3.10\";s:7:\"version\";s:6:\"9.3.10\";s:3:\"tag\";s:6:\"9.3.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.3.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.3.10.tar.gz\";s:4:\"date\";s:10:\"1649890098\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.9\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.9\";s:7:\"version\";s:5:\"9.3.9\";s:3:\"tag\";s:5:\"9.3.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.9.tar.gz\";s:4:\"date\";s:10:\"1647899360\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.8\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.8\";s:7:\"version\";s:5:\"9.3.8\";s:3:\"tag\";s:5:\"9.3.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.8.tar.gz\";s:4:\"date\";s:10:\"1647446914\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.7\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.7\";s:7:\"version\";s:5:\"9.3.7\";s:3:\"tag\";s:5:\"9.3.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.7.tar.gz\";s:4:\"date\";s:10:\"1646300599\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.6\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.6\";s:7:\"version\";s:5:\"9.3.6\";s:3:\"tag\";s:5:\"9.3.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.6.tar.gz\";s:4:\"date\";s:10:\"1645029460\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.5\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.5\";s:7:\"version\";s:5:\"9.3.5\";s:3:\"tag\";s:5:\"9.3.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.5.tar.gz\";s:4:\"date\";s:10:\"1644011676\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.4\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.4\";s:7:\"version\";s:5:\"9.3.4\";s:3:\"tag\";s:5:\"9.3.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.4.tar.gz\";s:4:\"date\";s:10:\"1643832805\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.3\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.3\";s:7:\"version\";s:5:\"9.3.3\";s:3:\"tag\";s:5:\"9.3.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.3.tar.gz\";s:4:\"date\";s:10:\"1642607769\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.2\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.2\";s:7:\"version\";s:5:\"9.3.2\";s:3:\"tag\";s:5:\"9.3.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.2.tar.gz\";s:4:\"date\";s:10:\"1641351799\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.1\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.1\";s:7:\"version\";s:5:\"9.3.1\";s:3:\"tag\";s:5:\"9.3.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.1.tar.gz\";s:4:\"date\";s:10:\"1641342679\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.3.0\";a:10:{s:4:\"name\";s:12:\"drupal 9.3.0\";s:7:\"version\";s:5:\"9.3.0\";s:3:\"tag\";s:5:\"9.3.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.3.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.3.0.tar.gz\";s:4:\"date\";s:10:\"1639051276\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"9.3.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 9.3.0-rc1\";s:7:\"version\";s:9:\"9.3.0-rc1\";s:3:\"tag\";s:9:\"9.3.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.3.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1637959424\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"9.3.0-beta3\";a:10:{s:4:\"name\";s:18:\"drupal 9.3.0-beta3\";s:7:\"version\";s:11:\"9.3.0-beta3\";s:3:\"tag\";s:11:\"9.3.0-beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.3.0-beta3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.3.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1637764182\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"9.3.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 9.3.0-beta2\";s:7:\"version\";s:11:\"9.3.0-beta2\";s:3:\"tag\";s:11:\"9.3.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.3.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.3.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1637196496\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"9.3.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 9.3.0-beta1\";s:7:\"version\";s:11:\"9.3.0-beta1\";s:3:\"tag\";s:11:\"9.3.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.3.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1636746050\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"9.3.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 9.3.0-alpha1\";s:7:\"version\";s:12:\"9.3.0-alpha1\";s:3:\"tag\";s:12:\"9.3.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/9.3.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-9.3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1635510285\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"9.2.21\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.21\";s:7:\"version\";s:6:\"9.2.21\";s:3:\"tag\";s:6:\"9.2.21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.21\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.21.tar.gz\";s:4:\"date\";s:10:\"1654889475\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.20\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.20\";s:7:\"version\";s:6:\"9.2.20\";s:3:\"tag\";s:6:\"9.2.20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.20\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.20.tar.gz\";s:4:\"date\";s:10:\"1653507225\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.19\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.19\";s:7:\"version\";s:6:\"9.2.19\";s:3:\"tag\";s:6:\"9.2.19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.19\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.19.tar.gz\";s:4:\"date\";s:10:\"1652306637\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.18\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.18\";s:7:\"version\";s:6:\"9.2.18\";s:3:\"tag\";s:6:\"9.2.18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.18\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.18.tar.gz\";s:4:\"date\";s:10:\"1650466972\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.17\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.17\";s:7:\"version\";s:6:\"9.2.17\";s:3:\"tag\";s:6:\"9.2.17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.17\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.17.tar.gz\";s:4:\"date\";s:10:\"1649898006\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.16\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.16\";s:7:\"version\";s:6:\"9.2.16\";s:3:\"tag\";s:6:\"9.2.16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.16\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.16.tar.gz\";s:4:\"date\";s:10:\"1647898826\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.15\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.15\";s:7:\"version\";s:6:\"9.2.15\";s:3:\"tag\";s:6:\"9.2.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.15\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.15.tar.gz\";s:4:\"date\";s:10:\"1647447411\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.14\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.14\";s:7:\"version\";s:6:\"9.2.14\";s:3:\"tag\";s:6:\"9.2.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.14.tar.gz\";s:4:\"date\";s:10:\"1647027629\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.13\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.13\";s:7:\"version\";s:6:\"9.2.13\";s:3:\"tag\";s:6:\"9.2.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.13.tar.gz\";s:4:\"date\";s:10:\"1645029955\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.12\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.12\";s:7:\"version\";s:6:\"9.2.12\";s:3:\"tag\";s:6:\"9.2.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.12.tar.gz\";s:4:\"date\";s:10:\"1644012448\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.11\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.11\";s:7:\"version\";s:6:\"9.2.11\";s:3:\"tag\";s:6:\"9.2.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.11.tar.gz\";s:4:\"date\";s:10:\"1642608353\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.2.10\";a:10:{s:4:\"name\";s:13:\"drupal 9.2.10\";s:7:\"version\";s:6:\"9.2.10\";s:3:\"tag\";s:6:\"9.2.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.2.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.2.10.tar.gz\";s:4:\"date\";s:10:\"1637765544\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.9\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.9\";s:7:\"version\";s:5:\"9.2.9\";s:3:\"tag\";s:5:\"9.2.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.9.tar.gz\";s:4:\"date\";s:10:\"1637184936\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.8\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.8\";s:7:\"version\";s:5:\"9.2.8\";s:3:\"tag\";s:5:\"9.2.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.8.tar.gz\";s:4:\"date\";s:10:\"1635961216\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.7\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.7\";s:7:\"version\";s:5:\"9.2.7\";s:3:\"tag\";s:5:\"9.2.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.7.tar.gz\";s:4:\"date\";s:10:\"1633544267\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.6\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.6\";s:7:\"version\";s:5:\"9.2.6\";s:3:\"tag\";s:5:\"9.2.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.6.tar.gz\";s:4:\"date\";s:10:\"1631721555\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.5\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.5\";s:7:\"version\";s:5:\"9.2.5\";s:3:\"tag\";s:5:\"9.2.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.5.tar.gz\";s:4:\"date\";s:10:\"1630534729\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.4\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.4\";s:7:\"version\";s:5:\"9.2.4\";s:3:\"tag\";s:5:\"9.2.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.4.tar.gz\";s:4:\"date\";s:10:\"1628791178\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.3\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.3\";s:7:\"version\";s:5:\"9.2.3\";s:3:\"tag\";s:5:\"9.2.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.3.tar.gz\";s:4:\"date\";s:10:\"1627997922\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.2\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.2\";s:7:\"version\";s:5:\"9.2.2\";s:3:\"tag\";s:5:\"9.2.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.2.tar.gz\";s:4:\"date\";s:10:\"1626882385\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.1\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.1\";s:7:\"version\";s:5:\"9.2.1\";s:3:\"tag\";s:5:\"9.2.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.1.tar.gz\";s:4:\"date\";s:10:\"1625664286\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.2.0\";a:10:{s:4:\"name\";s:12:\"drupal 9.2.0\";s:7:\"version\";s:5:\"9.2.0\";s:3:\"tag\";s:5:\"9.2.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.2.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.2.0.tar.gz\";s:4:\"date\";s:10:\"1623847798\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"9.2.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 9.2.0-rc1\";s:7:\"version\";s:9:\"9.2.0-rc1\";s:3:\"tag\";s:9:\"9.2.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.2.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1623080867\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"9.2.0-beta3\";a:10:{s:4:\"name\";s:18:\"drupal 9.2.0-beta3\";s:7:\"version\";s:11:\"9.2.0-beta3\";s:3:\"tag\";s:11:\"9.2.0-beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.2.0-beta3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1622207568\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"9.2.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 9.2.0-beta2\";s:7:\"version\";s:11:\"9.2.0-beta2\";s:3:\"tag\";s:11:\"9.2.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.2.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1622068611\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:4:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";i:3;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"9.2.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 9.2.0-beta1\";s:7:\"version\";s:11:\"9.2.0-beta1\";s:3:\"tag\";s:11:\"9.2.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.2.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1621506248\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"9.2.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 9.2.0-alpha1\";s:7:\"version\";s:12:\"9.2.0-alpha1\";s:3:\"tag\";s:12:\"9.2.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/9.2.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-9.2.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1620291652\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"9.1.15\";a:10:{s:4:\"name\";s:13:\"drupal 9.1.15\";s:7:\"version\";s:6:\"9.1.15\";s:3:\"tag\";s:6:\"9.1.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.1.15\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.1.15.tar.gz\";s:4:\"date\";s:10:\"1637766681\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.1.14\";a:10:{s:4:\"name\";s:13:\"drupal 9.1.14\";s:7:\"version\";s:6:\"9.1.14\";s:3:\"tag\";s:6:\"9.1.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.1.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.1.14.tar.gz\";s:4:\"date\";s:10:\"1637185450\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.1.13\";a:10:{s:4:\"name\";s:13:\"drupal 9.1.13\";s:7:\"version\";s:6:\"9.1.13\";s:3:\"tag\";s:6:\"9.1.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.1.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.1.13.tar.gz\";s:4:\"date\";s:10:\"1631722011\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.1.12\";a:10:{s:4:\"name\";s:13:\"drupal 9.1.12\";s:7:\"version\";s:6:\"9.1.12\";s:3:\"tag\";s:6:\"9.1.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.1.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.1.12.tar.gz\";s:4:\"date\";s:10:\"1628791786\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.1.11\";a:10:{s:4:\"name\";s:13:\"drupal 9.1.11\";s:7:\"version\";s:6:\"9.1.11\";s:3:\"tag\";s:6:\"9.1.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.1.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.1.11.tar.gz\";s:4:\"date\";s:10:\"1626882849\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.1.10\";a:10:{s:4:\"name\";s:13:\"drupal 9.1.10\";s:7:\"version\";s:6:\"9.1.10\";s:3:\"tag\";s:6:\"9.1.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.1.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.1.10.tar.gz\";s:4:\"date\";s:10:\"1622828120\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.9\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.9\";s:7:\"version\";s:5:\"9.1.9\";s:3:\"tag\";s:5:\"9.1.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.9.tar.gz\";s:4:\"date\";s:10:\"1622056478\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.8\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.8\";s:7:\"version\";s:5:\"9.1.8\";s:3:\"tag\";s:5:\"9.1.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.8.tar.gz\";s:4:\"date\";s:10:\"1620214182\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.7\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.7\";s:7:\"version\";s:5:\"9.1.7\";s:3:\"tag\";s:5:\"9.1.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.7.tar.gz\";s:4:\"date\";s:10:\"1619022156\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.6\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.6\";s:7:\"version\";s:5:\"9.1.6\";s:3:\"tag\";s:5:\"9.1.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.6.tar.gz\";s:4:\"date\";s:10:\"1617795446\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.5\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.5\";s:7:\"version\";s:5:\"9.1.5\";s:3:\"tag\";s:5:\"9.1.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.5.tar.gz\";s:4:\"date\";s:10:\"1614869503\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.4\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.4\";s:7:\"version\";s:5:\"9.1.4\";s:3:\"tag\";s:5:\"9.1.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.4.tar.gz\";s:4:\"date\";s:10:\"1612380948\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.3\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.3\";s:7:\"version\";s:5:\"9.1.3\";s:3:\"tag\";s:5:\"9.1.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.3.tar.gz\";s:4:\"date\";s:10:\"1611161215\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.2\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.2\";s:7:\"version\";s:5:\"9.1.2\";s:3:\"tag\";s:5:\"9.1.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.2.tar.gz\";s:4:\"date\";s:10:\"1609984407\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.1\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.1\";s:7:\"version\";s:5:\"9.1.1\";s:3:\"tag\";s:5:\"9.1.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.1.tar.gz\";s:4:\"date\";s:10:\"1609979034\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.1.0\";a:10:{s:4:\"name\";s:12:\"drupal 9.1.0\";s:7:\"version\";s:5:\"9.1.0\";s:3:\"tag\";s:5:\"9.1.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.1.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.1.0.tar.gz\";s:4:\"date\";s:10:\"1606933254\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"9.1.0-rc3\";a:10:{s:4:\"name\";s:16:\"drupal 9.1.0-rc3\";s:7:\"version\";s:9:\"9.1.0-rc3\";s:3:\"tag\";s:9:\"9.1.0-rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.1.0-rc3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.1.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1606357271\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"9.1.0-rc2\";a:10:{s:4:\"name\";s:16:\"drupal 9.1.0-rc2\";s:7:\"version\";s:9:\"9.1.0-rc2\";s:3:\"tag\";s:9:\"9.1.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.1.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1606332982\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"9.1.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 9.1.0-rc1\";s:7:\"version\";s:9:\"9.1.0-rc1\";s:3:\"tag\";s:9:\"9.1.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.1.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1605722782\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:4:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";i:3;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"9.1.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 9.1.0-beta1\";s:7:\"version\";s:11:\"9.1.0-beta1\";s:3:\"tag\";s:11:\"9.1.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.1.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1604672644\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"9.1.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 9.1.0-alpha1\";s:7:\"version\";s:12:\"9.1.0-alpha1\";s:3:\"tag\";s:12:\"9.1.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/9.1.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-9.1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1603466665\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"9.0.14\";a:10:{s:4:\"name\";s:13:\"drupal 9.0.14\";s:7:\"version\";s:6:\"9.0.14\";s:3:\"tag\";s:6:\"9.0.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.0.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.0.14.tar.gz\";s:4:\"date\";s:10:\"1622055778\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.0.13\";a:10:{s:4:\"name\";s:13:\"drupal 9.0.13\";s:7:\"version\";s:6:\"9.0.13\";s:3:\"tag\";s:6:\"9.0.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.0.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.0.13.tar.gz\";s:4:\"date\";s:10:\"1620218506\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.0.12\";a:10:{s:4:\"name\";s:13:\"drupal 9.0.12\";s:7:\"version\";s:6:\"9.0.12\";s:3:\"tag\";s:6:\"9.0.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.0.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.0.12.tar.gz\";s:4:\"date\";s:10:\"1619020951\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.0.11\";a:10:{s:4:\"name\";s:13:\"drupal 9.0.11\";s:7:\"version\";s:6:\"9.0.11\";s:3:\"tag\";s:6:\"9.0.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.0.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.0.11.tar.gz\";s:4:\"date\";s:10:\"1611161749\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"9.0.10\";a:10:{s:4:\"name\";s:13:\"drupal 9.0.10\";s:7:\"version\";s:6:\"9.0.10\";s:3:\"tag\";s:6:\"9.0.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/9.0.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-9.0.10.tar.gz\";s:4:\"date\";s:10:\"1607029536\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.9\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.9\";s:7:\"version\";s:5:\"9.0.9\";s:3:\"tag\";s:5:\"9.0.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.9.tar.gz\";s:4:\"date\";s:10:\"1606359757\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.8\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.8\";s:7:\"version\";s:5:\"9.0.8\";s:3:\"tag\";s:5:\"9.0.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.8.tar.gz\";s:4:\"date\";s:10:\"1605720638\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.7\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.7\";s:7:\"version\";s:5:\"9.0.7\";s:3:\"tag\";s:5:\"9.0.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.7.tar.gz\";s:4:\"date\";s:10:\"1602100055\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.6\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.6\";s:7:\"version\";s:5:\"9.0.6\";s:3:\"tag\";s:5:\"9.0.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.6.tar.gz\";s:4:\"date\";s:10:\"1600275813\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.5\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.5\";s:7:\"version\";s:5:\"9.0.5\";s:3:\"tag\";s:5:\"9.0.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.5.tar.gz\";s:4:\"date\";s:10:\"1599167739\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.4\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.4\";s:7:\"version\";s:5:\"9.0.4\";s:3:\"tag\";s:5:\"9.0.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.4.tar.gz\";s:4:\"date\";s:10:\"1599046734\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.3\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.3\";s:7:\"version\";s:5:\"9.0.3\";s:3:\"tag\";s:5:\"9.0.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.3.tar.gz\";s:4:\"date\";s:10:\"1596664575\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.2\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.2\";s:7:\"version\";s:5:\"9.0.2\";s:3:\"tag\";s:5:\"9.0.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.2.tar.gz\";s:4:\"date\";s:10:\"1594237418\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.1\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.1\";s:7:\"version\";s:5:\"9.0.1\";s:3:\"tag\";s:5:\"9.0.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.1.tar.gz\";s:4:\"date\";s:10:\"1592417721\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"9.0.0\";a:10:{s:4:\"name\";s:12:\"drupal 9.0.0\";s:7:\"version\";s:5:\"9.0.0\";s:3:\"tag\";s:5:\"9.0.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/9.0.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-9.0.0.tar.gz\";s:4:\"date\";s:10:\"1591221685\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"9.0.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 9.0.0-rc1\";s:7:\"version\";s:9:\"9.0.0-rc1\";s:3:\"tag\";s:9:\"9.0.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.0.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.0.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1590187579\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"9.0.0-beta3\";a:10:{s:4:\"name\";s:18:\"drupal 9.0.0-beta3\";s:7:\"version\";s:11:\"9.0.0-beta3\";s:3:\"tag\";s:11:\"9.0.0-beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.0.0-beta3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.0.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1589587936\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"9.0.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 9.0.0-beta2\";s:7:\"version\";s:11:\"9.0.0-beta2\";s:3:\"tag\";s:11:\"9.0.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.0.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.0.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1585597395\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"9.0.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 9.0.0-beta1\";s:7:\"version\";s:11:\"9.0.0-beta1\";s:3:\"tag\";s:11:\"9.0.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/9.0.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-9.0.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1584734060\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"9.0.0-alpha2\";a:10:{s:4:\"name\";s:19:\"drupal 9.0.0-alpha2\";s:7:\"version\";s:12:\"9.0.0-alpha2\";s:3:\"tag\";s:12:\"9.0.0-alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/9.0.0-alpha2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-9.0.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1583349043\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:12:\"9.0.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 9.0.0-alpha1\";s:7:\"version\";s:12:\"9.0.0-alpha1\";s:3:\"tag\";s:12:\"9.0.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/9.0.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-9.0.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1581447927\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"8.9.20\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.20\";s:7:\"version\";s:6:\"8.9.20\";s:3:\"tag\";s:6:\"8.9.20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.20\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.20.tar.gz\";s:4:\"date\";s:10:\"1637185966\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.19\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.19\";s:7:\"version\";s:6:\"8.9.19\";s:3:\"tag\";s:6:\"8.9.19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.19\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.19.tar.gz\";s:4:\"date\";s:10:\"1631722431\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.18\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.18\";s:7:\"version\";s:6:\"8.9.18\";s:3:\"tag\";s:6:\"8.9.18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.18\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.18.tar.gz\";s:4:\"date\";s:10:\"1628792296\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.17\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.17\";s:7:\"version\";s:6:\"8.9.17\";s:3:\"tag\";s:6:\"8.9.17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.17\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.17.tar.gz\";s:4:\"date\";s:10:\"1626883324\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.16\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.16\";s:7:\"version\";s:6:\"8.9.16\";s:3:\"tag\";s:6:\"8.9.16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.16\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.16.tar.gz\";s:4:\"date\";s:10:\"1622058087\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.15\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.15\";s:7:\"version\";s:6:\"8.9.15\";s:3:\"tag\";s:6:\"8.9.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.15\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.15.tar.gz\";s:4:\"date\";s:10:\"1620216983\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.14\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.14\";s:7:\"version\";s:6:\"8.9.14\";s:3:\"tag\";s:6:\"8.9.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.14.tar.gz\";s:4:\"date\";s:10:\"1619021518\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.13\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.13\";s:7:\"version\";s:6:\"8.9.13\";s:3:\"tag\";s:6:\"8.9.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.13.tar.gz\";s:4:\"date\";s:10:\"1611162272\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.12\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.12\";s:7:\"version\";s:6:\"8.9.12\";s:3:\"tag\";s:6:\"8.9.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.12.tar.gz\";s:4:\"date\";s:10:\"1609977009\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.11\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.11\";s:7:\"version\";s:6:\"8.9.11\";s:3:\"tag\";s:6:\"8.9.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.11.tar.gz\";s:4:\"date\";s:10:\"1607030087\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.9.10\";a:10:{s:4:\"name\";s:13:\"drupal 8.9.10\";s:7:\"version\";s:6:\"8.9.10\";s:3:\"tag\";s:6:\"8.9.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.9.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.9.10.tar.gz\";s:4:\"date\";s:10:\"1606360301\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.9\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.9\";s:7:\"version\";s:5:\"8.9.9\";s:3:\"tag\";s:5:\"8.9.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.9.tar.gz\";s:4:\"date\";s:10:\"1605721120\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.8\";s:7:\"version\";s:5:\"8.9.8\";s:3:\"tag\";s:5:\"8.9.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.8.tar.gz\";s:4:\"date\";s:10:\"1604595269\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.7\";s:7:\"version\";s:5:\"8.9.7\";s:3:\"tag\";s:5:\"8.9.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.7.tar.gz\";s:4:\"date\";s:10:\"1602100507\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.6\";s:7:\"version\";s:5:\"8.9.6\";s:3:\"tag\";s:5:\"8.9.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.6.tar.gz\";s:4:\"date\";s:10:\"1600276267\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.5\";s:7:\"version\";s:5:\"8.9.5\";s:3:\"tag\";s:5:\"8.9.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.5.tar.gz\";s:4:\"date\";s:10:\"1599168205\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.4\";s:7:\"version\";s:5:\"8.9.4\";s:3:\"tag\";s:5:\"8.9.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.4.tar.gz\";s:4:\"date\";s:10:\"1599047691\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.3\";s:7:\"version\";s:5:\"8.9.3\";s:3:\"tag\";s:5:\"8.9.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.3.tar.gz\";s:4:\"date\";s:10:\"1596665051\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.2\";s:7:\"version\";s:5:\"8.9.2\";s:3:\"tag\";s:5:\"8.9.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.2.tar.gz\";s:4:\"date\";s:10:\"1594237961\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.1\";s:7:\"version\";s:5:\"8.9.1\";s:3:\"tag\";s:5:\"8.9.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.1.tar.gz\";s:4:\"date\";s:10:\"1592418237\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.9.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.9.0\";s:7:\"version\";s:5:\"8.9.0\";s:3:\"tag\";s:5:\"8.9.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.9.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.9.0.tar.gz\";s:4:\"date\";s:10:\"1591204117\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.9.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.9.0-rc1\";s:7:\"version\";s:9:\"8.9.0-rc1\";s:3:\"tag\";s:9:\"8.9.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.9.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.9.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1590189096\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.9.0-beta3\";a:10:{s:4:\"name\";s:18:\"drupal 8.9.0-beta3\";s:7:\"version\";s:11:\"8.9.0-beta3\";s:3:\"tag\";s:11:\"8.9.0-beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.9.0-beta3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.9.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1589746375\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.9.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 8.9.0-beta2\";s:7:\"version\";s:11:\"8.9.0-beta2\";s:3:\"tag\";s:11:\"8.9.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.9.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.9.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1585863226\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.9.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.9.0-beta1\";s:7:\"version\";s:11:\"8.9.0-beta1\";s:3:\"tag\";s:11:\"8.9.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.9.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.9.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1585263710\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:6:\"8.8.12\";a:10:{s:4:\"name\";s:13:\"drupal 8.8.12\";s:7:\"version\";s:6:\"8.8.12\";s:3:\"tag\";s:6:\"8.8.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.8.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.8.12.tar.gz\";s:4:\"date\";s:10:\"1606360866\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.8.11\";a:10:{s:4:\"name\";s:13:\"drupal 8.8.11\";s:7:\"version\";s:6:\"8.8.11\";s:3:\"tag\";s:6:\"8.8.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.8.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.8.11.tar.gz\";s:4:\"date\";s:10:\"1605721628\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.8.10\";a:10:{s:4:\"name\";s:13:\"drupal 8.8.10\";s:7:\"version\";s:6:\"8.8.10\";s:3:\"tag\";s:6:\"8.8.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.8.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.8.10.tar.gz\";s:4:\"date\";s:10:\"1600276704\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.9\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.9\";s:7:\"version\";s:5:\"8.8.9\";s:3:\"tag\";s:5:\"8.8.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.9.tar.gz\";s:4:\"date\";s:10:\"1599168716\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.8\";s:7:\"version\";s:5:\"8.8.8\";s:3:\"tag\";s:5:\"8.8.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.8.tar.gz\";s:4:\"date\";s:10:\"1592418750\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.7\";s:7:\"version\";s:5:\"8.8.7\";s:3:\"tag\";s:5:\"8.8.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.7.tar.gz\";s:4:\"date\";s:10:\"1591203837\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.6\";s:7:\"version\";s:5:\"8.8.6\";s:3:\"tag\";s:5:\"8.8.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.6.tar.gz\";s:4:\"date\";s:10:\"1589989060\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.5\";s:7:\"version\";s:5:\"8.8.5\";s:3:\"tag\";s:5:\"8.8.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.5.tar.gz\";s:4:\"date\";s:10:\"1585861530\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.4\";s:7:\"version\";s:5:\"8.8.4\";s:3:\"tag\";s:5:\"8.8.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.4.tar.gz\";s:4:\"date\";s:10:\"1584560524\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.3\";s:7:\"version\";s:5:\"8.8.3\";s:3:\"tag\";s:5:\"8.8.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.3.tar.gz\";s:4:\"date\";s:10:\"1583347094\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.2\";s:7:\"version\";s:5:\"8.8.2\";s:3:\"tag\";s:5:\"8.8.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.2.tar.gz\";s:4:\"date\";s:10:\"1580598849\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.1\";s:7:\"version\";s:5:\"8.8.1\";s:3:\"tag\";s:5:\"8.8.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.1.tar.gz\";s:4:\"date\";s:10:\"1576695785\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.8.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.8.0\";s:7:\"version\";s:5:\"8.8.0\";s:3:\"tag\";s:5:\"8.8.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.8.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.8.0.tar.gz\";s:4:\"date\";s:10:\"1575450481\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.8.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.8.0-rc1\";s:7:\"version\";s:9:\"8.8.0-rc1\";s:3:\"tag\";s:9:\"8.8.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.8.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.8.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1574462580\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.8.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.8.0-beta1\";s:7:\"version\";s:11:\"8.8.0-beta1\";s:3:\"tag\";s:11:\"8.8.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.8.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.8.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1573256280\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.8.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 8.8.0-alpha1\";s:7:\"version\";s:12:\"8.8.0-alpha1\";s:3:\"tag\";s:12:\"8.8.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.8.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.8.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1571355784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"8.7.14\";a:10:{s:4:\"name\";s:13:\"drupal 8.7.14\";s:7:\"version\";s:6:\"8.7.14\";s:3:\"tag\";s:6:\"8.7.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.7.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.7.14.tar.gz\";s:4:\"date\";s:10:\"1589988665\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.7.13\";a:10:{s:4:\"name\";s:13:\"drupal 8.7.13\";s:7:\"version\";s:6:\"8.7.13\";s:3:\"tag\";s:6:\"8.7.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.7.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.7.13.tar.gz\";s:4:\"date\";s:10:\"1585861883\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.7.12\";a:10:{s:4:\"name\";s:13:\"drupal 8.7.12\";s:7:\"version\";s:6:\"8.7.12\";s:3:\"tag\";s:6:\"8.7.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.7.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.7.12.tar.gz\";s:4:\"date\";s:10:\"1584552250\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.7.11\";a:10:{s:4:\"name\";s:13:\"drupal 8.7.11\";s:7:\"version\";s:6:\"8.7.11\";s:3:\"tag\";s:6:\"8.7.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.7.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.7.11.tar.gz\";s:4:\"date\";s:10:\"1576695785\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.7.10\";a:10:{s:4:\"name\";s:13:\"drupal 8.7.10\";s:7:\"version\";s:6:\"8.7.10\";s:3:\"tag\";s:6:\"8.7.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.7.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.7.10.tar.gz\";s:4:\"date\";s:10:\"1573687985\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.9\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.9\";s:7:\"version\";s:5:\"8.7.9\";s:3:\"tag\";s:5:\"8.7.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.9.tar.gz\";s:4:\"date\";s:10:\"1573063387\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.8\";s:7:\"version\";s:5:\"8.7.8\";s:3:\"tag\";s:5:\"8.7.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.8.tar.gz\";s:4:\"date\";s:10:\"1570044484\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.7\";s:7:\"version\";s:5:\"8.7.7\";s:3:\"tag\";s:5:\"8.7.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.7.tar.gz\";s:4:\"date\";s:10:\"1567593185\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.6\";s:7:\"version\";s:5:\"8.7.6\";s:3:\"tag\";s:5:\"8.7.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.6.tar.gz\";s:4:\"date\";s:10:\"1565206385\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.5\";s:7:\"version\";s:5:\"8.7.5\";s:3:\"tag\";s:5:\"8.7.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.5.tar.gz\";s:4:\"date\";s:10:\"1563380885\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.4\";s:7:\"version\";s:5:\"8.7.4\";s:3:\"tag\";s:5:\"8.7.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.4.tar.gz\";s:4:\"date\";s:10:\"1562225587\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.3\";s:7:\"version\";s:5:\"8.7.3\";s:3:\"tag\";s:5:\"8.7.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.3.tar.gz\";s:4:\"date\";s:10:\"1559762581\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.2\";s:7:\"version\";s:5:\"8.7.2\";s:3:\"tag\";s:5:\"8.7.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.2.tar.gz\";s:4:\"date\";s:10:\"1558597086\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.1\";s:7:\"version\";s:5:\"8.7.1\";s:3:\"tag\";s:5:\"8.7.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.1.tar.gz\";s:4:\"date\";s:10:\"1557335588\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.7.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.7.0\";s:7:\"version\";s:5:\"8.7.0\";s:3:\"tag\";s:5:\"8.7.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.7.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.7.0.tar.gz\";s:4:\"date\";s:10:\"1556737085\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.7.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.7.0-rc1\";s:7:\"version\";s:9:\"8.7.0-rc1\";s:3:\"tag\";s:9:\"8.7.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.7.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.7.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1555603385\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:4:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";i:3;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.7.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 8.7.0-beta2\";s:7:\"version\";s:11:\"8.7.0-beta2\";s:3:\"tag\";s:11:\"8.7.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.7.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.7.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1554684784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.7.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.7.0-beta1\";s:7:\"version\";s:11:\"8.7.0-beta1\";s:3:\"tag\";s:11:\"8.7.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.7.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.7.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1553881681\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.7.0-alpha2\";a:10:{s:4:\"name\";s:19:\"drupal 8.7.0-alpha2\";s:7:\"version\";s:12:\"8.7.0-alpha2\";s:3:\"tag\";s:12:\"8.7.0-alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.7.0-alpha2\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.7.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1553106180\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:12:\"8.7.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 8.7.0-alpha1\";s:7:\"version\";s:12:\"8.7.0-alpha1\";s:3:\"tag\";s:12:\"8.7.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.7.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.7.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1552602484\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"8.6.18\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.18\";s:7:\"version\";s:6:\"8.6.18\";s:3:\"tag\";s:6:\"8.6.18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.18\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.18.tar.gz\";s:4:\"date\";s:10:\"1573687985\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.17\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.17\";s:7:\"version\";s:6:\"8.6.17\";s:3:\"tag\";s:6:\"8.6.17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.17\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.17.tar.gz\";s:4:\"date\";s:10:\"1560756785\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.16\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.16\";s:7:\"version\";s:6:\"8.6.16\";s:3:\"tag\";s:6:\"8.6.16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.16\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.16.tar.gz\";s:4:\"date\";s:10:\"1557335588\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.15\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.15\";s:7:\"version\";s:6:\"8.6.15\";s:3:\"tag\";s:6:\"8.6.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.15\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.15.tar.gz\";s:4:\"date\";s:10:\"1555533181\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.14\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.14\";s:7:\"version\";s:6:\"8.6.14\";s:3:\"tag\";s:6:\"8.6.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.14.tar.gz\";s:4:\"date\";s:10:\"1554688384\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.13\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.13\";s:7:\"version\";s:6:\"8.6.13\";s:3:\"tag\";s:6:\"8.6.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.13.tar.gz\";s:4:\"date\";s:10:\"1553099584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.12\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.12\";s:7:\"version\";s:6:\"8.6.12\";s:3:\"tag\";s:6:\"8.6.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.12.tar.gz\";s:4:\"date\";s:10:\"1552601584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.11\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.11\";s:7:\"version\";s:6:\"8.6.11\";s:3:\"tag\";s:6:\"8.6.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.11.tar.gz\";s:4:\"date\";s:10:\"1552511584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.6.10\";a:10:{s:4:\"name\";s:13:\"drupal 8.6.10\";s:7:\"version\";s:6:\"8.6.10\";s:3:\"tag\";s:6:\"8.6.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.6.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.6.10.tar.gz\";s:4:\"date\";s:10:\"1550691784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.9\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.9\";s:7:\"version\";s:5:\"8.6.9\";s:3:\"tag\";s:5:\"8.6.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.9.tar.gz\";s:4:\"date\";s:10:\"1549628580\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.8\";s:7:\"version\";s:5:\"8.6.8\";s:3:\"tag\";s:5:\"8.6.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.8.tar.gz\";s:4:\"date\";s:10:\"1549466580\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.7\";s:7:\"version\";s:5:\"8.6.7\";s:3:\"tag\";s:5:\"8.6.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.7.tar.gz\";s:4:\"date\";s:10:\"1547682180\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.6\";s:7:\"version\";s:5:\"8.6.6\";s:3:\"tag\";s:5:\"8.6.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.6.tar.gz\";s:4:\"date\";s:10:\"1547663557\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.5\";s:7:\"version\";s:5:\"8.6.5\";s:3:\"tag\";s:5:\"8.6.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.5.tar.gz\";s:4:\"date\";s:10:\"1546467485\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.4\";s:7:\"version\";s:5:\"8.6.4\";s:3:\"tag\";s:5:\"8.6.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.4.tar.gz\";s:4:\"date\";s:10:\"1544011681\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.3\";s:7:\"version\";s:5:\"8.6.3\";s:3:\"tag\";s:5:\"8.6.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.3.tar.gz\";s:4:\"date\";s:10:\"1541602684\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.2\";s:7:\"version\";s:5:\"8.6.2\";s:3:\"tag\";s:5:\"8.6.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.2.tar.gz\";s:4:\"date\";s:10:\"1539816180\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.1\";s:7:\"version\";s:5:\"8.6.1\";s:3:\"tag\";s:5:\"8.6.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.1.tar.gz\";s:4:\"date\";s:10:\"1536585780\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.6.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.6.0\";s:7:\"version\";s:5:\"8.6.0\";s:3:\"tag\";s:5:\"8.6.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.6.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.6.0.tar.gz\";s:4:\"date\";s:10:\"1536186480\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.6.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.6.0-rc1\";s:7:\"version\";s:9:\"8.6.0-rc1\";s:3:\"tag\";s:9:\"8.6.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.6.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.6.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1534532580\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.6.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 8.6.0-beta2\";s:7:\"version\";s:11:\"8.6.0-beta2\";s:3:\"tag\";s:11:\"8.6.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.6.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.6.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1533298080\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.6.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.6.0-beta1\";s:7:\"version\";s:11:\"8.6.0-beta1\";s:3:\"tag\";s:11:\"8.6.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.6.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.6.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1533270485\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.6.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 8.6.0-alpha1\";s:7:\"version\";s:12:\"8.6.0-alpha1\";s:3:\"tag\";s:12:\"8.6.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.6.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.6.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1532033881\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:6:\"8.5.15\";a:10:{s:4:\"name\";s:13:\"drupal 8.5.15\";s:7:\"version\";s:6:\"8.5.15\";s:3:\"tag\";s:6:\"8.5.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.5.15\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.5.15.tar.gz\";s:4:\"date\";s:10:\"1555533181\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.5.14\";a:10:{s:4:\"name\";s:13:\"drupal 8.5.14\";s:7:\"version\";s:6:\"8.5.14\";s:3:\"tag\";s:6:\"8.5.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.5.14\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.5.14.tar.gz\";s:4:\"date\";s:10:\"1553099584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.5.13\";a:10:{s:4:\"name\";s:13:\"drupal 8.5.13\";s:7:\"version\";s:6:\"8.5.13\";s:3:\"tag\";s:6:\"8.5.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.5.13\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.5.13.tar.gz\";s:4:\"date\";s:10:\"1552601584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.5.12\";a:10:{s:4:\"name\";s:13:\"drupal 8.5.12\";s:7:\"version\";s:6:\"8.5.12\";s:3:\"tag\";s:6:\"8.5.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.5.12\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.5.12.tar.gz\";s:4:\"date\";s:10:\"1552511584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.5.11\";a:10:{s:4:\"name\";s:13:\"drupal 8.5.11\";s:7:\"version\";s:6:\"8.5.11\";s:3:\"tag\";s:6:\"8.5.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.5.11\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.5.11.tar.gz\";s:4:\"date\";s:10:\"1550691784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:6:\"8.5.10\";a:10:{s:4:\"name\";s:13:\"drupal 8.5.10\";s:7:\"version\";s:6:\"8.5.10\";s:3:\"tag\";s:6:\"8.5.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.5.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.5.10.tar.gz\";s:4:\"date\";s:10:\"1547682180\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.9\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.9\";s:7:\"version\";s:5:\"8.5.9\";s:3:\"tag\";s:5:\"8.5.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.9.tar.gz\";s:4:\"date\";s:10:\"1547663557\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.8\";s:7:\"version\";s:5:\"8.5.8\";s:3:\"tag\";s:5:\"8.5.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.8.tar.gz\";s:4:\"date\";s:10:\"1539816180\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.7\";s:7:\"version\";s:5:\"8.5.7\";s:3:\"tag\";s:5:\"8.5.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.7.tar.gz\";s:4:\"date\";s:10:\"1536187080\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.6\";s:7:\"version\";s:5:\"8.5.6\";s:3:\"tag\";s:5:\"8.5.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.6.tar.gz\";s:4:\"date\";s:10:\"1533156780\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.5\";s:7:\"version\";s:5:\"8.5.5\";s:3:\"tag\";s:5:\"8.5.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.5.tar.gz\";s:4:\"date\";s:10:\"1530738820\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.4\";s:7:\"version\";s:5:\"8.5.4\";s:3:\"tag\";s:5:\"8.5.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.4.tar.gz\";s:4:\"date\";s:10:\"1528319584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.3\";s:7:\"version\";s:5:\"8.5.3\";s:3:\"tag\";s:5:\"8.5.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.3.tar.gz\";s:4:\"date\";s:10:\"1524672780\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.2\";s:7:\"version\";s:5:\"8.5.2\";s:3:\"tag\";s:5:\"8.5.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.2.tar.gz\";s:4:\"date\";s:10:\"1524073147\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.1\";s:7:\"version\";s:5:\"8.5.1\";s:3:\"tag\";s:5:\"8.5.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.1.tar.gz\";s:4:\"date\";s:10:\"1522263480\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.5.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.5.0\";s:7:\"version\";s:5:\"8.5.0\";s:3:\"tag\";s:5:\"8.5.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.5.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.5.0.tar.gz\";s:4:\"date\";s:10:\"1520457780\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.5.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.5.0-rc1\";s:7:\"version\";s:9:\"8.5.0-rc1\";s:3:\"tag\";s:9:\"8.5.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.5.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.5.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1519234680\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:4:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";i:2;s:9:\"Bug fixes\";i:3;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.5.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.5.0-beta1\";s:7:\"version\";s:11:\"8.5.0-beta1\";s:3:\"tag\";s:11:\"8.5.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.5.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.5.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1518211380\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.5.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 8.5.0-alpha1\";s:7:\"version\";s:12:\"8.5.0-alpha1\";s:3:\"tag\";s:12:\"8.5.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.5.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.5.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1516320484\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:5:\"8.4.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.8\";s:7:\"version\";s:5:\"8.4.8\";s:3:\"tag\";s:5:\"8.4.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.8.tar.gz\";s:4:\"date\";s:10:\"1524672780\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.7\";s:7:\"version\";s:5:\"8.4.7\";s:3:\"tag\";s:5:\"8.4.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.7.tar.gz\";s:4:\"date\";s:10:\"1524073147\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.6\";s:7:\"version\";s:5:\"8.4.6\";s:3:\"tag\";s:5:\"8.4.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.6.tar.gz\";s:4:\"date\";s:10:\"1522263480\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.5\";s:7:\"version\";s:5:\"8.4.5\";s:3:\"tag\";s:5:\"8.4.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.5.tar.gz\";s:4:\"date\";s:10:\"1519234680\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.4\";s:7:\"version\";s:5:\"8.4.4\";s:3:\"tag\";s:5:\"8.4.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.4.tar.gz\";s:4:\"date\";s:10:\"1515021185\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.3\";s:7:\"version\";s:5:\"8.4.3\";s:3:\"tag\";s:5:\"8.4.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.3.tar.gz\";s:4:\"date\";s:10:\"1512600784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.2\";s:7:\"version\";s:5:\"8.4.2\";s:3:\"tag\";s:5:\"8.4.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.2.tar.gz\";s:4:\"date\";s:10:\"1509719885\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.1\";s:7:\"version\";s:5:\"8.4.1\";s:3:\"tag\";s:5:\"8.4.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.1.tar.gz\";s:4:\"date\";s:10:\"1509562384\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.4.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.4.0\";s:7:\"version\";s:5:\"8.4.0\";s:3:\"tag\";s:5:\"8.4.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.4.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.4.0.tar.gz\";s:4:\"date\";s:10:\"1507146244\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.4.0-rc2\";a:10:{s:4:\"name\";s:16:\"drupal 8.4.0-rc2\";s:7:\"version\";s:9:\"8.4.0-rc2\";s:3:\"tag\";s:9:\"8.4.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.4.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.4.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1505911444\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"8.4.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.4.0-rc1\";s:7:\"version\";s:9:\"8.4.0-rc1\";s:3:\"tag\";s:9:\"8.4.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.4.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.4.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1504733043\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.4.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.4.0-beta1\";s:7:\"version\";s:11:\"8.4.0-beta1\";s:3:\"tag\";s:11:\"8.4.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.4.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.4.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1502992144\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.4.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 8.4.0-alpha1\";s:7:\"version\";s:12:\"8.4.0-alpha1\";s:3:\"tag\";s:12:\"8.4.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.4.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.4.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1501790944\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:5:\"8.3.9\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.9\";s:7:\"version\";s:5:\"8.3.9\";s:3:\"tag\";s:5:\"8.3.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.9.tar.gz\";s:4:\"date\";s:10:\"1522263480\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.8\";s:7:\"version\";s:5:\"8.3.8\";s:3:\"tag\";s:5:\"8.3.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.8.tar.gz\";s:4:\"date\";s:10:\"1520881985\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";i:2;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.7\";s:7:\"version\";s:5:\"8.3.7\";s:3:\"tag\";s:5:\"8.3.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.7.tar.gz\";s:4:\"date\";s:10:\"1502903903\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.6\";s:7:\"version\";s:5:\"8.3.6\";s:3:\"tag\";s:5:\"8.3.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.6.tar.gz\";s:4:\"date\";s:10:\"1501688043\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.5\";s:7:\"version\";s:5:\"8.3.5\";s:3:\"tag\";s:5:\"8.3.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.5.tar.gz\";s:4:\"date\";s:10:\"1499274843\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.4\";s:7:\"version\";s:5:\"8.3.4\";s:3:\"tag\";s:5:\"8.3.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.4.tar.gz\";s:4:\"date\";s:10:\"1498069442\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.3\";s:7:\"version\";s:5:\"8.3.3\";s:3:\"tag\";s:5:\"8.3.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.3.tar.gz\";s:4:\"date\";s:10:\"1496858041\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.2\";s:7:\"version\";s:5:\"8.3.2\";s:3:\"tag\";s:5:\"8.3.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.2.tar.gz\";s:4:\"date\";s:10:\"1493834585\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.1\";s:7:\"version\";s:5:\"8.3.1\";s:3:\"tag\";s:5:\"8.3.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.1.tar.gz\";s:4:\"date\";s:10:\"1492622946\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.3.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.3.0\";s:7:\"version\";s:5:\"8.3.0\";s:3:\"tag\";s:5:\"8.3.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.3.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.3.0.tar.gz\";s:4:\"date\";s:10:\"1491439084\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.3.0-rc2\";a:10:{s:4:\"name\";s:16:\"drupal 8.3.0-rc2\";s:7:\"version\";s:9:\"8.3.0-rc2\";s:3:\"tag\";s:9:\"8.3.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.3.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.3.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1489613583\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"8.3.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.3.0-rc1\";s:7:\"version\";s:9:\"8.3.0-rc1\";s:3:\"tag\";s:9:\"8.3.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.3.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.3.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1488383284\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.3.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.3.0-beta1\";s:7:\"version\";s:11:\"8.3.0-beta1\";s:3:\"tag\";s:11:\"8.3.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.3.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.3.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1487175783\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.3.0-alpha1\";a:10:{s:4:\"name\";s:19:\"drupal 8.3.0-alpha1\";s:7:\"version\";s:12:\"8.3.0-alpha1\";s:3:\"tag\";s:12:\"8.3.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.3.0-alpha1\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.3.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1485968583\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:5:\"8.2.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.8\";s:7:\"version\";s:5:\"8.2.8\";s:3:\"tag\";s:5:\"8.2.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.8.tar.gz\";s:4:\"date\";s:10:\"1492622852\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.7\";s:7:\"version\";s:5:\"8.2.7\";s:3:\"tag\";s:5:\"8.2.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.7.tar.gz\";s:4:\"date\";s:10:\"1489609638\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.6\";s:7:\"version\";s:5:\"8.2.6\";s:3:\"tag\";s:5:\"8.2.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.6.tar.gz\";s:4:\"date\";s:10:\"1485975485\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.5\";s:7:\"version\";s:5:\"8.2.5\";s:3:\"tag\";s:5:\"8.2.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.5.tar.gz\";s:4:\"date\";s:10:\"1483529942\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.4\";s:7:\"version\";s:5:\"8.2.4\";s:3:\"tag\";s:5:\"8.2.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.4.tar.gz\";s:4:\"date\";s:10:\"1481136784\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.3\";s:7:\"version\";s:5:\"8.2.3\";s:3:\"tag\";s:5:\"8.2.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.3.tar.gz\";s:4:\"date\";s:10:\"1479322439\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.2\";s:7:\"version\";s:5:\"8.2.2\";s:3:\"tag\";s:5:\"8.2.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.2.tar.gz\";s:4:\"date\";s:10:\"1478106542\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.1\";s:7:\"version\";s:5:\"8.2.1\";s:3:\"tag\";s:5:\"8.2.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.1.tar.gz\";s:4:\"date\";s:10:\"1476181439\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.2.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.2.0\";s:7:\"version\";s:5:\"8.2.0\";s:3:\"tag\";s:5:\"8.2.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.2.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.2.0.tar.gz\";s:4:\"date\";s:10:\"1475660639\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.2.0-rc2\";a:10:{s:4:\"name\";s:16:\"drupal 8.2.0-rc2\";s:7:\"version\";s:9:\"8.2.0-rc2\";s:3:\"tag\";s:9:\"8.2.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.2.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.2.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1474484358\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"8.2.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.2.0-rc1\";s:7:\"version\";s:9:\"8.2.0-rc1\";s:3:\"tag\";s:9:\"8.2.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.2.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.2.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1473285089\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.2.0-beta3\";a:10:{s:4:\"name\";s:18:\"drupal 8.2.0-beta3\";s:7:\"version\";s:11:\"8.2.0-beta3\";s:3:\"tag\";s:11:\"8.2.0-beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.2.0-beta3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.2.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1472222475\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.2.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 8.2.0-beta2\";s:7:\"version\";s:11:\"8.2.0-beta2\";s:3:\"tag\";s:11:\"8.2.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.2.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.2.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1471710839\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.2.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.2.0-beta1\";s:7:\"version\";s:11:\"8.2.0-beta1\";s:3:\"tag\";s:11:\"8.2.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.2.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.2.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1470230639\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:6:\"8.1.10\";a:10:{s:4:\"name\";s:13:\"drupal 8.1.10\";s:7:\"version\";s:6:\"8.1.10\";s:3:\"tag\";s:6:\"8.1.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:53:\"https://www.drupal.org/project/drupal/releases/8.1.10\";s:13:\"download_link\";s:58:\"https://ftp.drupal.org/files/projects/drupal-8.1.10.tar.gz\";s:4:\"date\";s:10:\"1474478939\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.9\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.9\";s:7:\"version\";s:5:\"8.1.9\";s:3:\"tag\";s:5:\"8.1.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.9\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.9.tar.gz\";s:4:\"date\";s:10:\"1473276313\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.8\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.8\";s:7:\"version\";s:5:\"8.1.8\";s:3:\"tag\";s:5:\"8.1.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.8\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.8.tar.gz\";s:4:\"date\";s:10:\"1470233647\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.7\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.7\";s:7:\"version\";s:5:\"8.1.7\";s:3:\"tag\";s:5:\"8.1.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.7\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.7.tar.gz\";s:4:\"date\";s:10:\"1468855358\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.6\";s:7:\"version\";s:5:\"8.1.6\";s:3:\"tag\";s:5:\"8.1.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.6.tar.gz\";s:4:\"date\";s:10:\"1468242539\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.5\";s:7:\"version\";s:5:\"8.1.5\";s:3:\"tag\";s:5:\"8.1.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.5.tar.gz\";s:4:\"date\";s:10:\"1467884639\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.4\";s:7:\"version\";s:5:\"8.1.4\";s:3:\"tag\";s:5:\"8.1.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.4.tar.gz\";s:4:\"date\";s:10:\"1467810839\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.3\";s:7:\"version\";s:5:\"8.1.3\";s:3:\"tag\";s:5:\"8.1.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.3.tar.gz\";s:4:\"date\";s:10:\"1466021480\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.2\";s:7:\"version\";s:5:\"8.1.2\";s:3:\"tag\";s:5:\"8.1.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.2.tar.gz\";s:4:\"date\";s:10:\"1464824339\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.1\";s:7:\"version\";s:5:\"8.1.1\";s:3:\"tag\";s:5:\"8.1.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.1.tar.gz\";s:4:\"date\";s:10:\"1462361039\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.1.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.1.0\";s:7:\"version\";s:5:\"8.1.0\";s:3:\"tag\";s:5:\"8.1.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.1.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.1.0.tar.gz\";s:4:\"date\";s:10:\"1461118190\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.1.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.1.0-rc1\";s:7:\"version\";s:9:\"8.1.0-rc1\";s:3:\"tag\";s:9:\"8.1.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.1.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1459976639\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:11:\"8.1.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 8.1.0-beta2\";s:7:\"version\";s:11:\"8.1.0-beta2\";s:3:\"tag\";s:11:\"8.1.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.1.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1458699840\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.1.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.1.0-beta1\";s:7:\"version\";s:11:\"8.1.0-beta1\";s:3:\"tag\";s:11:\"8.1.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.1.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1456975758\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";i:2;s:12:\"New features\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:5:\"8.0.6\";a:10:{s:4:\"name\";s:12:\"drupal 8.0.6\";s:7:\"version\";s:5:\"8.0.6\";s:3:\"tag\";s:5:\"8.0.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.0.6\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.0.6.tar.gz\";s:4:\"date\";s:10:\"1459900439\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.0.5\";a:10:{s:4:\"name\";s:12:\"drupal 8.0.5\";s:7:\"version\";s:5:\"8.0.5\";s:3:\"tag\";s:5:\"8.0.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.0.5\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.0.5.tar.gz\";s:4:\"date\";s:10:\"1456914839\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.0.4\";a:10:{s:4:\"name\";s:12:\"drupal 8.0.4\";s:7:\"version\";s:5:\"8.0.4\";s:3:\"tag\";s:5:\"8.0.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.0.4\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.0.4.tar.gz\";s:4:\"date\";s:10:\"1456341749\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.0.3\";a:10:{s:4:\"name\";s:12:\"drupal 8.0.3\";s:7:\"version\";s:5:\"8.0.3\";s:3:\"tag\";s:5:\"8.0.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.0.3\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.0.3.tar.gz\";s:4:\"date\";s:10:\"1454489043\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.0.2\";a:10:{s:4:\"name\";s:12:\"drupal 8.0.2\";s:7:\"version\";s:5:\"8.0.2\";s:3:\"tag\";s:5:\"8.0.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.0.2\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.0.2.tar.gz\";s:4:\"date\";s:10:\"1452119939\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.0.1\";a:10:{s:4:\"name\";s:12:\"drupal 8.0.1\";s:7:\"version\";s:5:\"8.0.1\";s:3:\"tag\";s:5:\"8.0.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.0.1\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.0.1.tar.gz\";s:4:\"date\";s:10:\"1449066839\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:5:\"8.0.0\";a:10:{s:4:\"name\";s:12:\"drupal 8.0.0\";s:7:\"version\";s:5:\"8.0.0\";s:3:\"tag\";s:5:\"8.0.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:52:\"https://www.drupal.org/project/drupal/releases/8.0.0\";s:13:\"download_link\";s:57:\"https://ftp.drupal.org/files/projects/drupal-8.0.0.tar.gz\";s:4:\"date\";s:10:\"1447941840\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";}s:9:\"8.0.0-rc4\";a:10:{s:4:\"name\";s:16:\"drupal 8.0.0-rc4\";s:7:\"version\";s:9:\"8.0.0-rc4\";s:3:\"tag\";s:9:\"8.0.0-rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.0.0-rc4\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1447413840\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"8.0.0-rc3\";a:10:{s:4:\"name\";s:16:\"drupal 8.0.0-rc3\";s:7:\"version\";s:9:\"8.0.0-rc3\";s:3:\"tag\";s:9:\"8.0.0-rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.0.0-rc3\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1446633239\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"8.0.0-rc2\";a:10:{s:4:\"name\";s:16:\"drupal 8.0.0-rc2\";s:7:\"version\";s:9:\"8.0.0-rc2\";s:3:\"tag\";s:9:\"8.0.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.0.0-rc2\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1445468639\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:9:\"8.0.0-rc1\";a:10:{s:4:\"name\";s:16:\"drupal 8.0.0-rc1\";s:7:\"version\";s:9:\"8.0.0-rc1\";s:3:\"tag\";s:9:\"8.0.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.0.0-rc1\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1444253039\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";}s:12:\"8.0.0-beta16\";a:10:{s:4:\"name\";s:19:\"drupal 8.0.0-beta16\";s:7:\"version\";s:12:\"8.0.0-beta16\";s:3:\"tag\";s:12:\"8.0.0-beta16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta16\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta16.tar.gz\";s:4:\"date\";s:10:\"1443746640\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.0.0-beta15\";a:10:{s:4:\"name\";s:19:\"drupal 8.0.0-beta15\";s:7:\"version\";s:12:\"8.0.0-beta15\";s:3:\"tag\";s:12:\"8.0.0-beta15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta15\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta15.tar.gz\";s:4:\"date\";s:10:\"1441357140\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.0.0-beta14\";a:10:{s:4:\"name\";s:19:\"drupal 8.0.0-beta14\";s:7:\"version\";s:12:\"8.0.0-beta14\";s:3:\"tag\";s:12:\"8.0.0-beta14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta14\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta14.tar.gz\";s:4:\"date\";s:10:\"1438593539\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.0.0-beta13\";a:10:{s:4:\"name\";s:19:\"drupal 8.0.0-beta13\";s:7:\"version\";s:12:\"8.0.0-beta13\";s:3:\"tag\";s:12:\"8.0.0-beta13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta13\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta13.tar.gz\";s:4:\"date\";s:10:\"1438194539\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.0.0-beta12\";a:10:{s:4:\"name\";s:19:\"drupal 8.0.0-beta12\";s:7:\"version\";s:12:\"8.0.0-beta12\";s:3:\"tag\";s:12:\"8.0.0-beta12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta12\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta12.tar.gz\";s:4:\"date\";s:10:\"1435601583\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.0.0-beta11\";a:10:{s:4:\"name\";s:19:\"drupal 8.0.0-beta11\";s:7:\"version\";s:12:\"8.0.0-beta11\";s:3:\"tag\";s:12:\"8.0.0-beta11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta11\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta11.tar.gz\";s:4:\"date\";s:10:\"1432758481\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:12:\"8.0.0-beta10\";a:10:{s:4:\"name\";s:19:\"drupal 8.0.0-beta10\";s:7:\"version\";s:12:\"8.0.0-beta10\";s:3:\"tag\";s:12:\"8.0.0-beta10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta10\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta10.tar.gz\";s:4:\"date\";s:10:\"1430314681\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.0.0-beta9\";a:10:{s:4:\"name\";s:18:\"drupal 8.0.0-beta9\";s:7:\"version\";s:11:\"8.0.0-beta9\";s:3:\"tag\";s:11:\"8.0.0-beta9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta9\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta9.tar.gz\";s:4:\"date\";s:10:\"1427299981\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.0.0-beta7\";a:10:{s:4:\"name\";s:18:\"drupal 8.0.0-beta7\";s:7:\"version\";s:11:\"8.0.0-beta7\";s:3:\"tag\";s:11:\"8.0.0-beta7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta7\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta7.tar.gz\";s:4:\"date\";s:10:\"1424875381\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.0.0-beta6\";a:10:{s:4:\"name\";s:18:\"drupal 8.0.0-beta6\";s:7:\"version\";s:11:\"8.0.0-beta6\";s:3:\"tag\";s:11:\"8.0.0-beta6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta6\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta6.tar.gz\";s:4:\"date\";s:10:\"1422443800\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.0.0-beta4\";a:10:{s:4:\"name\";s:18:\"drupal 8.0.0-beta4\";s:7:\"version\";s:11:\"8.0.0-beta4\";s:3:\"tag\";s:11:\"8.0.0-beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta4\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1418825280\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.0.0-beta3\";a:10:{s:4:\"name\";s:18:\"drupal 8.0.0-beta3\";s:7:\"version\";s:11:\"8.0.0-beta3\";s:3:\"tag\";s:11:\"8.0.0-beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1415797380\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.0.0-beta2\";a:10:{s:4:\"name\";s:18:\"drupal 8.0.0-beta2\";s:7:\"version\";s:11:\"8.0.0-beta2\";s:3:\"tag\";s:11:\"8.0.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1413394161\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:8:\"Insecure\";i:1;s:15:\"Security update\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:11:\"8.0.0-beta1\";a:10:{s:4:\"name\";s:18:\"drupal 8.0.0-beta1\";s:7:\"version\";s:11:\"8.0.0-beta1\";s:3:\"tag\";s:11:\"8.0.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0.0-beta1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1412147030\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";}s:13:\"8.0.0-alpha15\";a:10:{s:4:\"name\";s:20:\"drupal 8.0.0-alpha15\";s:7:\"version\";s:13:\"8.0.0-alpha15\";s:3:\"tag\";s:13:\"8.0.0-alpha15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/8.0.0-alpha15\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-alpha15.tar.gz\";s:4:\"date\";s:10:\"1411139628\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:13:\"8.0.0-alpha14\";a:10:{s:4:\"name\";s:20:\"drupal 8.0.0-alpha14\";s:7:\"version\";s:13:\"8.0.0-alpha14\";s:3:\"tag\";s:13:\"8.0.0-alpha14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:60:\"https://www.drupal.org/project/drupal/releases/8.0.0-alpha14\";s:13:\"download_link\";s:65:\"https://ftp.drupal.org/files/projects/drupal-8.0.0-alpha14.tar.gz\";s:4:\"date\";s:10:\"1407344628\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"8.0-alpha13\";a:10:{s:4:\"name\";s:18:\"drupal 8.0-alpha13\";s:7:\"version\";s:11:\"8.0-alpha13\";s:3:\"tag\";s:11:\"8.0-alpha13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0-alpha13\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha13.tar.gz\";s:4:\"date\";s:10:\"1404296627\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"8.0-alpha12\";a:10:{s:4:\"name\";s:18:\"drupal 8.0-alpha12\";s:7:\"version\";s:11:\"8.0-alpha12\";s:3:\"tag\";s:11:\"8.0-alpha12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0-alpha12\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha12.tar.gz\";s:4:\"date\";s:10:\"1401293627\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"8.0-alpha11\";a:10:{s:4:\"name\";s:18:\"drupal 8.0-alpha11\";s:7:\"version\";s:11:\"8.0-alpha11\";s:3:\"tag\";s:11:\"8.0-alpha11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0-alpha11\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha11.tar.gz\";s:4:\"date\";s:10:\"1398249227\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:11:\"8.0-alpha10\";a:10:{s:4:\"name\";s:18:\"drupal 8.0-alpha10\";s:7:\"version\";s:11:\"8.0-alpha10\";s:3:\"tag\";s:11:\"8.0-alpha10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/drupal/releases/8.0-alpha10\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha10.tar.gz\";s:4:\"date\";s:10:\"1395231556\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha9\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha9\";s:7:\"version\";s:10:\"8.0-alpha9\";s:3:\"tag\";s:10:\"8.0-alpha9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha9\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha9.tar.gz\";s:4:\"date\";s:10:\"1392806005\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:12:\"New features\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha8\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha8\";s:7:\"version\";s:10:\"8.0-alpha8\";s:3:\"tag\";s:10:\"8.0-alpha8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha8\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha8.tar.gz\";s:4:\"date\";s:10:\"1390393105\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha7\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha7\";s:7:\"version\";s:10:\"8.0-alpha7\";s:3:\"tag\";s:10:\"8.0-alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha7\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1387399705\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha6\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha6\";s:7:\"version\";s:10:\"8.0-alpha6\";s:3:\"tag\";s:10:\"8.0-alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha6\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1385153305\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha5\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha5\";s:7:\"version\";s:10:\"8.0-alpha5\";s:3:\"tag\";s:10:\"8.0-alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha5\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1384850305\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha4\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha4\";s:7:\"version\";s:10:\"8.0-alpha4\";s:3:\"tag\";s:10:\"8.0-alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha4\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1382092313\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha3\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha3\";s:7:\"version\";s:10:\"8.0-alpha3\";s:3:\"tag\";s:10:\"8.0-alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha3\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1378303307\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:12:\"New features\";i:1;s:9:\"Bug fixes\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"8.0-alpha2\";a:10:{s:4:\"name\";s:17:\"drupal 8.0-alpha2\";s:7:\"version\";s:10:\"8.0-alpha2\";s:3:\"tag\";s:10:\"8.0-alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/8.0-alpha2\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-8.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1372069563\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";}s:10:\"11.3.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 11.3.x-dev\";s:7:\"version\";s:10:\"11.3.x-dev\";s:3:\"tag\";s:6:\"11.3.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.3.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1767690569\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"11.2.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 11.2.x-dev\";s:7:\"version\";s:10:\"11.2.x-dev\";s:3:\"tag\";s:6:\"11.2.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.2.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1765361254\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"11.1.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 11.1.x-dev\";s:7:\"version\";s:10:\"11.1.x-dev\";s:3:\"tag\";s:6:\"11.1.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.1.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1763014588\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"11.0.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 11.0.x-dev\";s:7:\"version\";s:10:\"11.0.x-dev\";s:3:\"tag\";s:6:\"11.0.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/11.0.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-11.0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1746485552\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:8:\"11.x-dev\";a:10:{s:4:\"name\";s:15:\"drupal 11.x-dev\";s:7:\"version\";s:8:\"11.x-dev\";s:3:\"tag\";s:4:\"11.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:55:\"https://www.drupal.org/project/drupal/releases/11.x-dev\";s:13:\"download_link\";s:60:\"https://ftp.drupal.org/files/projects/drupal-11.x-dev.tar.gz\";s:4:\"date\";s:10:\"1767690928\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:10:\"10.6.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 10.6.x-dev\";s:7:\"version\";s:10:\"10.6.x-dev\";s:3:\"tag\";s:6:\"10.6.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.6.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.6.x-dev.tar.gz\";s:4:\"date\";s:10:\"1767272184\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"10.5.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 10.5.x-dev\";s:7:\"version\";s:10:\"10.5.x-dev\";s:3:\"tag\";s:6:\"10.5.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.5.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.5.x-dev.tar.gz\";s:4:\"date\";s:10:\"1765310830\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"10.4.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 10.4.x-dev\";s:7:\"version\";s:10:\"10.4.x-dev\";s:3:\"tag\";s:6:\"10.4.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.4.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.4.x-dev.tar.gz\";s:4:\"date\";s:10:\"1765304411\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"10.3.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 10.3.x-dev\";s:7:\"version\";s:10:\"10.3.x-dev\";s:3:\"tag\";s:6:\"10.3.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.3.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1738800218\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"10.2.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 10.2.x-dev\";s:7:\"version\";s:10:\"10.2.x-dev\";s:3:\"tag\";s:6:\"10.2.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.2.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1732287023\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"10.1.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 10.1.x-dev\";s:7:\"version\";s:10:\"10.1.x-dev\";s:3:\"tag\";s:6:\"10.1.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.1.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1713001795\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:10:\"10.0.x-dev\";a:10:{s:4:\"name\";s:17:\"drupal 10.0.x-dev\";s:7:\"version\";s:10:\"10.0.x-dev\";s:3:\"tag\";s:6:\"10.0.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:57:\"https://www.drupal.org/project/drupal/releases/10.0.x-dev\";s:13:\"download_link\";s:62:\"https://ftp.drupal.org/files/projects/drupal-10.0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1696930730\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:9:\"9.5.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 9.5.x-dev\";s:7:\"version\";s:9:\"9.5.x-dev\";s:3:\"tag\";s:5:\"9.5.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.5.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.5.x-dev.tar.gz\";s:4:\"date\";s:10:\"1701801362\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"9.4.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 9.4.x-dev\";s:7:\"version\";s:9:\"9.4.x-dev\";s:3:\"tag\";s:5:\"9.4.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.4.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.4.x-dev.tar.gz\";s:4:\"date\";s:10:\"1683123227\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"9.3.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 9.3.x-dev\";s:7:\"version\";s:9:\"9.3.x-dev\";s:3:\"tag\";s:5:\"9.3.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.3.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1664385919\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:9:\"9.2.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 9.2.x-dev\";s:7:\"version\";s:9:\"9.2.x-dev\";s:3:\"tag\";s:5:\"9.2.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.2.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1654891907\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"9.1.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 9.1.x-dev\";s:7:\"version\";s:9:\"9.1.x-dev\";s:3:\"tag\";s:5:\"9.1.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.1.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1637766277\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"9.0.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 9.0.x-dev\";s:7:\"version\";s:9:\"9.0.x-dev\";s:3:\"tag\";s:5:\"9.0.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/9.0.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-9.0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1622063424\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"8.9.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.9.x-dev\";s:7:\"version\";s:9:\"8.9.x-dev\";s:3:\"tag\";s:5:\"8.9.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.9.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.9.x-dev.tar.gz\";s:4:\"date\";s:10:\"1637188625\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"8.8.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.8.x-dev\";s:7:\"version\";s:9:\"8.8.x-dev\";s:3:\"tag\";s:5:\"8.8.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.8.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.8.x-dev.tar.gz\";s:4:\"date\";s:10:\"1606364994\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"8.7.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.7.x-dev\";s:7:\"version\";s:9:\"8.7.x-dev\";s:3:\"tag\";s:5:\"8.7.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.7.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.7.x-dev.tar.gz\";s:4:\"date\";s:10:\"1589987612\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"8.6.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.6.x-dev\";s:7:\"version\";s:9:\"8.6.x-dev\";s:3:\"tag\";s:5:\"8.6.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.6.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.6.x-dev.tar.gz\";s:4:\"date\";s:10:\"1573687985\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}s:9:\"8.5.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.5.x-dev\";s:7:\"version\";s:9:\"8.5.x-dev\";s:3:\"tag\";s:5:\"8.5.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.5.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.5.x-dev.tar.gz\";s:4:\"date\";s:10:\"1555533181\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:9:\"8.4.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.4.x-dev\";s:7:\"version\";s:9:\"8.4.x-dev\";s:3:\"tag\";s:5:\"8.4.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.4.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.4.x-dev.tar.gz\";s:4:\"date\";s:10:\"1533047880\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:9:\"8.3.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.3.x-dev\";s:7:\"version\";s:9:\"8.3.x-dev\";s:3:\"tag\";s:5:\"8.3.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.3.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.3.x-dev.tar.gz\";s:4:\"date\";s:10:\"1522263480\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:9:\"8.2.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.2.x-dev\";s:7:\"version\";s:9:\"8.2.x-dev\";s:3:\"tag\";s:5:\"8.2.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.2.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.2.x-dev.tar.gz\";s:4:\"date\";s:10:\"1492624982\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:9:\"8.1.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.1.x-dev\";s:7:\"version\";s:9:\"8.1.x-dev\";s:3:\"tag\";s:5:\"8.1.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.1.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1474478393\";s:5:\"files\";s:0:\"\";s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:5:\"terms\";a:0:{}}s:9:\"8.0.x-dev\";a:10:{s:4:\"name\";s:16:\"drupal 8.0.x-dev\";s:7:\"version\";s:9:\"8.0.x-dev\";s:3:\"tag\";s:5:\"8.0.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:56:\"https://www.drupal.org/project/drupal/releases/8.0.x-dev\";s:13:\"download_link\";s:61:\"https://ftp.drupal.org/files/projects/drupal-8.0.x-dev.tar.gz\";s:4:\"date\";s:10:\"1459900439\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";}}s:10:\"last_fetch\";i:1767711786;}",
  'expire' => '1767798186',
))
->values(array(
  'collection' => 'update_available_releases',
  'name' => 'search_api',
  'value' => "a:10:{s:5:\"title\";s:10:\"Search API\";s:10:\"short_name\";s:10:\"search_api\";s:4:\"type\";s:14:\"project_module\";s:18:\"supported_branches\";s:6:\"8.x-1.\";s:18:\"composer_namespace\";s:17:\"drupal/search_api\";s:14:\"project_status\";s:9:\"published\";s:4:\"link\";s:41:\"https://www.drupal.org/project/search_api\";s:5:\"terms\";s:0:\"\";s:8:\"releases\";a:68:{s:8:\"8.x-1.40\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.40\";s:7:\"version\";s:8:\"8.x-1.40\";s:3:\"tag\";s:8:\"8.x-1.40\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.40\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.40.tar.gz\";s:4:\"date\";s:10:\"1762030914\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.3 || ^11\";}s:8:\"8.x-1.39\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.39\";s:7:\"version\";s:8:\"8.x-1.39\";s:3:\"tag\";s:8:\"8.x-1.39\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.39\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.39.tar.gz\";s:4:\"date\";s:10:\"1758968162\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.3 || ^11\";}s:8:\"8.x-1.38\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.38\";s:7:\"version\";s:8:\"8.x-1.38\";s:3:\"tag\";s:8:\"8.x-1.38\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.38\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.38.tar.gz\";s:4:\"date\";s:10:\"1740298961\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.2 || ^11\";}s:8:\"8.x-1.37\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.37\";s:7:\"version\";s:8:\"8.x-1.37\";s:3:\"tag\";s:8:\"8.x-1.37\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.37\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.37.tar.gz\";s:4:\"date\";s:10:\"1732727356\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.2 || ^11\";}s:8:\"8.x-1.36\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.36\";s:7:\"version\";s:8:\"8.x-1.36\";s:3:\"tag\";s:8:\"8.x-1.36\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.36\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.36.tar.gz\";s:4:\"date\";s:10:\"1732448767\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.2 || ^11\";}s:8:\"8.x-1.35\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.35\";s:7:\"version\";s:8:\"8.x-1.35\";s:3:\"tag\";s:8:\"8.x-1.35\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.35\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.35.tar.gz\";s:4:\"date\";s:10:\"1718551025\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.1 || ^11\";}s:8:\"8.x-1.34\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.34\";s:7:\"version\";s:8:\"8.x-1.34\";s:3:\"tag\";s:8:\"8.x-1.34\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.34\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.34.tar.gz\";s:4:\"date\";s:10:\"1712400445\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.1 || ^11\";}s:8:\"8.x-1.33\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.33\";s:7:\"version\";s:8:\"8.x-1.33\";s:3:\"tag\";s:8:\"8.x-1.33\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.33\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.33.tar.gz\";s:4:\"date\";s:10:\"1712242225\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.1 || ^11\";}s:8:\"8.x-1.32\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.32\";s:7:\"version\";s:8:\"8.x-1.32\";s:3:\"tag\";s:8:\"8.x-1.32\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.32\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.32.tar.gz\";s:4:\"date\";s:10:\"1711906241\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:12:\"^10.1 || ^11\";}s:8:\"8.x-1.31\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.31\";s:7:\"version\";s:8:\"8.x-1.31\";s:3:\"tag\";s:8:\"8.x-1.31\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.31\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.31.tar.gz\";s:4:\"date\";s:10:\"1700926323\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:5:\"^10.0\";}s:8:\"8.x-1.30\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.30\";s:7:\"version\";s:8:\"8.x-1.30\";s:3:\"tag\";s:8:\"8.x-1.30\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.30\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.30.tar.gz\";s:4:\"date\";s:10:\"1697366291\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.3 || ^10.0\";}s:8:\"8.x-1.29\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.29\";s:7:\"version\";s:8:\"8.x-1.29\";s:3:\"tag\";s:8:\"8.x-1.29\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.29\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.29.tar.gz\";s:4:\"date\";s:10:\"1679910191\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.3 || ^10.0\";}s:8:\"8.x-1.28\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.28\";s:7:\"version\";s:8:\"8.x-1.28\";s:3:\"tag\";s:8:\"8.x-1.28\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.28\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.28.tar.gz\";s:4:\"date\";s:10:\"1667814116\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:1:{i:0;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.3 || ^10.0\";}s:8:\"8.x-1.27\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.27\";s:7:\"version\";s:8:\"8.x-1.27\";s:3:\"tag\";s:8:\"8.x-1.27\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.27\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.27.tar.gz\";s:4:\"date\";s:10:\"1666181440\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.3 || ^10.0\";}s:8:\"8.x-1.26\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.26\";s:7:\"version\";s:8:\"8.x-1.26\";s:3:\"tag\";s:8:\"8.x-1.26\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.26\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.26.tar.gz\";s:4:\"date\";s:10:\"1664974911\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.3 || ^10.0\";}s:8:\"8.x-1.25\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.25\";s:7:\"version\";s:8:\"8.x-1.25\";s:3:\"tag\";s:8:\"8.x-1.25\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.25\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.25.tar.gz\";s:4:\"date\";s:10:\"1658149514\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.2 || ^10.0\";}s:8:\"8.x-1.24\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.24\";s:7:\"version\";s:8:\"8.x-1.24\";s:3:\"tag\";s:8:\"8.x-1.24\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.24\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.24.tar.gz\";s:4:\"date\";s:10:\"1657180584\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:13:\"^9.2 || ^10.0\";}s:8:\"8.x-1.23\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.23\";s:7:\"version\";s:8:\"8.x-1.23\";s:3:\"tag\";s:8:\"8.x-1.23\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.23\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.23.tar.gz\";s:4:\"date\";s:10:\"1642769872\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:10:\"^8.8 || ^9\";}s:8:\"8.x-1.22\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.22\";s:7:\"version\";s:8:\"8.x-1.22\";s:3:\"tag\";s:8:\"8.x-1.22\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.22\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.22.tar.gz\";s:4:\"date\";s:10:\"1641998566\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:10:\"^8.8 || ^9\";}s:8:\"8.x-1.21\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.21\";s:7:\"version\";s:8:\"8.x-1.21\";s:3:\"tag\";s:8:\"8.x-1.21\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.21\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.21.tar.gz\";s:4:\"date\";s:10:\"1636024667\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:10:\"^8.8 || ^9\";}s:8:\"8.x-1.20\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.20\";s:7:\"version\";s:8:\"8.x-1.20\";s:3:\"tag\";s:8:\"8.x-1.20\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.20\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.20.tar.gz\";s:4:\"date\";s:10:\"1626684847\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:10:\"^8.8 || ^9\";}s:8:\"8.x-1.19\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.19\";s:7:\"version\";s:8:\"8.x-1.19\";s:3:\"tag\";s:8:\"8.x-1.19\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.19\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.19.tar.gz\";s:4:\"date\";s:10:\"1612192040\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:10:\"^8.8 || ^9\";}s:8:\"8.x-1.18\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.18\";s:7:\"version\";s:8:\"8.x-1.18\";s:3:\"tag\";s:8:\"8.x-1.18\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.18\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.18.tar.gz\";s:4:\"date\";s:10:\"1603359374\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:10:\"^8.8 || ^9\";}s:8:\"8.x-1.17\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.17\";s:7:\"version\";s:8:\"8.x-1.17\";s:3:\"tag\";s:8:\"8.x-1.17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.17\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.17.tar.gz\";s:4:\"date\";s:10:\"1591128369\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:10:\"^8.8 || ^9\";}s:8:\"8.x-1.16\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.16\";s:7:\"version\";s:8:\"8.x-1.16\";s:3:\"tag\";s:8:\"8.x-1.16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.16\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.16.tar.gz\";s:4:\"date\";s:10:\"1586374699\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:8:\"8.x-1.15\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.15\";s:7:\"version\";s:8:\"8.x-1.15\";s:3:\"tag\";s:8:\"8.x-1.15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.15\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.15.tar.gz\";s:4:\"date\";s:10:\"1573122785\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:8:\"8.x-1.14\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.14\";s:7:\"version\";s:8:\"8.x-1.14\";s:3:\"tag\";s:8:\"8.x-1.14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.14\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.14.tar.gz\";s:4:\"date\";s:10:\"1562599986\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:8:\"8.x-1.13\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.13\";s:7:\"version\";s:8:\"8.x-1.13\";s:3:\"tag\";s:8:\"8.x-1.13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.13\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.13.tar.gz\";s:4:\"date\";s:10:\"1557244685\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:8:\"8.x-1.12\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.12\";s:7:\"version\";s:8:\"8.x-1.12\";s:3:\"tag\";s:8:\"8.x-1.12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.12\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.12.tar.gz\";s:4:\"date\";s:10:\"1552334285\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:8:\"8.x-1.11\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.11\";s:7:\"version\";s:8:\"8.x-1.11\";s:3:\"tag\";s:8:\"8.x-1.11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.11\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.11.tar.gz\";s:4:\"date\";s:10:\"1542564480\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:8:\"8.x-1.10\";a:11:{s:4:\"name\";s:19:\"search_api 8.x-1.10\";s:7:\"version\";s:8:\"8.x-1.10\";s:3:\"tag\";s:8:\"8.x-1.10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:59:\"https://www.drupal.org/project/search_api/releases/8.x-1.10\";s:13:\"download_link\";s:64:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.10.tar.gz\";s:4:\"date\";s:10:\"1537175280\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.9\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.9\";s:7:\"version\";s:7:\"8.x-1.9\";s:3:\"tag\";s:7:\"8.x-1.9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.9\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.9.tar.gz\";s:4:\"date\";s:10:\"1531985581\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.8\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.8\";s:7:\"version\";s:7:\"8.x-1.8\";s:3:\"tag\";s:7:\"8.x-1.8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.8\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.8.tar.gz\";s:4:\"date\";s:10:\"1523872384\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.7\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.7\";s:7:\"version\";s:7:\"8.x-1.7\";s:3:\"tag\";s:7:\"8.x-1.7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.7\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.7.tar.gz\";s:4:\"date\";s:10:\"1519387684\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.6\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.6\";s:7:\"version\";s:7:\"8.x-1.6\";s:3:\"tag\";s:7:\"8.x-1.6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.6\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.6.tar.gz\";s:4:\"date\";s:10:\"1514109785\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.5\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.5\";s:7:\"version\";s:7:\"8.x-1.5\";s:3:\"tag\";s:7:\"8.x-1.5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.5\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.5.tar.gz\";s:4:\"date\";s:10:\"1507989244\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.4\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.4\";s:7:\"version\";s:7:\"8.x-1.4\";s:3:\"tag\";s:7:\"8.x-1.4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.4\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.4.tar.gz\";s:4:\"date\";s:10:\"1504799343\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.3\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.3\";s:7:\"version\";s:7:\"8.x-1.3\";s:3:\"tag\";s:7:\"8.x-1.3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.3\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.3.tar.gz\";s:4:\"date\";s:10:\"1500483242\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.2\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.2\";s:7:\"version\";s:7:\"8.x-1.2\";s:3:\"tag\";s:7:\"8.x-1.2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.2\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.2.tar.gz\";s:4:\"date\";s:10:\"1498403342\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.1\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.1\";s:7:\"version\";s:7:\"8.x-1.1\";s:3:\"tag\";s:7:\"8.x-1.1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.1\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.1.tar.gz\";s:4:\"date\";s:10:\"1494413585\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:7:\"8.x-1.0\";a:11:{s:4:\"name\";s:18:\"search_api 8.x-1.0\";s:7:\"version\";s:7:\"8.x-1.0\";s:3:\"tag\";s:7:\"8.x-1.0\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:58:\"https://www.drupal.org/project/search_api/releases/8.x-1.0\";s:13:\"download_link\";s:63:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0.tar.gz\";s:4:\"date\";s:10:\"1493201342\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:44:\"Covered by Drupal's security advisory policy\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:11:\"8.x-1.0-rc4\";a:11:{s:4:\"name\";s:22:\"search_api 8.x-1.0-rc4\";s:7:\"version\";s:11:\"8.x-1.0-rc4\";s:3:\"tag\";s:11:\"8.x-1.0-rc4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-rc4\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-rc4.tar.gz\";s:4:\"date\";s:10:\"1492764844\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:11:\"8.x-1.0-rc3\";a:11:{s:4:\"name\";s:22:\"search_api 8.x-1.0-rc3\";s:7:\"version\";s:11:\"8.x-1.0-rc3\";s:3:\"tag\";s:11:\"8.x-1.0-rc3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-rc3\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-rc3.tar.gz\";s:4:\"date\";s:10:\"1492677545\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:11:\"8.x-1.0-rc2\";a:11:{s:4:\"name\";s:22:\"search_api 8.x-1.0-rc2\";s:7:\"version\";s:11:\"8.x-1.0-rc2\";s:3:\"tag\";s:11:\"8.x-1.0-rc2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-rc2\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-rc2.tar.gz\";s:4:\"date\";s:10:\"1491843242\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:11:\"8.x-1.0-rc1\";a:11:{s:4:\"name\";s:22:\"search_api 8.x-1.0-rc1\";s:7:\"version\";s:11:\"8.x-1.0-rc1\";s:3:\"tag\";s:11:\"8.x-1.0-rc1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-rc1\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-rc1.tar.gz\";s:4:\"date\";s:10:\"1491764883\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:58:\"RC releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:13:\"8.x-1.0-beta5\";a:11:{s:4:\"name\";s:24:\"search_api 8.x-1.0-beta5\";s:7:\"version\";s:13:\"8.x-1.0-beta5\";s:3:\"tag\";s:13:\"8.x-1.0-beta5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-beta5\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-beta5.tar.gz\";s:4:\"date\";s:10:\"1491153783\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:13:\"8.x-1.0-beta4\";a:11:{s:4:\"name\";s:24:\"search_api 8.x-1.0-beta4\";s:7:\"version\";s:13:\"8.x-1.0-beta4\";s:3:\"tag\";s:13:\"8.x-1.0-beta4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-beta4\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-beta4.tar.gz\";s:4:\"date\";s:10:\"1483286941\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:13:\"8.x-1.0-beta3\";a:11:{s:4:\"name\";s:24:\"search_api 8.x-1.0-beta3\";s:7:\"version\";s:13:\"8.x-1.0-beta3\";s:3:\"tag\";s:13:\"8.x-1.0-beta3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-beta3\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-beta3.tar.gz\";s:4:\"date\";s:10:\"1477302541\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:13:\"8.x-1.0-beta2\";a:11:{s:4:\"name\";s:24:\"search_api 8.x-1.0-beta2\";s:7:\"version\";s:13:\"8.x-1.0-beta2\";s:3:\"tag\";s:13:\"8.x-1.0-beta2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-beta2\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-beta2.tar.gz\";s:4:\"date\";s:10:\"1475059139\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:13:\"8.x-1.0-beta1\";a:11:{s:4:\"name\";s:24:\"search_api 8.x-1.0-beta1\";s:7:\"version\";s:13:\"8.x-1.0-beta1\";s:3:\"tag\";s:13:\"8.x-1.0-beta1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:64:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-beta1\";s:13:\"download_link\";s:69:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-beta1.tar.gz\";s:4:\"date\";s:10:\"1473092339\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:60:\"Beta releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha17\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha17\";s:7:\"version\";s:15:\"8.x-1.0-alpha17\";s:3:\"tag\";s:15:\"8.x-1.0-alpha17\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha17\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha17.tar.gz\";s:4:\"date\";s:10:\"1472120490\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha16\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha16\";s:7:\"version\";s:15:\"8.x-1.0-alpha16\";s:3:\"tag\";s:15:\"8.x-1.0-alpha16\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha16\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha16.tar.gz\";s:4:\"date\";s:10:\"1467810839\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha15\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha15\";s:7:\"version\";s:15:\"8.x-1.0-alpha15\";s:3:\"tag\";s:15:\"8.x-1.0-alpha15\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha15\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha15.tar.gz\";s:4:\"date\";s:10:\"1463990939\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha14\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha14\";s:7:\"version\";s:15:\"8.x-1.0-alpha14\";s:3:\"tag\";s:15:\"8.x-1.0-alpha14\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha14\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha14.tar.gz\";s:4:\"date\";s:10:\"1461155939\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:15:\"Security update\";i:1;s:9:\"Bug fixes\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha13\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha13\";s:7:\"version\";s:15:\"8.x-1.0-alpha13\";s:3:\"tag\";s:15:\"8.x-1.0-alpha13\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha13\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha13.tar.gz\";s:4:\"date\";s:10:\"1460028239\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha12\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha12\";s:7:\"version\";s:15:\"8.x-1.0-alpha12\";s:3:\"tag\";s:15:\"8.x-1.0-alpha12\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha12\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha12.tar.gz\";s:4:\"date\";s:10:\"1453904040\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha11\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha11\";s:7:\"version\";s:15:\"8.x-1.0-alpha11\";s:3:\"tag\";s:15:\"8.x-1.0-alpha11\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha11\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha11.tar.gz\";s:4:\"date\";s:10:\"1451396939\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:15:\"8.x-1.0-alpha10\";a:11:{s:4:\"name\";s:26:\"search_api 8.x-1.0-alpha10\";s:7:\"version\";s:15:\"8.x-1.0-alpha10\";s:3:\"tag\";s:15:\"8.x-1.0-alpha10\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:66:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha10\";s:13:\"download_link\";s:71:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha10.tar.gz\";s:4:\"date\";s:10:\"1449072539\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha9\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha9\";s:7:\"version\";s:14:\"8.x-1.0-alpha9\";s:3:\"tag\";s:14:\"8.x-1.0-alpha9\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha9\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha9.tar.gz\";s:4:\"date\";s:10:\"1441882739\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha8\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha8\";s:7:\"version\";s:14:\"8.x-1.0-alpha8\";s:3:\"tag\";s:14:\"8.x-1.0-alpha8\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha8\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha8.tar.gz\";s:4:\"date\";s:10:\"1439824439\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha7\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha7\";s:7:\"version\";s:14:\"8.x-1.0-alpha7\";s:3:\"tag\";s:14:\"8.x-1.0-alpha7\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha7\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha7.tar.gz\";s:4:\"date\";s:10:\"1436513351\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha6\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha6\";s:7:\"version\";s:14:\"8.x-1.0-alpha6\";s:3:\"tag\";s:14:\"8.x-1.0-alpha6\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha6\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha6.tar.gz\";s:4:\"date\";s:10:\"1435299182\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha5\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha5\";s:7:\"version\";s:14:\"8.x-1.0-alpha5\";s:3:\"tag\";s:14:\"8.x-1.0-alpha5\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha5\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha5.tar.gz\";s:4:\"date\";s:10:\"1433224381\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha4\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha4\";s:7:\"version\";s:14:\"8.x-1.0-alpha4\";s:3:\"tag\";s:14:\"8.x-1.0-alpha4\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha4\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha4.tar.gz\";s:4:\"date\";s:10:\"1432543981\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha3\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha3\";s:7:\"version\";s:14:\"8.x-1.0-alpha3\";s:3:\"tag\";s:14:\"8.x-1.0-alpha3\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha3\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha3.tar.gz\";s:4:\"date\";s:10:\"1428386881\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha2\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha2\";s:7:\"version\";s:14:\"8.x-1.0-alpha2\";s:3:\"tag\";s:14:\"8.x-1.0-alpha2\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha2\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha2.tar.gz\";s:4:\"date\";s:10:\"1426611015\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:14:\"8.x-1.0-alpha1\";a:11:{s:4:\"name\";s:25:\"search_api 8.x-1.0-alpha1\";s:7:\"version\";s:14:\"8.x-1.0-alpha1\";s:3:\"tag\";s:14:\"8.x-1.0-alpha1\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:65:\"https://www.drupal.org/project/search_api/releases/8.x-1.0-alpha1\";s:13:\"download_link\";s:70:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.0-alpha1.tar.gz\";s:4:\"date\";s:10:\"1417615680\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:3:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";i:2;s:8:\"Insecure\";}}s:8:\"security\";s:61:\"Alpha releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:3:\"8.x\";}s:11:\"8.x-1.x-dev\";a:11:{s:4:\"name\";s:22:\"search_api 8.x-1.x-dev\";s:7:\"version\";s:11:\"8.x-1.x-dev\";s:3:\"tag\";s:7:\"8.x-1.x\";s:6:\"status\";s:9:\"published\";s:12:\"release_link\";s:62:\"https://www.drupal.org/project/search_api/releases/8.x-1.x-dev\";s:13:\"download_link\";s:67:\"https://ftp.drupal.org/files/projects/search_api-8.x-1.x-dev.tar.gz\";s:4:\"date\";s:10:\"1766438430\";s:5:\"files\";s:0:\"\";s:5:\"terms\";a:1:{s:12:\"Release type\";a:2:{i:0;s:9:\"Bug fixes\";i:1;s:12:\"New features\";}}s:8:\"security\";s:59:\"Dev releases are not covered by Drupal security advisories.\";s:18:\"core_compatibility\";s:12:\"^10.3 || ^11\";}}s:10:\"last_fetch\";i:1767714984;}",
  'expire' => '1767801384',
))
->execute();
$connection->schema()->createTable('menu_tree', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'id' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
    'parent' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'route_name' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
    'route_param_key' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'route_parameters' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'url' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'description' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'class' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'options' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'provider' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '50',
      'default' => 'system',
    ),
    'enabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '1',
    ),
    'discovered' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'metadata' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'form_class' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'unique keys' => array(
    'id' => array(
      'id',
    ),
  ),
  'indexes' => array(
    'menu_parents' => array(
      'menu_name',
      'p1',
      'p2',
      'p3',
      'p4',
      'p5',
      'p6',
      'p7',
      'p8',
      'p9',
    ),
    'menu_parent_expand_child' => array(
      'menu_name',
      'expanded',
      'has_children',
      array(
        'parent',
        '16',
      ),
    ),
    'route_values' => array(
      array(
        'route_name',
        '32',
      ),
      array(
        'route_param_key',
        '16',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('menu_tree')
->fields(array(
  'menu_name',
  'mlid',
  'id',
  'parent',
  'route_name',
  'route_param_key',
  'route_parameters',
  'url',
  'title',
  'description',
  'class',
  'options',
  'provider',
  'enabled',
  'discovered',
  'expanded',
  'weight',
  'metadata',
  'has_children',
  'depth',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'form_class',
))
->values(array(
  'menu_name' => 'tools',
  'mlid' => '1',
  'id' => 'filter.tips_all',
  'parent' => '',
  'route_name' => 'filter.tips_all',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Compose tips";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 's:0:"";',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'filter',
  'enabled' => '0',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'tools',
  'mlid' => '2',
  'id' => 'node.add_page',
  'parent' => '',
  'route_name' => 'node.add_page',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Add content";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 's:0:"";',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'node',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '3',
  'id' => 'system.admin',
  'parent' => '',
  'route_name' => 'system.admin',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"Administration";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 's:0:"";',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '9',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '1',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '4',
  'id' => 'system.admin_content',
  'parent' => 'system.admin',
  'route_name' => 'system.admin_content',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:24:"Find and manage content.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '2',
  'p1' => '3',
  'p2' => '4',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '5',
  'id' => 'system.admin_structure',
  'parent' => 'system.admin',
  'route_name' => 'system.admin_structure',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Structure";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:45:"Administer blocks, content types, menus, etc.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '2',
  'p1' => '3',
  'p2' => '5',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '6',
  'id' => 'block.admin_display',
  'parent' => 'system.admin_structure',
  'route_name' => 'block.admin_display',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Block layout";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => "O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}",
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'block',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '5',
  'p3' => '6',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '7',
  'id' => 'entity.node_type.collection',
  'parent' => 'system.admin_structure',
  'route_name' => 'entity.node_type.collection',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Content types";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:71:"Create and manage fields, forms, and display settings for your content.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'node',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '5',
  'p3' => '7',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '8',
  'id' => 'system.themes_page',
  'parent' => 'system.admin',
  'route_name' => 'system.themes_page',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:10:"Appearance";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:28:"Select and configure themes.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-6',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '2',
  'p1' => '3',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '9',
  'id' => 'system.modules_list',
  'parent' => 'system.admin',
  'route_name' => 'system.modules_list',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Extend";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:52:"Add and enable modules to extend site functionality.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-2',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '2',
  'p1' => '3',
  'p2' => '9',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '10',
  'id' => 'system.admin_config',
  'parent' => 'system.admin',
  'route_name' => 'system.admin_config',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"Administer settings.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '2',
  'p1' => '3',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '11',
  'id' => 'system.admin_config_media',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_media',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Media";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 's:0:"";',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '11',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '12',
  'id' => 'system.file_system_settings',
  'parent' => 'system.admin_config_media',
  'route_name' => 'system.file_system_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"File system";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:67:"Configure the location of uploaded files and how they are accessed.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '11',
  'p4' => '12',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '13',
  'id' => 'system.image_toolkit_settings',
  'parent' => 'system.admin_config_media',
  'route_name' => 'system.image_toolkit_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Image toolkit";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '20',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '11',
  'p4' => '13',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '14',
  'id' => 'system.admin_config_services',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_services',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Web services";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 's:0:"";',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '14',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '15',
  'id' => 'system.rss_feeds_settings',
  'parent' => 'system.admin_config_services',
  'route_name' => 'system.rss_feeds_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"RSS publishing";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:115:"Configure the site description, the number of items per feed, and whether feeds should be titles/teasers/full-text.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '14',
  'p4' => '15',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '16',
  'id' => 'system.linkset_settings',
  'parent' => 'system.admin_config_services',
  'route_name' => 'system.linkset_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:21:"Menu Linkset Settings";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:43:"Enable or disable the menu linkset endpoint";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '10',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '14',
  'p4' => '16',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '17',
  'id' => 'system.admin_config_development',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_development',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Development";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:36:"Configure and use development tools.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '17',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '18',
  'id' => 'system.site_maintenance_mode',
  'parent' => 'system.admin_config_development',
  'route_name' => 'system.site_maintenance_mode',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Maintenance mode";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:62:"Take the site offline for updates and other maintenance tasks.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '17',
  'p4' => '18',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '19',
  'id' => 'system.performance_settings',
  'parent' => 'system.admin_config_development',
  'route_name' => 'system.performance_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Performance";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:45:"Configure caching and bandwidth optimization.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '17',
  'p4' => '19',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '20',
  'id' => 'system.development_settings',
  'parent' => 'system.admin_config_development',
  'route_name' => 'system.development_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"Development settings";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:36:"Configure theme development settings";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-19',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '17',
  'p4' => '20',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '21',
  'id' => 'system.logging_settings',
  'parent' => 'system.admin_config_development',
  'route_name' => 'system.logging_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:18:"Logging and errors";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:61:"Configure the display of error messages and database logging.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '17',
  'p4' => '21',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '22',
  'id' => 'system.admin_config_regional',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_regional',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Region and language";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:59:"Configure regional settings, localization, and translation.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '22',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '23',
  'id' => 'system.regional_settings',
  'parent' => 'system.admin_config_regional',
  'route_name' => 'system.regional_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:17:"Regional settings";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:43:"Configure the locale and timezone settings.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '22',
  'p4' => '23',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '24',
  'id' => 'entity.date_format.collection',
  'parent' => 'system.admin_config_regional',
  'route_name' => 'entity.date_format.collection',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:21:"Date and time formats";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:44:"Configure how dates and times are displayed.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-9',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '22',
  'p4' => '24',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '25',
  'id' => 'system.admin_config_search',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_search',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Search and metadata";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:64:"Configure site search, metadata, and search engine optimization.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '25',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '26',
  'id' => 'system.admin_config_system',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_system',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"System";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:49:"Configure basic site settings, actions, and cron.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '26',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '27',
  'id' => 'system.site_information_settings',
  'parent' => 'system.admin_config_system',
  'route_name' => 'system.site_information_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Basic site settings";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:77:"Change site name, email address, slogan, default front page, and error pages.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '26',
  'p4' => '27',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '28',
  'id' => 'system.cron_settings',
  'parent' => 'system.admin_config_system',
  'route_name' => 'system.cron_settings',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"Cron";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:40:"Manage automatic site maintenance tasks.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '20',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '26',
  'p4' => '28',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '29',
  'id' => 'system.admin_config_ui',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_ui',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:14:"User interface";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:44:"Configure the administrative user interface.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '29',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '30',
  'id' => 'system.admin_config_workflow',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_workflow',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"Workflow";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:28:"Manage the content workflow.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '5',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '30',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '31',
  'id' => 'system.admin_config_content',
  'parent' => 'system.admin_config',
  'route_name' => 'system.admin_config_content',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:17:"Content authoring";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:43:"Configure content formatting and authoring.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '31',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '32',
  'id' => 'filter.admin_overview',
  'parent' => 'system.admin_config_content',
  'route_name' => 'filter.admin_overview',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Text formats";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:125:"Configure how content is filtered when displayed, including which HTML tags are rendered, and enable module-provided filters.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'filter',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '31',
  'p4' => '32',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '33',
  'id' => 'user.admin_index',
  'parent' => 'system.admin_config',
  'route_name' => 'user.admin_index',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"People";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:24:"Configure user accounts.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'user',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '3',
  'p1' => '3',
  'p2' => '10',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '34',
  'id' => 'entity.user.admin_form',
  'parent' => 'user.admin_index',
  'route_name' => 'entity.user.admin_form',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Account settings";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:105:"Configure default user account settings, including fields, registration requirements, and email messages.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'user',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '33',
  'p4' => '34',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '35',
  'id' => 'system.admin_reports',
  'parent' => 'system.admin',
  'route_name' => 'system.admin_reports',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Reports";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"View reports, updates, and errors.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '5',
  'metadata' => 'a:0:{}',
  'has_children' => '1',
  'depth' => '2',
  'p1' => '3',
  'p2' => '35',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '36',
  'id' => 'dblog.overview',
  'parent' => 'system.admin_reports',
  'route_name' => 'dblog.overview',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Recent log messages";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:43:"View events that have recently been logged.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'dblog',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-1',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '35',
  'p3' => '36',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '37',
  'id' => 'dblog.page_not_found',
  'parent' => 'system.admin_reports',
  'route_name' => 'dblog.page_not_found',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => "O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:27:\"Top 'page not found' errors\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}",
  'description' => "O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:36:\"View 'page not found' errors (404s).\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}",
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'dblog',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '35',
  'p3' => '37',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '38',
  'id' => 'dblog.access_denied',
  'parent' => 'system.admin_reports',
  'route_name' => 'dblog.access_denied',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => "O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:26:\"Top 'access denied' errors\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}",
  'description' => "O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:35:\"View 'access denied' errors (403s).\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}",
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'dblog',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '35',
  'p3' => '38',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '39',
  'id' => 'system.status',
  'parent' => 'system.admin_reports',
  'route_name' => 'system.status',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Status report";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => "O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:48:\"Get a status report about your site's operation.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}",
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'system',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-60',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '35',
  'p3' => '39',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '40',
  'id' => 'update.status',
  'parent' => 'system.admin_reports',
  'route_name' => 'update.status',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:17:"Available updates";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:82:"Get a status report about available updates for your installed modules and themes.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'update',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-50',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '35',
  'p3' => '40',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '41',
  'id' => 'entity.user.collection',
  'parent' => 'system.admin',
  'route_name' => 'entity.user.collection',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"People";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:45:"Manage user accounts, roles, and permissions.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'user',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '4',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '2',
  'p1' => '3',
  'p2' => '41',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'account',
  'mlid' => '42',
  'id' => 'user.page',
  'parent' => '',
  'route_name' => 'user.page',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:10:"My account";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 's:0:"";',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'user',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '42',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'account',
  'mlid' => '43',
  'id' => 'user.logout',
  'parent' => '',
  'route_name' => '',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 's:0:"";',
  'description' => 's:0:"";',
  'class' => 'Drupal\user\Plugin\Menu\LoginLogoutMenuLink',
  'options' => 'a:0:{}',
  'provider' => 'user',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '10',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '43',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '44',
  'id' => 'search_api.overview',
  'parent' => 'system.admin_config_search',
  'route_name' => 'search_api.overview',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:10:"Search API";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:48:"Create and configure search indexes and servers.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'search_api',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '4',
  'p1' => '3',
  'p2' => '10',
  'p3' => '25',
  'p4' => '44',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '45',
  'id' => 'entity.view.collection',
  'parent' => 'system.admin_structure',
  'route_name' => 'entity.view.collection',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Views";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:35:"Manage customized lists of content.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'views_ui',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '5',
  'p3' => '45',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'admin',
  'mlid' => '46',
  'id' => 'views_ui.reports_plugins',
  'parent' => 'system.admin_reports',
  'route_name' => 'views_ui.reports_plugins',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Views plugins";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'description' => 'O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:38:"Overview of plugins used in all views.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}',
  'class' => 'Drupal\Core\Menu\MenuLinkDefault',
  'options' => 'a:0:{}',
  'provider' => 'views_ui',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:0:{}',
  'has_children' => '0',
  'depth' => '3',
  'p1' => '3',
  'p2' => '35',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\Core\Menu\Form\MenuLinkDefaultForm',
))
->values(array(
  'menu_name' => 'main',
  'mlid' => '52',
  'id' => 'views_view:views.view_search_colorful_organization.page_search',
  'parent' => '',
  'route_name' => 'view.view_search_colorful_organization.page_search',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 's:35:"View: Search: Colorful organization";',
  'description' => 's:0:"";',
  'class' => 'Drupal\views\Plugin\Menu\ViewsMenuLink',
  'options' => 'a:0:{}',
  'provider' => 'views',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:2:{s:7:"view_id";s:33:"view_search_colorful_organization";s:10:"display_id";s:11:"page_search";}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '52',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\views\Plugin\Menu\Form\ViewsMenuLinkForm',
))
->values(array(
  'menu_name' => 'main',
  'mlid' => '53',
  'id' => 'views_view:views.view_search_drab_feather.page_query',
  'parent' => '',
  'route_name' => 'view.view_search_drab_feather.page_query',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 's:26:"View: Search: Drab feather";',
  'description' => 's:0:"";',
  'class' => 'Drupal\views\Plugin\Menu\ViewsMenuLink',
  'options' => 'a:0:{}',
  'provider' => 'views',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:2:{s:7:"view_id";s:24:"view_search_drab_feather";s:10:"display_id";s:10:"page_query";}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '53',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\views\Plugin\Menu\Form\ViewsMenuLinkForm',
))
->values(array(
  'menu_name' => 'main',
  'mlid' => '54',
  'id' => 'views_view:views.view_search_parched_arithmetic.page_rummage',
  'parent' => '',
  'route_name' => 'view.view_search_parched_arithmetic.page_rummage',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 's:32:"View: Search: Parched arithmetic";',
  'description' => 's:0:"";',
  'class' => 'Drupal\views\Plugin\Menu\ViewsMenuLink',
  'options' => 'a:0:{}',
  'provider' => 'views',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:2:{s:7:"view_id";s:30:"view_search_parched_arithmetic";s:10:"display_id";s:12:"page_rummage";}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '54',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\views\Plugin\Menu\Form\ViewsMenuLinkForm',
))
->values(array(
  'menu_name' => 'main',
  'mlid' => '55',
  'id' => 'views_view:views.view_search_robust_discussion.page_explore',
  'parent' => '',
  'route_name' => 'view.view_search_robust_discussion.page_explore',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 's:31:"View: Search: Robust discussion";',
  'description' => 's:0:"";',
  'class' => 'Drupal\views\Plugin\Menu\ViewsMenuLink',
  'options' => 'a:0:{}',
  'provider' => 'views',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:2:{s:7:"view_id";s:29:"view_search_robust_discussion";s:10:"display_id";s:12:"page_explore";}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '55',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\views\Plugin\Menu\Form\ViewsMenuLinkForm',
))
->values(array(
  'menu_name' => 'main',
  'mlid' => '56',
  'id' => 'views_view:views.view_search_yummy_lettuce.page_seek',
  'parent' => '',
  'route_name' => 'view.view_search_yummy_lettuce.page_seek',
  'route_param_key' => '',
  'route_parameters' => 'a:0:{}',
  'url' => '',
  'title' => 's:27:"View: Search: Yummy lettuce";',
  'description' => 's:0:"";',
  'class' => 'Drupal\views\Plugin\Menu\ViewsMenuLink',
  'options' => 'a:0:{}',
  'provider' => 'views',
  'enabled' => '1',
  'discovered' => '1',
  'expanded' => '0',
  'weight' => '0',
  'metadata' => 'a:2:{s:7:"view_id";s:25:"view_search_yummy_lettuce";s:10:"display_id";s:9:"page_seek";}',
  'has_children' => '0',
  'depth' => '1',
  'p1' => '56',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'form_class' => 'Drupal\views\Plugin\Menu\Form\ViewsMenuLinkForm',
))
->execute();
$connection->schema()->createTable('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'unique keys' => array(
    'node_field__uuid__value' => array(
      'uuid',
    ),
    'node__vid' => array(
      'vid',
    ),
  ),
  'indexes' => array(
    'node_field__type__target_id' => array(
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('node__body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'fallback' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'realm' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_update' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_delete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
    'langcode',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('node_access')
->fields(array(
  'nid',
  'langcode',
  'fallback',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'langcode' => '',
  'fallback' => '1',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();
$connection->schema()->createTable('node_field_data', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'nid',
    'langcode',
  ),
  'indexes' => array(
    'node__id__default_langcode__langcode' => array(
      'nid',
      'default_langcode',
      'langcode',
    ),
    'node__vid' => array(
      'vid',
    ),
    'node_field__type__target_id' => array(
      'type',
    ),
    'node_field__uid__target_id' => array(
      'uid',
    ),
    'node_field__created' => array(
      'created',
    ),
    'node_field__changed' => array(
      'changed',
    ),
    'node__status_type' => array(
      'status',
      'type',
      'nid',
    ),
    'node__frontpage' => array(
      'promote',
      'status',
      'sticky',
      'created',
    ),
    'node__title_type' => array(
      array(
        'title',
        '191',
      ),
      array(
        'type',
        '4',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('node_field_revision', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'vid',
    'langcode',
  ),
  'indexes' => array(
    'node__id__default_langcode__langcode' => array(
      'nid',
      'default_langcode',
      'langcode',
    ),
    'node_field__uid__target_id' => array(
      'uid',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('node_revision', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'revision_uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_timestamp' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'revision_log' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'revision_default' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'node__nid' => array(
      'nid',
    ),
    'node_field__langcode' => array(
      'langcode',
    ),
    'node_field__revision_uid__target_id' => array(
      'revision_uid',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('node_revision__body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('path_alias', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'path' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'alias' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'unique keys' => array(
    'path_alias_field__uuid__value' => array(
      'uuid',
    ),
    'path_alias__revision_id' => array(
      'revision_id',
    ),
  ),
  'indexes' => array(
    'path_alias__alias_langcode_id_status' => array(
      array(
        'alias',
        '191',
      ),
      'langcode',
      'id',
      'status',
    ),
    'path_alias__path_langcode_id_status' => array(
      array(
        'path',
        '191',
      ),
      'langcode',
      'id',
      'status',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('path_alias_revision', array(
  'fields' => array(
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'path' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'alias' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_default' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'revision_id',
  ),
  'indexes' => array(
    'path_alias__id' => array(
      'id',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('queue', array(
  'fields' => array(
    'item_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'item_id',
  ),
  'indexes' => array(
    'name_created' => array(
      'name',
      'created',
    ),
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('router', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'pattern_outline' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'route' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'indexes' => array(
    'pattern_outline_parts' => array(
      array(
        'pattern_outline',
        '191',
      ),
      'number_parts',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('router')
->fields(array(
  'name',
  'path',
  'pattern_outline',
  'fit',
  'route',
  'number_parts',
))
->values(array(
  'name' => '<button>',
  'path' => '/',
  'pattern_outline' => '/',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => '<current>',
  'path' => '/<current>',
  'pattern_outline' => '/<current>',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:10:"/<current>";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:0:{}s:7:"options";a:2:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:19:"{^/\<current\>$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/<current>";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:10:"/<current>";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => '<front>',
  'path' => '/',
  'pattern_outline' => '/',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:6:"_title";s:4:"Home";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => '<nolink>',
  'path' => '/',
  'pattern_outline' => '/',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => '<none>',
  'path' => '/',
  'pattern_outline' => '/',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => 'block.admin_add',
  'path' => '/admin/structure/block/add/{plugin_id}/{theme}',
  'pattern_outline' => '/admin/structure/block/add/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:46:"/admin/structure/block/add/{plugin_id}/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:66:"\Drupal\block\Controller\BlockAddController::blockAddConfigureForm";s:5:"theme";N;s:6:"_title";s:15:"Configure block";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:9:"plugin_id";i:1;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:78:"{^/admin/structure/block/add/(?P<plugin_id>[^/]++)(?:/(?P<theme>[^/]++))?$}sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"plugin_id";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/structure/block/add";}}s:9:"path_vars";a:2:{i:0;s:9:"plugin_id";i:1;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:28:"/admin/structure/block/add/%";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'block.admin_demo',
  'path' => '/admin/structure/block/demo/{theme}',
  'pattern_outline' => '/admin/structure/block/demo/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:35:"/admin/structure/block/demo/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:46:"\Drupal\block\Controller\BlockController::demo";s:15:"_title_callback";s:21:"theme_handler:getName";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:12:"_admin_route";b:0;s:4:"utf8";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"{^/admin/structure/block/demo/(?P<theme>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/block/demo";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:29:"/admin/structure/block/demo/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'block.admin_display',
  'path' => '/admin/structure/block',
  'pattern_outline' => '/admin/structure/block',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/admin/structure/block";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:53:"\Drupal\block\Controller\BlockListController::listing";s:6:"_title";s:12:"Block layout";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/structure/block$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/structure/block";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/structure/block";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'block.admin_display_theme',
  'path' => '/admin/structure/block/list/{theme}',
  'pattern_outline' => '/admin/structure/block/list/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:35:"/admin/structure/block/list/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:53:"\Drupal\block\Controller\BlockListController::listing";s:6:"_title";s:12:"Block layout";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"{^/admin/structure/block/list/(?P<theme>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/block/list";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:29:"/admin/structure/block/list/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'block.admin_library',
  'path' => '/admin/structure/block/library/{theme}',
  'pattern_outline' => '/admin/structure/block/library/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:38:"/admin/structure/block/library/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:59:"\Drupal\block\Controller\BlockLibraryController::listBlocks";s:6:"_title";s:11:"Place block";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:55:"{^/admin/structure/block/library/(?P<theme>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:30:"/admin/structure/block/library";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:32:"/admin/structure/block/library/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'block.category_autocomplete',
  'path' => '/block-category/autocomplete',
  'pattern_outline' => '/block-category/autocomplete',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:28:"/block-category/autocomplete";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:69:"\Drupal\block\Controller\CategoryAutocompleteController::autocomplete";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/block\-category/autocomplete$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/block-category/autocomplete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:28:"/block-category/autocomplete";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'dblog.access_denied',
  'path' => '/admin/reports/access-denied',
  'pattern_outline' => '/admin/reports/access-denied',
  'fit' => '7',
  'route' => "O:31:\"Symfony\\Component\\Routing\\Route\":9:{s:4:\"path\";s:28:\"/admin/reports/access-denied\";s:4:\"host\";s:0:\"\";s:8:\"defaults\";a:3:{s:6:\"_title\";s:26:\"Top 'access denied' errors\";s:11:\"_controller\";s:56:\"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages\";s:4:\"type\";s:13:\"access denied\";}s:12:\"requirements\";a:1:{s:11:\"_permission\";s:19:\"access site reports\";}s:7:\"options\";a:4:{s:14:\"compiler_class\";s:33:\"Drupal\\Core\\Routing\\RouteCompiler\";s:4:\"utf8\";b:1;s:12:\"_admin_route\";b:1;s:14:\"_access_checks\";a:1:{i:0;s:23:\"access_check.permission\";}}s:7:\"schemes\";a:0:{}s:7:\"methods\";a:2:{i:0;s:3:\"GET\";i:1;s:4:\"POST\";}s:9:\"condition\";s:0:\"\";s:8:\"compiled\";O:33:\"Drupal\\Core\\Routing\\CompiledRoute\":11:{s:4:\"vars\";a:0:{}s:11:\"path_prefix\";s:0:\"\";s:10:\"path_regex\";s:36:\"{^/admin/reports/access\\-denied\$}sDu\";s:11:\"path_tokens\";a:1:{i:0;a:2:{i:0;s:4:\"text\";i:1;s:28:\"/admin/reports/access-denied\";}}s:9:\"path_vars\";a:0:{}s:10:\"host_regex\";N;s:11:\"host_tokens\";a:0:{}s:9:\"host_vars\";a:0:{}s:3:\"fit\";i:7;s:14:\"patternOutline\";s:28:\"/admin/reports/access-denied\";s:8:\"numParts\";i:3;}}",
  'number_parts' => '3',
))
->values(array(
  'name' => 'dblog.confirm',
  'path' => '/admin/reports/dblog/confirm',
  'pattern_outline' => '/admin/reports/dblog/confirm',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:28:"/admin/reports/dblog/confirm";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:43:"\Drupal\dblog\Form\DblogClearLogConfirmForm";s:6:"_title";s:34:"Confirm delete recent log messages";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:35:"{^/admin/reports/dblog/confirm$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/admin/reports/dblog/confirm";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:28:"/admin/reports/dblog/confirm";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'dblog.event',
  'path' => '/admin/reports/dblog/event/{event_id}',
  'pattern_outline' => '/admin/reports/dblog/event/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:37:"/admin/reports/dblog/event/{event_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:54:"\Drupal\dblog\Controller\DbLogController::eventDetails";s:6:"_title";s:7:"Details";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:8:"event_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"{^/admin/reports/dblog/event/(?P<event_id>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:8:"event_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/reports/dblog/event";}}s:9:"path_vars";a:1:{i:0;s:8:"event_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:28:"/admin/reports/dblog/event/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'dblog.overview',
  'path' => '/admin/reports/dblog',
  'pattern_outline' => '/admin/reports/dblog',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:20:"/admin/reports/dblog";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:50:"\Drupal\dblog\Controller\DbLogController::overview";s:6:"_title";s:19:"Recent log messages";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:27:"{^/admin/reports/dblog$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/reports/dblog";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:20:"/admin/reports/dblog";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'dblog.page_not_found',
  'path' => '/admin/reports/page-not-found',
  'pattern_outline' => '/admin/reports/page-not-found',
  'fit' => '7',
  'route' => "O:31:\"Symfony\\Component\\Routing\\Route\":9:{s:4:\"path\";s:29:\"/admin/reports/page-not-found\";s:4:\"host\";s:0:\"\";s:8:\"defaults\";a:3:{s:6:\"_title\";s:27:\"Top 'page not found' errors\";s:11:\"_controller\";s:56:\"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages\";s:4:\"type\";s:14:\"page not found\";}s:12:\"requirements\";a:1:{s:11:\"_permission\";s:19:\"access site reports\";}s:7:\"options\";a:4:{s:14:\"compiler_class\";s:33:\"Drupal\\Core\\Routing\\RouteCompiler\";s:4:\"utf8\";b:1;s:12:\"_admin_route\";b:1;s:14:\"_access_checks\";a:1:{i:0;s:23:\"access_check.permission\";}}s:7:\"schemes\";a:0:{}s:7:\"methods\";a:2:{i:0;s:3:\"GET\";i:1;s:4:\"POST\";}s:9:\"condition\";s:0:\"\";s:8:\"compiled\";O:33:\"Drupal\\Core\\Routing\\CompiledRoute\":11:{s:4:\"vars\";a:0:{}s:11:\"path_prefix\";s:0:\"\";s:10:\"path_regex\";s:38:\"{^/admin/reports/page\\-not\\-found\$}sDu\";s:11:\"path_tokens\";a:1:{i:0;a:2:{i:0;s:4:\"text\";i:1;s:29:\"/admin/reports/page-not-found\";}}s:9:\"path_vars\";a:0:{}s:10:\"host_regex\";N;s:11:\"host_tokens\";a:0:{}s:9:\"host_vars\";a:0:{}s:3:\"fit\";i:7;s:14:\"patternOutline\";s:29:\"/admin/reports/page-not-found\";s:8:\"numParts\";i:3;}}",
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.block.delete_form',
  'path' => '/admin/structure/block/manage/{block}/delete',
  'pattern_outline' => '/admin/structure/block/manage/%/delete',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:44:"/admin/structure/block/manage/{block}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:12:"block.delete";s:6:"_title";s:12:"Remove block";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:61:"{^/admin/structure/block/manage/(?P<block>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:38:"/admin/structure/block/manage/%/delete";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.block.disable',
  'path' => '/admin/structure/block/manage/{block}/disable',
  'pattern_outline' => '/admin/structure/block/manage/%/disable',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:45:"/admin/structure/block/manage/{block}/disable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:58:"\Drupal\block\Controller\BlockController::performOperation";s:2:"op";s:7:"disable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:13:"block.disable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:62:"{^/admin/structure/block/manage/(?P<block>[^/]++)/disable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/disable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:39:"/admin/structure/block/manage/%/disable";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.block.edit_form',
  'path' => '/admin/structure/block/manage/{block}',
  'pattern_outline' => '/admin/structure/block/manage/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:37:"/admin/structure/block/manage/{block}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:13:"block.default";s:6:"_title";s:15:"Configure block";}s:12:"requirements";a:1:{s:14:"_entity_access";s:12:"block.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"{^/admin/structure/block/manage/(?P<block>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:31:"/admin/structure/block/manage/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'entity.block.enable',
  'path' => '/admin/structure/block/manage/{block}/enable',
  'pattern_outline' => '/admin/structure/block/manage/%/enable',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:44:"/admin/structure/block/manage/{block}/enable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:58:"\Drupal\block\Controller\BlockController::performOperation";s:2:"op";s:6:"enable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:12:"block.enable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:61:"{^/admin/structure/block/manage/(?P<block>[^/]++)/enable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/enable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:38:"/admin/structure/block/manage/%/enable";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.date_format.collection',
  'path' => '/admin/config/regional/date-time',
  'pattern_outline' => '/admin/config/regional/date-time',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:32:"/admin/config/regional/date-time";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:11:"date_format";s:6:"_title";s:21:"Date and time formats";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"{^/admin/config/regional/date\-time$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:32:"/admin/config/regional/date-time";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:32:"/admin/config/regional/date-time";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'entity.date_format.delete_form',
  'path' => '/admin/config/regional/date-time/formats/manage/{date_format}/delete',
  'pattern_outline' => '/admin/config/regional/date-time/formats/manage/%/delete',
  'fit' => '253',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:68:"/admin/config/regional/date-time/formats/manage/{date_format}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:18:"date_format.delete";s:6:"_title";s:18:"Delete date format";}s:12:"requirements";a:1:{s:14:"_entity_access";s:18:"date_format.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:11:"date_format";a:2:{s:4:"type";s:18:"entity:date_format";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:11:"date_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:86:"{^/admin/config/regional/date\-time/formats/manage/(?P<date_format>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"date_format";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:47:"/admin/config/regional/date-time/formats/manage";}}s:9:"path_vars";a:1:{i:0;s:11:"date_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:253;s:14:"patternOutline";s:56:"/admin/config/regional/date-time/formats/manage/%/delete";s:8:"numParts";i:8;}}',
  'number_parts' => '8',
))
->values(array(
  'name' => 'entity.date_format.edit_form',
  'path' => '/admin/config/regional/date-time/formats/manage/{date_format}',
  'pattern_outline' => '/admin/config/regional/date-time/formats/manage/%',
  'fit' => '126',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:61:"/admin/config/regional/date-time/formats/manage/{date_format}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:16:"date_format.edit";s:6:"_title";s:16:"Edit date format";}s:12:"requirements";a:1:{s:14:"_entity_access";s:18:"date_format.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:11:"date_format";a:2:{s:4:"type";s:18:"entity:date_format";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:11:"date_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:79:"{^/admin/config/regional/date\-time/formats/manage/(?P<date_format>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"date_format";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:47:"/admin/config/regional/date-time/formats/manage";}}s:9:"path_vars";a:1:{i:0;s:11:"date_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:49:"/admin/config/regional/date-time/formats/manage/%";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.filter_format.disable',
  'path' => '/admin/config/content/formats/manage/{filter_format}/disable',
  'pattern_outline' => '/admin/config/content/formats/manage/%/disable',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:60:"/admin/config/content/formats/manage/{filter_format}/disable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:21:"filter_format.disable";s:6:"_title";s:19:"Disable text format";}s:12:"requirements";a:1:{s:14:"_entity_access";s:21:"filter_format.disable";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"filter_format";a:2:{s:4:"type";s:20:"entity:filter_format";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"filter_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:77:"{^/admin/config/content/formats/manage/(?P<filter_format>[^/]++)/disable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/disable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"filter_format";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:36:"/admin/config/content/formats/manage";}}s:9:"path_vars";a:1:{i:0;s:13:"filter_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:46:"/admin/config/content/formats/manage/%/disable";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.filter_format.edit_form',
  'path' => '/admin/config/content/formats/manage/{filter_format}',
  'pattern_outline' => '/admin/config/content/formats/manage/%',
  'fit' => '62',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:52:"/admin/config/content/formats/manage/{filter_format}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:18:"filter_format.edit";s:15:"_title_callback";s:52:"\Drupal\filter\Controller\FilterController::getLabel";}s:12:"requirements";a:1:{s:14:"_entity_access";s:20:"filter_format.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"filter_format";a:2:{s:4:"type";s:20:"entity:filter_format";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"filter_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:69:"{^/admin/config/content/formats/manage/(?P<filter_format>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"filter_format";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:36:"/admin/config/content/formats/manage";}}s:9:"path_vars";a:1:{i:0;s:13:"filter_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:62;s:14:"patternOutline";s:38:"/admin/config/content/formats/manage/%";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.node.canonical',
  'path' => '/node/{node}',
  'pattern_outline' => '/node/%',
  'fit' => '2',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:12:"/node/{node}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:48:"\Drupal\node\Controller\NodeViewController::view";s:15:"_title_callback";s:49:"\Drupal\node\Controller\NodeViewController::title";}s:12:"requirements";a:2:{s:4:"node";s:3:"\d+";s:14:"_entity_access";s:9:"node.view";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"node";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:26:"{^/node/(?P<node>\d+)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:1:{i:0;s:4:"node";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:7:"/node/%";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'entity.node.delete_form',
  'path' => '/node/{node}/delete',
  'pattern_outline' => '/node/%/delete',
  'fit' => '5',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:19:"/node/{node}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:11:"node.delete";s:6:"_title";s:6:"Delete";}s:12:"requirements";a:2:{s:4:"node";s:3:"\d+";s:14:"_entity_access";s:11:"node.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:10:"parameters";a:1:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"node";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:33:"{^/node/(?P<node>\d+)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:1:{i:0;s:4:"node";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:14:"/node/%/delete";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.node.delete_multiple_form',
  'path' => '/admin/content/node/delete',
  'pattern_outline' => '/admin/content/node/delete',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:26:"/admin/content/node/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:32:"\Drupal\node\Form\DeleteMultiple";s:14:"entity_type_id";s:4:"node";}s:12:"requirements";a:1:{s:30:"_entity_delete_multiple_access";s:4:"node";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:35:"access_check.entity_delete_multiple";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:33:"{^/admin/content/node/delete$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/content/node/delete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:26:"/admin/content/node/delete";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'entity.node.edit_form',
  'path' => '/node/{node}/edit',
  'pattern_outline' => '/node/%/edit',
  'fit' => '5',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:17:"/node/{node}/edit";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:9:"node.edit";}s:12:"requirements";a:2:{s:14:"_entity_access";s:11:"node.update";s:4:"node";s:3:"\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:10:"parameters";a:1:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"node";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:31:"{^/node/(?P<node>\d+)/edit$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:5:"/edit";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:1:{i:0;s:4:"node";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:12:"/node/%/edit";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.node.preview',
  'path' => '/node/preview/{node_preview}/{view_mode_id}',
  'pattern_outline' => '/node/preview/%/%',
  'fit' => '12',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:43:"/node/preview/{node_preview}/{view_mode_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:51:"\Drupal\node\Controller\NodePreviewController::view";s:15:"_title_callback";s:52:"\Drupal\node\Controller\NodePreviewController::title";}s:12:"requirements";a:1:{s:20:"_node_preview_access";s:14:"{node_preview}";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:12:"node_preview";a:2:{s:4:"type";s:12:"node_preview";s:9:"converter";s:42:"drupal.proxy_original_service.node_preview";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:25:"access_check.node.preview";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:12:"node_preview";i:1;s:12:"view_mode_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"{^/node/preview/(?P<node_preview>[^/]++)/(?P<view_mode_id>[^/]++)$}sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"view_mode_id";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"node_preview";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:13:"/node/preview";}}s:9:"path_vars";a:2:{i:0;s:12:"node_preview";i:1;s:12:"view_mode_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:12;s:14:"patternOutline";s:17:"/node/preview/%/%";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'entity.node.revision',
  'path' => '/node/{node}/revisions/{node_revision}/view',
  'pattern_outline' => '/node/%/revisions/%/view',
  'fit' => '21',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:43:"/node/{node}/revisions/{node_revision}/view";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:52:"\Drupal\node\Controller\NodeController::revisionShow";s:15:"_title_callback";s:57:"\Drupal\node\Controller\NodeController::revisionPageTitle";}s:12:"requirements";a:2:{s:14:"_entity_access";s:27:"node_revision.view revision";s:4:"node";s:3:"\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:2:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}s:13:"node_revision";a:2:{s:4:"type";s:20:"entity_revision:node";s:9:"converter";s:30:"paramconverter.entity_revision";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:4:"node";i:1;s:13:"node_revision";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:67:"{^/node/(?P<node>\d+)/revisions/(?P<node_revision>[^/]++)/view$}sDu";s:11:"path_tokens";a:5:{i:0;a:2:{i:0;s:4:"text";i:1;s:5:"/view";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"node_revision";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:10:"/revisions";}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:4;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:2:{i:0;s:4:"node";i:1;s:13:"node_revision";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:21;s:14:"patternOutline";s:24:"/node/%/revisions/%/view";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'entity.node.version_history',
  'path' => '/node/{node}/revisions',
  'pattern_outline' => '/node/%/revisions',
  'fit' => '5',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/node/{node}/revisions";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:9:"Revisions";s:11:"_controller";s:56:"\Drupal\node\Controller\NodeController::revisionOverview";}s:12:"requirements";a:2:{s:14:"_entity_access";s:23:"node.view all revisions";s:4:"node";s:3:"\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:10:"parameters";a:1:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"node";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/node/(?P<node>\d+)/revisions$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/revisions";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:1:{i:0;s:4:"node";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:17:"/node/%/revisions";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.node_type.collection',
  'path' => '/admin/structure/types',
  'pattern_outline' => '/admin/structure/types',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/admin/structure/types";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:9:"node_type";s:6:"_title";s:13:"Content types";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer content types";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/structure/types$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/structure/types";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/structure/types";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.node_type.delete_form',
  'path' => '/admin/structure/types/manage/{node_type}/delete',
  'pattern_outline' => '/admin/structure/types/manage/%/delete',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:48:"/admin/structure/types/manage/{node_type}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:16:"node_type.delete";s:6:"_title";s:6:"Delete";}s:12:"requirements";a:1:{s:14:"_entity_access";s:16:"node_type.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:9:"node_type";a:2:{s:4:"type";s:16:"entity:node_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"node_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:65:"{^/admin/structure/types/manage/(?P<node_type>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"node_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/types/manage";}}s:9:"path_vars";a:1:{i:0;s:9:"node_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:38:"/admin/structure/types/manage/%/delete";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.node_type.edit_form',
  'path' => '/admin/structure/types/manage/{node_type}',
  'pattern_outline' => '/admin/structure/types/manage/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:41:"/admin/structure/types/manage/{node_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:14:"node_type.edit";s:15:"_title_callback";s:54:"\Drupal\Core\Entity\Controller\EntityController::title";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer content types";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:9:"node_type";a:2:{s:4:"type";s:16:"entity:node_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"node_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:58:"{^/admin/structure/types/manage/(?P<node_type>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"node_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/types/manage";}}s:9:"path_vars";a:1:{i:0;s:9:"node_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:31:"/admin/structure/types/manage/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'entity.node_type.entity_permissions_form',
  'path' => '/admin/structure/types/manage/{node_type}/permissions',
  'pattern_outline' => '/admin/structure/types/manage/%/permissions',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:53:"/admin/structure/types/manage/{node_type}/permissions";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:6:"_title";s:18:"Manage permissions";s:5:"_form";s:38:"Drupal\user\Form\EntityPermissionsForm";s:14:"entity_type_id";s:4:"node";s:18:"bundle_entity_type";s:9:"node_type";}s:12:"requirements";a:1:{s:11:"_permission";s:22:"administer permissions";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:9:"_field_ui";b:1;s:10:"parameters";a:1:{s:9:"node_type";a:3:{s:4:"type";s:16:"entity:node_type";s:21:"with_config_overrides";b:1;s:9:"converter";s:21:"paramconverter.entity";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"node_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"{^/admin/structure/types/manage/(?P<node_type>[^/]++)/permissions$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:12:"/permissions";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"node_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/types/manage";}}s:9:"path_vars";a:1:{i:0;s:9:"node_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:43:"/admin/structure/types/manage/%/permissions";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.search_api_index.add_fields',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/fields/add/nojs',
  'pattern_outline' => '/admin/config/search/search-api/index/%/fields/add/nojs',
  'fit' => '503',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:72:"/admin/config/search/search-api/index/{search_api_index}/fields/add/nojs";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:27:"search_api_index.add_fields";}s:12:"requirements";a:1:{s:14:"_entity_access";s:23:"search_api_index.fields";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:9:"tempstore";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:55:"drupal.proxy_original_service.paramconverter.search_api";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:90:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/fields/add/nojs$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:16:"/fields/add/nojs";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:503;s:14:"patternOutline";s:55:"/admin/config/search/search-api/index/%/fields/add/nojs";s:8:"numParts";i:9;}}',
  'number_parts' => '9',
))
->values(array(
  'name' => 'entity.search_api_index.add_fields_ajax',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/fields/add/ajax',
  'pattern_outline' => '/admin/config/search/search-api/index/%/fields/add/ajax',
  'fit' => '503',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:72:"/admin/config/search/search-api/index/{search_api_index}/fields/add/ajax";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:27:"search_api_index.add_fields";}s:12:"requirements";a:1:{s:14:"_entity_access";s:23:"search_api_index.fields";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:9:"tempstore";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:55:"drupal.proxy_original_service.paramconverter.search_api";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:90:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/fields/add/ajax$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:16:"/fields/add/ajax";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:503;s:14:"patternOutline";s:55:"/admin/config/search/search-api/index/%/fields/add/ajax";s:8:"numParts";i:9;}}',
  'number_parts' => '9',
))
->values(array(
  'name' => 'entity.search_api_index.add_form',
  'path' => '/admin/config/search/search-api/add-index',
  'pattern_outline' => '/admin/config/search/search-api/add-index',
  'fit' => '31',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:41:"/admin/config/search/search-api/add-index";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:24:"search_api_index.default";}s:12:"requirements";a:1:{s:21:"_entity_create_access";s:16:"search_api_index";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:26:"access_check.entity_create";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:50:"{^/admin/config/search/search\-api/add\-index$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:41:"/admin/config/search/search-api/add-index";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:41:"/admin/config/search/search-api/add-index";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'entity.search_api_index.break_lock_form',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/fields/break-lock',
  'pattern_outline' => '/admin/config/search/search-api/index/%/fields/break-lock',
  'fit' => '251',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:74:"/admin/config/search/search-api/index/{search_api_index}/fields/break-lock";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:27:"search_api_index.break_lock";s:6:"_title";s:10:"Break lock";}s:12:"requirements";a:1:{s:14:"_entity_access";s:27:"search_api_index.break-lock";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:16:"search_api_index";a:2:{s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:93:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/fields/break\-lock$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:18:"/fields/break-lock";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:251;s:14:"patternOutline";s:57:"/admin/config/search/search-api/index/%/fields/break-lock";s:8:"numParts";i:8;}}',
  'number_parts' => '8',
))
->values(array(
  'name' => 'entity.search_api_index.canonical',
  'path' => '/admin/config/search/search-api/index/{search_api_index}',
  'pattern_outline' => '/admin/config/search/search-api/index/%',
  'fit' => '62',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:56:"/admin/config/search/search-api/index/{search_api_index}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:51:"\Drupal\search_api\Controller\IndexController::page";s:15:"_title_callback";s:56:"\Drupal\search_api\Controller\IndexController::pageTitle";}s:12:"requirements";a:1:{s:14:"_entity_access";s:21:"search_api_index.view";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:74:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:62;s:14:"patternOutline";s:39:"/admin/config/search/search-api/index/%";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.search_api_index.clear',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/clear',
  'pattern_outline' => '/admin/config/search/search-api/index/%/clear',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:62:"/admin/config/search/search-api/index/{search_api_index}/clear";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:22:"search_api_index.clear";}s:12:"requirements";a:1:{s:14:"_entity_access";s:22:"search_api_index.clear";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:80:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/clear$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:6:"/clear";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:45:"/admin/config/search/search-api/index/%/clear";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.delete_form',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/delete',
  'pattern_outline' => '/admin/config/search/search-api/index/%/delete',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:63:"/admin/config/search/search-api/index/{search_api_index}/delete";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:23:"search_api_index.delete";}s:12:"requirements";a:1:{s:14:"_entity_access";s:23:"search_api_index.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:81:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:46:"/admin/config/search/search-api/index/%/delete";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.disable',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/disable',
  'pattern_outline' => '/admin/config/search/search-api/index/%/disable',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:64:"/admin/config/search/search-api/index/{search_api_index}/disable";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:24:"search_api_index.disable";}s:12:"requirements";a:1:{s:14:"_entity_access";s:24:"search_api_index.disable";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:16:"search_api_index";a:2:{s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:82:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/disable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/disable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:47:"/admin/config/search/search-api/index/%/disable";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.edit_form',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/edit',
  'pattern_outline' => '/admin/config/search/search-api/index/%/edit',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:61:"/admin/config/search/search-api/index/{search_api_index}/edit";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:21:"search_api_index.edit";}s:12:"requirements";a:1:{s:14:"_entity_access";s:21:"search_api_index.edit";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:16:"search_api_index";a:2:{s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:79:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/edit$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:5:"/edit";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:44:"/admin/config/search/search-api/index/%/edit";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.enable',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/enable',
  'pattern_outline' => '/admin/config/search/search-api/index/%/enable',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:63:"/admin/config/search/search-api/index/{search_api_index}/enable";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:63:"Drupal\search_api\Controller\IndexController::indexBypassEnable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:23:"search_api_index.enable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:16:"search_api_index";a:2:{s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:81:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/enable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/enable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:46:"/admin/config/search/search-api/index/%/enable";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.fields',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/fields',
  'pattern_outline' => '/admin/config/search/search-api/index/%/fields',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:63:"/admin/config/search/search-api/index/{search_api_index}/fields";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:23:"search_api_index.fields";}s:12:"requirements";a:1:{s:14:"_entity_access";s:23:"search_api_index.fields";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:9:"tempstore";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:55:"drupal.proxy_original_service.paramconverter.search_api";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:81:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/fields$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/fields";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:46:"/admin/config/search/search-api/index/%/fields";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.field_config',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/fields/edit/{field_id}',
  'pattern_outline' => '/admin/config/search/search-api/index/%/fields/edit/%',
  'fit' => '502',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:79:"/admin/config/search/search-api/index/{search_api_index}/fields/edit/{field_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:10:"Edit field";s:12:"_entity_form";s:29:"search_api_index.field_config";}s:12:"requirements";a:1:{s:14:"_entity_access";s:23:"search_api_index.fields";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:9:"tempstore";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:55:"drupal.proxy_original_service.paramconverter.search_api";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:16:"search_api_index";i:1;s:8:"field_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:107:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/fields/edit/(?P<field_id>[^/]++)$}sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:8:"field_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:12:"/fields/edit";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:2:{i:0;s:16:"search_api_index";i:1;s:8:"field_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:502;s:14:"patternOutline";s:53:"/admin/config/search/search-api/index/%/fields/edit/%";s:8:"numParts";i:9;}}',
  'number_parts' => '9',
))
->values(array(
  'name' => 'entity.search_api_index.processors',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/processors',
  'pattern_outline' => '/admin/config/search/search-api/index/%/processors',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:67:"/admin/config/search/search-api/index/{search_api_index}/processors";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:27:"search_api_index.processors";}s:12:"requirements";a:1:{s:14:"_entity_access";s:27:"search_api_index.processors";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:16:"search_api_index";a:2:{s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:85:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/processors$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:11:"/processors";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:50:"/admin/config/search/search-api/index/%/processors";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.rebuild_tracker',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/rebuild-tracker',
  'pattern_outline' => '/admin/config/search/search-api/index/%/rebuild-tracker',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:72:"/admin/config/search/search-api/index/{search_api_index}/rebuild-tracker";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:32:"search_api_index.rebuild_tracker";}s:12:"requirements";a:1:{s:14:"_entity_access";s:32:"search_api_index.rebuild_tracker";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:91:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/rebuild\-tracker$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:16:"/rebuild-tracker";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:55:"/admin/config/search/search-api/index/%/rebuild-tracker";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.reindex',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/reindex',
  'pattern_outline' => '/admin/config/search/search-api/index/%/reindex',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:64:"/admin/config/search/search-api/index/{search_api_index}/reindex";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:24:"search_api_index.reindex";}s:12:"requirements";a:1:{s:14:"_entity_access";s:24:"search_api_index.reindex";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:16:"search_api_index";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:82:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/reindex$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/reindex";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:1:{i:0;s:16:"search_api_index";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:47:"/admin/config/search/search-api/index/%/reindex";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_index.remove_field',
  'path' => '/admin/config/search/search-api/index/{search_api_index}/fields/remove/{field_id}',
  'pattern_outline' => '/admin/config/search/search-api/index/%/fields/remove/%',
  'fit' => '502',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:81:"/admin/config/search/search-api/index/{search_api_index}/fields/remove/{field_id}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:57:"Drupal\search_api\Controller\IndexController::removeField";}s:12:"requirements";a:2:{s:14:"_entity_access";s:23:"search_api_index.fields";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:16:"search_api_index";a:3:{s:9:"tempstore";b:1;s:4:"type";s:23:"entity:search_api_index";s:9:"converter";s:55:"drupal.proxy_original_service.paramconverter.search_api";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:16:"search_api_index";i:1;s:8:"field_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:109:"{^/admin/config/search/search\-api/index/(?P<search_api_index>[^/]++)/fields/remove/(?P<field_id>[^/]++)$}sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:8:"field_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:14:"/fields/remove";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:16:"search_api_index";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/search/search-api/index";}}s:9:"path_vars";a:2:{i:0;s:16:"search_api_index";i:1;s:8:"field_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:502;s:14:"patternOutline";s:55:"/admin/config/search/search-api/index/%/fields/remove/%";s:8:"numParts";i:9;}}',
  'number_parts' => '9',
))
->values(array(
  'name' => 'entity.search_api_server.add_form',
  'path' => '/admin/config/search/search-api/add-server',
  'pattern_outline' => '/admin/config/search/search-api/add-server',
  'fit' => '31',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:42:"/admin/config/search/search-api/add-server";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:25:"search_api_server.default";}s:12:"requirements";a:1:{s:21:"_entity_create_access";s:17:"search_api_server";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:26:"access_check.entity_create";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:51:"{^/admin/config/search/search\-api/add\-server$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:42:"/admin/config/search/search-api/add-server";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:42:"/admin/config/search/search-api/add-server";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'entity.search_api_server.canonical',
  'path' => '/admin/config/search/search-api/server/{search_api_server}',
  'pattern_outline' => '/admin/config/search/search-api/server/%',
  'fit' => '62',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:58:"/admin/config/search/search-api/server/{search_api_server}";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:52:"\Drupal\search_api\Controller\ServerController::page";s:15:"_title_callback";s:57:"\Drupal\search_api\Controller\ServerController::pageTitle";s:6:"_title";s:4:"View";}s:12:"requirements";a:1:{s:14:"_entity_access";s:22:"search_api_server.view";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:17:"search_api_server";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:24:"entity:search_api_server";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:17:"search_api_server";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:76:"{^/admin/config/search/search\-api/server/(?P<search_api_server>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:17:"search_api_server";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:38:"/admin/config/search/search-api/server";}}s:9:"path_vars";a:1:{i:0;s:17:"search_api_server";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:62;s:14:"patternOutline";s:40:"/admin/config/search/search-api/server/%";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.search_api_server.clear',
  'path' => '/admin/config/search/search-api/server/{search_api_server}/clear',
  'pattern_outline' => '/admin/config/search/search-api/server/%/clear',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:64:"/admin/config/search/search-api/server/{search_api_server}/clear";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:23:"search_api_server.clear";}s:12:"requirements";a:1:{s:14:"_entity_access";s:23:"search_api_server.clear";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:17:"search_api_server";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:24:"entity:search_api_server";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:17:"search_api_server";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:82:"{^/admin/config/search/search\-api/server/(?P<search_api_server>[^/]++)/clear$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:6:"/clear";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:17:"search_api_server";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:38:"/admin/config/search/search-api/server";}}s:9:"path_vars";a:1:{i:0;s:17:"search_api_server";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:46:"/admin/config/search/search-api/server/%/clear";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_server.delete_form',
  'path' => '/admin/config/search/search-api/server/{search_api_server}/delete',
  'pattern_outline' => '/admin/config/search/search-api/server/%/delete',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:65:"/admin/config/search/search-api/server/{search_api_server}/delete";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:24:"search_api_server.delete";}s:12:"requirements";a:1:{s:14:"_entity_access";s:24:"search_api_server.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:17:"search_api_server";a:3:{s:21:"with_config_overrides";b:1;s:4:"type";s:24:"entity:search_api_server";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:17:"search_api_server";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:83:"{^/admin/config/search/search\-api/server/(?P<search_api_server>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:17:"search_api_server";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:38:"/admin/config/search/search-api/server";}}s:9:"path_vars";a:1:{i:0;s:17:"search_api_server";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:47:"/admin/config/search/search-api/server/%/delete";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_server.disable',
  'path' => '/admin/config/search/search-api/server/{search_api_server}/disable',
  'pattern_outline' => '/admin/config/search/search-api/server/%/disable',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:66:"/admin/config/search/search-api/server/{search_api_server}/disable";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:25:"search_api_server.disable";}s:12:"requirements";a:1:{s:14:"_entity_access";s:25:"search_api_server.disable";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:17:"search_api_server";a:2:{s:4:"type";s:24:"entity:search_api_server";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:17:"search_api_server";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:84:"{^/admin/config/search/search\-api/server/(?P<search_api_server>[^/]++)/disable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/disable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:17:"search_api_server";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:38:"/admin/config/search/search-api/server";}}s:9:"path_vars";a:1:{i:0;s:17:"search_api_server";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:48:"/admin/config/search/search-api/server/%/disable";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_server.edit_form',
  'path' => '/admin/config/search/search-api/server/{search_api_server}/edit',
  'pattern_outline' => '/admin/config/search/search-api/server/%/edit',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:63:"/admin/config/search/search-api/server/{search_api_server}/edit";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:22:"search_api_server.edit";}s:12:"requirements";a:1:{s:14:"_entity_access";s:22:"search_api_server.edit";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:17:"search_api_server";a:2:{s:4:"type";s:24:"entity:search_api_server";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:17:"search_api_server";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:81:"{^/admin/config/search/search\-api/server/(?P<search_api_server>[^/]++)/edit$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:5:"/edit";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:17:"search_api_server";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:38:"/admin/config/search/search-api/server";}}s:9:"path_vars";a:1:{i:0;s:17:"search_api_server";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:45:"/admin/config/search/search-api/server/%/edit";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.search_api_server.enable',
  'path' => '/admin/config/search/search-api/server/{search_api_server}/enable',
  'pattern_outline' => '/admin/config/search/search-api/server/%/enable',
  'fit' => '125',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:65:"/admin/config/search/search-api/server/{search_api_server}/enable";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:65:"Drupal\search_api\Controller\ServerController::serverBypassEnable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:24:"search_api_server.enable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:17:"search_api_server";a:2:{s:4:"type";s:24:"entity:search_api_server";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:17:"search_api_server";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:83:"{^/admin/config/search/search\-api/server/(?P<search_api_server>[^/]++)/enable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/enable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:17:"search_api_server";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:38:"/admin/config/search/search-api/server";}}s:9:"path_vars";a:1:{i:0;s:17:"search_api_server";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:47:"/admin/config/search/search-api/server/%/enable";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.user.admin_form',
  'path' => '/admin/config/people/accounts',
  'pattern_outline' => '/admin/config/people/accounts',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:29:"/admin/config/people/accounts";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:32:"\Drupal\user\AccountSettingsForm";s:6:"_title";s:16:"Account settings";}s:12:"requirements";a:1:{s:11:"_permission";s:27:"administer account settings";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/admin/config/people/accounts$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/config/people/accounts";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:29:"/admin/config/people/accounts";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'entity.user.cancel_form',
  'path' => '/user/{user}/cancel',
  'pattern_outline' => '/user/%/cancel',
  'fit' => '5',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:19:"/user/{user}/cancel";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:14:"Cancel account";s:12:"_entity_form";s:11:"user.cancel";}s:12:"requirements";a:2:{s:4:"user";s:3:"\d+";s:14:"_entity_access";s:11:"user.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:12:"_admin_route";b:1;s:10:"parameters";a:1:{s:4:"user";a:2:{s:4:"type";s:11:"entity:user";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"user";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:33:"{^/user/(?P<user>\d+)/cancel$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/cancel";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"user";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:5:"/user";}}s:9:"path_vars";a:1:{i:0;s:4:"user";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:14:"/user/%/cancel";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.user.canonical',
  'path' => '/user/{user}',
  'pattern_outline' => '/user/%',
  'fit' => '2',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:12:"/user/{user}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_view";s:9:"user.full";s:15:"_title_callback";s:48:"Drupal\user\Controller\UserController::userTitle";}s:12:"requirements";a:2:{s:4:"user";s:3:"\d+";s:14:"_entity_access";s:9:"user.view";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:4:"user";a:2:{s:4:"type";s:11:"entity:user";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"user";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:26:"{^/user/(?P<user>\d+)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"user";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:5:"/user";}}s:9:"path_vars";a:1:{i:0;s:4:"user";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:7:"/user/%";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'entity.user.collection',
  'path' => '/admin/people',
  'pattern_outline' => '/admin/people',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:13:"/admin/people";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:4:"user";s:6:"_title";s:6:"People";}s:12:"requirements";a:1:{s:11:"_permission";s:16:"administer users";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:20:"{^/admin/people$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:13:"/admin/people";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:13:"/admin/people";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'entity.user.edit_form',
  'path' => '/user/{user}/edit',
  'pattern_outline' => '/user/%/edit',
  'fit' => '5',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:17:"/user/{user}/edit";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:12:"user.default";s:15:"_title_callback";s:48:"Drupal\user\Controller\UserController::userTitle";}s:12:"requirements";a:2:{s:4:"user";s:3:"\d+";s:14:"_entity_access";s:11:"user.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:12:"_admin_route";b:1;s:10:"parameters";a:1:{s:4:"user";a:2:{s:4:"type";s:11:"entity:user";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"user";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:31:"{^/user/(?P<user>\d+)/edit$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:5:"/edit";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"user";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:5:"/user";}}s:9:"path_vars";a:1:{i:0;s:4:"user";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:12:"/user/%/edit";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.user_role.collection',
  'path' => '/admin/people/roles',
  'pattern_outline' => '/admin/people/roles',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:19:"/admin/people/roles";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:9:"user_role";s:6:"_title";s:5:"Roles";}s:12:"requirements";a:1:{s:11:"_permission";s:22:"administer permissions";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:26:"{^/admin/people/roles$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:19:"/admin/people/roles";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:19:"/admin/people/roles";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.user_role.delete_form',
  'path' => '/admin/people/roles/manage/{user_role}/delete',
  'pattern_outline' => '/admin/people/roles/manage/%/delete',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:45:"/admin/people/roles/manage/{user_role}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:16:"user_role.delete";s:6:"_title";s:11:"Delete role";}s:12:"requirements";a:1:{s:14:"_entity_access";s:16:"user_role.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:9:"user_role";a:2:{s:4:"type";s:16:"entity:user_role";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"user_role";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:62:"{^/admin/people/roles/manage/(?P<user_role>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"user_role";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/people/roles/manage";}}s:9:"path_vars";a:1:{i:0;s:9:"user_role";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:35:"/admin/people/roles/manage/%/delete";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.user_role.edit_form',
  'path' => '/admin/people/roles/manage/{user_role}',
  'pattern_outline' => '/admin/people/roles/manage/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:38:"/admin/people/roles/manage/{user_role}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:17:"user_role.default";s:6:"_title";s:9:"Edit role";}s:12:"requirements";a:1:{s:14:"_entity_access";s:16:"user_role.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:9:"user_role";a:2:{s:4:"type";s:16:"entity:user_role";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"user_role";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:55:"{^/admin/people/roles/manage/(?P<user_role>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"user_role";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/people/roles/manage";}}s:9:"path_vars";a:1:{i:0;s:9:"user_role";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:28:"/admin/people/roles/manage/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'entity.user_role.edit_permissions_form',
  'path' => '/admin/people/permissions/{user_role}',
  'pattern_outline' => '/admin/people/permissions/%',
  'fit' => '14',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:37:"/admin/people/permissions/{user_role}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:49:"\Drupal\user\Form\UserPermissionsRoleSpecificForm";s:6:"_title";s:9:"Edit role";}s:12:"requirements";a:1:{s:14:"_entity_access";s:16:"user_role.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:9:"user_role";a:2:{s:4:"type";s:16:"entity:user_role";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"user_role";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"{^/admin/people/permissions/(?P<user_role>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"user_role";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:25:"/admin/people/permissions";}}s:9:"path_vars";a:1:{i:0;s:9:"user_role";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:14;s:14:"patternOutline";s:27:"/admin/people/permissions/%";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'entity.view.break_lock_form',
  'path' => '/admin/structure/views/view/{view}/break-lock',
  'pattern_outline' => '/admin/structure/views/view/%/break-lock',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:45:"/admin/structure/views/view/{view}/break-lock";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:15:"view.break_lock";s:6:"_title";s:10:"Break lock";}s:12:"requirements";a:1:{s:14:"_entity_access";s:15:"view.break-lock";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:4:"view";a:2:{s:4:"type";s:11:"entity:view";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"view";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:63:"{^/admin/structure/views/view/(?P<view>[^/]++)/break\-lock$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:11:"/break-lock";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:1:{i:0;s:4:"view";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:40:"/admin/structure/views/view/%/break-lock";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.view.collection',
  'path' => '/admin/structure/views',
  'pattern_outline' => '/admin/structure/views',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/admin/structure/views";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:4:"view";s:6:"_title";s:5:"Views";}s:12:"requirements";a:1:{s:11:"_permission";s:16:"administer views";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/structure/views$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/structure/views";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/structure/views";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'entity.view.delete_form',
  'path' => '/admin/structure/views/view/{view}/delete',
  'pattern_outline' => '/admin/structure/views/view/%/delete',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:41:"/admin/structure/views/view/{view}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:11:"view.delete";s:6:"_title";s:11:"Delete view";}s:12:"requirements";a:1:{s:14:"_entity_access";s:11:"view.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:4:"view";a:2:{s:4:"type";s:11:"entity:view";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"view";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:58:"{^/admin/structure/views/view/(?P<view>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:1:{i:0;s:4:"view";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:36:"/admin/structure/views/view/%/delete";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.view.disable',
  'path' => '/admin/structure/views/view/{view}/disable',
  'pattern_outline' => '/admin/structure/views/view/%/disable',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:42:"/admin/structure/views/view/{view}/disable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:60:"\Drupal\views_ui\Controller\ViewsUIController::ajaxOperation";s:2:"op";s:7:"disable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:12:"view.disable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:4:"view";a:2:{s:4:"type";s:11:"entity:view";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"view";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:59:"{^/admin/structure/views/view/(?P<view>[^/]++)/disable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/disable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:1:{i:0;s:4:"view";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:37:"/admin/structure/views/view/%/disable";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.view.duplicate_form',
  'path' => '/admin/structure/views/view/{view}/duplicate',
  'pattern_outline' => '/admin/structure/views/view/%/duplicate',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:44:"/admin/structure/views/view/{view}/duplicate";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:14:"view.duplicate";s:6:"_title";s:14:"Duplicate view";}s:12:"requirements";a:1:{s:14:"_entity_access";s:14:"view.duplicate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:4:"view";a:2:{s:4:"type";s:11:"entity:view";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"view";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:61:"{^/admin/structure/views/view/(?P<view>[^/]++)/duplicate$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/duplicate";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:1:{i:0;s:4:"view";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:39:"/admin/structure/views/view/%/duplicate";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.view.edit_display_form',
  'path' => '/admin/structure/views/view/{view}/edit/{display_id}',
  'pattern_outline' => '/admin/structure/views/view/%/edit',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:52:"/admin/structure/views/view/{view}/edit/{display_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:51:"\Drupal\views_ui\Controller\ViewsUIController::edit";s:10:"display_id";N;}s:12:"requirements";a:1:{s:14:"_entity_access";s:11:"view.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:4:"view";a:3:{s:9:"tempstore";b:1;s:4:"type";s:11:"entity:view";s:9:"converter";s:53:"drupal.proxy_original_service.paramconverter.views_ui";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:4:"view";i:1;s:10:"display_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:84:"{^/admin/structure/views/view/(?P<view>[^/]++)/edit(?:/(?P<display_id>[^/]++))?$}sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:10:"display_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:5:"/edit";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:2:{i:0;s:4:"view";i:1;s:10:"display_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:34:"/admin/structure/views/view/%/edit";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'entity.view.edit_form',
  'path' => '/admin/structure/views/view/{view}',
  'pattern_outline' => '/admin/structure/views/view/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:34:"/admin/structure/views/view/{view}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:51:"\Drupal\views_ui\Controller\ViewsUIController::edit";}s:12:"requirements";a:1:{s:14:"_entity_access";s:11:"view.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:4:"view";a:3:{s:9:"tempstore";b:1;s:4:"type";s:11:"entity:view";s:9:"converter";s:53:"drupal.proxy_original_service.paramconverter.views_ui";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"view";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:51:"{^/admin/structure/views/view/(?P<view>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:1:{i:0;s:4:"view";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:29:"/admin/structure/views/view/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'entity.view.enable',
  'path' => '/admin/structure/views/view/{view}/enable',
  'pattern_outline' => '/admin/structure/views/view/%/enable',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:41:"/admin/structure/views/view/{view}/enable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:60:"\Drupal\views_ui\Controller\ViewsUIController::ajaxOperation";s:2:"op";s:6:"enable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:11:"view.enable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:4:"view";a:2:{s:4:"type";s:11:"entity:view";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"view";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:58:"{^/admin/structure/views/view/(?P<view>[^/]++)/enable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/enable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:1:{i:0;s:4:"view";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:36:"/admin/structure/views/view/%/enable";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'entity.view.preview_form',
  'path' => '/admin/structure/views/view/{view}/preview/{display_id}',
  'pattern_outline' => '/admin/structure/views/view/%/preview',
  'fit' => '61',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:55:"/admin/structure/views/view/{view}/preview/{display_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:12:"view.preview";s:10:"display_id";N;}s:12:"requirements";a:1:{s:11:"_permission";s:16:"administer views";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:10:"parameters";a:1:{s:4:"view";a:3:{s:9:"tempstore";b:1;s:4:"type";s:11:"entity:view";s:9:"converter";s:53:"drupal.proxy_original_service.paramconverter.views_ui";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:4:"view";i:1;s:10:"display_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:87:"{^/admin/structure/views/view/(?P<view>[^/]++)/preview(?:/(?P<display_id>[^/]++))?$}sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:10:"display_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:8:"/preview";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"view";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/views/view";}}s:9:"path_vars";a:2:{i:0;s:4:"view";i:1;s:10:"display_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:37:"/admin/structure/views/view/%/preview";s:8:"numParts";i:7;}}',
  'number_parts' => '7',
))
->values(array(
  'name' => 'filter.admin_overview',
  'path' => '/admin/config/content/formats',
  'pattern_outline' => '/admin/config/content/formats',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:29:"/admin/config/content/formats";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:13:"filter_format";s:6:"_title";s:24:"Text formats and editors";}s:12:"requirements";a:1:{s:11:"_permission";s:18:"administer filters";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/admin/config/content/formats$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/config/content/formats";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:29:"/admin/config/content/formats";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'filter.format_add',
  'path' => '/admin/config/content/formats/add',
  'pattern_outline' => '/admin/config/content/formats/add',
  'fit' => '31',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:33:"/admin/config/content/formats/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:17:"filter_format.add";s:6:"_title";s:15:"Add text format";}s:12:"requirements";a:1:{s:21:"_entity_create_access";s:13:"filter_format";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:26:"access_check.entity_create";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"{^/admin/config/content/formats/add$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:33:"/admin/config/content/formats/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:33:"/admin/config/content/formats/add";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'filter.tips',
  'path' => '/filter/tips/{filter_format}',
  'pattern_outline' => '/filter/tips/%',
  'fit' => '6',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:28:"/filter/tips/{filter_format}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:54:"\Drupal\filter\Controller\FilterController::filterTips";s:6:"_title";s:12:"Compose tips";}s:12:"requirements";a:1:{s:14:"_entity_access";s:17:"filter_format.use";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"filter_format";a:2:{s:4:"type";s:20:"entity:filter_format";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"filter_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:45:"{^/filter/tips/(?P<filter_format>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"filter_format";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:12:"/filter/tips";}}s:9:"path_vars";a:1:{i:0;s:13:"filter_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:14:"/filter/tips/%";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'filter.tips_all',
  'path' => '/filter/tips',
  'pattern_outline' => '/filter/tips',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:12:"/filter/tips";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:54:"\Drupal\filter\Controller\FilterController::filterTips";s:6:"_title";s:12:"Compose tips";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"filter_format";a:2:{s:4:"type";s:20:"entity:filter_format";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:19:"{^/filter/tips$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:12:"/filter/tips";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:12:"/filter/tips";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'node.add',
  'path' => '/node/add/{node_type}',
  'pattern_outline' => '/node/add/%',
  'fit' => '6',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:21:"/node/add/{node_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:12:"node.default";s:15:"_title_callback";s:52:"\Drupal\node\Controller\NodeController::addPageTitle";}s:12:"requirements";a:1:{s:21:"_entity_create_access";s:16:"node:{node_type}";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:10:"parameters";a:1:{s:9:"node_type";a:3:{s:4:"type";s:16:"entity:node_type";s:21:"with_config_overrides";b:1;s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:26:"access_check.entity_create";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"node_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:38:"{^/node/add/(?P<node_type>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"node_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:9:"/node/add";}}s:9:"path_vars";a:1:{i:0;s:9:"node_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:11:"/node/add/%";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'node.add_page',
  'path' => '/node/add',
  'pattern_outline' => '/node/add',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:9:"/node/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:11:"Add content";s:11:"_controller";s:47:"\Drupal\node\Controller\NodeController::addPage";}s:12:"requirements";a:1:{s:25:"_entity_create_any_access";s:4:"node";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:30:"access_check.entity_create_any";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:16:"{^/node/add$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:9:"/node/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:9:"/node/add";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'node.configure_rebuild_confirm',
  'path' => '/admin/reports/status/rebuild',
  'pattern_outline' => '/admin/reports/status/rebuild',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:29:"/admin/reports/status/rebuild";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:5:"_form";s:40:"\Drupal\node\Form\RebuildPermissionsForm";}s:12:"requirements";a:1:{s:11:"_permission";s:16:"administer nodes";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/admin/reports/status/rebuild$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/reports/status/rebuild";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:29:"/admin/reports/status/rebuild";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'node.multiple_delete_confirm',
  'path' => '/admin/content/node/delete',
  'pattern_outline' => '/admin/content/node/delete',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:26:"/admin/content/node/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:32:"\Drupal\node\Form\DeleteMultiple";s:14:"entity_type_id";s:4:"node";}s:12:"requirements";a:1:{s:30:"_entity_delete_multiple_access";s:4:"node";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:35:"access_check.entity_delete_multiple";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:33:"{^/admin/content/node/delete$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/content/node/delete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:26:"/admin/content/node/delete";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'node.revision_delete_confirm',
  'path' => '/node/{node}/revisions/{node_revision}/delete',
  'pattern_outline' => '/node/%/revisions/%/delete',
  'fit' => '21',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:45:"/node/{node}/revisions/{node_revision}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:40:"\Drupal\node\Form\NodeRevisionDeleteForm";s:6:"_title";s:23:"Delete earlier revision";}s:12:"requirements";a:2:{s:14:"_entity_access";s:29:"node_revision.delete revision";s:4:"node";s:3:"\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:10:"parameters";a:2:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}s:13:"node_revision";a:2:{s:4:"type";s:20:"entity_revision:node";s:9:"converter";s:30:"paramconverter.entity_revision";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:4:"node";i:1;s:13:"node_revision";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:69:"{^/node/(?P<node>\d+)/revisions/(?P<node_revision>[^/]++)/delete$}sDu";s:11:"path_tokens";a:5:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"node_revision";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:10:"/revisions";}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:4;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:2:{i:0;s:4:"node";i:1;s:13:"node_revision";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:21;s:14:"patternOutline";s:26:"/node/%/revisions/%/delete";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'node.revision_revert_confirm',
  'path' => '/node/{node}/revisions/{node_revision}/revert',
  'pattern_outline' => '/node/%/revisions/%/revert',
  'fit' => '21',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:45:"/node/{node}/revisions/{node_revision}/revert";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:40:"\Drupal\node\Form\NodeRevisionRevertForm";s:6:"_title";s:26:"Revert to earlier revision";}s:12:"requirements";a:2:{s:14:"_entity_access";s:29:"node_revision.revert revision";s:4:"node";s:3:"\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:10:"parameters";a:2:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}s:13:"node_revision";a:2:{s:4:"type";s:20:"entity_revision:node";s:9:"converter";s:30:"paramconverter.entity_revision";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:4:"node";i:1;s:13:"node_revision";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:69:"{^/node/(?P<node>\d+)/revisions/(?P<node_revision>[^/]++)/revert$}sDu";s:11:"path_tokens";a:5:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/revert";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"node_revision";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:10:"/revisions";}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:4;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:2:{i:0;s:4:"node";i:1;s:13:"node_revision";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:21;s:14:"patternOutline";s:26:"/node/%/revisions/%/revert";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'node.revision_revert_translation_confirm',
  'path' => '/node/{node}/revisions/{node_revision}/revert/{langcode}',
  'pattern_outline' => '/node/%/revisions/%/revert/%',
  'fit' => '42',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:56:"/node/{node}/revisions/{node_revision}/revert/{langcode}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:51:"\Drupal\node\Form\NodeRevisionRevertTranslationForm";s:6:"_title";s:43:"Revert to earlier revision of a translation";}s:12:"requirements";a:2:{s:14:"_entity_access";s:29:"node_revision.revert revision";s:4:"node";s:3:"\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:21:"_node_operation_route";b:1;s:10:"parameters";a:2:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}s:13:"node_revision";a:2:{s:4:"type";s:20:"entity_revision:node";s:9:"converter";s:30:"paramconverter.entity_revision";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:3:{i:0;s:4:"node";i:1;s:13:"node_revision";i:2;s:8:"langcode";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:90:"{^/node/(?P<node>\d+)/revisions/(?P<node_revision>[^/]++)/revert/(?P<langcode>[^/]++)$}sDu";s:11:"path_tokens";a:6:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:8:"langcode";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:7:"/revert";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"node_revision";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:10:"/revisions";}i:4;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\d+";i:3;s:4:"node";i:4;b:1;}i:5;a:2:{i:0;s:4:"text";i:1;s:5:"/node";}}s:9:"path_vars";a:3:{i:0;s:4:"node";i:1;s:13:"node_revision";i:2;s:8:"langcode";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:42;s:14:"patternOutline";s:28:"/node/%/revisions/%/revert/%";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'node.type_add',
  'path' => '/admin/structure/types/add',
  'pattern_outline' => '/admin/structure/types/add',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:26:"/admin/structure/types/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:13:"node_type.add";s:6:"_title";s:16:"Add content type";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer content types";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:33:"{^/admin/structure/types/add$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/structure/types/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:26:"/admin/structure/types/add";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'search_api.execute_tasks',
  'path' => '/admin/config/search/search-api/execute-tasks',
  'pattern_outline' => '/admin/config/search/search-api/execute-tasks',
  'fit' => '31',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:45:"/admin/config/search/search-api/execute-tasks";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:58:"\Drupal\search_api\Controller\TaskController::executeTasks";s:6:"_title";s:21:"Execute pending tasks";}s:12:"requirements";a:1:{s:14:"_custom_access";s:64:"\Drupal\search_api\Controller\TaskController::executeTasksAccess";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.custom";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"{^/admin/config/search/search\-api/execute\-tasks$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:45:"/admin/config/search/search-api/execute-tasks";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:45:"/admin/config/search/search-api/execute-tasks";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'search_api.overview',
  'path' => '/admin/config/search/search-api',
  'pattern_outline' => '/admin/config/search/search-api',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:31:"/admin/config/search/search-api";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:10:"Search API";s:12:"_entity_list";s:16:"search_api_index";}s:12:"requirements";a:1:{s:11:"_permission";s:21:"administer search_api";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:39:"{^/admin/config/search/search\-api$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/config/search/search-api";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:31:"/admin/config/search/search-api";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.401',
  'path' => '/system/401',
  'pattern_outline' => '/system/401',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:11:"/system/401";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:49:"\Drupal\system\Controller\Http4xxController:on401";s:6:"_title";s:12:"Unauthorized";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:18:"{^/system/401$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:11:"/system/401";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:11:"/system/401";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.403',
  'path' => '/system/403',
  'pattern_outline' => '/system/403',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:11:"/system/403";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:49:"\Drupal\system\Controller\Http4xxController:on403";s:6:"_title";s:13:"Access denied";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:18:"{^/system/403$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:11:"/system/403";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:11:"/system/403";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.404',
  'path' => '/system/404',
  'pattern_outline' => '/system/404',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:11:"/system/404";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:49:"\Drupal\system\Controller\Http4xxController:on404";s:6:"_title";s:14:"Page not found";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:18:"{^/system/404$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:11:"/system/404";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:11:"/system/404";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.4xx',
  'path' => '/system/4xx',
  'pattern_outline' => '/system/4xx',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:11:"/system/4xx";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:49:"\Drupal\system\Controller\Http4xxController:on4xx";s:6:"_title";s:12:"Client error";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:18:"{^/system/4xx$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:11:"/system/4xx";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:11:"/system/4xx";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.admin',
  'path' => '/admin',
  'pattern_outline' => '/admin',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:6:"/admin";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:14:"Administration";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:13:"{^/admin$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:6:"/admin";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:6:"/admin";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => 'system.admin_compact_page',
  'path' => '/admin/compact/{mode}',
  'pattern_outline' => '/admin/compact',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:21:"/admin/compact/{mode}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:55:"\Drupal\system\Controller\SystemController::compactPage";s:4:"mode";s:3:"off";}s:12:"requirements";a:1:{s:11:"_permission";s:27:"access administration pages";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"mode";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:43:"{^/admin/compact(?:/(?P<mode>[^/]++))?$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:4:"mode";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:14:"/admin/compact";}}s:9:"path_vars";a:1:{i:0;s:4:"mode";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:14:"/admin/compact";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config',
  'path' => '/admin/config',
  'pattern_outline' => '/admin/config',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:13:"/admin/config";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:52:"\Drupal\system\Controller\SystemController::overview";s:7:"link_id";s:19:"system.admin_config";s:6:"_title";s:13:"Configuration";}s:12:"requirements";a:1:{s:11:"_permission";s:27:"access administration pages";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:20:"{^/admin/config$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:13:"/admin/config";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:13:"/admin/config";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.admin_config_content',
  'path' => '/admin/config/content',
  'pattern_outline' => '/admin/config/content',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:21:"/admin/config/content";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:17:"Content authoring";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:28:"{^/admin/config/content$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:21:"/admin/config/content";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:21:"/admin/config/content";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_development',
  'path' => '/admin/config/development',
  'pattern_outline' => '/admin/config/development',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:25:"/admin/config/development";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:11:"Development";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:32:"{^/admin/config/development$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:25:"/admin/config/development";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:25:"/admin/config/development";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_media',
  'path' => '/admin/config/media',
  'pattern_outline' => '/admin/config/media',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:19:"/admin/config/media";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:5:"Media";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:26:"{^/admin/config/media$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:19:"/admin/config/media";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:19:"/admin/config/media";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_regional',
  'path' => '/admin/config/regional',
  'pattern_outline' => '/admin/config/regional',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/admin/config/regional";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:19:"Region and language";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/config/regional$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/config/regional";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/config/regional";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_search',
  'path' => '/admin/config/search',
  'pattern_outline' => '/admin/config/search',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:20:"/admin/config/search";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:19:"Search and metadata";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:27:"{^/admin/config/search$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/config/search";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:20:"/admin/config/search";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_services',
  'path' => '/admin/config/services',
  'pattern_outline' => '/admin/config/services',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/admin/config/services";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:12:"Web services";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/config/services$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/config/services";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/config/services";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_system',
  'path' => '/admin/config/system',
  'pattern_outline' => '/admin/config/system',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:20:"/admin/config/system";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:6:"System";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:27:"{^/admin/config/system$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/config/system";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:20:"/admin/config/system";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_ui',
  'path' => '/admin/config/user-interface',
  'pattern_outline' => '/admin/config/user-interface',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:28:"/admin/config/user-interface";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:14:"User interface";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/admin/config/user\-interface$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/admin/config/user-interface";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:28:"/admin/config/user-interface";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_config_workflow',
  'path' => '/admin/config/workflow',
  'pattern_outline' => '/admin/config/workflow',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/admin/config/workflow";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:8:"Workflow";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/config/workflow$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/config/workflow";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/config/workflow";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.admin_content',
  'path' => '/admin/content',
  'pattern_outline' => '/admin/content',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:14:"/admin/content";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:7:"Content";s:12:"_entity_list";s:4:"node";}s:12:"requirements";a:1:{s:11:"_permission";s:23:"access content overview";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:21:"{^/admin/content$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:14:"/admin/content";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:14:"/admin/content";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.admin_index',
  'path' => '/admin/index',
  'pattern_outline' => '/admin/index',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:12:"/admin/index";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:48:"\Drupal\system\Controller\AdminController::index";s:6:"_title";s:14:"Administration";}s:12:"requirements";a:1:{s:11:"_permission";s:27:"access administration pages";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:19:"{^/admin/index$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:12:"/admin/index";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:12:"/admin/index";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.admin_reports',
  'path' => '/admin/reports',
  'pattern_outline' => '/admin/reports',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:14:"/admin/reports";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:7:"Reports";}s:12:"requirements";a:2:{s:11:"_permission";s:19:"access site reports";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:21:"{^/admin/reports$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:14:"/admin/reports";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:14:"/admin/reports";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.admin_structure',
  'path' => '/admin/structure',
  'pattern_outline' => '/admin/structure',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:16:"/admin/structure";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:68:"\Drupal\system\Controller\SystemController::systemAdminMenuBlockPage";s:6:"_title";s:9:"Structure";}s:12:"requirements";a:2:{s:11:"_permission";s:27:"access administration pages";s:29:"_access_admin_menu_block_page";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:34:"access_check.admin_menu_block_page";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:23:"{^/admin/structure$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:16:"/admin/structure";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:16:"/admin/structure";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.batch_page.html',
  'path' => '/batch',
  'pattern_outline' => '/batch',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:6:"/batch";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:52:"\Drupal\system\Controller\BatchController::batchPage";s:15:"_title_callback";s:57:"\Drupal\system\Controller\BatchController::batchPageTitle";}s:12:"requirements";a:2:{s:7:"_access";s:4:"TRUE";s:7:"_format";s:4:"html";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:13:"{^/batch$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:6:"/batch";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:6:"/batch";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => 'system.batch_page.json',
  'path' => '/batch',
  'pattern_outline' => '/batch',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:6:"/batch";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:52:"\Drupal\system\Controller\BatchController::batchPage";}s:12:"requirements";a:2:{s:7:"_access";s:4:"TRUE";s:7:"_format";s:4:"json";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:13:"{^/batch$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:6:"/batch";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:6:"/batch";s:8:"numParts";i:1;}}',
  'number_parts' => '1',
))
->values(array(
  'name' => 'system.cron',
  'path' => '/cron/{key}',
  'pattern_outline' => '/cron/%',
  'fit' => '2',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:11:"/cron/{key}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:34:"\Drupal\system\CronController::run";}s:12:"requirements";a:1:{s:19:"_access_system_cron";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:8:"no_cache";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:17:"access_check.cron";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:3:"key";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:28:"{^/cron/(?P<key>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:3:"key";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:5:"/cron";}}s:9:"path_vars";a:1:{i:0;s:3:"key";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:7:"/cron/%";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.cron_settings',
  'path' => '/admin/config/system/cron',
  'pattern_outline' => '/admin/config/system/cron',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:25:"/admin/config/system/cron";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:28:"\Drupal\system\Form\CronForm";s:6:"_title";s:4:"Cron";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:32:"{^/admin/config/system/cron$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:25:"/admin/config/system/cron";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:25:"/admin/config/system/cron";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.csrftoken',
  'path' => '/session/token',
  'pattern_outline' => '/session/token',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:14:"/session/token";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:56:"\Drupal\system\Controller\CsrfTokenController::csrfToken";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:21:"{^/session/token$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:14:"/session/token";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:14:"/session/token";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.css_asset',
  'path' => '/sites/default/files/css/{file_name}',
  'pattern_outline' => '/sites/default/files/css/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:36:"/sites/default/files/css/{file_name}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:52:"Drupal\system\Controller\CssAssetController::deliver";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"file_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:53:"{^/sites/default/files/css/(?P<file_name>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"file_name";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:24:"/sites/default/files/css";}}s:9:"path_vars";a:1:{i:0;s:9:"file_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:26:"/sites/default/files/css/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'system.date_format_add',
  'path' => '/admin/config/regional/date-time/formats/add',
  'pattern_outline' => '/admin/config/regional/date-time/formats/add',
  'fit' => '63',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:44:"/admin/config/regional/date-time/formats/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:15:"date_format.add";s:6:"_title";s:15:"Add date format";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"{^/admin/config/regional/date\-time/formats/add$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:44:"/admin/config/regional/date-time/formats/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:44:"/admin/config/regional/date-time/formats/add";s:8:"numParts";i:6;}}',
  'number_parts' => '6',
))
->values(array(
  'name' => 'system.db_update',
  'path' => '/update.php/{op}',
  'pattern_outline' => '/update.php',
  'fit' => '1',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:16:"/update.php/{op}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:2:"op";s:4:"info";}s:12:"requirements";a:1:{s:21:"_access_system_update";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:19:"default_url_options";a:1:{s:15:"path_processing";b:0;}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:22:"access_check.db_update";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:2:"op";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:39:"{^/update\.php(?:/(?P<op>[^/]++))?$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:2:"op";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:11:"/update.php";}}s:9:"path_vars";a:1:{i:0;s:2:"op";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:11:"/update.php";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.development_settings',
  'path' => '/admin/config/development/settings',
  'pattern_outline' => '/admin/config/development/settings',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:34:"/admin/config/development/settings";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:43:"\Drupal\system\Form\DevelopmentSettingsForm";s:6:"_title";s:20:"Development settings";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:41:"{^/admin/config/development/settings$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:34:"/admin/config/development/settings";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:34:"/admin/config/development/settings";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.entity_autocomplete',
  'path' => '/entity_reference_autocomplete/{target_type}/{selection_handler}/{selection_settings_key}',
  'pattern_outline' => '/entity_reference_autocomplete/%/%/%',
  'fit' => '8',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:89:"/entity_reference_autocomplete/{target_type}/{selection_handler}/{selection_settings_key}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:74:"\Drupal\system\Controller\EntityAutocompleteController::handleAutocomplete";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:3:{i:0;s:11:"target_type";i:1;s:17:"selection_handler";i:2;s:22:"selection_settings_key";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:126:"{^/entity_reference_autocomplete/(?P<target_type>[^/]++)/(?P<selection_handler>[^/]++)/(?P<selection_settings_key>[^/]++)$}sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:22:"selection_settings_key";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:17:"selection_handler";i:4;b:1;}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"target_type";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:30:"/entity_reference_autocomplete";}}s:9:"path_vars";a:3:{i:0;s:11:"target_type";i:1;s:17:"selection_handler";i:2;s:22:"selection_settings_key";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:8;s:14:"patternOutline";s:36:"/entity_reference_autocomplete/%/%/%";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.files',
  'path' => '/system/files/{scheme}',
  'pattern_outline' => '/system/files',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:22:"/system/files/{scheme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:47:"\Drupal\system\FileDownloadController::download";s:6:"scheme";s:7:"private";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:6:"scheme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:44:"{^/system/files(?:/(?P<scheme>[^/]++))?$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"scheme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:13:"/system/files";}}s:9:"path_vars";a:1:{i:0;s:6:"scheme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:13:"/system/files";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.file_system_settings',
  'path' => '/admin/config/media/file-system',
  'pattern_outline' => '/admin/config/media/file-system',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:31:"/admin/config/media/file-system";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:34:"\Drupal\system\Form\FileSystemForm";s:6:"_title";s:11:"File system";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:39:"{^/admin/config/media/file\-system$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/config/media/file-system";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:31:"/admin/config/media/file-system";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.image_toolkit_settings',
  'path' => '/admin/config/media/image-toolkit',
  'pattern_outline' => '/admin/config/media/image-toolkit',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:33:"/admin/config/media/image-toolkit";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:36:"\Drupal\system\Form\ImageToolkitForm";s:6:"_title";s:13:"Image toolkit";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:41:"{^/admin/config/media/image\-toolkit$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:33:"/admin/config/media/image-toolkit";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:33:"/admin/config/media/image-toolkit";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.js_asset',
  'path' => '/sites/default/files/js/{file_name}',
  'pattern_outline' => '/sites/default/files/js/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:35:"/sites/default/files/js/{file_name}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:51:"Drupal\system\Controller\JsAssetController::deliver";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:9:"file_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"{^/sites/default/files/js/(?P<file_name>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"file_name";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:23:"/sites/default/files/js";}}s:9:"path_vars";a:1:{i:0;s:9:"file_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:25:"/sites/default/files/js/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'system.linkset_settings',
  'path' => '/admin/config/services/linkset',
  'pattern_outline' => '/admin/config/services/linkset',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:30:"/admin/config/services/linkset";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:21:"Menu Linkset Settings";s:5:"_form";s:42:"Drupal\system\Form\MenuLinksetSettingsForm";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:37:"{^/admin/config/services/linkset$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:30:"/admin/config/services/linkset";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:30:"/admin/config/services/linkset";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.logging_settings',
  'path' => '/admin/config/development/logging',
  'pattern_outline' => '/admin/config/development/logging',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:33:"/admin/config/development/logging";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:31:"\Drupal\system\Form\LoggingForm";s:6:"_title";s:18:"Logging and errors";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"{^/admin/config/development/logging$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:33:"/admin/config/development/logging";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:33:"/admin/config/development/logging";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.machine_name_transliterate',
  'path' => '/machine_name/transliterate',
  'pattern_outline' => '/machine_name/transliterate',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:27:"/machine_name/transliterate";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:51:"\Drupal\system\MachineNameController::transliterate";}s:12:"requirements";a:1:{s:11:"_permission";s:14:"access content";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:34:"{^/machine_name/transliterate$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:27:"/machine_name/transliterate";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:27:"/machine_name/transliterate";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.modules_list',
  'path' => '/admin/modules',
  'pattern_outline' => '/admin/modules',
  'fit' => '3',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:14:"/admin/modules";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:6:"Extend";s:14:"_title_context";s:15:"With components";s:5:"_form";s:35:"\Drupal\system\Form\ModulesListForm";}s:12:"requirements";a:1:{s:11:"_permission";s:18:"administer modules";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:21:"{^/admin/modules$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:14:"/admin/modules";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:14:"/admin/modules";s:8:"numParts";i:2;}}',
  'number_parts' => '2',
))
->values(array(
  'name' => 'system.modules_list_confirm',
  'path' => '/admin/modules/list/confirm',
  'pattern_outline' => '/admin/modules/list/confirm',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:27:"/admin/modules/list/confirm";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:42:"\Drupal\system\Form\ModulesListConfirmForm";s:6:"_title";s:37:"Some required modules must be enabled";}s:12:"requirements";a:1:{s:11:"_permission";s:18:"administer modules";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:34:"{^/admin/modules/list/confirm$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/modules/list/confirm";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:27:"/admin/modules/list/confirm";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.modules_list_non_stable_confirm',
  'path' => '/admin/modules/list/confirm-non-stable',
  'pattern_outline' => '/admin/modules/list/confirm-non-stable',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:38:"/admin/modules/list/confirm-non-stable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:51:"\Drupal\system\Form\ModulesListNonStableConfirmForm";s:6:"_title";s:18:"Non-stable modules";}s:12:"requirements";a:1:{s:11:"_permission";s:18:"administer modules";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:47:"{^/admin/modules/list/confirm\-non\-stable$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:38:"/admin/modules/list/confirm-non-stable";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:38:"/admin/modules/list/confirm-non-stable";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.modules_uninstall',
  'path' => '/admin/modules/uninstall',
  'pattern_outline' => '/admin/modules/uninstall',
  'fit' => '7',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:24:"/admin/modules/uninstall";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:40:"\Drupal\system\Form\ModulesUninstallForm";s:6:"_title";s:9:"Uninstall";}s:12:"requirements";a:1:{s:11:"_permission";s:18:"administer modules";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:31:"{^/admin/modules/uninstall$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:24:"/admin/modules/uninstall";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:24:"/admin/modules/uninstall";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.modules_uninstall_confirm',
  'path' => '/admin/modules/uninstall/confirm',
  'pattern_outline' => '/admin/modules/uninstall/confirm',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:32:"/admin/modules/uninstall/confirm";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:47:"\Drupal\system\Form\ModulesUninstallConfirmForm";s:6:"_title";s:17:"Confirm uninstall";}s:12:"requirements";a:1:{s:11:"_permission";s:18:"administer modules";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:39:"{^/admin/modules/uninstall/confirm$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:32:"/admin/modules/uninstall/confirm";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:32:"/admin/modules/uninstall/confirm";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.performance_settings',
  'path' => '/admin/config/development/performance',
  'pattern_outline' => '/admin/config/development/performance',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:37:"/admin/config/development/performance";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:54:"\Drupal\system\Controller\PerformanceController::build";s:6:"_title";s:11:"Performance";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:44:"{^/admin/config/development/performance$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/config/development/performance";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:37:"/admin/config/development/performance";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.php',
  'path' => '/admin/reports/status/php',
  'pattern_outline' => '/admin/reports/status/php',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:25:"/admin/reports/status/php";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:51:"\Drupal\system\Controller\SystemInfoController::php";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:12:"_admin_route";b:0;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:32:"{^/admin/reports/status/php$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:25:"/admin/reports/status/php";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:25:"/admin/reports/status/php";s:8:"numParts";i:4;}}',
  'number_parts' => '4',
))
->values(array(
  'name' => 'system.prepare_modules_entity_uninstall',
  'path' => '/admin/modules/uninstall/entity/{entity_type_id}',
  'pattern_outline' => '/admin/modules/uninstall/entity/%',
  'fit' => '30',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:48:"/admin/modules/uninstall/entity/{entity_type_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:53:"\Drupal\system\Form\PrepareModulesEntityUninstallForm";s:15:"_title_callback";s:64:"\Drupal\system\Form\PrepareModulesEntityUninstallForm::formTitle";}s:12:"requirements";a:1:{s:11:"_permission";s:18:"administer modules";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:14:"entity_type_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:65:"{^/admin/modules/uninstall/entity/(?P<entity_type_id>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:14:"entity_type_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/modules/uninstall/entity";}}s:9:"path_vars";a:1:{i:0;s:14:"entity_type_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:33:"/admin/modules/uninstall/entity/%";s:8:"numParts";i:5;}}',
  'number_parts' => '5',
))
->values(array(
  'name' => 'system.private_file_download',
  'path' => '/system/files/{filepath}',
  'pattern_outline' => '/system/files/%',
  'fit' => '6',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:24:"/system/files/{filepath}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:47:"\Drupal\system\FileDownloadController::download";}s:12:"requirements";a:2:{s:8:"filepath";s:2:".+";s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\Core\Routing\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:8:"filepath";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:37:"{^/system/files/(?P<filepath>.+)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:2:".+";i:3;s:8:"filepath";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:13:"/system/files";}}s:9:"path_vars";a:1:{i:0;s:8:"filepath";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:15:"/system/files/%";s:8:"numParts";i:3;}}',
  'number_parts' => '3',
))
->values(array(
  'name' => 'system.regional_settings',
  'path' => '/admin/config/regional/settings',
  'pattern_outline' => '/admin/config/regional/settings',
  'fit' => '15',
  'route' => 'O:31:"Symfony\Component\Routing\Route":9:{s:4:"path";s:31:"/admin/config/regional/settings";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:32:"\Drupal\system\Form\RegionalForm";s:6:"_title";s:17:"Regional settings";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\Core\Routing\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s