<?php

namespace Drupal\Tests\domain_path\Functional;

// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;
use Drupal\node\Entity\Node;
use Drupal\Tests\language\Traits\LanguageTestTrait;

/**
 * Tests the Domain Path form.
 *
 * @group domain_path
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class DomainPathFormTest extends DomainPathTestBase {

  use LanguageTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'language',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->createLanguageFromLangcode('de');

    // Adding languages requires a container rebuild in the test-running
    // environment so that multilingual services are used.
    $this->rebuildContainer();
  }

  /**
   * Test the Domain Path form.
   */
  public function testDomainPathForm() {
    $nodeEN = Node::create([
      'type' => 'page',
      'title' => $this->randomMachineName(),
      'field_domain_access' => 'example_com',
      'langcode' => 'en',
    ]);
    $nodeEN->save();

    $nodeDE = Node::create([
      'type' => 'page',
      'title' => $this->randomMachineName(),
      'field_domain_access' => 'example_com',
      'langcode' => 'de',
    ]);
    $nodeDE->save();

    $this->drupalGet('/admin/config/search/path/add');
    $this->fillField('domain_id[0][target_id]', 'Example (example_com)');
    $this->fillField('path[0][value]', '/node/' . $nodeEN->id());
    $this->fillField('alias[0][value]', '/foo');
    $this->selectFieldOption('langcode[0][value]', 'en');
    $this->pressButton('Save');

    $this->drupalGet('/admin/config/search/path/add');
    $this->fillField('domain_id[0][target_id]', 'Example (example_com)');
    $this->fillField('path[0][value]', '/node/' . $nodeDE->id());
    $this->fillField('alias[0][value]', '/foo');
    $this->selectFieldOption('langcode[0][value]', 'de');
    $this->pressButton('Save');

    $this->drupalGet('/foo');
    $this->assertSession()->pageTextContains($nodeEN->label());

    $this->drupalGet('/de/foo');
    $this->assertSession()->pageTextContains($nodeDE->label());
  }

}
