<?php

namespace Drupal\Tests\domain_path\Functional;

// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests an alias on each domain.
 *
 * @group domain_path
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class DomainPathDomainTest extends DomainPathTestBase {

  /**
   * Tests getting each of the domain paths.
   */
  public function testDomainPathGet() {
    // No domain paths should exist.
    $this->pathAliasTableIsEmpty();
    $node = $this->drupalCreateNode();

    foreach ($this->domains as $domain) {
      $alias = '/' . $this->randomMachineName(8);
      $this->pathAliasStorage->create([
        'type' => 'path_alias',
        'alias' => $alias,
        'domain_id' => $domain->id(),
        'langcode' => $node->language()->getId(),
        'path' => '/node/' . $node->id(),
      ])->save();
      $domain_paths[] = [
        'alias' => $domain->getPath() . $alias,
        'path' => $node->id(),
        'text' => $node->getTitle(),
      ];
    }

    foreach ($domain_paths as $domain_path) {
      $this->drupalGet($domain_path['alias']);
      $this->assertSession()->statusCodeEquals(200);
      $this->assertSession()->pageTextContains($domain_path['text']);
    }

    // Test cache invalidation and 404 error-page invalidation.
    $alias = '/' . $this->randomMachineName(8);
    $domain = reset($this->domains);
    $domain_path_alias = $domain->getPath() . $alias;

    $this->drupalGet($domain_path_alias);
    $this->assertSession()->statusCodeEquals(404);

    $node = $this->drupalCreateNode();
    $this->pathAliasStorage->create([
      'type' => 'path_alias',
      'alias' => $alias,
      'domain_id' => $domain->id(),
      'langcode' => $node->language()->getId(),
      'path' => '/node/' . $node->id(),
    ])->save();

    $this->drupalGet($domain_path_alias);
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains($node->getTitle());
  }

}
