<?php

namespace Drupal\domain_path\Plugin\Validation\Constraint;

// @phpstan-ignore-next-line
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Constraint for creating domain alias for users without access to domain.
 *
 * @Constraint(
 *   id = "DomainPathUserAccess",
 *   label = @Translation("Domain path.", context = "Validation"),
 * )
 * @phpstan-ignore-next-line
 */
#[Constraint(
  id: 'DomainPathUserAccess',
  label: new \Drupal\Core\StringTranslation\TranslatableMarkup('Domain path.', [], ['context' => 'Validation']),
)]
class DomainPathUserAccessConstraint extends SymfonyConstraint {

  /**
   * Violation message.
   *
   * @var string
   */
  public $message = "You don't have access to this domain.";

}
