<?php

namespace Drupal\domain_path;

use Drupal\path_alias\PathAliasInterface;

/**
 * Defines an interface for domain path alias entities.
 */
interface DomainPathAliasInterface extends PathAliasInterface {

  /**
   * Checks if the alias has a domain id.
   *
   * @return bool
   *   TRUE if the alias has a domain id.
   */
  public function hasDomainId(): bool;

  /**
   * Gets the domain id of the alias.
   *
   * @return string|null
   *   The domain id.
   */
  public function getDomainId(): ?string;

  /**
   * Sets the domain id of the alias.
   *
   * @param string $domain_id
   *   The domain id.
   *
   * @return $this
   */
  public function setDomainId($domain_id): static;

}
