<?php

namespace Drupal\domain_path_pathauto;

use Drupal\pathauto\PathautoState;

/**
 * Extends DomainPathautoState to support domain-aware path fields.
 */
class DomainPathautoState extends PathautoState {

  /**
   * {@inheritdoc}
   */
  protected function getCollection() {
    $domain_id = $this->parent->get('domain_id')->getValue();
    return 'domain_path_pathauto_state.' . $domain_id . '.' . $this->parent->getEntity()->getEntityTypeId();
  }

  /**
   * Retrieves the parent collection name.
   *
   * @return mixed
   *   The collection returned by the parent's getCollection method.
   */
  protected function getDefaultCollection() {
    return parent::getCollection();
  }

  /**
   * {@inheritdoc}
   */
  public function getValue() {
    if ($this->value === NULL) {
      $this->value = $this->getOriginalValue();

      // If it was not yet saved or no value was found, then set the flag to
      // create the alias if there is a matching pattern.
      if ($this->value === NULL) {
        $entity = $this->parent->getEntity();
        $pattern = \Drupal::service('pathauto.generator')->getPatternByEntity($entity);
        if (empty($pattern)) {
          $this->value = static::SKIP;
        }
        else {
          // If the entity is new, then use the default CREATE value.
          if ($entity->isNew()) {
            $this->value = static::CREATE;
          }
          else {
            // Use the default non-domain-specific pathauto state value.
            $this->value = \Drupal::keyValue($this->getDefaultCollection())
              ->get(static::getPathautoStateKey($entity->id()));
            if ($this->value === NULL) {
              if (empty($entity->get('path')?->first()?->alias)) {
                $this->value = static::CREATE;
              }
              else {
                $this->value = static::SKIP;
              }
            }
          }
        }
      }
    }
    return $this->value;
  }

}
