<?php

namespace Drupal\domain_path_pathauto;

use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;
use Drupal\domain_path\Plugin\Field\FieldType\DomainPathItem;
use Drupal\pathauto\PathautoState;

/**
 * Extends the default PathItem implementation to generate aliases.
 */
class DomainPathautoItem extends DomainPathItem {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = parent::propertyDefinitions($field_definition);
    $properties['pathauto'] = DataDefinition::create('integer')
      ->setLabel(t('Pathauto state'))
      ->setDescription(t('Whether an automated alias should be created or not.'))
      ->setComputed(TRUE)
      ->setClass(DomainPathautoState::class);
    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public function postSave($update) {
    // Only allow the parent implementation to act if pathauto will not create
    // an alias.
    if ($this->pathauto == PathautoState::SKIP) {
      parent::postSave($update);
    }
    $this->get('pathauto')->persist();
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    // Make sure that the pathauto state flag does not get lost if just that is
    // changed.
    return parent::isEmpty() && !$this->get('pathauto')->hasValue();
  }

}
