<?php

namespace Drupal\domain_path_pathauto;

use Drupal\Core\Language\LanguageInterface;
use Drupal\pathauto\AliasStorageHelperInterface;

/**
 * Defines an interface for domain alias storage helper objects.
 */
interface DomainAliasStorageHelperInterface extends AliasStorageHelperInterface {

  /**
   * Loads data based on the provided source, domain ID, and language code.
   *
   * @param string $source
   *   The source identifier to load data from.
   * @param string $domain_id
   *   The ID of the domain to filter or retrieve the data for.
   * @param string $language
   *   The language code to filter or localize the data.
   *
   * @return bool|array
   *   FALSE if no alias was found or an associative array containing the
   *   following keys:
   *   - source (string): The internal system path with a starting slash.
   *   - alias (string): The URL alias with a starting slash.
   *   - pid (int): Unique path alias identifier.
   *   - langcode (string): The language code of the alias.
   *   - domain_id (string): The domain ID of the alias.
   */
  public function loadBySourceAndDomain($source, $domain_id, $language = LanguageInterface::LANGCODE_NOT_SPECIFIED);

}
