<?php

namespace Drupal\Tests\domain_path\Functional;

// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Base class for Domain Path functional tests.
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
abstract class DomainPathTestBase extends DomainPathNoAccessTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain_access',
  ];

  /**
   * {@inheritDoc}
   */
  protected function getAdminPermissions() {
    $permissions = parent::getAdminPermissions();
    $permissions[] = 'publish to any domain';
    return $permissions;
  }

}
