<?php

namespace Drupal\Tests\domain_path\Functional;

// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the domain path creation API.
 *
 * @group domain_path
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class DomainPathCreateTest extends DomainPathTestBase {

  /**
   * Tests initial domain path creation.
   */
  public function testDomainPathCreate() {
    // No domain paths should exist.
    $this->pathAliasTableIsEmpty();
    $node = $this->drupalCreateNode();
    $default_domain_id = NULL;
    foreach ($this->domains as $domain) {
      $domain_id = $domain->id();
      if ($domain->isDefault()) {
        $default_domain_id = $domain_id;
      }
      $domain_path_entity = $this->pathAliasStorage->create(['type' => 'path_alias']);
      $domain_specific_alias_value = $this->randomMachineName(8);
      $domain_specific_alias_path = "/$domain_specific_alias_value";
      $properties = [
        'alias' => $domain_specific_alias_path,
        'domain_id' => $domain_id,
        'langcode' => $node->language()->getId(),
        'path' => '/' . $node->toUrl()->getInternalPath(),
      ];
      foreach ($properties as $field => $value) {
        $domain_path_entity->set($field, $value);
      }
      $domain_path_entity->save();
    }

    $loaded_domain_paths = $this->pathAliasStorage->loadMultiple();
    foreach ($loaded_domain_paths as $loaded_domain_path) {
      // Check that links are printed.
      $edit_href = "admin/config/search/path/edit/{$loaded_domain_path->id()}";
      $this->drupalGet($edit_href);
      $this->assertSession()->statusCodeEquals(200);
      $domain_alias = ltrim($loaded_domain_path->getAlias(), '/');
      $this->drupalGet($domain_alias);
      $loaded_domain_path_domain_id = $loaded_domain_path->getDomainId();
      if ($loaded_domain_path_domain_id === $default_domain_id) {
        $this->assertSession()->statusCodeEquals(200);
      }
      else {
        $this->assertSession()->statusCodeNotEquals(200);
      }
    }
  }

}
