<?php

namespace Drupal\domain_path\Plugin\Validation\Constraint;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Constraint validator for creating domain alias starting with a slash.
 */
class DomainPathSlashConstraintValidator extends ConstraintValidator implements ContainerInjectionInterface {

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static();
  }

  /**
   * {@inheritdoc}
   */
  public function validate($value, Constraint $constraint) {
    $alias = rtrim(trim($value->alias ?? ''), " \\/");
    if ($alias && $alias[0] !== '/') {
      $this->context->addViolation($constraint->message, ['%alias' => $alias]);
    }
  }

}
