<?php

namespace Drupal\domain_path\Plugin\Validation\Constraint;

// @phpstan-ignore-next-line
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Constraint for creating domain alias starting with a slash.
 *
 * @Constraint(
 *   id = "DomainPathSlash",
 *   label = @Translation("Domain path must start with a slash.", context = "Validation"),
 * )
 * @phpstan-ignore-next-line
 */
#[Constraint(
  id: 'DomainPathSlash',
  label: new \Drupal\Core\StringTranslation\TranslatableMarkup('Domain path must start with a slash.', [], ['context' => 'Validation']),
)]
class DomainPathSlashConstraint extends SymfonyConstraint {

  /**
   * Violation message.
   *
   * @var string
   */
  public $message = 'Domain path "%alias" needs to start with a slash.';

}
