<?php

namespace Drupal\domain_path\Plugin\Field\FieldType;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Session\AccountInterface;
use Drupal\path\Plugin\Field\FieldType\PathFieldItemList;

/**
 * The domain path field Item.
 */
class DomainPathFieldItemList extends PathFieldItemList {

  /**
   * {@inheritdoc}
   */
  protected function computeValue() {
    $user = \Drupal::service('current_user');
    $domains = \Drupal::service('domain_path.helper')->getUserAccessibleDomains($user);
    // For a new entity, default to creating new aliases.
    $entity = $this->getEntity();
    if ($entity->isNew()) {
      $i = 0;
      foreach ($domains as $domain_id => $domain) {
        $value = [
          'langcode' => $this->getLangcode(),
          'domain_id' => $domain_id,
        ];
        $this->list[$i] = $this->createItem($i, $value);
        $i++;
      }
    }
    else {
      /** @var \Drupal\path_alias\AliasRepositoryInterface $path_alias_repository */
      $domain_path_alias_storage = \Drupal::entityTypeManager()
        ->getStorage('path_alias');
      $paths = $domain_path_alias_storage
        ->loadByProperties([
          'path' => '/' . $entity->toUrl()->getInternalPath(),
          'langcode' => $this->getLangcode(),
        ]);
      $paths_by_domain = [];
      foreach ($paths as $path) {
        if ($path->hasDomainId()) {
          $paths_by_domain[$path->getDomainId()] = $path;
        }
      }

      $i = 0;
      foreach ($domains as $domain_id => $domain) {
        if (isset($paths_by_domain[$domain_id])) {
          $path = $paths_by_domain[$domain_id];
          $value = [
            'alias' => $path->getAlias(),
            'pid' => $path->id(),
            'langcode' => $path->get('langcode')->getString(),
            'domain_id' => $path->getDomainId(),
          ];
        }
        else {
          $value = [
            'langcode' => $this->getLangcode(),
            'domain_id' => $domain_id,
          ];
        }
        $this->list[$i] = $this->createItem($i, $value);
        $i++;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function defaultAccess($operation = 'view', ?AccountInterface $account = NULL) {
    if ($operation == 'view') {
      return AccessResult::allowed();
    }
    return AccessResult::allowedIfHasPermissions(
      $account,
      [
        'create url aliases',
        'administer url aliases',
      ],
      'OR'
    )->cachePerPermissions();
  }

}
