<?php

namespace Drupal\domain_path\Entity;

use Drupal\domain_path\DomainPathAliasInterface;
use Drupal\path_alias\Entity\PathAlias;

/**
 * Defines a domain path alias entity.
 */
class DomainPathAlias extends PathAlias implements DomainPathAliasInterface {

  /**
   * {@inheritdoc}
   */
  public function hasDomainId(): bool {
    return !empty($this->get('domain_id')->getValue());
  }

  /**
   * {@inheritdoc}
   */
  public function getDomainId(): ?string {
    return $this->get('domain_id')->target_id;
  }

  /**
   * {@inheritdoc}
   */
  public function setDomainId($domain_id): static {
    $this->set('domain_id', $domain_id);
    return $this;
  }

}
