<?php

namespace Drupal\Tests\domain_path_pathauto\Functional;

use Drupal\node\Entity\Node;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the Domain Path Pathauto integration programmatically.
 *
 * @group domain_path_pathauto
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class PathautoNodeProgrammaticTest extends DomainPathPathautoTestBase {

  /**
   * Tests programmatic node alias generation.
   */
  public function testProgrammaticNodeAlias(): void {
    $title = 'Test Node';
    $node = Node::create([
      'type' => 'page',
      'title' => $title,
      'field_domain_all_affiliates' => 1,
      'status' => 1,
    ]);
    $node->save();

    $path_aliases = $this->pathAliasStorage->loadByProperties([
      'path' => '/node/' . $node->id(),
    ]);

    // Check if the path aliases are created for all domains + default.
    $this->assertCount(count($this->domains) + 1, $path_aliases, 'Domain paths should be created for all domains.');

    foreach ($this->domains as $domain) {
      $domain_id = $domain->id();
      $found = FALSE;
      foreach ($path_aliases as $path_alias) {
        if ($path_alias->get('domain_id')->target_id === $domain_id) {
          $this->assertEquals('/content/test-node', $path_alias->get('alias')->value);
          $found = TRUE;
          break;
        }
      }
      $this->assertTrue($found, "Domain path for domain $domain_id not found.");
    }
  }

}
