<?php

namespace Drupal\Tests\domain_path_pathauto\Functional;

use Drupal\node\Entity\Node;
use Drupal\Tests\domain_path\Functional\DomainPathNoAccessTestBase;
use Drupal\Tests\pathauto\Functional\PathautoTestHelperTrait;
// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the Domain Path Pathauto integration without domain_access.
 *
 * @group domain_path_pathauto
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class PathautoNodeProgrammaticNoAccessTest extends DomainPathNoAccessTestBase {

  use PathautoTestHelperTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain_path_pathauto',
    'pathauto',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $pattern = $this->createPattern('node', '/content/[node:title]');
    $this->addBundleCondition($pattern, 'node', 'page');
    $pattern->save();

    // Enable domain_path for nodes.
    $this->config('domain_path.settings')
      ->set('entity_types', ['node'])
      ->save();
  }

  /**
   * Tests programmatic node alias generation without domain_access.
   */
  public function testProgrammaticNodeAlias(): void {
    $title = 'Test Node';
    $node = Node::create([
      'type' => 'page',
      'title' => $title,
      'status' => 1,
    ]);
    $node->save();

    $path_aliases = $this->pathAliasStorage->loadByProperties([
      'path' => '/node/' . $node->id(),
    ]);

    // Check if path aliases are created for all domains + default.
    $this->assertCount(count($this->domains) + 1, $path_aliases, 'Domain paths should be created for all domains.');

    foreach ($this->domains as $domain) {
      $domain_id = $domain->id();
      $found = FALSE;
      foreach ($path_aliases as $path_alias) {
        if ($path_alias->get('domain_id')->target_id === $domain_id) {
          $this->assertEquals('/content/test-node', $path_alias->get('alias')->value);
          $found = TRUE;
          break;
        }
      }
      $this->assertTrue($found, "Domain path for domain $domain_id not found.");
    }
  }

}
