<?php

namespace Drupal\Tests\domain_path_pathauto\Functional;

use Drupal\Tests\domain_path\Functional\DomainPathTestBase;
use Drupal\Tests\pathauto\Functional\PathautoTestHelperTrait;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Base class for Domain Path Pathauto functional tests.
 *
 * @group domain_path_pathauto
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
abstract class DomainPathPathautoTestBase extends DomainPathTestBase {

  use PathautoTestHelperTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain_path_pathauto',
    'pathauto',
  ];

  /**
   * The key value store.
   *
   * @var \Drupal\Core\KeyValueStore\KeyValueFactoryInterface
   */
  protected $keyValue;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->keyValue = $this->container->get('keyvalue');

    $pattern = $this->createPattern('node', '/content/[node:title]');
    $this->addBundleCondition($pattern, 'node', 'page');
    $pattern->save();
  }

}
