<?php

namespace Drupal\domain_path_pathauto;

use Drupal\domain_path\Plugin\Field\FieldType\DomainPathFieldItemList;

/**
 * Field item list that integrates the Domain Path field with Pathauto.
 *
 * This class extends DomainPathFieldItemList to apply Pathauto state handling
 * for domain-aware path fields. For new entities, it defaults the first item's
 * 'pathauto' state to DomainPathautoState::CREATE.
 */
class DomainPathautoFieldItemList extends DomainPathFieldItemList {

  /**
   * {@inheritdoc}
   */
  protected function delegateMethod($method) {
    // @todo Workaround until this is fixed, see
    //   https://www.drupal.org/project/drupal/issues/2946289.
    $this->ensureComputedValue();

    // Duplicate the logic instead of calling the parent due to the dynamic
    // arguments.
    $result = [];
    $args = array_slice(func_get_args(), 1);
    foreach ($this->list as $delta => $item) {
      // call_user_func_array() is way slower than a direct call so we avoid
      // using it if have no parameters.
      $result[$delta] = $args ? call_user_func_array([$item, $method], $args) : $item->{$method}();
    }
    return $result;
  }

  /**
   * {@inheritdoc}
   */
  protected function computeValue() {
    parent::computeValue();

    // Initialize the pathauto state for new entities.
    if ($this->getEntity()->isNew()) {
      foreach ($this->list as $item) {
        $item->get('pathauto');
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function delete() {
    parent::delete();

    // Delete path auto states.
    foreach ($this->list as $item) {
      $item->get('pathauto')->purge();
    }
  }

}
