<?php

namespace Drupal\domain_path\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Constraint for creating domain alias starting with a slash.
 *
 * @Constraint(
 *   id = "DomainPathSlash",
 *   label = @Translation("Domain path must start with a slash.", context = "Validation"),
 * )
 */
class DomainPathSlashConstraint extends Constraint {

  /**
   * Violation message.
   *
   * @var string
   */
  public $message = 'Domain path "%alias" needs to start with a slash.';

}
