# Domain Source

The Domain Source module allows content to be assigned a canonical domain when
writing URLs. Domain Source will ensure that content that appears on multiple
domains always links to one URL.

## Features

### Multiple Language Negotiation Mechanisms for Source Domains

When a site uses multiple domains and multiple languages, it is common for
different domains to have different language negotiation settings. For example,
one domain might use path prefixes (e.g., `example.com/en`) while another uses a
different structure.

By default, when Domain Source rewrites a URL to point to a different domain, it
uses the language negotiation settings of the *current* domain. This can result
in incorrect URLs if the target domain expects a different language negotiation
format.

If you enable **"Use source domain language negotiation"** in the Domain Source
settings (`/admin/config/domain/entities/domain_source/settings`):

- Outbound URLs will be processed using the language negotiation settings of
  their assigned source domain.
- This ensures that path prefixes and other negotiation methods are correctly
  applied for the target domain.

Note that enabling this option will trigger an additional language-negotiation
pass for URLs whose source domain differs from the current domain.

This feature is currently marked as experimental.

### Cross-domain Destination Query Parameter Handling

When a user follows a link that takes them to a different domain (e.g., to log
in or edit content), Drupal often uses a `destination` query parameter to
redirect the user back to the original page after the action is completed.

However, the standard `destination` parameter is usually a relative path. If the
user is moved to a different domain, a relative redirect will keep them on that
new domain, which might not be desired.

If you enable **"Allow domain-scoped destination redirects"** in the Domain
Source settings:

- Cross-domain links that include a `destination` parameter will automatically
  include a `destination_domain` parameter.
- The `destination_domain` parameter stores the original domain's base URL.
- When the redirect is processed on the target domain, it will use both
  `destination` and `destination_domain` to ensure the user is sent back to the
  correct page on the original domain.

This feature is currently marked as experimental.
