<?php

use Drupal\Core\Site\Settings;
use Drupal\depcalc\DepcalcRequirements;
use Drupal\KernelTests\KernelTestBase;

class DepcalcRequirementsTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'depcalc',
    'system',
  ];

  /**
   * The DepcalcRequirements instance.
   *
   * @var \Drupal\depcalc\DepcalcRequirements
   */
  protected DepcalcRequirements $depcalcRequirements;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installSchema('system', ['sequences']);
  }

  /**
   * Tests cache configuration requirements for depcalc module
   *
   * @dataProvider requirementsDataProvider
   */
  public function testDepcalcRequirements(array $settings_data, int $expected_severity, string $expected_value): void {
    $settings = new Settings($settings_data);
    $this->depcalcRequirements = new DepcalcRequirements($settings);

    $requirements = $this->depcalcRequirements->getRequirements();

    $this->assertArrayHasKey('depcalc_cache_config', $requirements);
    $requirement = $requirements['depcalc_cache_config'];

    $this->assertEquals($expected_severity, $requirement['severity']);
    $this->assertEquals($expected_value, (string) $requirement['value']);
    $this->assertEquals('Depcalc Cache Configuration', (string) $requirement['title']);
  }

  /**
   * Data provider for depcalc requirements scenarios.
   *
   * @return array
   *   Test data with settings, expected severity and value.
   */
  public static function requirementsDataProvider(): array {
    return [
      'depcalc_ok_unlimited' => [
        [
          'database_cache_max_rows' => [
            'bins' => [
              'depcalc' => -1,
            ],
          ],
        ],
        0,
        'Unlimited cache size',
      ],
      'depcalc_warning_adequate_size' => [
        [
          'database_cache_max_rows' => [
            'bins' => [
              'depcalc' => 7000,
            ],
          ],
        ],
        1,
        'Cache bin size: 7000',
      ],
      'depcalc_error_too_small' => [
        [
          'database_cache_max_rows' => [
            'bins' => [
              'depcalc' => 2000,
            ],
          ],
        ],
        2,
        'Cache bin size too small: 2000',
      ],
      'default_error_default_too_low' => [
        [
          'database_cache_max_rows' => [
            'default' => 3000,
          ],
        ],
        2,
        'Cache bin size not configured',
      ],
      'default_warning_adequate' => [
        [
          'database_cache_max_rows' => [
            'default' => 10000,
          ],
        ],
        1,
        'Depcalc cache bin not specifically configured',
      ],
      'error_no_settings' => [
        [],
        2,
        'Cache bin size not configured',
      ],
    ];
  }

}
