<?php

namespace Drupal\depcalc\EventSubscriber\DependencyCollector;

use Drupal\Core\Entity\EntityMalformedException;
use Drupal\Core\Entity\Exception\UndefinedLinkTemplateException;
use Drupal\depcalc\DependencyCalculatorEvents;
use Drupal\depcalc\DependentEntityWrapper;
use Drupal\depcalc\Event\CalculateEntityDependenciesEvent;

/**
 * Calculates dependencies of Entity Path alias.
 */
class EntityPathAliasCollector extends BaseDependencyCollector {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = [];
    $events[DependencyCalculatorEvents::CALCULATE_DEPENDENCIES][] = ['onCalculateDependencies'];
    return $events;
  }

  /**
   * Calculates the entities referenced on Layout Builder components.
   *
   * @param \Drupal\depcalc\Event\CalculateEntityDependenciesEvent $event
   *   The dependency calculation event.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   */
  public function onCalculateDependencies(CalculateEntityDependenciesEvent $event) {
    if ($event->getEntity()->getEntityTypeId() !== 'path_alias' && \Drupal::moduleHandler()->moduleExists('path_alias')) {
      $entity = $event->getEntity();
      try {
        $uri = "/{$entity->toUrl()->getInternalPath()}";
        /** @var \Drupal\path_alias\PathAliasStorage $storage */
        $storage = \Drupal::entityTypeManager()->getStorage('path_alias');
        $paths = $storage->loadByProperties(['path' => $uri]);
        if ($paths) {
          foreach ($paths as $path) {
            $path_wrapper = new DependentEntityWrapper($path);
            $path_wrapper->addDependency($event->getWrapper(), $event->getStack());
            $local_dependencies = [];
            $this->mergeDependencies($path_wrapper, $event->getStack(), $this->getCalculator()
              ->calculateDependencies($path_wrapper, $event->getStack(), $local_dependencies));
            $event->addDependency($path_wrapper);
          }
        }
      }
      catch (EntityMalformedException | UndefinedLinkTemplateException $e) {
        return;
      }
    }
  }

}
