/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  var ids = [];
  Drupal.behaviors.copyFieldValue = {
    attach: function attach(context) {
      Object.keys(drupalSettings.copyFieldValue || {}).forEach(function (element) {
        ids.push(element);
      });

      if (ids.length) {
        $(once('copy-field-values', 'body')).on('value:copy', this.valueTargetCopyHandler);
        $(once('copy-field-values', "#".concat(ids.join(', #')))).on('blur', this.valueSourceBlurHandler);
      }
    },
    detach: function detach(context, settings, trigger) {
      if (trigger === 'unload' && ids.length) {
        $(once.remove('copy-field-values', 'body')).off('value:copy');
        $(once.remove('copy-field-values', "#".concat(ids.join(', #')))).off('blur');
      }
    },
    valueTargetCopyHandler: function valueTargetCopyHandler(e, value) {
      var $target = $(e.target);

      if ($target.val() === '') {
        $target.val(value);
      }
    },
    valueSourceBlurHandler: function valueSourceBlurHandler(e) {
      var value = $(e.target).val();
      var targetIds = drupalSettings.copyFieldValue[e.target.id];
      $("#".concat(targetIds.join(', #'))).trigger('value:copy', value);
    }
  };
})(jQuery, Drupal, drupalSettings);