<?php

declare(strict_types=1);

namespace Drupal\Tests\comment\Functional\Views;

use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests comments on nodes.
 */
#[Group('comment')]
#[RunTestsInSeparateProcesses]
class NodeCommentsTest extends CommentTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Views used by this test.
   *
   * @var array
   */
  public static $testViews = ['test_comment_count'];

  /**
   * Test the comment count field.
   */
  public function testCommentCount(): void {
    $this->drupalGet('test-comment-count');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertCount(2, $this->cssSelect('.views-row'));
    $comment_count_with_comment = $this->cssSelect(".views-field-comment-count span:contains('1')");
    $this->assertCount(1, $comment_count_with_comment);
    $comment_count_without_comment = $this->cssSelect(".views-field-comment-count span:contains('0')");
    $this->assertCount(1, $comment_count_without_comment);

    // Create a content type with no comment field, and add a node.
    $this->drupalCreateContentType(['type' => 'no_comment', 'name' => 'No comment page']);
    $this->nodeUserPosted = $this->drupalCreateNode(['type' => 'no_comment']);
    $this->drupalGet('test-comment-count');

    // Test that the node with no comment field is also shown.
    $this->assertSession()->statusCodeEquals(200);
    $this->assertCount(3, $this->cssSelect('.views-row'));
    $comment_count_with_comment = $this->cssSelect(".views-field-comment-count span:contains('1')");
    $this->assertCount(1, $comment_count_with_comment);
    $comment_count_without_comment = $this->cssSelect(".views-field-comment-count span:contains('0')");
    $this->assertCount(2, $comment_count_without_comment);
  }

}
