/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(Drupal => {
  const searchWideButton = document.querySelector('[data-drupal-selector="block-search-wide-button"]');
  const searchWideWrapper = document.querySelector('[data-drupal-selector="block-search-wide-wrapper"]');

  function searchIsVisible() {
    return searchWideWrapper.classList.contains('is-active');
  }

  Drupal.olivero.searchIsVisible = searchIsVisible;

  function handleFocus() {
    if (searchIsVisible()) {
      searchWideWrapper.querySelector('input[type="search"]').focus();
    } else if (searchWideWrapper.contains(document.activeElement)) {
      searchWideButton.focus();
    }
  }

  function toggleSearchVisibility(visibility) {
    searchWideButton.setAttribute('aria-expanded', visibility === true);
    searchWideWrapper.addEventListener('transitionend', handleFocus, {
      once: true
    });

    if (visibility === true) {
      Drupal.olivero.closeAllSubNav();
      searchWideWrapper.classList.add('is-active');
    } else {
      searchWideWrapper.classList.remove('is-active');
    }
  }

  Drupal.olivero.toggleSearchVisibility = toggleSearchVisibility;
  document.addEventListener('keyup', e => {
    if (e.key === 'Escape') {
      toggleSearchVisibility(false);
    }
  });
  searchWideButton.addEventListener('click', () => {
    toggleSearchVisibility(!searchIsVisible());
  });
  Drupal.behaviors.searchWide = {
    attach(context) {
      const searchWideButton = once('search-wide', '[data-drupal-selector="block-search-wide-button"]', context).shift();

      if (searchWideButton) {
        searchWideButton.setAttribute('aria-expanded', 'false');
      }
    }

  };
  document.querySelector('[data-drupal-selector="search-block-form-2"]').addEventListener('focusout', e => {
    if (!e.currentTarget.contains(e.relatedTarget)) {
      toggleSearchVisibility(false);
    }
  });
})(Drupal);