/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

((Drupal, settings, once) => {
  const colorSchemeOptions = settings.olivero.colorSchemes;

  function announceFieldChange(changedInput) {
    const fieldTitle = changedInput.parentElement.querySelector('label').innerText;
    const fieldValue = changedInput.value;
    const announcement = Drupal.t('@fieldName has changed to @fieldValue', {
      '@fieldName': fieldTitle,
      '@fieldValue': fieldValue
    });
    Drupal.announce(announcement);
  }

  function synchronizeInputs(changedInput, inputToSync) {
    inputToSync.value = changedInput.value;
    changedInput.setAttribute('data-olivero-custom-color', changedInput.value);
    inputToSync.setAttribute('data-olivero-custom-color', changedInput.value);
    const colorSchemeSelect = document.querySelector('[data-drupal-selector="edit-color-scheme"]');

    if (colorSchemeSelect.value !== '') {
      colorSchemeSelect.value = '';
      announceFieldChange(colorSchemeSelect);
    }
  }

  function setColorScheme(_ref) {
    let {
      target
    } = _ref;
    if (!target.value) return;
    const selectedColorScheme = colorSchemeOptions[target.value].colors;

    if (selectedColorScheme) {
      Object.entries(selectedColorScheme).forEach(_ref2 => {
        let [key, color] = _ref2;
        document.querySelectorAll(`input[name="${key}"], input[name="${key}_visual"]`).forEach(input => {
          if (input.value !== color) {
            input.value = color;

            if (input.type === 'text') {
              announceFieldChange(input);
            }
          }
        });
      });
    } else {
      document.querySelectorAll(`input[data-olivero-custom-color]`).forEach(input => {
        input.value = input.getAttribute('data-olivero-custom-color');
      });
    }
  }

  function initColorSchemeSelect(selectElement) {
    selectElement.closest('[style*="display:none;"]').style.display = '';
    selectElement.addEventListener('change', setColorScheme);
    Object.entries(colorSchemeOptions).forEach(option => {
      const [key, values] = option;
      const {
        label,
        colors
      } = values;
      let allColorsMatch = true;
      Object.entries(colors).forEach(_ref3 => {
        let [colorName, colorHex] = _ref3;
        const field = document.querySelector(`input[type="text"][name="${colorName}"]`);

        if (field.value !== colorHex) {
          allColorsMatch = false;
        }
      });

      if (allColorsMatch) {
        selectElement.value = key;
      }
    });
  }

  function initColorPicker(textInput) {
    const colorInput = document.createElement('input');
    colorInput.type = 'color';
    colorInput.classList.add('form-color', 'form-element', 'form-element--type-color', 'form-element--api-color');
    colorInput.value = textInput.value;
    colorInput.setAttribute('name', `${textInput.name}_visual`);
    colorInput.setAttribute('data-olivero-custom-color', textInput.getAttribute('data-olivero-custom-color'));
    textInput.after(colorInput);
    const fieldID = textInput.id;
    const label = document.querySelector(`label[for="${fieldID}"]`);
    label.removeAttribute('for');
    label.setAttribute('id', `${fieldID}-label`);
    textInput.setAttribute('aria-labelledby', `${fieldID}-label`);
    colorInput.setAttribute('aria-labelledby', `${fieldID}-label`);
    textInput.addEventListener('input', () => {
      synchronizeInputs(textInput, colorInput);
    });
    colorInput.addEventListener('input', () => {
      synchronizeInputs(colorInput, textInput);
    });
  }

  Drupal.behaviors.oliveroColorPicker = {
    attach: () => {
      const colorSchemeSelect = once('olivero-color-picker', '[data-drupal-selector="edit-color-scheme"]');
      colorSchemeSelect.forEach(selectElement => {
        initColorSchemeSelect(selectElement);
      });
      const colorTextInputs = once('olivero-color-picker', '[data-drupal-selector="olivero-color-picker"] input[type="text"]');
      colorTextInputs.forEach(textInput => {
        initColorPicker(textInput);
      });
    }
  };
})(Drupal, drupalSettings, once);