/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  function handleDialogResize(e) {
    const $modal = $(e.currentTarget);
    const $viewsOverride = $modal.find('[data-drupal-views-offset]');
    const $scroll = $modal.find('[data-drupal-views-scroll]');
    let offset = 0;
    let modalHeight;

    if ($scroll.length) {
      $modal.closest('.views-ui-dialog').addClass('views-ui-dialog-scroll');
      $scroll.css({
        overflow: 'visible',
        height: 'auto'
      });
      modalHeight = $modal.height();
      $viewsOverride.each(function () {
        offset += $(this).outerHeight();
      });
      const scrollOffset = $scroll.outerHeight() - $scroll.height();
      $scroll.height(modalHeight - offset - scrollOffset);
      $modal.css('overflow', 'hidden');
      $scroll.css('overflow', 'auto');
    }
  }

  Drupal.behaviors.viewsModalContent = {
    attach(context) {
      $(once('viewsDialog', 'body')).on('dialogContentResize.viewsDialog', '.ui-dialog-content', handleDialogResize);
      $(once('detailsUpdate', '.scroll', context)).on('click', 'summary', e => {
        $(e.currentTarget).trigger('dialogContentResize');
      });
    },

    detach(context, settings, trigger) {
      if (trigger === 'unload') {
        $(once.remove('viewsDialog', 'body')).off('.viewsDialog');
      }
    }

  };
})(jQuery, Drupal, drupalSettings);