/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  const dateFormats = drupalSettings.dateFormats;
  Drupal.behaviors.dateFormat = {
    attach(context) {
      const source = once('dateFormat', '[data-drupal-date-formatter="source"]', context);
      const target = once('dateFormat', '[data-drupal-date-formatter="preview"]', context);

      if (!source.length || !target.length) {
        return;
      }

      function dateFormatHandler(e) {
        const baseValue = e.target.value || '';
        const dateString = baseValue.replace(/\\?(.?)/gi, (key, value) => dateFormats[key] ? dateFormats[key] : value);
        target.forEach(item => {
          item.querySelectorAll('em').forEach(em => {
            em.textContent = dateString;
          });
        });
        $(target).toggleClass('js-hide', !dateString.length);
      }

      $(source).on('keyup.dateFormat change.dateFormat input.dateFormat', dateFormatHandler).trigger('keyup');
    }

  };
})(jQuery, Drupal, drupalSettings);