/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(($, Drupal, window, _ref) => {
  let {
    tabbable
  } = _ref;
  Drupal.MediaLibrary = {
    currentSelection: []
  };

  Drupal.AjaxCommands.prototype.updateMediaLibrarySelection = function (ajax, response, status) {
    Object.values(response.mediaIds).forEach(value => {
      Drupal.MediaLibrary.currentSelection.push(value);
    });
  };

  Drupal.behaviors.MediaLibraryTabs = {
    attach(context) {
      const $menu = $('.js-media-library-menu');
      $(once('media-library-menu-item', $menu.find('a'))).on('keypress', e => {
        if (e.which === 32) {
          e.preventDefault();
          e.stopPropagation();
          $(e.currentTarget).trigger('click');
        }
      }).on('click', e => {
        e.preventDefault();
        e.stopPropagation();
        const ajaxObject = Drupal.ajax({
          wrapper: 'media-library-content',
          url: e.currentTarget.href,
          dialogType: 'ajax',
          progress: {
            type: 'fullscreen',
            message: Drupal.t('Please wait...')
          }
        });

        ajaxObject.success = function (response, status) {
          if (this.progress.element) {
            $(this.progress.element).remove();
          }

          if (this.progress.object) {
            this.progress.object.stopMonitoring();
          }

          $(this.element).prop('disabled', false);
          Object.keys(response || {}).forEach(i => {
            if (response[i].command && this.commands[response[i].command]) {
              this.commands[response[i].command](this, response[i], status);
            }
          });
          const mediaLibraryContent = document.getElementById('media-library-content');

          if (mediaLibraryContent) {
            const tabbableContent = tabbable(mediaLibraryContent);

            if (tabbableContent.length) {
              tabbableContent[0].focus();
            }
          }

          this.settings = null;
        };

        ajaxObject.execute();
        $menu.find('.active-tab').remove();
        $menu.find('a').removeClass('active');
        $(e.currentTarget).addClass('active').html(Drupal.t('<span class="visually-hidden">Show </span>@title<span class="visually-hidden"> media</span><span class="active-tab visually-hidden"> (selected)</span>', {
          '@title': $(e.currentTarget).data('title')
        }));
        Drupal.announce(Drupal.t('Showing @title media.', {
          '@title': $(e.currentTarget).data('title')
        }));
      });
    }

  };
  Drupal.behaviors.MediaLibraryViewsDisplay = {
    attach(context) {
      const $view = $(context).hasClass('.js-media-library-view') ? $(context) : $('.js-media-library-view', context);
      $view.closest('.views-element-container').attr('id', 'media-library-view');
      $(once('media-library-views-display-link', '.views-display-link-widget, .views-display-link-widget_table', context)).on('click', e => {
        e.preventDefault();
        e.stopPropagation();
        const $link = $(e.currentTarget);
        let loadingAnnouncement = '';
        let displayAnnouncement = '';
        let focusSelector = '';

        if ($link.hasClass('views-display-link-widget')) {
          loadingAnnouncement = Drupal.t('Loading grid view.');
          displayAnnouncement = Drupal.t('Changed to grid view.');
          focusSelector = '.views-display-link-widget';
        } else if ($link.hasClass('views-display-link-widget_table')) {
          loadingAnnouncement = Drupal.t('Loading table view.');
          displayAnnouncement = Drupal.t('Changed to table view.');
          focusSelector = '.views-display-link-widget_table';
        }

        const ajaxObject = Drupal.ajax({
          wrapper: 'media-library-view',
          url: e.currentTarget.href,
          dialogType: 'ajax',
          progress: {
            type: 'fullscreen',
            message: loadingAnnouncement || Drupal.t('Please wait...')
          }
        });

        if (displayAnnouncement || focusSelector) {
          const success = ajaxObject.success;

          ajaxObject.success = function (response, status) {
            success.bind(this)(response, status);

            if (focusSelector) {
              $(focusSelector).focus();
            }

            if (displayAnnouncement) {
              Drupal.announce(displayAnnouncement);
            }
          };
        }

        ajaxObject.execute();

        if (loadingAnnouncement) {
          Drupal.announce(loadingAnnouncement);
        }
      });
    }

  };
  Drupal.behaviors.MediaLibraryItemSelection = {
    attach(context, settings) {
      const $form = $('.js-media-library-views-form, .js-media-library-add-form', context);
      const currentSelection = Drupal.MediaLibrary.currentSelection;

      if (!$form.length) {
        return;
      }

      const $mediaItems = $('.js-media-library-item input[type="checkbox"]', $form);

      function disableItems($items) {
        $items.prop('disabled', true).closest('.js-media-library-item').addClass('media-library-item--disabled');
      }

      function enableItems($items) {
        $items.prop('disabled', false).closest('.js-media-library-item').removeClass('media-library-item--disabled');
      }

      function updateSelectionCount(remaining) {
        const selectItemsText = remaining < 0 ? Drupal.formatPlural(currentSelection.length, '1 item selected', '@count items selected') : Drupal.formatPlural(remaining, '@selected of @count item selected', '@selected of @count items selected', {
          '@selected': currentSelection.length
        });
        $('.js-media-library-selected-count').html(selectItemsText);
      }

      $(once('media-item-change', $mediaItems)).on('change', e => {
        const id = e.currentTarget.value;
        const position = currentSelection.indexOf(id);

        if (e.currentTarget.checked) {
          if (position === -1) {
            currentSelection.push(id);
          }
        } else if (position !== -1) {
          currentSelection.splice(position, 1);
        }

        const mediaLibraryModalSelection = document.querySelector('#media-library-modal-selection');

        if (mediaLibraryModalSelection) {
          mediaLibraryModalSelection.value = currentSelection.join();
          $(mediaLibraryModalSelection).trigger('change');
        }

        document.querySelectorAll('.js-media-library-add-form-current-selection').forEach(item => {
          item.value = currentSelection.join();
        });
      });
      $(once('media-library-selection-change', $form.find('#media-library-modal-selection'))).on('change', e => {
        updateSelectionCount(settings.media_library.selection_remaining);

        if (currentSelection.length === settings.media_library.selection_remaining) {
          disableItems($mediaItems.not(':checked'));
          enableItems($mediaItems.filter(':checked'));
        } else {
          enableItems($mediaItems);
        }
      });
      currentSelection.forEach(value => {
        $form.find(`input[type="checkbox"][value="${value}"]`).prop('checked', true).trigger('change');
      });

      if (!once('media-library-selection-info', 'html').length) {
        return;
      }

      $(window).on('dialog:aftercreate', () => {
        const $buttonPane = $('.media-library-widget-modal .ui-dialog-buttonpane');

        if (!$buttonPane.length) {
          return;
        }

        $buttonPane.append(Drupal.theme('mediaLibrarySelectionCount'));
        updateSelectionCount(settings.media_library.selection_remaining);
      });
    }

  };
  Drupal.behaviors.MediaLibraryModalClearSelection = {
    attach() {
      if (!once('media-library-clear-selection', 'html').length) {
        return;
      }

      $(window).on('dialog:afterclose', () => {
        Drupal.MediaLibrary.currentSelection = [];
      });
    }

  };

  Drupal.theme.mediaLibrarySelectionCount = function () {
    return `<div class="media-library-selected-count js-media-library-selected-count" role="status" aria-live="polite" aria-atomic="true"></div>`;
  };
})(jQuery, Drupal, window, window.tabbable);