/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal) {
  Drupal.behaviors.filterStatus = {
    attach(context, settings) {
      const $context = $(context);
      once('filter-status', '#filters-status-wrapper input.form-checkbox', context).forEach(checkbox => {
        const $checkbox = $(checkbox);
        const $row = $context.find(`#${$checkbox.attr('id').replace(/-status$/, '-weight')}`).closest('tr');
        const $filterSettings = $context.find(`[data-drupal-selector='${$checkbox.attr('id').replace(/-status$/, '-settings')}']`);
        const filterSettingsTab = $filterSettings.data('verticalTab');
        $checkbox.on('click.filterUpdate', () => {
          if ($checkbox.is(':checked')) {
            $row.show();

            if (filterSettingsTab) {
              filterSettingsTab.tabShow().updateSummary();
            } else {
              $filterSettings.show();
            }
          } else {
            $row.hide();

            if (filterSettingsTab) {
              filterSettingsTab.tabHide().updateSummary();
            } else {
              $filterSettings.hide();
            }
          }

          Drupal.tableDrag['filter-order'].restripeTable();
        });

        if (filterSettingsTab) {
          filterSettingsTab.details.drupalSetSummary(() => $checkbox.is(':checked') ? Drupal.t('Enabled') : Drupal.t('Disabled'));
        }

        $checkbox.triggerHandler('click.filterUpdate');
      });
    }

  };
})(jQuery, Drupal);