/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings, CKEDITOR) {
  function parseAttributes(editor, element) {
    const parsedAttributes = {};
    const domElement = element.$;
    let attribute;
    let attributeName;

    for (let attrIndex = 0; attrIndex < domElement.attributes.length; attrIndex++) {
      attribute = domElement.attributes.item(attrIndex);
      attributeName = attribute.nodeName.toLowerCase();

      if (attributeName.indexOf('data-cke-') === 0) {
        continue;
      }

      parsedAttributes[attributeName] = element.data(`cke-saved-${attributeName}`) || attribute.nodeValue;
    }

    if (parsedAttributes.class) {
      parsedAttributes.class = CKEDITOR.tools.trim(parsedAttributes.class.replace(/cke_\S+/, ''));
    }

    return parsedAttributes;
  }

  function getAttributes(editor, data) {
    const set = {};
    Object.keys(data || {}).forEach(attributeName => {
      set[attributeName] = data[attributeName];
    });
    set['data-cke-saved-href'] = set.href;
    const removed = {};
    Object.keys(set).forEach(s => {
      delete removed[s];
    });
    return {
      set,
      removed: CKEDITOR.tools.objectKeys(removed)
    };
  }

  const registeredLinkableWidgets = [];

  function registerLinkableWidget(widgetName) {
    registeredLinkableWidgets.push(widgetName);
  }

  function getFocusedLinkableWidget(editor) {
    const widget = editor.widgets.focused;

    if (widget && registeredLinkableWidgets.indexOf(widget.name) !== -1) {
      return widget;
    }

    return null;
  }

  function getSelectedLink(editor) {
    const selection = editor.getSelection();
    const selectedElement = selection.getSelectedElement();

    if (selectedElement && selectedElement.is('a')) {
      return selectedElement;
    }

    const range = selection.getRanges(true)[0];

    if (range) {
      range.shrink(CKEDITOR.SHRINK_TEXT);
      return editor.elementPath(range.getCommonAncestor()).contains('a', 1);
    }

    return null;
  }

  CKEDITOR.plugins.add('drupallink', {
    icons: 'drupallink,drupalunlink',
    hidpi: true,

    init(editor) {
      editor.addCommand('drupallink', {
        allowedContent: {
          a: {
            attributes: {
              '!href': true
            },
            classes: {}
          }
        },
        requiredContent: new CKEDITOR.style({
          element: 'a',
          attributes: {
            href: ''
          }
        }),
        modes: {
          wysiwyg: 1
        },
        canUndo: true,

        exec(editor) {
          const focusedLinkableWidget = getFocusedLinkableWidget(editor);
          let linkElement = getSelectedLink(editor);
          let existingValues = {};

          if (linkElement && linkElement.$) {
            existingValues = parseAttributes(editor, linkElement);
          } else if (focusedLinkableWidget && focusedLinkableWidget.data.link) {
            existingValues = CKEDITOR.tools.clone(focusedLinkableWidget.data.link);
          }

          const saveCallback = function (returnValues) {
            if (focusedLinkableWidget) {
              focusedLinkableWidget.setData('link', CKEDITOR.tools.extend(returnValues.attributes, focusedLinkableWidget.data.link));
              editor.fire('saveSnapshot');
              return;
            }

            editor.fire('saveSnapshot');

            if (!linkElement && returnValues.attributes.href) {
              const selection = editor.getSelection();
              const range = selection.getRanges(1)[0];

              if (range.collapsed) {
                const text = new CKEDITOR.dom.text(returnValues.attributes.href.replace(/^mailto:/, ''), editor.document);
                range.insertNode(text);
                range.selectNodeContents(text);
              }

              const style = new CKEDITOR.style({
                element: 'a',
                attributes: returnValues.attributes
              });
              style.type = CKEDITOR.STYLE_INLINE;
              style.applyToRange(range);
              range.select();
              linkElement = getSelectedLink(editor);
            } else if (linkElement) {
              Object.keys(returnValues.attributes || {}).forEach(attrName => {
                if (returnValues.attributes[attrName].length > 0) {
                  const value = returnValues.attributes[attrName];
                  linkElement.data(`cke-saved-${attrName}`, value);
                  linkElement.setAttribute(attrName, value);
                } else {
                  linkElement.removeAttribute(attrName);
                }
              });
            }

            editor.fire('saveSnapshot');
          };

          const dialogSettings = {
            title: linkElement ? editor.config.drupalLink_dialogTitleEdit : editor.config.drupalLink_dialogTitleAdd,
            dialogClass: 'editor-link-dialog'
          };
          Drupal.ckeditor.openDialog(editor, Drupal.url(`editor/dialog/link/${editor.config.drupal.format}`), existingValues, saveCallback, dialogSettings);
        }

      });
      editor.addCommand('drupalunlink', {
        contextSensitive: 1,
        startDisabled: 1,
        requiredContent: new CKEDITOR.style({
          element: 'a',
          attributes: {
            href: ''
          }
        }),

        exec(editor) {
          const style = new CKEDITOR.style({
            element: 'a',
            type: CKEDITOR.STYLE_INLINE,
            alwaysRemoveElement: 1
          });
          editor.removeStyle(style);
        },

        refresh(editor, path) {
          const element = path.lastElement && path.lastElement.getAscendant('a', true);

          if (element && element.getName() === 'a' && element.getAttribute('href') && element.getChildCount()) {
            this.setState(CKEDITOR.TRISTATE_OFF);
          } else {
            this.setState(CKEDITOR.TRISTATE_DISABLED);
          }
        }

      });
      editor.setKeystroke(CKEDITOR.CTRL + 75, 'drupallink');

      if (editor.ui.addButton) {
        editor.ui.addButton('DrupalLink', {
          label: Drupal.t('Link'),
          command: 'drupallink'
        });
        editor.ui.addButton('DrupalUnlink', {
          label: Drupal.t('Unlink'),
          command: 'drupalunlink'
        });
      }

      editor.on('doubleclick', evt => {
        const element = getSelectedLink(editor) || evt.data.element;

        if (!element.isReadOnly()) {
          if (element.is('a')) {
            editor.getSelection().selectElement(element);
            editor.getCommand('drupallink').exec();
          }
        }
      });

      if (editor.addMenuItems) {
        editor.addMenuItems({
          link: {
            label: Drupal.t('Edit Link'),
            command: 'drupallink',
            group: 'link',
            order: 1
          },
          unlink: {
            label: Drupal.t('Unlink'),
            command: 'drupalunlink',
            group: 'link',
            order: 5
          }
        });
      }

      if (editor.contextMenu) {
        editor.contextMenu.addListener((element, selection) => {
          if (!element || element.isReadOnly()) {
            return null;
          }

          const anchor = getSelectedLink(editor);

          if (!anchor) {
            return null;
          }

          let menu = {};

          if (anchor.getAttribute('href') && anchor.getChildCount()) {
            menu = {
              link: CKEDITOR.TRISTATE_OFF,
              unlink: CKEDITOR.TRISTATE_OFF
            };
          }

          return menu;
        });
      }
    }

  });
  CKEDITOR.plugins.drupallink = {
    parseLinkAttributes: parseAttributes,
    getLinkAttributes: getAttributes,
    registerLinkableWidget
  };
})(jQuery, Drupal, drupalSettings, CKEDITOR);