/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(($, CKEDITOR) => {
  const convertToOffCanvasCss = originalCss => {
    const selectorPrefix = '#drupal-off-canvas ';
    const skinPath = `${CKEDITOR.basePath}${CKEDITOR.skinName}/`;
    const css = originalCss.substring(originalCss.indexOf('*/') + 2).trim().replace(/}/g, `}${selectorPrefix}`).replace(/,/g, `,${selectorPrefix}`).replace(/url\(/g, skinPath);
    return `${selectorPrefix}${css}`;
  };

  const insertCss = cssToInsert => {
    const offCanvasCss = document.createElement('style');
    offCanvasCss.innerHTML = cssToInsert;
    offCanvasCss.setAttribute('id', 'ckeditor-off-canvas-reset');
    document.body.appendChild(offCanvasCss);
  };

  const addCkeditorOffCanvasCss = () => {
    if (document.getElementById('ckeditor-off-canvas-reset')) {
      return;
    }

    CKEDITOR.skinName = CKEDITOR.skin.name;
    const editorCssPath = CKEDITOR.skin.getPath('editor');
    const dialogCssPath = CKEDITOR.skin.getPath('dialog');
    const storedOffCanvasCss = window.localStorage.getItem(`Drupal.off-canvas.css.${editorCssPath}${dialogCssPath}`);

    if (storedOffCanvasCss) {
      insertCss(storedOffCanvasCss);
      return;
    }

    $.when($.get(editorCssPath), $.get(dialogCssPath)).done((editorCss, dialogCss) => {
      const offCanvasEditorCss = convertToOffCanvasCss(editorCss[0]);
      const offCanvasDialogCss = convertToOffCanvasCss(dialogCss[0]);
      const cssToInsert = `#drupal-off-canvas .cke_inner * {background: transparent;}
          ${offCanvasEditorCss}
          ${offCanvasDialogCss}`;
      insertCss(cssToInsert);

      if (CKEDITOR.timestamp && editorCssPath.indexOf(CKEDITOR.timestamp) !== -1 && dialogCssPath.indexOf(CKEDITOR.timestamp) !== -1) {
        Object.keys(window.localStorage).forEach(key => {
          if (key.indexOf('Drupal.off-canvas.css.') === 0) {
            window.localStorage.removeItem(key);
          }
        });
        window.localStorage.setItem(`Drupal.off-canvas.css.${editorCssPath}${dialogCssPath}`, cssToInsert);
      }
    });
  };

  addCkeditorOffCanvasCss();
})(jQuery, CKEDITOR);