/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, window, Drupal, once) {
  Drupal.behaviors.blockSettingsSummary = {
    attach() {
      if (typeof $.fn.drupalSetSummary === 'undefined') {
        return;
      }

      function checkboxesSummary(context) {
        const vals = [];
        const $checkboxes = $(context).find('input[type="checkbox"]:checked + label');
        const il = $checkboxes.length;

        for (let i = 0; i < il; i++) {
          vals.push($($checkboxes[i]).html());
        }

        if (!vals.length) {
          vals.push(Drupal.t('Not restricted'));
        }

        return vals.join(', ');
      }

      $('[data-drupal-selector="edit-visibility-node-type"], [data-drupal-selector="edit-visibility-entity-bundlenode"], [data-drupal-selector="edit-visibility-language"], [data-drupal-selector="edit-visibility-user-role"]').drupalSetSummary(checkboxesSummary);
      $('[data-drupal-selector="edit-visibility-request-path"]').drupalSetSummary(context => {
        const $pages = $(context).find('textarea[name="visibility[request_path][pages]"]');

        if (!$pages.length || !$pages[0].value) {
          return Drupal.t('Not restricted');
        }

        return Drupal.t('Restricted to certain pages');
      });
    }

  };
  Drupal.behaviors.blockDrag = {
    attach(context, settings) {
      if (typeof Drupal.tableDrag === 'undefined' || typeof Drupal.tableDrag.blocks === 'undefined') {
        return;
      }

      function checkEmptyRegions(table, rowObject) {
        table.find('tr.region-message').each(function () {
          const $this = $(this);

          if ($this.prev('tr').get(0) === rowObject.element) {
            if (rowObject.method !== 'keyboard' || rowObject.direction === 'down') {
              rowObject.swap('after', this);
            }
          }

          if ($this.next('tr').is(':not(.draggable)') || $this.next('tr').length === 0) {
            $this.removeClass('region-populated').addClass('region-empty');
          } else if ($this.is('.region-empty')) {
            $this.removeClass('region-empty').addClass('region-populated');
          }
        });
      }

      function updateLastPlaced(table, rowObject) {
        table.find('.color-success').removeClass('color-success');
        const $rowObject = $(rowObject);

        if (!$rowObject.is('.drag-previous')) {
          table.find('.drag-previous').removeClass('drag-previous');
          $rowObject.addClass('drag-previous');
        }
      }

      function updateBlockWeights(table, region) {
        let weight = -Math.round(table.find('.draggable').length / 2);
        table.find(`.region-${region}-message`).nextUntil('.region-title').find('select.block-weight').each(function () {
          this.value = ++weight;
        });
      }

      const table = $('#blocks');
      const tableDrag = Drupal.tableDrag.blocks;

      tableDrag.row.prototype.onSwap = function (swappedRow) {
        checkEmptyRegions(table, this);
        updateLastPlaced(table, this);
      };

      tableDrag.onDrop = function () {
        const dragObject = this;
        const $rowElement = $(dragObject.rowObject.element);
        const regionRow = $rowElement.prevAll('tr.region-message').get(0);
        const regionName = regionRow.className.replace(/([^ ]+[ ]+)*region-([^ ]+)-message([ ]+[^ ]+)*/, '$2');
        const regionField = $rowElement.find('select.block-region-select');

        if (regionField.find(`option[value=${regionName}]`).length === 0) {
          window.alert(Drupal.t('The block cannot be placed in this region.'));
          regionField.trigger('change');
        }

        if (!regionField.is(`.block-region-${regionName}`)) {
          const weightField = $rowElement.find('select.block-weight');
          const oldRegionName = weightField[0].className.replace(/([^ ]+[ ]+)*block-weight-([^ ]+)([ ]+[^ ]+)*/, '$2');
          regionField.removeClass(`block-region-${oldRegionName}`).addClass(`block-region-${regionName}`);
          weightField.removeClass(`block-weight-${oldRegionName}`).addClass(`block-weight-${regionName}`);
          regionField[0].value = regionName;
        }

        updateBlockWeights(table, regionName);
      };

      $(once('block-region-select', 'select.block-region-select', context)).on('change', function (event) {
        const row = $(this).closest('tr');
        const select = $(this);
        tableDrag.rowObject = new tableDrag.row(row[0]);
        const regionMessage = table.find(`.region-${select[0].value}-message`);
        const regionItems = regionMessage.nextUntil('.region-message, .region-title');

        if (regionItems.length) {
          regionItems.last().after(row);
        } else {
          regionMessage.after(row);
        }

        updateBlockWeights(table, select[0].value);
        checkEmptyRegions(table, tableDrag.rowObject);
        updateLastPlaced(table, row);

        if (!tableDrag.changed) {
          $(Drupal.theme('tableDragChangedWarning')).insertBefore(tableDrag.table).hide().fadeIn('slow');
          tableDrag.changed = true;
        }

        select.trigger('blur');
      });
    }

  };
})(jQuery, window, Drupal, once);