<?php

declare(strict_types=1);

namespace Drupal\KernelTests\Core\Entity;

use Drupal\Core\Entity\EntityBundleListener;
use Drupal\entity_test\EntityTestHelper;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests Drupal\Core\Entity\EntityBundleListener.
 */
#[CoversClass(EntityBundleListener::class)]
#[Group('Entity')]
#[RunTestsInSeparateProcesses]
class EntityBundleListenerTest extends EntityKernelTestBase {

  /**
   * Test bundle creation.
   *
   * Note: Installing the entity_schema_test module will mask the bug this test
   * was written to cover, as the field map cache is cleared manually by
   * \Drupal\Core\Field\FieldDefinitionListener::onFieldDefinitionCreate().
   */
  public function testOnBundleCreate(): void {
    $field_map = $this->container->get('entity_field.manager')->getFieldMap();
    $expected = [
      'entity_test' => 'entity_test',
    ];
    $this->assertEquals($expected, $field_map['entity_test']['id']['bundles']);

    EntityTestHelper::createBundle('custom');
    $field_map = $this->container->get('entity_field.manager')->getFieldMap();
    $expected = [
      'entity_test' => 'entity_test',
      'custom' => 'custom',
    ];
    $this->assertSame($expected, $field_map['entity_test']['id']['bundles']);
  }

}
