/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(Drupal => {
  Drupal.tour.convertToJoyrideMarkup = shepherdTour => {
    const changeTag = (element, tag) => {
      if (element) {
        const newTagElement = document.createElement(tag);
        [...element.attributes].forEach(attr => {
          newTagElement.setAttribute(attr.name, attr.value);
        });
        newTagElement.innerHTML = element.innerHTML;
        element.parentNode.replaceChild(newTagElement, element);
      }
    };

    const shepherdElement = shepherdTour.currentStep.el;
    const shepherdContent = shepherdElement.querySelector('.shepherd-content');
    const shepherdCancel = shepherdElement.querySelector('.shepherd-cancel-icon');
    const shepherdTitle = shepherdElement.querySelector('.shepherd-title');
    const shepherdText = shepherdElement.querySelector('.shepherd-text');
    const shepherdNext = shepherdElement.querySelector('footer .button');
    const tourProgress = shepherdElement.querySelector('.tour-progress');
    shepherdElement.classList.add('joyride-tip-guide');
    shepherdContent.classList.add('joyride-content-wrapper');
    shepherdNext.classList.add('joyride-next-tip');
    shepherdNext.setAttribute('href', '#');
    shepherdNext.setAttribute('role', 'button');
    shepherdNext.removeAttribute('type');
    shepherdCancel.classList.add('joyride-close-tip');
    shepherdCancel.removeAttribute('type');
    shepherdCancel.setAttribute('href', '#');
    shepherdCancel.setAttribute('role', 'button');
    shepherdElement.setAttribute('data-index', shepherdTour.currentStep.options.index);
    shepherdElement.querySelector('footer').remove();
    shepherdContent.insertBefore(shepherdTitle, shepherdContent.firstChild);
    shepherdContent.insertBefore(tourProgress, shepherdText.nextSibling);
    shepherdContent.appendChild(shepherdCancel);
    shepherdContent.querySelector('.shepherd-header').remove();
    shepherdContent.insertBefore(shepherdNext, tourProgress.nextSibling);
    shepherdCancel.innerHTML = '<span aria-hidden="true">×</span>';
    shepherdTitle.classList.add('tour-tip-label');
    changeTag(shepherdTitle, 'h2');
    shepherdText.outerHTML = shepherdText.innerHTML;
    changeTag(shepherdElement.querySelector('.joyride-close-tip'), 'a');
    changeTag(shepherdElement.querySelector('.joyride-next-tip'), 'a');
    const shepherdArrow = shepherdElement.querySelector('.shepherd-arrow');

    if (shepherdArrow) {
      shepherdArrow.classList.add('joyride-nub');

      if (shepherdTour.currentStep.options.attachTo.on) {
        const stepToTipPosition = {
          bottom: 'top',
          top: 'bottom',
          left: 'right',
          right: 'left'
        };
        shepherdArrow.classList.add(stepToTipPosition[shepherdTour.currentStep.options.attachTo.on.split('-')[0]]);
      }

      changeTag(shepherdArrow, 'span');
    } else {
      const nub = document.createElement('span');
      nub.classList.add('joyride-nub');
      nub.setAttribute('style', 'display: none;');
      shepherdElement.insertBefore(nub, shepherdElement.firstChild);
    }

    shepherdElement.querySelector('.joyride-next-tip').addEventListener('click', e => {
      e.preventDefault();
      shepherdTour.next();
    });
    shepherdElement.querySelector('.joyride-close-tip').addEventListener('click', e => {
      e.preventDefault();
      shepherdTour.cancel();
    });
    shepherdElement.querySelector('.joyride-next-tip').focus();
  };
})(Drupal);