/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal) {
  Drupal.behaviors.menuUiChangeParentItems = {
    attach(context, settings) {
      const menu = once('menu-parent', '#edit-menu');

      if (menu.length) {
        const $menu = $(menu);
        Drupal.menuUiUpdateParentList();
        $menu.on('change', 'input', Drupal.menuUiUpdateParentList);
      }
    }

  };

  Drupal.menuUiUpdateParentList = function () {
    const $menu = $('#edit-menu');
    const values = [];
    $menu.find('input:checked').each(function () {
      values.push(Drupal.checkPlain(this.value));
    });
    $.ajax({
      url: `${window.location.protocol}//${window.location.host}${Drupal.url('admin/structure/menu/parents')}`,
      type: 'POST',
      data: {
        'menus[]': values
      },
      dataType: 'json',

      success(options) {
        const $select = $('#edit-menu-parent');
        const selected = $select[0].value;
        $select.children().remove();
        let totalOptions = 0;
        Object.keys(options || {}).forEach(machineName => {
          const selectContents = document.createElement('option');
          selectContents.selected = machineName === selected;
          selectContents.value = machineName;
          selectContents.textContent = options[machineName];
          $select.append(selectContents);
          totalOptions++;
        });
        $select.closest('div').toggle(totalOptions > 0).attr('hidden', totalOptions === 0);
      }

    });
  };
})(jQuery, Drupal);