/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, document) {
  if (Drupal.filterConfiguration) {
    Drupal.filterConfiguration.liveSettingParsers.filter_html = {
      getRules() {
        const currentValue = document.querySelector('#edit-filters-filter-html-settings-allowed-html').value;

        const rules = Drupal.behaviors.filterFilterHtmlUpdating._parseSetting(currentValue);

        const rule = new Drupal.FilterHTMLRule();
        rule.restrictedTags.tags = ['*'];
        rule.restrictedTags.forbidden.attributes = ['style', 'on*'];
        rules.push(rule);
        return rules;
      }

    };
  }

  function difference() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return args.reduce((mainData, otherData) => mainData.filter(data => !otherData.includes(data)));
  }

  Drupal.behaviors.filterFilterHtmlUpdating = {
    $allowedHTMLFormItem: null,
    $allowedHTMLDescription: null,
    userTags: {},
    autoTags: null,
    newFeatures: {},

    attach(context, settings) {
      const that = this;
      once('filter-filter_html-updating', '[name="filters[filter_html][settings][allowed_html]"]', context).forEach(formItem => {
        that.$allowedHTMLFormItem = $(formItem);
        that.$allowedHTMLDescription = that.$allowedHTMLFormItem.closest('.js-form-item').find('.description');
        that.userTags = that._parseSetting(formItem.value);
        $(document).on('drupalEditorFeatureAdded', (e, feature) => {
          that.newFeatures[feature.name] = feature.rules;

          that._updateAllowedTags();
        }).on('drupalEditorFeatureModified', (e, feature) => {
          if (that.newFeatures.hasOwnProperty(feature.name)) {
            that.newFeatures[feature.name] = feature.rules;

            that._updateAllowedTags();
          }
        }).on('drupalEditorFeatureRemoved', (e, feature) => {
          if (that.newFeatures.hasOwnProperty(feature.name)) {
            delete that.newFeatures[feature.name];

            that._updateAllowedTags();
          }
        });
        that.$allowedHTMLFormItem.on('change.updateUserTags', function () {
          that.userTags = difference(Object.values(that._parseSetting(this.value)), Object.values(that.autoTags));
        });
      });
    },

    _updateAllowedTags() {
      this.autoTags = this._calculateAutoAllowedTags(this.userTags, this.newFeatures);
      this.$allowedHTMLDescription.find('.editor-update-message').remove();

      if (Object.keys(this.autoTags).length > 0) {
        this.$allowedHTMLDescription.append(Drupal.theme('filterFilterHTMLUpdateMessage', this.autoTags));
        const userTagsWithoutOverrides = {};
        Object.keys(this.userTags).filter(tag => !this.autoTags.hasOwnProperty(tag)).forEach(tag => {
          userTagsWithoutOverrides[tag] = this.userTags[tag];
        });
        this.$allowedHTMLFormItem.val(`${this._generateSetting(userTagsWithoutOverrides)} ${this._generateSetting(this.autoTags)}`);
      } else {
        this.$allowedHTMLFormItem.val(this._generateSetting(this.userTags));
      }
    },

    _calculateAutoAllowedTags(userAllowedTags, newFeatures) {
      const editorRequiredTags = {};
      Object.keys(newFeatures || {}).forEach(featureName => {
        const feature = newFeatures[featureName];
        let featureRule;
        let filterRule;
        let tag;

        for (let f = 0; f < feature.length; f++) {
          featureRule = feature[f];

          for (let t = 0; t < featureRule.required.tags.length; t++) {
            tag = featureRule.required.tags[t];

            if (!editorRequiredTags.hasOwnProperty(tag)) {
              filterRule = new Drupal.FilterHTMLRule();
              filterRule.restrictedTags.tags = [tag];
              filterRule.restrictedTags.allowed.attributes = featureRule.required.attributes.slice(0);
              filterRule.restrictedTags.allowed.classes = featureRule.required.classes.slice(0);
              editorRequiredTags[tag] = filterRule;
            } else {
              filterRule = editorRequiredTags[tag];
              filterRule.restrictedTags.allowed.attributes = [...filterRule.restrictedTags.allowed.attributes, ...featureRule.required.attributes];
              filterRule.restrictedTags.allowed.classes = [...filterRule.restrictedTags.allowed.classes, ...featureRule.required.classes];
            }
          }
        }
      });
      const autoAllowedTags = {};
      Object.keys(editorRequiredTags).forEach(tag => {
        if (!userAllowedTags.hasOwnProperty(tag)) {
          autoAllowedTags[tag] = editorRequiredTags[tag];
        } else {
          const requiredAttributes = editorRequiredTags[tag].restrictedTags.allowed.attributes;
          const allowedAttributes = userAllowedTags[tag].restrictedTags.allowed.attributes;
          const needsAdditionalAttributes = requiredAttributes.length && difference(requiredAttributes, allowedAttributes).length;
          const requiredClasses = editorRequiredTags[tag].restrictedTags.allowed.classes;
          const allowedClasses = userAllowedTags[tag].restrictedTags.allowed.classes;
          const needsAdditionalClasses = requiredClasses.length && difference(requiredClasses, allowedClasses).length;

          if (needsAdditionalAttributes || needsAdditionalClasses) {
            autoAllowedTags[tag] = userAllowedTags[tag].clone();
          }

          if (needsAdditionalAttributes) {
            autoAllowedTags[tag].restrictedTags.allowed.attributes = [...allowedAttributes, ...requiredAttributes];
          }

          if (needsAdditionalClasses) {
            autoAllowedTags[tag].restrictedTags.allowed.classes = [...allowedClasses, ...requiredClasses];
          }
        }
      });
      return autoAllowedTags;
    },

    _parseSetting(setting) {
      let tag;
      let rule;
      let attributes;
      let attribute;
      const allowedTags = setting.match(/(<[^>]+>)/g);
      const rules = {};

      for (let t = 0; t < allowedTags.length; t++) {
        const $tagObject = $(allowedTags[t]);
        tag = $tagObject.prop('tagName').toLowerCase();
        rule = new Drupal.FilterHTMLRule();
        rule.restrictedTags.tags = [tag];
        attributes = $tagObject.prop('attributes');

        for (let i = 0; i < attributes.length; i++) {
          attribute = attributes.item(i);
          const attributeName = attribute.nodeName;

          if (attributeName === 'class') {
            const attributeValue = attribute.textContent;
            rule.restrictedTags.allowed.classes = attributeValue.split(' ');
          } else {
            rule.restrictedTags.allowed.attributes.push(attributeName);
          }
        }

        rules[tag] = rule;
      }

      return rules;
    },

    _generateSetting(tags) {
      return Object.keys(tags).reduce((setting, tag) => {
        const rule = tags[tag];

        if (setting.length) {
          setting += ' ';
        }

        setting += `<${tag}`;

        if (rule.restrictedTags.allowed.attributes.length) {
          setting += ` ${rule.restrictedTags.allowed.attributes.join(' ')}`;
        }

        if (rule.restrictedTags.allowed.classes.length) {
          setting += ` class="${rule.restrictedTags.allowed.classes.join(' ')}"`;
        }

        setting += '>';
        return setting;
      }, '');
    }

  };

  Drupal.theme.filterFilterHTMLUpdateMessage = function (tags) {
    let html = '';

    const tagList = Drupal.behaviors.filterFilterHtmlUpdating._generateSetting(tags);

    html += '<p class="editor-update-message">';
    html += Drupal.t('Based on the text editor configuration, these tags have automatically been added: <strong>@tag-list</strong>.', {
      '@tag-list': tagList
    });
    html += '</p>';
    return html;
  };
})(jQuery, Drupal, document);