/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone) {
  Drupal.contextual.VisualView = Backbone.View.extend({
    events() {
      const touchEndToClick = function (event) {
        event.preventDefault();
        event.target.click();
      };

      let touchStart = false;
      return {
        touchstart() {
          touchStart = true;
        },

        mouseenter() {
          if (!touchStart) {
            this.model.focus();
          }
        },

        mousemove() {
          touchStart = false;
        },

        'click .trigger': function () {
          this.model.toggleOpen();
        },
        'touchend .trigger': touchEndToClick,
        'click .contextual-links a': function () {
          this.model.close().blur();
        },
        'touchend .contextual-links a': touchEndToClick
      };
    },

    initialize() {
      this.listenTo(this.model, 'change', this.render);
    },

    render() {
      const isOpen = this.model.get('isOpen');
      const isVisible = this.model.get('isLocked') || this.model.get('regionIsHovered') || isOpen;
      this.$el.toggleClass('open', isOpen).find('.trigger').toggleClass('visually-hidden', !isVisible);

      if ('isOpen' in this.model.changed) {
        this.$el.closest('.contextual-region').find('.contextual .trigger:not(:first)').toggle(!isOpen);
      }

      return this;
    }

  });
})(Drupal, Backbone);