/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone) {
  Drupal.contextual.RegionView = Backbone.View.extend({
    events() {
      let touchStart = false;
      return {
        touchstart() {
          touchStart = true;
        },

        mouseenter() {
          if (!touchStart) {
            this.model.set('regionIsHovered', true);
          }
        },

        mouseleave() {
          if (!touchStart) {
            this.model.close().blur().set('regionIsHovered', false);
          }
        },

        mousemove() {
          touchStart = false;
        }

      };
    },

    initialize() {
      this.listenTo(this.model, 'change:hasFocus', this.render);
    },

    render() {
      this.$el.toggleClass('focus', this.model.get('hasFocus'));
      return this;
    }

  });
})(Drupal, Backbone);