/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal) {
  Drupal.behaviors.color = {
    attach(context, settings) {
      let i;
      let j;
      let colors;
      const form = $(once('color', '#system-theme-settings .color-form', context));

      if (form.length === 0) {
        return;
      }

      const inputs = [];
      const hooks = [];
      const locks = [];
      let focused = null;
      $(once('color', $('<div class="color-placeholder"></div>'))).prependTo(form);
      const farb = $.farbtastic('.color-placeholder');
      const reference = settings.color.reference;
      Object.keys(reference || {}).forEach(color => {
        reference[color] = farb.RGBToHSL(farb.unpack(reference[color]));
      });
      const height = [];
      const width = [];

      function preview() {
        Drupal.color.callback(context, settings, form, farb, height, width);
      }

      function resetScheme() {
        form.find('#edit-scheme').each(function () {
          this.selectedIndex = this.options.length - 1;
        });
      }

      function shiftColor(given, ref1, ref2) {
        let d;
        given = farb.RGBToHSL(farb.unpack(given));
        given[0] += ref2[0] - ref1[0];

        if (ref1[1] === 0 || ref2[1] === 0) {
          given[1] = ref2[1];
        } else {
          d = ref1[1] / ref2[1];

          if (d > 1) {
            given[1] /= d;
          } else {
            given[1] = 1 - (1 - given[1]) * d;
          }
        }

        if (ref1[2] === 0 || ref2[2] === 0) {
          given[2] = ref2[2];
        } else {
          d = ref1[2] / ref2[2];

          if (d > 1) {
            given[2] /= d;
          } else {
            given[2] = 1 - (1 - given[2]) * d;
          }
        }

        return farb.pack(farb.HSLToRGB(given));
      }

      function callback(input, color, propagate, colorScheme) {
        let matched;
        $(input).css({
          backgroundColor: color,
          color: farb.RGBToHSL(farb.unpack(color))[2] > 0.5 ? '#000' : '#fff'
        });

        if (input.value && input.value !== color) {
          input.value = color;

          if (propagate) {
            i = input.i;

            for (j = i + 1;; ++j) {
              if (!locks[j - 1] || $(locks[j - 1]).is('.is-unlocked')) {
                break;
              }

              matched = shiftColor(color, reference[input.key], reference[inputs[j].key]);
              callback(inputs[j], matched, false);
            }

            for (j = i - 1;; --j) {
              if (!locks[j] || $(locks[j]).is('.is-unlocked')) {
                break;
              }

              matched = shiftColor(color, reference[input.key], reference[inputs[j].key]);
              callback(inputs[j], matched, false);
            }

            preview();
          }

          if (!colorScheme) {
            resetScheme();
          }
        }
      }

      Object.keys(settings.gradients || {}).forEach(i => {
        $(once('color', '.color-preview')).append(`<div id="gradient-${i}"></div>`);
        const gradient = $(`.color-preview #gradient-${i}`);
        height.push(parseInt(gradient.css('height'), 10) / 10);
        width.push(parseInt(gradient.css('width'), 10) / 10);

        for (j = 0; j < (settings.gradients[i].direction === 'vertical' ? height[i] : width[i]); ++j) {
          gradient.append('<div class="gradient-line"></div>');
        }
      });
      form.find('#edit-scheme').on('change', function () {
        const schemes = settings.color.schemes;
        const colorScheme = this.options[this.selectedIndex].value;

        if (colorScheme !== '' && schemes[colorScheme]) {
          colors = schemes[colorScheme];
          Object.keys(colors || {}).forEach(fieldName => {
            callback($(`#edit-palette-${fieldName}`), colors[fieldName], false, true);
          });
          preview();
        }
      });

      function focus(e) {
        const input = e.target;

        if (focused) {
          $(focused).off('keyup', farb.updateValue).off('keyup', preview).off('keyup', resetScheme).parent().removeClass('item-selected');
        }

        focused = input;
        farb.linkTo(color => {
          callback(input, color, true, false);
        });
        farb.setColor(input.value);
        $(focused).on('keyup', farb.updateValue).on('keyup', preview).on('keyup', resetScheme).parent().addClass('item-selected');
      }

      form.find('.js-color-palette input.form-text').each(function () {
        this.key = this.id.substring(13);
        farb.linkTo(() => {}).setColor('#000').linkTo(this);
        const i = inputs.length;

        if (inputs.length) {
          let toggleClick = true;
          const lock = $(`<button class="color-palette__lock">${Drupal.t('Unlock')}</button>`).on('click', function (e) {
            e.preventDefault();

            if (toggleClick) {
              $(this).addClass('is-unlocked').html(Drupal.t('Lock'));
              $(hooks[i - 1]).attr('class', locks[i - 2] && $(locks[i - 2]).is(':not(.is-unlocked)') ? 'color-palette__hook is-up' : 'color-palette__hook');
              $(hooks[i]).attr('class', locks[i] && $(locks[i]).is(':not(.is-unlocked)') ? 'color-palette__hook is-down' : 'color-palette__hook');
            } else {
              $(this).removeClass('is-unlocked').html(Drupal.t('Unlock'));
              $(hooks[i - 1]).attr('class', locks[i - 2] && $(locks[i - 2]).is(':not(.is-unlocked)') ? 'color-palette__hook is-both' : 'color-palette__hook is-down');
              $(hooks[i]).attr('class', locks[i] && $(locks[i]).is(':not(.is-unlocked)') ? 'color-palette__hook is-both' : 'color-palette__hook is-up');
            }

            toggleClick = !toggleClick;
          });
          $(this).after(lock);
          locks.push(lock);
        }

        const hook = $('<div class="color-palette__hook"></div>');
        $(this).after(hook);
        hooks.push(hook);
        $(this).parent().find('.color-palette__lock').trigger('click');
        this.i = i;
        inputs.push(this);
      }).on('focus', focus);
      form.find('.js-color-palette label');
      inputs[0].focus();
      preview();
    }

  };
})(jQuery, Drupal);