/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone, $) {
  Drupal.ckeditor.AuralView = Backbone.View.extend({
    events: {
      'click .ckeditor-buttons a': 'announceButtonHelp',
      'click .ckeditor-multiple-buttons a': 'announceSeparatorHelp',
      'focus .ckeditor-button a': 'onFocus',
      'focus .ckeditor-button-separator a': 'onFocus',
      'focus .ckeditor-toolbar-group': 'onFocus'
    },

    initialize() {
      this.listenTo(this.model, 'change:isDirty', this.announceMove);
    },

    announceMove(model, isDirty) {
      if (!isDirty) {
        const item = document.activeElement || null;

        if (item) {
          const $item = $(item);

          if ($item.hasClass('ckeditor-toolbar-group')) {
            this.announceButtonGroupPosition($item);
          } else if ($item.parent().hasClass('ckeditor-button')) {
            this.announceButtonPosition($item.parent());
          }
        }
      }
    },

    onFocus(event) {
      event.stopPropagation();
      const $originalTarget = $(event.target);
      const $currentTarget = $(event.currentTarget);
      const $parent = $currentTarget.parent();

      if ($parent.hasClass('ckeditor-button') || $parent.hasClass('ckeditor-button-separator')) {
        this.announceButtonPosition($currentTarget.parent());
      } else if ($originalTarget.attr('role') !== 'button' && $currentTarget.hasClass('ckeditor-toolbar-group')) {
        this.announceButtonGroupPosition($currentTarget);
      }
    },

    announceButtonGroupPosition($group) {
      const $groups = $group.parent().children();
      const $row = $group.closest('.ckeditor-row');
      const $rows = $row.parent().children();
      const position = $groups.index($group) + 1;
      const positionCount = $groups.not('.placeholder').length;
      const row = $rows.index($row) + 1;
      const rowCount = $rows.not('.placeholder').length;
      let text = Drupal.t('@groupName button group in position @position of @positionCount in row @row of @rowCount.', {
        '@groupName': $group.attr('data-drupal-ckeditor-toolbar-group-name'),
        '@position': position,
        '@positionCount': positionCount,
        '@row': row,
        '@rowCount': rowCount
      });

      if (position === 1 && row === rowCount) {
        text += '\n';
        text += Drupal.t('Press the down arrow key to create a new row.');
      }

      Drupal.announce(text, 'assertive');
    },

    announceButtonPosition($button) {
      const $row = $button.closest('.ckeditor-row');
      const $rows = $row.parent().children();
      const $buttons = $button.closest('.ckeditor-buttons').children();
      const $group = $button.closest('.ckeditor-toolbar-group');
      const $groups = $group.parent().children();
      const groupPosition = $groups.index($group) + 1;
      const groupPositionCount = $groups.not('.placeholder').length;
      const position = $buttons.index($button) + 1;
      const positionCount = $buttons.length;
      const row = $rows.index($row) + 1;
      const rowCount = $rows.not('.placeholder').length;
      const type = $button.attr('data-drupal-ckeditor-type') === 'separator' ? '' : Drupal.t('button');
      let text;

      if ($button.closest('.ckeditor-toolbar-disabled').length > 0) {
        text = Drupal.t('@name @type.', {
          '@name': $button.children().attr('aria-label'),
          '@type': type
        });
        text += `\n${Drupal.t('Press the down arrow key to activate.')}`;
        Drupal.announce(text, 'assertive');
      } else if ($group.not('.placeholder').length === 1) {
        text = Drupal.t('@name @type in position @position of @positionCount in @groupName button group in row @row of @rowCount.', {
          '@name': $button.children().attr('aria-label'),
          '@type': type,
          '@position': position,
          '@positionCount': positionCount,
          '@groupName': $group.attr('data-drupal-ckeditor-toolbar-group-name'),
          '@row': row,
          '@rowCount': rowCount
        });

        if (groupPosition === 1 && position === 1 && row === rowCount) {
          text += '\n';
          text += Drupal.t('Press the down arrow key to create a new button group in a new row.');
        }

        if (groupPosition === groupPositionCount && position === positionCount) {
          text += '\n';
          text += Drupal.t('This is the last group. Move the button forward to create a new group.');
        }

        Drupal.announce(text, 'assertive');
      }
    },

    announceButtonHelp(event) {
      const $link = $(event.currentTarget);
      const $button = $link.parent();
      const enabled = $button.closest('.ckeditor-toolbar-active').length > 0;
      let message;

      if (enabled) {
        message = Drupal.t('The "@name" button is currently enabled.', {
          '@name': $link.attr('aria-label')
        });
        message += `\n${Drupal.t('Use the keyboard arrow keys to change the position of this button.')}`;
        message += `\n${Drupal.t('Press the up arrow key on the top row to disable the button.')}`;
      } else {
        message = Drupal.t('The "@name" button is currently disabled.', {
          '@name': $link.attr('aria-label')
        });
        message += `\n${Drupal.t('Use the down arrow key to move this button into the active toolbar.')}`;
      }

      Drupal.announce(message);
      event.preventDefault();
    },

    announceSeparatorHelp(event) {
      const $link = $(event.currentTarget);
      const $button = $link.parent();
      const enabled = $button.closest('.ckeditor-toolbar-active').length > 0;
      let message;

      if (enabled) {
        message = Drupal.t('This @name is currently enabled.', {
          '@name': $link.attr('aria-label')
        });
        message += `\n${Drupal.t('Use the keyboard arrow keys to change the position of this separator.')}`;
      } else {
        message = Drupal.t('Separators are used to visually split individual buttons.');
        message += `\n${Drupal.t('This @name is currently disabled.', {
          '@name': $link.attr('aria-label')
        })}`;
        message += `\n${Drupal.t('Use the down arrow key to move this separator into the active toolbar.')}`;
        message += `\n${Drupal.t('You may add multiple separators to each button group.')}`;
      }

      Drupal.announce(message);
      event.preventDefault();
    }

  });
})(Drupal, Backbone, jQuery);