/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, CKEDITOR) {
  function getFocusedWidget(editor) {
    const widget = editor.widgets.focused;

    if (widget && widget.name === 'image') {
      return widget;
    }

    return null;
  }

  function linkCommandIntegrator(editor) {
    if (!editor.plugins.drupallink) {
      return;
    }

    CKEDITOR.plugins.drupallink.registerLinkableWidget('image');
    editor.getCommand('drupalunlink').on('exec', function (evt) {
      const widget = getFocusedWidget(editor);

      if (!widget || !widget.parts.link) {
        return;
      }

      widget.setData('link', null);
      this.refresh(editor, editor.elementPath());
      evt.cancel();
    });
    editor.getCommand('drupalunlink').on('refresh', function (evt) {
      const widget = getFocusedWidget(editor);

      if (!widget) {
        return;
      }

      this.setState(widget.data.link || widget.wrapper.getAscendant('a') ? CKEDITOR.TRISTATE_OFF : CKEDITOR.TRISTATE_DISABLED);
      evt.cancel();
    });
  }

  CKEDITOR.plugins.add('drupalimage', {
    requires: 'image2',
    icons: 'drupalimage',
    hidpi: true,

    beforeInit(editor) {
      editor.on('widgetDefinition', event => {
        const widgetDefinition = event.data;

        if (widgetDefinition.name !== 'image') {
          return;
        }

        widgetDefinition.allowedContent = {
          img: {
            attributes: {
              '!src': true,
              '!alt': true,
              width: true,
              height: true
            },
            classes: {}
          }
        };
        widgetDefinition.requiredContent = new CKEDITOR.style({
          element: 'img',
          attributes: {
            src: '',
            alt: ''
          }
        });
        const requiredContent = widgetDefinition.requiredContent.getDefinition();
        requiredContent.attributes['data-entity-type'] = '';
        requiredContent.attributes['data-entity-uuid'] = '';
        widgetDefinition.requiredContent = new CKEDITOR.style(requiredContent);
        widgetDefinition.allowedContent.img.attributes['!data-entity-type'] = true;
        widgetDefinition.allowedContent.img.attributes['!data-entity-uuid'] = true;

        widgetDefinition.downcast = function (element) {
          element.attributes['data-entity-type'] = this.data['data-entity-type'];
          element.attributes['data-entity-uuid'] = this.data['data-entity-uuid'];
        };

        widgetDefinition.upcast = function (element, data) {
          if (element.name !== 'img') {
            return;
          }

          if (element.attributes['data-cke-realelement']) {
            return;
          }

          data['data-entity-type'] = element.attributes['data-entity-type'];
          data['data-entity-uuid'] = element.attributes['data-entity-uuid'];
          return element;
        };

        const originalGetClasses = widgetDefinition.getClasses;

        widgetDefinition.getClasses = function () {
          const classes = originalGetClasses.call(this);
          const captionedClasses = (this.editor.config.image2_captionedClass || '').split(/\s+/);

          if (captionedClasses.length && classes) {
            for (let i = 0; i < captionedClasses.length; i++) {
              if (captionedClasses[i] in classes) {
                delete classes[captionedClasses[i]];
              }
            }
          }

          return classes;
        };

        widgetDefinition._mapDataToDialog = {
          src: 'src',
          alt: 'alt',
          width: 'width',
          height: 'height',
          'data-entity-type': 'data-entity-type',
          'data-entity-uuid': 'data-entity-uuid'
        };

        widgetDefinition._dataToDialogValues = function (data) {
          const dialogValues = {};
          const map = widgetDefinition._mapDataToDialog;
          Object.keys(widgetDefinition._mapDataToDialog).forEach(key => {
            dialogValues[map[key]] = data[key];
          });
          return dialogValues;
        };

        widgetDefinition._dialogValuesToData = function (dialogReturnValues) {
          const data = {};
          const map = widgetDefinition._mapDataToDialog;
          Object.keys(widgetDefinition._mapDataToDialog).forEach(key => {
            if (dialogReturnValues.hasOwnProperty(map[key])) {
              data[key] = dialogReturnValues[map[key]];
            }
          });
          return data;
        };

        widgetDefinition._createDialogSaveCallback = function (editor, widget) {
          return function (dialogReturnValues) {
            const firstEdit = !widget.ready;

            if (!firstEdit) {
              widget.focus();
            }

            editor.fire('saveSnapshot');
            const container = widget.wrapper.getParent(true);
            const image = widget.parts.image;

            const data = widgetDefinition._dialogValuesToData(dialogReturnValues.attributes);

            widget.setData(data);
            widget = editor.widgets.getByElement(image);

            if (firstEdit) {
              editor.widgets.finalizeCreation(container);
            }

            setTimeout(() => {
              widget.focus();
              editor.fire('saveSnapshot');
            });
            return widget;
          };
        };

        const originalInit = widgetDefinition.init;

        widgetDefinition.init = function () {
          originalInit.call(this);

          if (this.parts.link) {
            this.setData('link', CKEDITOR.plugins.image2.getLinkAttributesParser()(editor, this.parts.link));
          }
        };
      });
      editor.widgets.on('instanceCreated', event => {
        const widget = event.data;

        if (widget.name !== 'image') {
          return;
        }

        widget.on('edit', event => {
          event.cancel();
          editor.execCommand('editdrupalimage', {
            existingValues: widget.definition._dataToDialogValues(widget.data),
            saveCallback: widget.definition._createDialogSaveCallback(editor, widget),
            dialogTitle: widget.data.src ? editor.config.drupalImage_dialogTitleEdit : editor.config.drupalImage_dialogTitleAdd
          });
        });
      });
      editor.addCommand('editdrupalimage', {
        allowedContent: 'img[alt,!src,width,height,!data-entity-type,!data-entity-uuid]',
        requiredContent: 'img[alt,src,data-entity-type,data-entity-uuid]',
        modes: {
          wysiwyg: 1
        },
        canUndo: true,

        exec(editor, data) {
          const dialogSettings = {
            title: data.dialogTitle,
            dialogClass: 'editor-image-dialog'
          };
          Drupal.ckeditor.openDialog(editor, Drupal.url(`editor/dialog/image/${editor.config.drupal.format}`), data.existingValues, data.saveCallback, dialogSettings);
        }

      });

      if (editor.ui.addButton) {
        editor.ui.addButton('DrupalImage', {
          label: Drupal.t('Image'),
          command: 'image'
        });
      }
    },

    afterInit(editor) {
      linkCommandIntegrator(editor);
    }

  });

  CKEDITOR.plugins.image2.getLinkAttributesParser = function () {
    return CKEDITOR.plugins.drupallink.parseLinkAttributes;
  };

  CKEDITOR.plugins.image2.getLinkAttributesGetter = function () {
    return CKEDITOR.plugins.drupallink.getLinkAttributes;
  };

  CKEDITOR.plugins.drupalimage = {
    getFocusedWidget
  };
})(jQuery, Drupal, CKEDITOR);