/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(($, Drupal, window) => {
  Drupal.behaviors.MediaLibraryItemSelectionClaro = {
    attach() {
      if (!once('media-library-selection-info-claro-event', 'html').length) {
        return;
      }

      $(window).on('dialog:aftercreate', (event, dialog, $element, settings) => {
        const moveCounter = ($selectedCount, $buttonPane) => {
          const $moveSelectedCount = $selectedCount.detach();
          $buttonPane.prepend($moveSelectedCount);
        };

        const $buttonPane = $element.closest('.media-library-widget-modal').find('.ui-dialog-buttonpane');

        if (!$buttonPane.length) {
          return;
        }

        const $selectedCount = $buttonPane.find('.js-media-library-selected-count');

        if ($selectedCount.length) {
          moveCounter($selectedCount, $buttonPane);
        } else {
          const selectedCountObserver = new MutationObserver(() => {
            const $selectedCountFind = $buttonPane.find('.js-media-library-selected-count');

            if ($selectedCountFind.length) {
              moveCounter($selectedCountFind, $buttonPane);
              selectedCountObserver.disconnect();
            }
          });
          selectedCountObserver.observe($buttonPane[0], {
            attributes: false,
            childList: true,
            characterData: false,
            subtree: true
          });
        }
      });
    }

  };
})(jQuery, Drupal, window);