/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal) {
  Drupal.behaviors.viewTableFilterByText = {
    attach(context, settings) {
      const [input] = once('views-filter-text', 'input.views-filter-text');

      if (!input) {
        return;
      }

      const $table = $(input.getAttribute('data-table'));
      let $rows;

      function filterViewList(e) {
        const query = e.target.value.toLowerCase();

        function showViewRow(index, row) {
          const sources = row.querySelectorAll('[data-drupal-selector="views-table-filter-text-source"]');
          let sourcesConcat = '';
          sources.forEach(item => {
            sourcesConcat += item.textContent;
          });
          const textMatch = sourcesConcat.toLowerCase().indexOf(query) !== -1;
          $(row).closest('tr').toggle(textMatch);
        }

        if (query.length >= 2) {
          $rows.each(showViewRow);
        } else {
          $rows.show();
        }
      }

      if ($table.length) {
        $rows = $table.find('tbody tr');
        $(input).on('keyup', filterViewList);
      }
    }

  };
})(jQuery, Drupal);