/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, _, Drupal) {
  Drupal.quickedit.editors.plain_text = Drupal.quickedit.EditorView.extend({
    $textElement: null,

    initialize(options) {
      Drupal.quickedit.EditorView.prototype.initialize.call(this, options);
      const editorModel = this.model;
      const fieldModel = this.fieldModel;
      const $fieldItems = this.$el.find('.quickedit-field');
      const $textElement = $fieldItems.length ? $fieldItems.eq(0) : this.$el;
      this.$textElement = $textElement;
      editorModel.set('originalValue', this.$textElement[0].textContent.trim());
      let previousText = editorModel.get('originalValue');
      $textElement.on('keyup paste', event => {
        const currentText = $textElement[0].textContent.trim();

        if (previousText !== currentText) {
          previousText = currentText;
          editorModel.set('currentValue', currentText);
          fieldModel.set('state', 'changed');
        }
      });
    },

    getEditedElement() {
      return this.$textElement;
    },

    stateChange(fieldModel, state, options) {
      const from = fieldModel.previous('state');
      const to = state;

      switch (to) {
        case 'inactive':
          break;

        case 'candidate':
          if (from !== 'inactive') {
            this.$textElement.removeAttr('contenteditable');
          }

          if (from === 'invalid') {
            this.removeValidationErrors();
          }

          break;

        case 'highlighted':
          break;

        case 'activating':
          _.defer(() => {
            fieldModel.set('state', 'active');
          });

          break;

        case 'active':
          this.$textElement.attr('contenteditable', 'true');
          break;

        case 'changed':
          break;

        case 'saving':
          if (from === 'invalid') {
            this.removeValidationErrors();
          }

          this.save(options);
          break;

        case 'saved':
          break;

        case 'invalid':
          this.showValidationErrors();
          break;
      }
    },

    getQuickEditUISettings() {
      return {
        padding: true,
        unifiedToolbar: false,
        fullWidthToolbar: false,
        popup: false
      };
    },

    revert() {
      this.$textElement.html(this.model.get('originalValue'));
    }

  });
})(jQuery, _, Drupal);