/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.nodeDetailsSummaries = {
    attach(context) {
      const $context = $(context);
      $context.find('.node-form-author').drupalSetSummary(context => {
        const nameElement = context.querySelector('.field--name-uid input');
        const name = nameElement && nameElement.value;
        const dateElement = context.querySelector('.field--name-created input');
        const date = dateElement && dateElement.value;

        if (name && date) {
          return Drupal.t('By @name on @date', {
            '@name': name,
            '@date': date
          });
        }

        if (name) {
          return Drupal.t('By @name', {
            '@name': name
          });
        }

        if (date) {
          return Drupal.t('Authored on @date', {
            '@date': date
          });
        }
      });
      $context.find('.node-form-options').drupalSetSummary(context => {
        const $optionsContext = $(context);
        const vals = [];

        if ($optionsContext.find('input').is(':checked')) {
          $optionsContext.find('input:checked').next('label').each(function () {
            vals.push(Drupal.checkPlain(this.textContent.trim()));
          });
          return vals.join(', ');
        }

        return Drupal.t('Not promoted');
      });
    }

  };
})(jQuery, Drupal, drupalSettings);