/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal) {
  Drupal.behaviors.menuUiDetailsSummaries = {
    attach(context) {
      $(context).find('.menu-link-form').drupalSetSummary(context => {
        const $context = $(context);

        if ($context.find('.js-form-item-menu-enabled input').is(':checked')) {
          return Drupal.checkPlain($context.find('.js-form-item-menu-title input')[0].value);
        }

        return Drupal.t('Not in menu');
      });
    }

  };
  Drupal.behaviors.menuUiLinkAutomaticTitle = {
    attach(context) {
      const $context = $(context);
      $context.find('.menu-link-form').each(function () {
        const $this = $(this);
        const $checkbox = $this.find('.js-form-item-menu-enabled input');
        const $linkTitle = $context.find('.js-form-item-menu-title input');
        const $title = $this.closest('form').find('.js-form-item-title-0-value input');

        if (!($checkbox.length && $linkTitle.length && $title.length)) {
          return;
        }

        if ($checkbox.is(':checked') && $linkTitle[0].value.length) {
          $linkTitle.data('menuLinkAutomaticTitleOverridden', true);
        }

        $linkTitle.on('keyup', () => {
          $linkTitle.data('menuLinkAutomaticTitleOverridden', true);
        });
        $checkbox.on('change', () => {
          if ($checkbox.is(':checked')) {
            if (!$linkTitle.data('menuLinkAutomaticTitleOverridden')) {
              $linkTitle[0].value = $title[0].value;
            }
          } else {
            $linkTitle[0].value = '';
            $linkTitle.removeData('menuLinkAutomaticTitleOverridden');
          }

          $checkbox.closest('.vertical-tabs-pane').trigger('summaryUpdated');
          $checkbox.trigger('formUpdated');
        });
        $title.on('keyup', () => {
          if (!$linkTitle.data('menuLinkAutomaticTitleOverridden') && $checkbox.is(':checked')) {
            $linkTitle[0].value = $title[0].value;
            $linkTitle.trigger('formUpdated');
          }
        });
      });
    }

  };
})(jQuery, Drupal);