/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone) {
  Drupal.contextual.AuralView = Backbone.View.extend({
    initialize(options) {
      this.options = options;
      this.listenTo(this.model, 'change', this.render);
      this.render();
    },

    render() {
      const isOpen = this.model.get('isOpen');
      this.$el.find('.contextual-links').prop('hidden', !isOpen);
      const $trigger = this.$el.find('.trigger');
      $trigger.each((index, element) => {
        element.textContent = Drupal.t('@action @title configuration options', {
          '@action': !isOpen ? this.options.strings.open : this.options.strings.close,
          '@title': this.model.get('title')
        });
      }).attr('aria-pressed', isOpen);
    }

  });
})(Drupal, Backbone);